/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.handler;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.Handler;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.HandlerRegistry;
import weblogic.wsee.util.ToStringWriter;

public class WseeHandlerRegistry
implements HandlerRegistry {
    private Map chainMap = Collections.synchronizedMap(new HashMap());

    public List getHandlerChain(QName qName) {
        ArrayList arrayList = (ArrayList)this.chainMap.get(qName.getLocalPart());
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.setHandlerChain(qName, arrayList);
        }
        return arrayList;
    }

    public void setHandlerChain(QName qName, List list) {
        for (Object e : list) {
            if (e instanceof HandlerInfo) {
                this.validateHandlerInfo((HandlerInfo)e, qName);
                continue;
            }
            throw new JAXRPCException("The List argument to  setHandlerChain must contain instances of javax.xml.rpc.handler.HandlerInfo.  The list contained " + e.getClass().getName() + " which is not an instanceof" + " HandlerInfo.");
        }
        this.chainMap.put(qName.getLocalPart(), list);
    }

    private void validateHandlerInfo(HandlerInfo handlerInfo, QName qName) {
        Class clazz = handlerInfo.getHandlerClass();
        if (clazz == null) {
            throw new JAXRPCException("The HandlerInfo for the name:" + qName + " had a null HandlerClass.");
        }
        if (!Handler.class.isAssignableFrom(clazz)) {
            throw new JAXRPCException("The HandlerInfo for the name:" + qName + " contains a handler class: " + clazz.getName() + " which is not an instanceof javax.xml.rpc.handler.Handler");
        }
        try {
            Constructor constructor = clazz.getConstructor(new Class[0]);
            if (!Modifier.isPublic(constructor.getModifiers())) {
                throw new JAXRPCException("The HandlerInfo for the name:" + qName + " contains a handler class: " + clazz.getName() + " which has a default, no argument constructor.  However," + "this constructor is not public.");
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new JAXRPCException("The HandlerInfo for the name:" + qName + " contains a handler class: " + clazz.getName() + " which does not have a public, no argument constructor.");
        }
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.writeMap("chainMap", this.chainMap);
        toStringWriter.end();
    }
}

