/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.interception;

import java.security.AccessController;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;
import weblogic.management.provider.ManagementService;
import weblogic.messaging.interception.MessageInterceptionService;
import weblogic.messaging.interception.exceptions.InterceptionServiceException;
import weblogic.messaging.interception.interfaces.InterceptionPointHandle;
import weblogic.messaging.interception.interfaces.InterceptionPointNameDescriptor;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.wsee.message.WlMessageContext;

public final class InterceptionHandler
extends GenericHandler {
    private InterceptionPointHandle[] IPHandles = new InterceptionPointHandle[2];
    private static final String[] IPStrings = new String[]{"Request", "Response"};
    private static final int REQUEST_IP = 0;
    private static final int RESPONSE_IP = 1;
    private static boolean registeredType = false;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public void init(HandlerInfo handlerInfo) {
        super.init(handlerInfo);
        if (!registeredType) {
            registeredType = true;
            try {
                this.registerWithInterceptionService();
            }
            catch (InterceptionServiceException interceptionServiceException) {
                throw new JAXRPCException("Registering with interception service", (Throwable)interceptionServiceException);
            }
        }
    }

    public QName[] getHeaders() {
        return new QName[0];
    }

    private final void registerWithInterceptionService() throws InterceptionServiceException {
        InterceptionPointNameDescriptor[] interceptionPointNameDescriptorArray = new InterceptionPointNameDescriptor[]{new WSInterceptionPointNameDescriptor("server name"), new WSInterceptionPointNameDescriptor("URI"), new WSInterceptionPointNameDescriptor("location")};
        MessageInterceptionService.getSingleton().registerInterceptionPointNameDescription("Web Services", interceptionPointNameDescriptorArray, null);
    }

    private boolean interceptionPoint(int n, MessageContext messageContext) throws JAXRPCException {
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        InterceptionPointHandle interceptionPointHandle = this.IPHandles[n];
        if (interceptionPointHandle == null) {
            if (ManagementService.getRuntimeAccess(kernelId) == null) {
                return true;
            }
            String[] stringArray = new String[]{ManagementService.getRuntimeAccess(kernelId).getServerName(), wlMessageContext.getDispatcher().getConnection().getTransport().getServiceURI(), IPStrings[n]};
            try {
                interceptionPointHandle = MessageInterceptionService.getSingleton().registerInterceptionPoint("Web Services", stringArray);
            }
            catch (InterceptionServiceException interceptionServiceException) {
                throw new JAXRPCException("Failed to registerInterceptionPoint" + interceptionServiceException, (Throwable)interceptionServiceException);
            }
            this.IPHandles[n] = interceptionPointHandle;
        }
        try {
            if (interceptionPointHandle.hasAssociation()) {
                return interceptionPointHandle.process(messageContext);
            }
        }
        catch (Exception exception) {
            throw new JAXRPCException("Processor threw exception", (Throwable)exception);
        }
        return true;
    }

    public boolean handleRequest(MessageContext messageContext) throws JAXRPCException {
        return this.interceptionPoint(0, messageContext);
    }

    public boolean handleResponse(MessageContext messageContext) throws JAXRPCException {
        return this.interceptionPoint(1, messageContext);
    }

    public boolean handleFault(MessageContext messageContext) throws JAXRPCException {
        return true;
    }

    public void destroy() {
        for (int i = 0; i < 2; ++i) {
            if (this.IPHandles[i] == null) continue;
            try {
                MessageInterceptionService.getSingleton().unRegisterInterceptionPoint(this.IPHandles[i]);
                continue;
            }
            catch (InterceptionServiceException interceptionServiceException) {
                throw new AssertionError((Object)("unRegister failed: " + interceptionServiceException));
            }
        }
    }

    private class WSInterceptionPointNameDescriptor
    extends InterceptionPointNameDescriptor {
        private String title;

        public WSInterceptionPointNameDescriptor(String string) {
            this.title = string;
        }

        public String getTitle() {
            return this.title;
        }

        public int getTotalNumberOfUniqueValue() {
            return 100;
        }

        public boolean isValid(String string) {
            return true;
        }
    }
}

