/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxrpc;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.ParameterMode;
import javax.xml.soap.SOAPException;
import weblogic.utils.StackTraceUtils;
import weblogic.wsee.bind.runtime.RuntimeBindings;
import weblogic.wsee.jaxrpc.ServiceImpl;
import weblogic.wsee.jaxrpc.WLCall;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsMethod;
import weblogic.wsee.ws.WsParameterType;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.WsService;
import weblogic.wsee.ws.WsStub;
import weblogic.wsee.ws.WsType;
import weblogic.wsee.wsdl.WsdlBinding;
import weblogic.wsee.wsdl.WsdlBindingMessage;
import weblogic.wsee.wsdl.WsdlBindingOperation;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlElement;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlExtensible;
import weblogic.wsee.wsdl.WsdlExtension;
import weblogic.wsee.wsdl.WsdlFactory;
import weblogic.wsee.wsdl.WsdlOperation;
import weblogic.wsee.wsdl.WsdlPortType;
import weblogic.wsee.wsdl.builder.WsdlBindingBuilder;
import weblogic.wsee.wsdl.builder.WsdlBindingMessageBuilder;
import weblogic.wsee.wsdl.builder.WsdlDefinitionsBuilder;
import weblogic.wsee.wsdl.builder.WsdlMessageBuilder;
import weblogic.wsee.wsdl.builder.WsdlOperationBuilder;
import weblogic.wsee.wsdl.builder.WsdlPartBuilder;
import weblogic.wsee.wsdl.builder.WsdlPortBuilder;
import weblogic.wsee.wsdl.builder.WsdlPortTypeBuilder;
import weblogic.wsee.wsdl.builder.WsdlServiceBuilder;
import weblogic.wsee.wsdl.soap11.SoapAddress;
import weblogic.wsee.wsdl.soap11.SoapBinding;
import weblogic.wsee.wsdl.soap11.SoapBindingOperation;
import weblogic.wsee.wsdl.soap11.SoapBody;

public class CallImpl
implements WLCall {
    private boolean isOneWay = false;
    private QName operationName;
    private QName portTypeName;
    private boolean changed = true;
    private HashMap properties = new HashMap();
    private ArrayList parameters = new ArrayList();
    private ParameterInfo returnInfo;
    private Map lastResult;
    private ServiceImpl serviceImpl;
    private WsdlPortBuilder wsdlPort;
    private static final boolean verbose = Verbose.isVerbose(CallImpl.class);
    private static ArrayList validProperties = new ArrayList();

    CallImpl(ServiceImpl serviceImpl) {
        this.serviceImpl = serviceImpl;
        this.properties.put("weblogic.wsee.handler.registry", serviceImpl._internalGetHandlerRegistry());
    }

    public boolean isParameterAndReturnSpecRequired(QName qName) {
        return this.serviceImpl.getWsdlStatus() == 3;
    }

    public void addParameter(String string, QName qName, Class clazz, ParameterMode parameterMode) throws JAXRPCException {
        this.markChanged();
        ParameterInfo parameterInfo = new ParameterInfo();
        parameterInfo.name = string;
        parameterInfo.xmlType = qName;
        parameterInfo.javaType = clazz;
        parameterInfo.mode = parameterMode;
        this.parameters.add(parameterInfo);
    }

    public void addParameter(String string, QName qName, ParameterMode parameterMode) throws JAXRPCException {
        this.addParameter(string, qName, null, parameterMode);
    }

    public QName getParameterTypeByName(String string) {
        if (this.serviceImpl.getWsdlStatus() == 3) {
            for (ParameterInfo parameterInfo : this.parameters) {
                if (!string.equals(parameterInfo.name)) continue;
                return parameterInfo.xmlType;
            }
        } else {
            WsMethod wsMethod = this.getWsMethod();
            Iterator iterator = wsMethod.getParameters();
            while (iterator.hasNext()) {
                WsParameterType wsParameterType = (WsParameterType)iterator.next();
                if (!wsParameterType.getName().equals(string)) continue;
                return wsParameterType.getXmlName().getQName();
            }
        }
        throw new JAXRPCException("Can't find parameter \"" + string + "\"");
    }

    public Iterator getParameterNames() {
        HashSet<String> hashSet = new HashSet<String>();
        if (this.serviceImpl.getWsdlStatus() == 3) {
            for (ParameterInfo parameterInfo : this.parameters) {
                hashSet.add(parameterInfo.name);
            }
        } else {
            WsMethod wsMethod = this.getWsMethod();
            Iterator iterator = wsMethod.getParameters();
            while (iterator.hasNext()) {
                WsParameterType wsParameterType = (WsParameterType)iterator.next();
                hashSet.add(wsParameterType.getName());
            }
        }
        return hashSet.iterator();
    }

    private WsMethod getWsMethod() {
        if (this.changed) {
            this.syncWithWsdl();
        }
        WsStub wsStub = this.serviceImpl.getWsStub(this.wsdlPort);
        return wsStub.getMethod(this.operationName.getLocalPart());
    }

    public Class getParameterJavaType(String string) {
        if (this.serviceImpl.getWsdlStatus() == 3) {
            for (ParameterInfo parameterInfo : this.parameters) {
                if (!string.equals(parameterInfo.name)) continue;
                return parameterInfo.javaType;
            }
        } else {
            WsMethod wsMethod = this.getWsMethod();
            Iterator iterator = wsMethod.getParameters();
            while (iterator.hasNext()) {
                WsParameterType wsParameterType = (WsParameterType)iterator.next();
                if (!wsParameterType.getName().equals(string)) continue;
                return wsParameterType.getJavaType();
            }
        }
        throw new JAXRPCException("Can't find parameter \"" + string + "\"");
    }

    public ParameterMode getParameterMode(String string) {
        if (this.serviceImpl.getWsdlStatus() == 3) {
            for (ParameterInfo parameterInfo : this.parameters) {
                if (!string.equals(parameterInfo.name)) continue;
                return parameterInfo.mode;
            }
        } else {
            WsMethod wsMethod = this.getWsMethod();
            Iterator iterator = wsMethod.getParameters();
            while (iterator.hasNext()) {
                WsParameterType wsParameterType = (WsParameterType)iterator.next();
                if (!wsParameterType.getName().equals(string)) continue;
                switch (wsParameterType.getMode()) {
                    case 0: {
                        return ParameterMode.IN;
                    }
                    case 1: {
                        return ParameterMode.OUT;
                    }
                    case 2: {
                        return ParameterMode.INOUT;
                    }
                }
            }
        }
        throw new JAXRPCException("Can't find parameter \"" + string + "\"");
    }

    public void setReturnType(QName qName, Class clazz) throws JAXRPCException {
        String string;
        this.markChanged();
        this.returnInfo = new ParameterInfo();
        this.returnInfo.name = string = "__bea_noname_result";
        this.returnInfo.xmlType = qName;
        this.returnInfo.javaType = clazz;
    }

    public void setReturnType(QName qName) throws JAXRPCException {
        this.setReturnType(qName, null);
    }

    public QName getReturnType() {
        if (this.operationName == null) {
            return null;
        }
        if (this.serviceImpl.getWsdlStatus() == 3) {
            if (this.returnInfo == null) {
                throw new JAXRPCException("Return type is not set.");
            }
            return this.returnInfo.xmlType;
        }
        WsMethod wsMethod = this.getWsMethod();
        return null;
    }

    public void removeAllParameters() {
        this.markChanged();
        this.returnInfo = null;
        this.parameters.clear();
    }

    private void markChanged() {
        if (this.serviceImpl.getWsdlStatus() != 3) {
            throw new JAXRPCException("This call is created from WSDL, you can not add/remove parameters or set return type for this call");
        }
        this.changed = true;
    }

    public QName getOperationName() {
        return this.operationName;
    }

    public void setOperationName(QName qName) {
        if (verbose) {
            Verbose.log("Setting operation name to: " + qName);
        }
        if (qName.equals(this.operationName)) {
            return;
        }
        this.operationName = qName;
        this.changed = true;
    }

    public QName getPortTypeName() {
        if (this.portTypeName == null) {
            return new QName("");
        }
        return this.portTypeName;
    }

    public void setPortTypeName(QName qName) {
        if (qName == null) {
            throw new IllegalArgumentException("port type name can not be null");
        }
        this.portTypeName = qName;
        if (this.wsdlPort != null && !this.wsdlPort.getPortType().getName().equals(qName)) {
            this.wsdlPort = null;
        }
        this.changed = true;
    }

    void setWsdlPort(WsdlPortBuilder wsdlPortBuilder) {
        this.wsdlPort = wsdlPortBuilder;
        this.setPortTypeName(wsdlPortBuilder.getPortType().getName());
    }

    public void setTargetEndpointAddress(String string) {
        this.setProperty("javax.xml.rpc.service.endpoint.address", string);
    }

    public String getTargetEndpointAddress() {
        return (String)this.getProperty("javax.xml.rpc.service.endpoint.address");
    }

    static boolean isValidProperty(String string) {
        if (string == null) {
            throw new JAXRPCException("property name can not be null");
        }
        return validProperties.contains(string) || string.startsWith("com.bea") || string.startsWith("weblogic.wsee");
    }

    public void setProperty(String string, Object object) throws JAXRPCException {
        if (!CallImpl.isValidProperty(string)) {
            throw new JAXRPCException("unknown property: " + string);
        }
        this.properties.put(string, object);
    }

    public Object getProperty(String string) {
        if (!CallImpl.isValidProperty(string)) {
            throw new JAXRPCException("unknown property: " + string);
        }
        return this.properties.get(string);
    }

    public void removeProperty(String string) {
        this.properties.remove(string);
    }

    public Iterator getPropertyNames() {
        return this.properties.keySet().iterator();
    }

    private WsdlDefinitions createDummyWsdl(QName qName) throws WsdlException {
        WsdlExtension wsdlExtension;
        WsdlExtensible wsdlExtensible;
        Object object;
        WsdlElement wsdlElement;
        Object object22;
        if (verbose) {
            Verbose.log("Creating dummy wsdl for service: " + qName);
        }
        if (this.operationName == null) {
            throw new JAXRPCException("operation name not set");
        }
        String string = this.operationName.getNamespaceURI();
        boolean bl = this.isDocumentStyle();
        if (this.portTypeName == null) {
            this.portTypeName = new QName(string, "DefaultPortTypeName");
        }
        WsdlDefinitionsBuilder wsdlDefinitionsBuilder = WsdlFactory.getInstance().create();
        wsdlDefinitionsBuilder.setTargetNamespace(string);
        WsdlPortTypeBuilder wsdlPortTypeBuilder = wsdlDefinitionsBuilder.addPortType(this.portTypeName);
        WsdlOperationBuilder wsdlOperationBuilder = wsdlPortTypeBuilder.addOperation(this.operationName);
        WsdlMessageBuilder wsdlMessageBuilder = wsdlDefinitionsBuilder.addMessage(new QName(string, this.operationName.getLocalPart()));
        wsdlOperationBuilder.setInput(wsdlMessageBuilder);
        WsdlMessageBuilder wsdlMessageBuilder2 = null;
        if (this.isOneWay) {
            wsdlOperationBuilder.setType(1);
        } else {
            wsdlMessageBuilder2 = wsdlDefinitionsBuilder.addMessage(new QName(string, this.operationName.getLocalPart() + "Response"));
            wsdlOperationBuilder.setOutput(wsdlMessageBuilder2);
        }
        for (Object object22 : this.parameters) {
            if (((ParameterInfo)object22).mode == ParameterMode.IN) {
                wsdlElement = wsdlMessageBuilder.addPart(((ParameterInfo)object22).name);
                this.setXmlTypeOrElement(bl, (WsdlPartBuilder)wsdlElement, (ParameterInfo)object22);
            }
            if (((ParameterInfo)object22).mode != ParameterMode.OUT) continue;
            if (this.isOneWay) {
                throw new JAXRPCException("One way method can not have out parames" + object22);
            }
            wsdlElement = wsdlMessageBuilder2.addPart(((ParameterInfo)object22).name);
            this.setXmlTypeOrElement(bl, (WsdlPartBuilder)wsdlElement, (ParameterInfo)object22);
        }
        if (this.returnInfo != null) {
            if (this.isOneWay) {
                throw new JAXRPCException("One way method can not have return type:" + this.returnInfo);
            }
            object = wsdlMessageBuilder2.addPart(this.returnInfo.name);
            this.setXmlTypeOrElement(bl, (WsdlPartBuilder)object, this.returnInfo);
        }
        object = wsdlDefinitionsBuilder.addBinding(this.portTypeName, wsdlPortTypeBuilder);
        object22 = SoapBinding.attach((WsdlBinding)object);
        if (bl) {
            ((SoapBinding)object22).setStyle("document");
        } else {
            ((SoapBinding)object22).setStyle("rpc");
        }
        wsdlElement = object.addOperation(wsdlOperationBuilder);
        SoapBindingOperation.attach((WsdlBindingOperation)wsdlElement);
        WsdlBindingMessageBuilder wsdlBindingMessageBuilder = wsdlElement.createInput();
        SoapBody soapBody = SoapBody.attach(wsdlBindingMessageBuilder);
        soapBody.setNamespace(this.operationName.getNamespaceURI());
        if (bl) {
            soapBody.setUse("literal");
        } else {
            soapBody.setUse("encoded");
        }
        if (!this.isOneWay) {
            wsdlExtensible = wsdlElement.createOutput();
            wsdlExtension = SoapBody.attach((WsdlBindingMessage)wsdlExtensible);
            wsdlExtension.setNamespace(this.operationName.getNamespaceURI());
            if (bl) {
                wsdlExtension.setUse("literal");
            } else {
                wsdlExtension.setUse("encoded");
            }
        }
        wsdlExtensible = wsdlDefinitionsBuilder.addService(qName);
        this.wsdlPort = wsdlExtensible.addPort(this.portTypeName, (WsdlBinding)object);
        wsdlExtension = SoapAddress.attach(this.wsdlPort);
        return wsdlDefinitionsBuilder;
    }

    private void setXmlTypeOrElement(boolean bl, WsdlPartBuilder wsdlPartBuilder, ParameterInfo parameterInfo) {
        if (bl) {
            wsdlPartBuilder.setElement(parameterInfo.xmlType);
        } else {
            wsdlPartBuilder.setType(parameterInfo.xmlType);
        }
    }

    private boolean isDocumentStyle() {
        String string = (String)this.properties.get("javax.xml.rpc.soap.operation.style");
        boolean bl = false;
        if (string != null && "document".equals(string)) {
            bl = true;
        }
        return bl;
    }

    private Map getInputParamMap(WsStub wsStub, Object[] objectArray) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        WsMethod wsMethod = wsStub.getMethod(this.operationName.getLocalPart());
        try {
            for (int i = 0; i < objectArray.length; ++i) {
                WsParameterType wsParameterType = wsMethod.getParameter(i);
                linkedHashMap.put(wsParameterType.getName(), objectArray[i]);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new JAXRPCException("There are more parameters passed in than required.");
        }
        return linkedHashMap;
    }

    private void syncWithWsdl() {
        if (this.operationName == null) {
            throw new JAXRPCException("operation name not set.");
        }
        if (this.wsdlPort != null) {
            return;
        }
        if (this.portTypeName == null) {
            boolean bl = false;
            for (WsdlPortBuilder wsdlPortBuilder : ((WsdlServiceBuilder)this.serviceImpl.getWebService().getWsdlService()).getPorts().values()) {
                if (wsdlPortBuilder.getPortType().getOperations().get(this.operationName) == null) continue;
                if (bl) {
                    throw new JAXRPCException("There are more than one port types that have operation " + this.operationName + " please set a " + "port type name using Call.setPortTypeName(QName name).");
                }
                this.wsdlPort = wsdlPortBuilder;
                this.portTypeName = wsdlPortBuilder.getPortType().getName();
                bl = true;
            }
        } else {
            for (WsdlPortBuilder wsdlPortBuilder : ((WsdlServiceBuilder)this.serviceImpl.getWebService().getWsdlService()).getPorts().values()) {
                if (!this.portTypeName.equals(wsdlPortBuilder.getPortType().getName())) continue;
                this.wsdlPort = wsdlPortBuilder;
                if (wsdlPortBuilder.getPortType().getOperations().get(this.operationName) != null) continue;
                throw new JAXRPCException("Can't find operation \"" + this.operationName + "\" in portType \"" + this.portTypeName + "\"" + " supported operations are [" + this.getOperationNames(wsdlPortBuilder.getPortType()) + "]");
            }
        }
        if (this.wsdlPort == null) {
            throw new JAXRPCException("Can't find and wsdl port that implementsport type \"" + this.portTypeName + "\".");
        }
    }

    private String getOperationNames(WsdlPortType wsdlPortType) {
        StringBuffer stringBuffer = new StringBuffer();
        for (WsdlOperation wsdlOperation : wsdlPortType.getOperations().values()) {
            stringBuffer.append(wsdlOperation.getName());
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public Object invoke(Object[] objectArray) throws RemoteException {
        if (verbose) {
            Verbose.log("Goint to call operation " + this.operationName);
        }
        if (this.changed) {
            this.applyChanges();
        }
        WsStub wsStub = this.serviceImpl.getWsStub(this.wsdlPort);
        Map map = this.getInputParamMap(wsStub, objectArray);
        this.lastResult = new LinkedHashMap();
        try {
            return wsStub.invoke(this.operationName.getLocalPart(), this.wsdlPort.getName().getLocalPart(), map, this.lastResult, this.properties);
        }
        catch (SOAPException sOAPException) {
            throw this.getRemoteException(sOAPException);
        }
        catch (Throwable throwable) {
            throw new RemoteException("failed to invoke operation '" + this.operationName + StackTraceUtils.throwable2StackTrace((Throwable)throwable), throwable);
        }
    }

    private RemoteException getRemoteException(SOAPException sOAPException) {
        Throwable throwable = sOAPException.getCause();
        if (throwable == null) {
            throwable = sOAPException;
        }
        return new RemoteException("failed to invoke operation '" + this.operationName + "' due to an error in the " + "soap layer (SAAJ); nested exception is: " + StackTraceUtils.throwable2StackTrace((Throwable)sOAPException), throwable);
    }

    private void applyChanges() throws RemoteException {
        if (this.serviceImpl.getWsdlStatus() == 3) {
            String string = this.operationName.getNamespaceURI();
            QName qName = new QName(string, "DefaultServiceName");
            WsdlDefinitions wsdlDefinitions = null;
            try {
                wsdlDefinitions = this.createDummyWsdl(qName);
            }
            catch (WsdlException wsdlException) {
                throw new RemoteException("Failed to create dummy WSDL", wsdlException);
            }
            RuntimeBindings runtimeBindings = (RuntimeBindings)this.properties.get("weblogic.wsee.bind.runtimeBindingProvider");
            WsService wsService = this.serviceImpl.createWebService(wsdlDefinitions, qName, runtimeBindings);
            WsPort wsPort = wsService.getPort(this.portTypeName.getLocalPart());
            WsMethod wsMethod = wsPort.getEndpoint().getMethod(this.operationName.getLocalPart());
            this.setJavaTypes(wsMethod, this.parameters);
        } else {
            this.syncWithWsdl();
        }
    }

    private void setJavaTypes(WsMethod wsMethod, ArrayList arrayList) {
        WsType wsType;
        Iterator iterator = wsMethod.getParameters();
        while (iterator.hasNext()) {
            wsType = (WsParameterType)iterator.next();
            ParameterInfo parameterInfo = this.getParameterInfo(wsType.getName(), arrayList);
            if (parameterInfo.javaType == null) continue;
            wsType.setJavaType(parameterInfo.javaType);
        }
        wsType = wsMethod.getReturnType();
        if (wsType != null && this.returnInfo != null && this.returnInfo.javaType != null) {
            wsType.setJavaType(this.returnInfo.javaType);
        }
    }

    private ParameterInfo getParameterInfo(String string, ArrayList arrayList) {
        for (ParameterInfo parameterInfo : arrayList) {
            if (!string.equals(parameterInfo.name)) continue;
            return parameterInfo;
        }
        throw new AssertionError((Object)"Unable to find parameterInfo");
    }

    public Object invoke(QName qName, Object[] objectArray) throws JAXRPCException, RemoteException {
        this.setOperationName(qName);
        return this.invoke(objectArray);
    }

    public void invokeOneWay(Object[] objectArray) throws JAXRPCException {
        this.isOneWay = true;
        try {
            this.invoke(objectArray);
        }
        catch (RemoteException remoteException) {
            throw new JAXRPCException((Throwable)remoteException);
        }
        this.isOneWay = false;
    }

    private void makeOperationOneway() {
        WsdlBindingBuilder wsdlBindingBuilder = this.wsdlPort.getBinding();
        WsdlOperationBuilder wsdlOperationBuilder = wsdlBindingBuilder.getPortType().getOperations().get(this.operationName);
        wsdlOperationBuilder.setType(1);
    }

    public List getOutputValues() throws JAXRPCException {
        Map map = this.getOutputParams();
        if (map == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public Map getOutputParams() throws JAXRPCException {
        if (this.lastResult == null) {
            throw new JAXRPCException("Invoke not called");
        }
        return this.lastResult;
    }

    static {
        validProperties.add("javax.xml.rpc.service.endpoint.address");
        validProperties.add("javax.xml.rpc.security.auth.username");
        validProperties.add("javax.xml.rpc.security.auth.password");
        validProperties.add("javax.xml.rpc.soap.operation.style");
        validProperties.add("javax.xml.rpc.soap.http.soapaction.use");
        validProperties.add("javax.xml.rpc.soap.http.soapaction.uri");
        validProperties.add("javax.xml.rpc.encodingstyle.namespace.uri");
        validProperties.add("javax.xml.rpc.session.maintain");
        validProperties.add("weblogic.wsee.client.ssladapter");
        validProperties.add("weblogic.wsee.bind.runtimeBindingProvider");
        validProperties.add("weblogic.wsee.security.wss.CredentialProviderList");
        validProperties.add("weblogic.wsee.security.wss.TrustManager");
        validProperties.add("weblogic.wsee.connection.transportinfo");
        validProperties.add("weblogic.wsee.wst.sts_endpoint_uri");
        validProperties.add("weblogic.wsee.security.bst.serverEncryptCert");
        validProperties.add("weblogic.wsee.security.bst.serverVerifyCert");
        validProperties.add("weblogic.wsee.transport.connection.timeout");
        validProperties.add("weblogic.wsee.transport.read.timeout");
        validProperties.add("weblogic.wsee.wssc.sct.lifetime");
        validProperties.add("weblogic.wsee.wssc.dk.label");
        validProperties.add("weblogic.wsee.wssc.dk.length");
        validProperties.add("weblogic.wsee.security.message_age");
        validProperties.add("weblogic.wsee.policy.selection.preference");
        validProperties.add("weblogic.wsee.policy.compat.preference");
        validProperties.add("weblogic.wsee.security.bst.stsEncryptCert");
        validProperties.add("weblogic.wsee.wst.saml.sts_endpoint_uri");
        validProperties.add("oracle.contextelement.saml2.AttributeOnly");
        validProperties.add("weblogic.wsee.security.saml.attributies");
    }

    private static class ParameterInfo {
        String name;
        QName xmlType;
        Class javaType;
        ParameterMode mode;

        private ParameterInfo() {
        }
    }
}

