/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxrpc;

import com.bea.xml.XmlException;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.ServiceException;
import javax.xml.soap.SOAPElement;
import weblogic.wsee.bind.runtime.RuntimeBindings;
import weblogic.wsee.bind.runtime.RuntimeBindingsBuilder;
import weblogic.wsee.jaxrpc.Dispatch;
import weblogic.wsee.jaxrpc.JAXRPCContext;
import weblogic.wsee.jaxrpc.ServiceImpl;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.util.Verbose;

public class DispatchImpl
implements Dispatch {
    private static final boolean verbose = Verbose.isVerbose(DispatchImpl.class);
    private static final QName any = new QName("http://www.w3.org/2001/XMLSchema", "any");
    private Call call;
    private JAXRPCContext context;

    public DispatchImpl(QName qName, ServiceImpl serviceImpl) throws ServiceException {
        this.call = serviceImpl.createCall();
        this.setRuntimeBindings();
        this.call.setProperty("javax.xml.rpc.soap.operation.style", (Object)"document");
        this.call.setOperationName(new QName("invoke"));
        this.call.setReturnType(any, SOAPElement.class);
        this.call.addParameter("parameters", any, SOAPElement.class, ParameterMode.IN);
    }

    private void setRuntimeBindings() throws ServiceException {
        RuntimeBindingsBuilder runtimeBindingsBuilder = RuntimeBindingsBuilder.Factory.newInstance();
        try {
            RuntimeBindings runtimeBindings = runtimeBindingsBuilder.createGenericRuntimeBindings();
            this.call.setProperty("weblogic.wsee.bind.runtimeBindingProvider", (Object)runtimeBindings);
        }
        catch (IOException iOException) {
            throw new ServiceException("Failed to create runtime bindings", (Throwable)iOException);
        }
        catch (XmlException xmlException) {
            throw new ServiceException("Failed to create runtime bindings", (Throwable)xmlException);
        }
    }

    public JAXRPCContext getContext() {
        if (this.context == null) {
            this.context = new JAXRPCContext(this.call);
        }
        return this.context;
    }

    public Object invoke(Object object) throws RemoteException {
        return this.call.invoke(new Object[]{object});
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.end();
    }
}

