/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxrpc;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.Handler;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.HandlerRegistry;
import weblogic.j2ee.descriptor.ParamValueBean;
import weblogic.j2ee.descriptor.ServiceRefHandlerBean;
import weblogic.xml.schema.binding.util.ClassUtil;

public final class HandlerRegistryImpl
implements HandlerRegistry {
    private Map chainMap = Collections.synchronizedMap(new HashMap());
    private ServiceRefHandlerBean[] handlers = new ServiceRefHandlerBean[0];
    private boolean changed = false;

    HandlerRegistryImpl() {
    }

    HandlerRegistryImpl(ServiceRefHandlerBean[] serviceRefHandlerBeanArray) {
        this.handlers = serviceRefHandlerBeanArray;
    }

    public List getHandlerChain(QName qName) {
        List list = (List)this.chainMap.get(qName.getLocalPart());
        if (list == null) {
            list = this.createChain(qName);
            this.setHandlerChain(qName, list);
        }
        this.changed = true;
        return list;
    }

    public void setHandlerChain(QName qName, List list) {
        for (Object e : list) {
            if (e instanceof HandlerInfo) {
                this.validateHandlerInfo((HandlerInfo)e, qName);
                continue;
            }
            throw new JAXRPCException("The List argument to  setHandlerChain must contain instances of javax.xml.rpc.handler.HandlerInfo.  The list contained " + e.getClass().getName() + " which is not an instanceof" + " HandlerInfo.");
        }
        this.chainMap.put(qName.getLocalPart(), list);
        this.changed = true;
    }

    private void validateHandlerInfo(HandlerInfo handlerInfo, QName qName) {
        Class clazz = handlerInfo.getHandlerClass();
        if (clazz == null) {
            throw new JAXRPCException("The HandlerInfo for the name:" + qName + " had a null HandlerClass.");
        }
        if (!Handler.class.isAssignableFrom(clazz)) {
            throw new JAXRPCException("The HandlerInfo for the name:" + qName + " contains a handler class: " + clazz.getName() + " which is not an instanceof javax.xml.rpc.handler.Handler");
        }
        try {
            Constructor constructor = clazz.getConstructor(null);
            if (!Modifier.isPublic(constructor.getModifiers())) {
                throw new JAXRPCException("The HandlerInfo for the name:" + qName + " contains a handler class: " + clazz.getName() + " which has a default, no argument constructor.  However," + "this constructor is not public.");
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new JAXRPCException("The HandlerInfo for the name:" + qName + " contains a handler class: " + clazz.getName() + " which does not have a public, no argument constructor.");
        }
    }

    private List createChain(QName qName) {
        ArrayList<HandlerInfo> arrayList = new ArrayList<HandlerInfo>();
        for (int i = 0; i < this.handlers.length; ++i) {
            if (!this.containName(this.handlers[i].getPortNames(), qName.getLocalPart())) continue;
            String string = this.handlers[i].getHandlerClass();
            QName[] qNameArray = this.handlers[i].getSoapHeaders();
            Map map = this.buildInitParams(this.handlers[i].getInitParams());
            arrayList.add(new HandlerInfo(this.loadClass(string), map, qNameArray));
        }
        return arrayList;
    }

    private boolean containName(String[] stringArray, String string) {
        if (stringArray == null || stringArray.length == 0) {
            return true;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    private Map buildInitParams(ParamValueBean[] paramValueBeanArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (paramValueBeanArray == null) {
            return hashMap;
        }
        for (int i = 0; i < paramValueBeanArray.length; ++i) {
            String string = paramValueBeanArray[i].getParamName();
            String string2 = paramValueBeanArray[i].getParamValue();
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean bl) {
        this.changed = bl;
    }

    private Class loadClass(String string) {
        try {
            return ClassUtil.loadClass((String)string);
        }
        catch (ClassUtil.ClassUtilException classUtilException) {
            throw new JAXRPCException("Failed to load class " + (Object)((Object)classUtilException), (Throwable)classUtilException);
        }
    }

    public String toString() {
        return "[HandlerRegistry]: " + this.chainMap.toString();
    }
}

