/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxrpc;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.util.Map;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import weblogic.wsee.jaxrpc.ServiceImpl;

public class JndiServiceImpl
implements InvocationHandler,
Serializable {
    private String implJndiName;
    private Map portNameMap;
    private transient ServiceImpl impl = null;

    JndiServiceImpl(String string, Map map) {
        this.implJndiName = string;
        this.portNameMap = map;
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        Object object2;
        if (this.impl == null) {
            object2 = new InitialContext();
            this.impl = (ServiceImpl)object2.lookup("java:comp/env/" + this.implJndiName);
            assert (this.impl != null) : "Can't find ServiceImpl " + this.implJndiName;
        }
        if (method.getDeclaringClass().isAssignableFrom(ServiceImpl.class)) {
            return this.callServiceMethod(method, objectArray);
        }
        object2 = method.getName();
        this.checkGetPortMethod((String)object2, method);
        object2 = ((String)object2).substring(3);
        Object object3 = (String)this.portNameMap.get(object2);
        if (object3 == null) {
            object3 = object2;
        }
        return this.invokePortMethod((String)object3, method);
    }

    private Object invokePortMethod(String string, Method method) throws Throwable {
        try {
            Method method2 = ServiceImpl.class.getMethod("getPort", QName.class, Class.class);
            return method2.invoke((Object)this.impl, new QName(string), method.getReturnType());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JAXRPCException("Failed to call method " + method.getName() + illegalAccessException, (Throwable)illegalAccessException);
        }
    }

    private void checkGetPortMethod(String string, Method method) {
        if (!string.startsWith("get")) {
            this.throwMethodError(method.getName());
        }
        if (method.getParameterTypes().length != 0) {
            this.throwMethodError(method.getName());
        }
        if (!Remote.class.isAssignableFrom(method.getReturnType())) {
            this.throwMethodError(method.getName());
        }
    }

    private Object callServiceMethod(Method method, Object[] objectArray) throws Throwable {
        try {
            return method.invoke((Object)this.impl, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JAXRPCException("Failed to call method " + method.getName() + illegalAccessException, (Throwable)illegalAccessException);
        }
    }

    private void throwMethodError(String string) {
        throw new JAXRPCException("There is no suitable implementation for method " + string);
    }
}

