/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxrpc;

import java.util.HashMap;
import java.util.Map;

public class Mime2JavaMapping {
    private static final String MIME_IMAGE_GIF = "image/gif";
    private static final String MIME_IMAGE_JPG = "image/jpeg";
    private static final String MIME_TEXT = "text/plain";
    private static final String MIME_MULTIPART = "multipart";
    private static final String MIME_TEXT_XML = "text/xml";
    private static final String MIME_APP_XML = "application/xml";
    private static final String JAVA_IMAGE = "java.awt.Image";
    private static final String JAVA_TEXT = "java.lang.String";
    private static final String JAVA_MULTIPART = "javax.mail.internet.MimeMultipart";
    private static final String JAVA_XML = "javax.xml.transform.Source";
    private static Map<String, String> mime2JavaMapping = new HashMap<String, String>();

    public static String getJavaTypeFromMime(String string) {
        if (string.startsWith(MIME_MULTIPART)) {
            return JAVA_MULTIPART;
        }
        return mime2JavaMapping.get(string);
    }

    static {
        mime2JavaMapping.put(MIME_IMAGE_GIF, JAVA_IMAGE);
        mime2JavaMapping.put(MIME_IMAGE_JPG, JAVA_IMAGE);
        mime2JavaMapping.put(MIME_TEXT, JAVA_TEXT);
        mime2JavaMapping.put(MIME_TEXT_XML, JAVA_XML);
        mime2JavaMapping.put(MIME_APP_XML, JAVA_XML);
    }
}

