/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxrpc;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.ServiceFactory;
import weblogic.descriptor.DescriptorManager;
import weblogic.j2ee.descriptor.JavaWsdlMappingBean;
import weblogic.wsee.deploy.ClientDeployInfo;
import weblogic.wsee.jaxrpc.ServiceImpl;
import weblogic.wsee.util.Verbose;
import weblogic.xml.schema.binding.util.ClassUtil;

public final class ServiceFactoryImpl
extends ServiceFactory {
    private static final boolean verbose = Verbose.isVerbose(ServiceFactoryImpl.class);

    public ServiceFactoryImpl() {
        if (verbose) {
            Verbose.log("JAX-RPC Service factory created");
        }
    }

    public Service createService(URL uRL, QName qName) throws ServiceException {
        if (uRL == null) {
            throw new IllegalArgumentException("wsdlLocation can't be null.");
        }
        ClientDeployInfo clientDeployInfo = new ClientDeployInfo();
        clientDeployInfo.setServiceName(qName);
        return new ServiceImpl(clientDeployInfo, uRL.toString());
    }

    public Service createService(QName qName) throws ServiceException {
        if (qName == null) {
            throw new IllegalArgumentException("serviceName can't be null.");
        }
        ClientDeployInfo clientDeployInfo = new ClientDeployInfo();
        clientDeployInfo.setServiceName(qName);
        return new ServiceImpl(clientDeployInfo, null);
    }

    public Service createService(URL uRL, QName qName, InputStream inputStream) throws ServiceException {
        if (uRL == null) {
            throw new IllegalArgumentException("wsdlLocation can't be null.");
        }
        ClientDeployInfo clientDeployInfo = new ClientDeployInfo();
        clientDeployInfo.setMappingdd(this.loadJaxRpcMappingFile(inputStream));
        clientDeployInfo.setServiceName(qName);
        return new ServiceImpl(clientDeployInfo, uRL.toString());
    }

    private JavaWsdlMappingBean loadJaxRpcMappingFile(InputStream inputStream) throws ServiceException {
        if (inputStream == null) {
            throw new IllegalArgumentException("jaxRpcMappingStream can't be null.");
        }
        DescriptorManager descriptorManager = new DescriptorManager();
        try {
            return (JavaWsdlMappingBean)descriptorManager.createDescriptor(inputStream).getRootBean();
        }
        catch (IOException iOException) {
            throw new ServiceException("Failed to load JAX-RPC mapping file", (Throwable)iOException);
        }
    }

    public Service loadService(Class clazz) throws ServiceException {
        if (clazz == null) {
            throw new IllegalArgumentException("Service interface can not be null");
        }
        String string = this.implClassName(clazz);
        if (verbose) {
            Verbose.log("Loading service implementation: " + string);
        }
        try {
            Service service2 = (Service)ClassUtil.newInstance((String)string);
            return service2;
        }
        catch (ClassUtil.ClassUtilException classUtilException) {
            throw new ServiceException("Failed to load service implementation class:" + string, (Throwable)classUtilException);
        }
    }

    private String implClassName(Class clazz) {
        return clazz.getName() + "_Impl";
    }

    public Service loadService(URL uRL, Class clazz, Properties properties) throws ServiceException {
        if (uRL == null) {
            throw new IllegalArgumentException("WSDL cannot be null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Service interface can not be null");
        }
        String string = this.implClassName(clazz);
        Class clazz2 = this.loadServiceClass(string);
        return this.newService(clazz2, uRL);
    }

    private Service newService(Class clazz, URL uRL) throws ServiceException {
        try {
            Class[] classArray = new Class[]{String.class};
            Constructor constructor = clazz.getConstructor(classArray);
            Service service2 = (Service)constructor.newInstance(uRL.toString());
            return service2;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ServiceException((Throwable)noSuchMethodException);
        }
        catch (SecurityException securityException) {
            throw new ServiceException((Throwable)securityException);
        }
        catch (InstantiationException instantiationException) {
            throw new ServiceException((Throwable)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ServiceException((Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ServiceException((Throwable)invocationTargetException);
        }
    }

    private Class loadServiceClass(String string) throws ServiceException {
        Class clazz;
        try {
            clazz = ClassUtil.loadClass((String)string);
        }
        catch (ClassUtil.ClassUtilException classUtilException) {
            throw new ServiceException("Failed to load impl class:" + string, (Throwable)classUtilException);
        }
        return clazz;
    }

    public Service loadService(URL uRL, QName qName, Properties properties) throws ServiceException {
        throw new Error("NYI");
    }
}

