/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxrpc;

import com.bea.xbean.xb.xsdschema.SchemaDocument;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.Stub;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import javax.xml.rpc.handler.HandlerRegistry;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import weblogic.application.descriptor.NamespaceURIMunger;
import weblogic.descriptor.DescriptorManager;
import weblogic.descriptor.EditableDescriptorManager;
import weblogic.j2ee.descriptor.JavaWsdlMappingBean;
import weblogic.j2ee.descriptor.ServiceRefBean;
import weblogic.j2ee.descriptor.wl.PortInfoBean;
import weblogic.j2ee.descriptor.wl.PropertyNamevalueBean;
import weblogic.j2ee.descriptor.wl.ServiceReferenceDescriptionBean;
import weblogic.j2ee.descriptor.wl.WeblogicWseeStandaloneclientBean;
import weblogic.wsee.bind.runtime.RuntimeBindings;
import weblogic.wsee.connection.transport.TransportInfo;
import weblogic.wsee.context.ContextNotFoundException;
import weblogic.wsee.context.WebServiceContext;
import weblogic.wsee.deploy.ClientDeployInfo;
import weblogic.wsee.deploy.WsdlAddressInfo;
import weblogic.wsee.jaxrpc.CallImpl;
import weblogic.wsee.jaxrpc.Dispatch;
import weblogic.wsee.jaxrpc.DispatchImpl;
import weblogic.wsee.jaxrpc.HandlerRegistryImpl;
import weblogic.wsee.jaxrpc.StubImpl;
import weblogic.wsee.jaxrpc.WLService;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.framework.PolicyMath;
import weblogic.wsee.policy.framework.PolicyStatement;
import weblogic.wsee.policy.runtime.PolicyFinder;
import weblogic.wsee.security.policy.SecurityPolicyCustomizer;
import weblogic.wsee.security.policy.assertions.SecurityPolicyAssertionFactory;
import weblogic.wsee.security.wssp.SecurityPolicyAssertionInfoFactory;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsEndpoint;
import weblogic.wsee.ws.WsException;
import weblogic.wsee.ws.WsFactory;
import weblogic.wsee.ws.WsMethod;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.WsService;
import weblogic.wsee.ws.WsStub;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlFactory;
import weblogic.wsee.wsdl.WsdlOperation;
import weblogic.wsee.wsdl.WsdlPartnerLinkType;
import weblogic.wsee.wsdl.WsdlPort;
import weblogic.wsee.wsdl.WsdlPortType;
import weblogic.wsee.wsdl.WsdlService;
import weblogic.wsee.wsdl.WsdlTypes;
import weblogic.wsee.wsdl.WsdlUtils;
import weblogic.wsee.wsdl.builder.WsdlBindingBuilder;
import weblogic.wsee.wsdl.builder.WsdlDefinitionsBuilder;
import weblogic.wsee.wsdl.builder.WsdlOperationBuilder;
import weblogic.wsee.wsdl.builder.WsdlPortBuilder;
import weblogic.wsee.wsdl.builder.WsdlPortTypeBuilder;
import weblogic.wsee.wsdl.builder.WsdlServiceBuilder;
import weblogic.wsee.wsdl.soap11.SoapAddress;
import weblogic.wsee.wsdl.validation.WsdlValidationException;
import weblogic.wsee.wsdl.validation.WsdlValidationRegistry;
import weblogic.xml.schema.binding.internal.NameUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceImpl
implements WLService {
    private static final boolean verbose = Verbose.isVerbose(ServiceImpl.class);
    static final int FULL_WSDL = 1;
    static final int PARTIAL_WSDL = 2;
    static final int NO_WSDL = 3;
    private static final String DEFAULT_SERVICE_NAME = "weblogic_defalt_service_name_for_partial_wsdl";
    private WsService webservice;
    private String wsdlLocation;
    private QName serviceName;
    private int wsdlStatus;
    private Map portComponentLinks = new HashMap();
    private Map bareCallProps = new HashMap();
    private Map portCallProps = new HashMap();
    private Map portStubProps = new HashMap();
    private HandlerRegistry handlerRegistry = new HandlerRegistryImpl();
    private boolean hasCallback = false;
    private boolean has81Callback = false;
    private QName callbackServiceQName = null;
    private boolean allowHandlerChain = true;
    private boolean policyListenerLoaded = false;
    protected TransportInfo transportInfo = null;
    private ClientDeployInfo clientDeployInfo;

    protected ServiceImpl(String string, QName qName, String string2) throws ServiceException {
        this(string, qName, string2, null);
    }

    protected ServiceImpl(String string, QName qName, String string2, TransportInfo transportInfo) throws ServiceException {
        if (verbose) {
            Verbose.logArgs("wsdl", string, "service name", qName, "configuration", string2);
        }
        this.transportInfo = transportInfo;
        String string3 = ServiceImpl.getWsdlUrl(string);
        ClientDeployInfo clientDeployInfo = new ClientDeployInfo();
        clientDeployInfo.setWsdlDef(this.loadWsdlDefinition(string3, qName));
        clientDeployInfo.setServiceName(qName);
        this.loadInternalDD(clientDeployInfo, string2);
        this.init(clientDeployInfo);
        this.parseCallAndStubProps(clientDeployInfo.getWlServiceRef());
    }

    ServiceImpl(ClientDeployInfo clientDeployInfo, String string) throws ServiceException {
        if (verbose) {
            Verbose.log("Non generated Impl client created : wsdl " + string);
        }
        if (string == null) {
            if (verbose) {
                Verbose.log("Service without WSDL");
            }
            this.wsdlStatus = 3;
            this.serviceName = clientDeployInfo.getServiceName();
        } else {
            this.wsdlLocation = string;
            clientDeployInfo.setWsdlDef(this.loadWsdlDefinition(string, clientDeployInfo.getServiceName()));
            this.init(clientDeployInfo);
        }
        this.parseCallAndStubProps(clientDeployInfo.getWlServiceRef());
    }

    private void init(ClientDeployInfo clientDeployInfo) throws ServiceException {
        try {
            this.checkWsdlDefinition(clientDeployInfo);
            if (clientDeployInfo.getMappingdd() != null) {
                WsFactory wsFactory = WsFactory.instance();
                this.webservice = wsFactory.createClientService(clientDeployInfo);
            } else {
                this.clientDeployInfo = clientDeployInfo;
            }
            this.initHandlerRegistry(clientDeployInfo);
        }
        catch (WsdlValidationException wsdlValidationException) {
            ServiceImpl.throwServiceException(wsdlValidationException.getMessage(), wsdlValidationException);
        }
        catch (WsException wsException) {
            ServiceImpl.throwServiceException(wsException.getMessage(), wsException);
        }
    }

    private void initHandlerRegistry(ClientDeployInfo clientDeployInfo) {
        ServiceRefBean serviceRefBean = clientDeployInfo.getServiceRef();
        if (serviceRefBean != null) {
            this.handlerRegistry = new HandlerRegistryImpl(serviceRefBean.getHandlers());
        }
    }

    static void throwServiceException(String string, Throwable throwable) throws ServiceException {
        ServiceException serviceException = new ServiceException(string, throwable);
        if (serviceException.getCause() == null) {
            serviceException.initCause(throwable);
        }
        throw serviceException;
    }

    private void parseCallAndStubProps(ServiceReferenceDescriptionBean serviceReferenceDescriptionBean) throws ServiceException {
        if (serviceReferenceDescriptionBean == null) {
            return;
        }
        PropertyNamevalueBean[] propertyNamevalueBeanArray = serviceReferenceDescriptionBean.getCallProperties();
        this.populateCallProperties(propertyNamevalueBeanArray);
        PortInfoBean[] portInfoBeanArray = serviceReferenceDescriptionBean.getPortInfos();
        for (int i = 0; i < portInfoBeanArray.length; ++i) {
            PortInfoBean portInfoBean = portInfoBeanArray[i];
            String string = portInfoBean.getPortName();
            this.populatePortProperties(portInfoBean, string);
            this.populateStubProperties(portInfoBean, string);
        }
    }

    private void populateStubProperties(PortInfoBean portInfoBean, String string) {
        PropertyNamevalueBean[] propertyNamevalueBeanArray = portInfoBean.getStubProperties();
        if (propertyNamevalueBeanArray != null && propertyNamevalueBeanArray.length > 0) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (int i = 0; i < propertyNamevalueBeanArray.length; ++i) {
                PropertyNamevalueBean propertyNamevalueBean = propertyNamevalueBeanArray[i];
                hashMap.put(propertyNamevalueBean.getName(), propertyNamevalueBean.getValue());
            }
            this.portStubProps.put(string, hashMap);
        }
    }

    private void populatePortProperties(PortInfoBean portInfoBean, String string) {
        PropertyNamevalueBean[] propertyNamevalueBeanArray = portInfoBean.getCallProperties();
        if (propertyNamevalueBeanArray != null && propertyNamevalueBeanArray.length > 0) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (int i = 0; i < propertyNamevalueBeanArray.length; ++i) {
                PropertyNamevalueBean propertyNamevalueBean = propertyNamevalueBeanArray[i];
                hashMap.put(propertyNamevalueBean.getName(), propertyNamevalueBean.getValue());
            }
            this.portCallProps.put(string, hashMap);
        }
    }

    private void populateCallProperties(PropertyNamevalueBean[] propertyNamevalueBeanArray) throws ServiceException {
        for (int i = 0; i < propertyNamevalueBeanArray.length; ++i) {
            PropertyNamevalueBean propertyNamevalueBean = propertyNamevalueBeanArray[i];
            if (!CallImpl.isValidProperty(propertyNamevalueBean.getName())) {
                throw new ServiceException(propertyNamevalueBean.getName() + " is not a " + "valid JAX RPC Call object property.");
            }
            this.bareCallProps.put(propertyNamevalueBean.getName(), propertyNamevalueBean.getValue());
        }
    }

    private void checkWsdlDefinition(ClientDeployInfo clientDeployInfo) throws WsdlValidationException, ServiceException {
        WsdlDefinitionsBuilder wsdlDefinitionsBuilder = (WsdlDefinitionsBuilder)clientDeployInfo.getWsdlDef();
        if (wsdlDefinitionsBuilder.getServices().size() == 0) {
            this.wsdlStatus = 2;
            if (verbose) {
                Verbose.log("Service with partial WSDL");
            }
            this.createDummyService(wsdlDefinitionsBuilder);
        } else {
            this.wsdlStatus = 1;
            if (verbose) {
                Verbose.log("Service with full WSDL");
            }
            this.findServiceName(clientDeployInfo, wsdlDefinitionsBuilder);
        }
        WsdlPartnerLinkType wsdlPartnerLinkType = (WsdlPartnerLinkType)wsdlDefinitionsBuilder.getExtension("PartnerLinkType");
        if (wsdlPartnerLinkType != null) {
            this.setCallbackServiceQName(wsdlDefinitionsBuilder, wsdlPartnerLinkType);
        } else {
            this.checkAndSet81CallbackServiceQName(wsdlDefinitionsBuilder, this.serviceName);
        }
        clientDeployInfo.setServiceName(this.serviceName);
        WsdlValidationRegistry.getInstance().validate(wsdlDefinitionsBuilder);
    }

    private void checkAndSet81CallbackServiceQName(WsdlDefinitionsBuilder wsdlDefinitionsBuilder, QName qName) {
        WsdlServiceBuilder wsdlServiceBuilder = wsdlDefinitionsBuilder.getServices().get(qName);
        if (wsdlServiceBuilder == null) {
            throw new IllegalArgumentException("Cannot find a service with QName " + qName + " in provided WSDL");
        }
        for (WsdlPortTypeBuilder wsdlPortTypeBuilder : wsdlServiceBuilder.getPortTypes()) {
            for (WsdlOperationBuilder wsdlOperationBuilder : wsdlPortTypeBuilder.getOperations().values()) {
                if (!wsdlOperationBuilder.isWLW81CallbackOperation()) continue;
                this.callbackServiceQName = qName;
                this.has81Callback = true;
                return;
            }
        }
    }

    private void setCallbackServiceQName(WsdlDefinitions wsdlDefinitions, WsdlPartnerLinkType wsdlPartnerLinkType) {
        this.hasCallback = true;
        for (WsdlService wsdlService : wsdlDefinitions.getServices().values()) {
            for (WsdlPortType wsdlPortType : wsdlService.getPortTypes()) {
                try {
                    if (verbose) {
                        Verbose.log("Port type " + wsdlPortType.getName() + " link name " + wsdlPartnerLinkType.getRole2Name() + ", " + wsdlPartnerLinkType.getPortTypeName("Callback"));
                    }
                    if (!wsdlPortType.getName().equals(wsdlPartnerLinkType.getPortTypeName("Callback"))) continue;
                    this.callbackServiceQName = wsdlService.getName();
                    return;
                }
                catch (WsdlException wsdlException) {
                    throw new JAXRPCException("Failed to parse WSDL", (Throwable)wsdlException);
                }
            }
        }
    }

    public boolean hasCallback() {
        return this.hasCallback;
    }

    public boolean has81Callback() {
        return this.has81Callback;
    }

    public QName getCallbackServiceName() {
        return this.callbackServiceQName;
    }

    private void findServiceName(ClientDeployInfo clientDeployInfo, WsdlDefinitions wsdlDefinitions) throws ServiceException {
        if (clientDeployInfo.getServiceName() != null) {
            this.serviceName = clientDeployInfo.getServiceName();
        } else if (clientDeployInfo.getServiceRef().getServiceQname() != null) {
            this.serviceName = clientDeployInfo.getServiceRef().getServiceQname();
        } else {
            Iterator<? extends WsdlService> iterator = wsdlDefinitions.getServices().values().iterator();
            WsdlService wsdlService = iterator.next();
            if (iterator.hasNext()) {
                throw new ServiceException("Wsdl has more than one service, service-name is required.");
            }
            this.serviceName = wsdlService.getName();
        }
    }

    private void createDummyService(WsdlDefinitionsBuilder wsdlDefinitionsBuilder) {
        if (this.serviceName == null) {
            this.serviceName = new QName(wsdlDefinitionsBuilder.getTargetNamespace(), DEFAULT_SERVICE_NAME);
        }
        WsdlServiceBuilder wsdlServiceBuilder = wsdlDefinitionsBuilder.addService(this.serviceName);
        for (WsdlBindingBuilder wsdlBindingBuilder : wsdlDefinitionsBuilder.getBindings().values()) {
            String string = wsdlBindingBuilder.getPortType().getName().getNamespaceURI();
            QName qName = new QName(string, wsdlBindingBuilder.getName() + "port");
            WsdlPortBuilder wsdlPortBuilder = wsdlServiceBuilder.addPort(qName, wsdlBindingBuilder);
            wsdlPortBuilder.setBinding(wsdlBindingBuilder.getName());
        }
    }

    private void loadInternalDD(ClientDeployInfo clientDeployInfo, String string) throws ServiceException {
        this.loadWeblogicDD(string, clientDeployInfo);
        this.loadJaxrpcMappingDD(clientDeployInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadJaxrpcMappingDD(ClientDeployInfo clientDeployInfo) throws ServiceException {
        InputStream inputStream = null;
        try {
            String string = clientDeployInfo.getServiceRef().getJaxrpcMappingFile();
            inputStream = this.loadResource(string);
            if (inputStream == null) {
                throw new ServiceException("weblogic client JAX_RPC mapping file " + string + "not found. Please make sure all " + "clientgen generated files are in the classpath.");
            }
            DescriptorManager descriptorManager = new DescriptorManager();
            JavaWsdlMappingBean javaWsdlMappingBean = (JavaWsdlMappingBean)descriptorManager.createDescriptor(inputStream).getRootBean();
            clientDeployInfo.setMappingdd(javaWsdlMappingBean);
            this.ignoreClose(inputStream);
        }
        catch (IOException iOException) {
            try {
                ServiceImpl.throwServiceException("Failed to load weblogic client's  JAX RPC mapping file. " + iOException, iOException);
                this.ignoreClose(inputStream);
            }
            catch (Throwable throwable) {
                this.ignoreClose(inputStream);
                throw throwable;
            }
        }
    }

    private void ignoreClose(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadWeblogicDD(String string, ClientDeployInfo clientDeployInfo) throws ServiceException {
        InputStream inputStream = null;
        try {
            inputStream = this.loadResource(string);
            if (inputStream == null) {
                throw new ServiceException("weblogic client internal deployment descriptor " + string + " not found. Please make sure all " + "clientgen generated files are in the classpath.");
            }
            DescriptorManager descriptorManager = new DescriptorManager();
            String[] stringArray = new String[]{"http://www.bea.com/ns/weblogic/90", "http://www.bea.com/ns/weblogic/weblogic-wsee-standaloneclient"};
            WeblogicWseeStandaloneclientBean weblogicWseeStandaloneclientBean = (WeblogicWseeStandaloneclientBean)descriptorManager.createDescriptor((XMLStreamReader)new NamespaceURIMunger(inputStream, "http://xmlns.oracle.com/weblogic/weblogic-wsee-standaloneclient", stringArray)).getRootBean();
            clientDeployInfo.setServiceRef(weblogicWseeStandaloneclientBean.getServiceRef());
        }
        catch (XMLStreamException xMLStreamException) {
            ServiceImpl.throwServiceException("Failed to load weblogic client internal deployment descriptor. " + xMLStreamException, xMLStreamException);
        }
        catch (IOException iOException) {
            ServiceImpl.throwServiceException("Failed to load weblogic client internal deployment descriptor. " + iOException, iOException);
        }
        finally {
            this.ignoreClose(inputStream);
        }
    }

    static String getWsdlUrl(String string) throws ServiceException {
        try {
            new URL(string);
            return string;
        }
        catch (MalformedURLException malformedURLException) {
            URL uRL = ServiceImpl.loadResourceAsSource(string);
            if (uRL != null) {
                return uRL.toString();
            }
            throw new ServiceException("Invalid wsdl location " + string);
        }
    }

    private WsdlDefinitions loadWsdlDefinition(String string, QName qName) throws ServiceException {
        try {
            WsdlDefinitions wsdlDefinitions = WsdlFactory.getInstance().parse(this.transportInfo, string, true);
            if (qName != null && wsdlDefinitions.getServices().get(qName) == null) {
                throw new ServiceException("Can't find service \"" + qName + "\" in wsdl \"" + string + "\".");
            }
            return wsdlDefinitions;
        }
        catch (WsdlException wsdlException) {
            ServiceImpl.throwServiceException("Failed to parse WSDL " + string + " " + wsdlException, wsdlException);
            return null;
        }
    }

    private InputStream loadResource(String string) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        InputStream inputStream = null;
        inputStream = classLoader.getResourceAsStream(string);
        if (inputStream == null) {
            inputStream = this.getClass().getResourceAsStream(string);
        }
        return inputStream;
    }

    private static URL loadResourceAsSource(String string) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = string.getClass().getClassLoader();
        }
        URL uRL = null;
        uRL = classLoader.getResource(string);
        if (uRL == null) {
            uRL = string.getClass().getResource(string);
        }
        return uRL;
    }

    private void setEmptyJaxrpcMapping(ClientDeployInfo clientDeployInfo) {
        if (clientDeployInfo.getMappingdd() != null) {
            return;
        }
        EditableDescriptorManager editableDescriptorManager = new EditableDescriptorManager();
        JavaWsdlMappingBean javaWsdlMappingBean = (JavaWsdlMappingBean)editableDescriptorManager.createDescriptorRoot(JavaWsdlMappingBean.class).getRootBean();
        clientDeployInfo.setMappingdd(javaWsdlMappingBean);
    }

    int getWsdlStatus() {
        return this.wsdlStatus;
    }

    WsService getWebService() {
        if (this.webservice == null) {
            try {
                WsFactory wsFactory = WsFactory.instance();
                this.webservice = wsFactory.createClientService(this.clientDeployInfo);
            }
            catch (WsException wsException) {
                if (verbose) {
                    Verbose.logException(wsException);
                }
                throw new JAXRPCException("Faile to create ws runtime structure " + wsException, (Throwable)wsException);
            }
        }
        return this.webservice;
    }

    void setPortComponentLinks(Map map) {
        if (map != null) {
            this.portComponentLinks = map;
        }
    }

    WsService createWebService(WsdlDefinitions wsdlDefinitions, QName qName, RuntimeBindings runtimeBindings) {
        try {
            WsFactory wsFactory = WsFactory.instance();
            ClientDeployInfo clientDeployInfo = new ClientDeployInfo();
            clientDeployInfo.setWsdlDef(wsdlDefinitions);
            clientDeployInfo.setServiceName(qName);
            this.setEmptyJaxrpcMapping(clientDeployInfo);
            clientDeployInfo.setRuntimeBindings(runtimeBindings);
            this.webservice = wsFactory.createClientService(clientDeployInfo);
        }
        catch (WsException wsException) {
            if (verbose) {
                Verbose.logException(wsException);
            }
            throw new JAXRPCException("Faile to create ws runtime structure " + wsException, (Throwable)wsException);
        }
        return this.webservice;
    }

    WsStub getWsStub(WsdlPort wsdlPort) {
        return (WsStub)this.getWebService().getEndpoint(wsdlPort.getPortType().getName());
    }

    HandlerRegistry _internalGetHandlerRegistry() {
        return this.handlerRegistry;
    }

    public String _getPortTransport(String string) {
        WsdlPort wsdlPort = this._getPort(string);
        return wsdlPort.getTransport();
    }

    public String _getPortLocation(String string) {
        WsdlPort wsdlPort = this._getPort(string);
        return WsdlUtils.getSoapAddress(wsdlPort).getLocation();
    }

    public String _getPortBindingType(String string) {
        WsdlPort wsdlPort = this._getPort(string);
        return wsdlPort.getBinding().getBindingType();
    }

    public boolean _has81Conversation() {
        SchemaDocument[] schemaDocumentArray;
        if (this.webservice == null) {
            return false;
        }
        WsdlTypes wsdlTypes = this.webservice.getWsdlService().getDefinitions().getTypes();
        if (wsdlTypes == null) {
            return false;
        }
        for (SchemaDocument schemaDocument : schemaDocumentArray = wsdlTypes.getSchemaArray()) {
            if (!"http://www.openuri.org/2002/04/soap/conversation/".equals(schemaDocument.getSchema().getTargetNamespace())) continue;
            return true;
        }
        return false;
    }

    protected WsdlPort _getPort(String string) {
        String string2 = this.getWebService().getWsdlService().getName().getNamespaceURI();
        WsdlPort wsdlPort = this.getWebService().getWsdlService().getPorts().get(new QName(string2, string));
        if (wsdlPort == null) {
            throw new JAXRPCException("unable to find port:" + string + " This may be because the WSDL file and the generated stub is out " + " sync. Doing clientgen again may fix this problem.");
        }
        return wsdlPort;
    }

    public Remote getPort(QName qName, Class clazz) throws ServiceException {
        if (this.wsdlStatus != 1) {
            throw new ServiceException("This service is not created from a full wsdl,\"Remote getPort(QName port, Class SEI)\" is not allowed");
        }
        if (qName == null) {
            throw new ServiceException("Port name can not be null");
        }
        WsdlPort wsdlPort = null;
        this.lazyLoadInternalDDAndService(clazz);
        try {
            wsdlPort = this._getPort(qName.getLocalPart());
        }
        catch (JAXRPCException jAXRPCException) {
            ServiceImpl.throwServiceException("Failed to get port", jAXRPCException);
        }
        return this.createStub(clazz, wsdlPort);
    }

    private void lazyLoadInternalDDAndService(Class clazz) throws ServiceException {
        if (this.clientDeployInfo != null && this.clientDeployInfo.getMappingdd() == null) {
            String string = NameUtil.getJAXRPCClassName((String)this.serviceName.getLocalPart());
            if (clazz == null) {
                throw new JAXRPCException("Port type class can't be null! ");
            }
            String string2 = clazz.getPackage().getName().replace(".", "/") + "/" + string + "_internaldd.xml";
            this.loadInternalDD(this.clientDeployInfo, string2);
            try {
                WsFactory wsFactory = WsFactory.instance();
                this.webservice = wsFactory.createClientService(this.clientDeployInfo);
            }
            catch (WsException wsException) {
                if (verbose) {
                    Verbose.logException(wsException);
                }
                throw new JAXRPCException("Faile to create ws runtime structure " + wsException, (Throwable)wsException);
            }
        }
    }

    public Remote getPort(Class clazz) throws ServiceException {
        Class clazz2;
        WsEndpoint wsEndpoint;
        if (this.wsdlStatus == 3) {
            throw new ServiceException("This service is not created from a wsdl,\"Remote getPort(Class SEI)\" is not allowed");
        }
        this.lazyLoadInternalDDAndService(clazz);
        Iterator iterator = this.getWebService().getEndpoints();
        while (iterator.hasNext()) {
            wsEndpoint = (WsEndpoint)iterator.next();
            clazz2 = wsEndpoint.getEndpointInterface();
            if (clazz2 == null || !clazz.isAssignableFrom(clazz2)) continue;
            return this.createStub(clazz, wsEndpoint);
        }
        iterator = this.getWebService().getEndpoints();
        block1: while (iterator.hasNext()) {
            int n;
            wsEndpoint = (WsEndpoint)iterator.next();
            clazz2 = wsEndpoint.getEndpointInterface();
            Method[] methodArray = clazz.getMethods();
            if (clazz2 == null) {
                for (n = 0; n < methodArray.length; ++n) {
                    if (wsEndpoint.getMethod(methodArray[n].getName()) == null) continue block1;
                }
            } else {
                for (n = 0; n < methodArray.length; ++n) {
                    if (!this.isInClass(clazz2, methodArray[n])) continue block1;
                }
            }
            return this.createStub(clazz, wsEndpoint);
        }
        throw new ServiceException("unable to find any port that can implement service endpoint interface " + clazz);
    }

    private Remote createStub(Class clazz, WsEndpoint wsEndpoint) throws ServiceException {
        for (WsdlPort wsdlPort : this.getWebService().getWsdlService().getPorts().values()) {
            boolean bl = false;
            Object object = this.getWebService().getPorts();
            while (object.hasNext()) {
                WsPort wsPort = object.next();
                if (!wsdlPort.getName().equals(wsPort.getWsdlPort().getName())) continue;
                bl = true;
                break;
            }
            if (!bl || wsEndpoint.getPortType() != wsdlPort.getPortType()) continue;
            object = this.createStub(clazz, wsdlPort);
            this.checkLinkedPort((Stub)object, clazz);
            return object;
        }
        throw new ServiceException("unable to find any port that use " + wsEndpoint.getPortType().getName() + " as port type.");
    }

    private void checkLinkedPort(Stub stub, Class clazz) throws ServiceException {
        WsdlPort wsdlPort = (WsdlPort)this.portComponentLinks.get(clazz.getName());
        if (wsdlPort != null) {
            SoapAddress soapAddress = WsdlUtils.getSoapAddress(wsdlPort);
            if (soapAddress == null) {
                throw new ServiceException("wsdl port " + wsdlPort + " doesn't " + "have a soap address extension.");
            }
            WsdlAddressInfo wsdlAddressInfo = new WsdlAddressInfo();
            wsdlAddressInfo.addWsdlPort(wsdlPort.getName(), wsdlPort.getPortAddress());
            WsdlUtils.updateAddress(wsdlPort.getDefinitions(), wsdlAddressInfo);
            stub._setProperty("javax.xml.rpc.service.endpoint.address", (Object)soapAddress.getLocation());
        }
    }

    private Remote createStub(Class clazz, WsdlPort wsdlPort) {
        HashMap hashMap = (HashMap)this.portStubProps.get(wsdlPort.getName().getLocalPart());
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        return (Remote)StubImpl.implementInterface(clazz, wsdlPort, hashMap, this);
    }

    private boolean isInClass(Class clazz, Method method) {
        Method[] methodArray = clazz.getMethods();
        block0: for (int i = 0; i < methodArray.length; ++i) {
            Class<?>[] classArray;
            Class<?>[] classArray2;
            if (!method.getName().equals(methodArray[i].getName()) || !method.getReturnType().isAssignableFrom(methodArray[i].getReturnType()) || (classArray2 = method.getParameterTypes()).length != (classArray = methodArray[i].getParameterTypes()).length) continue;
            for (int j = 0; j < classArray2.length; ++j) {
                if (!classArray2[j].isAssignableFrom(classArray[j])) continue block0;
            }
            return true;
        }
        return false;
    }

    void _setAllowHandlerChain(boolean bl) {
        this.allowHandlerChain = bl;
    }

    public HandlerRegistry getHandlerRegistry() {
        if (this.allowHandlerChain) {
            return this.handlerRegistry;
        }
        throw new UnsupportedOperationException("This operation is not supported  in a JSR 109 based web service");
    }

    public Call createCall() throws ServiceException {
        CallImpl callImpl = new CallImpl(this);
        for (Map.Entry entry : this.bareCallProps.entrySet()) {
            callImpl.setProperty((String)entry.getKey(), entry.getValue());
        }
        return callImpl;
    }

    public Call createCall(QName qName) throws ServiceException {
        if (this.wsdlStatus != 1) {
            throw new ServiceException("This service is not created from a full wsdl, \"Call createCall(QName port)\" is not allowed.");
        }
        if (qName == null) {
            throw new ServiceException("portName can not be null");
        }
        CallImpl callImpl = new CallImpl(this);
        WsdlPortBuilder wsdlPortBuilder = (WsdlPortBuilder)this.getWebService().getWsdlService().getPorts().get(qName);
        if (wsdlPortBuilder == null) {
            throw new ServiceException("Unable to find port " + qName + " in this web service. Make sure that you have provided " + "the right WSDL url");
        }
        callImpl.setWsdlPort(wsdlPortBuilder);
        Map map = (Map)this.portCallProps.get(qName.getLocalPart());
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                callImpl.setProperty((String)entry.getKey(), entry.getValue());
            }
        }
        return callImpl;
    }

    public Call createCall(QName qName, QName qName2) throws ServiceException {
        if (this.wsdlStatus != 1) {
            throw new ServiceException("This service is not created from a full wsdl, \"Call createCall(QName port, QName operation)\" is not allowed.");
        }
        Call call = this.createCall(qName);
        call.setOperationName(qName2);
        return call;
    }

    public Call createCall(QName qName, String string) throws ServiceException {
        if (this.wsdlStatus != 1) {
            throw new ServiceException("This service is not created from a full wsdl, \"Call createCall(QName port, String operation)\" is not allowed.");
        }
        String string2 = this.guessOperationNS(qName, string);
        return this.createCall(qName, new QName(string2, string));
    }

    private String guessOperationNS(QName qName, String string) throws ServiceException {
        WsdlPort wsdlPort = this.webservice.getWsdlService().getPorts().get(qName);
        WsdlPortType wsdlPortType = wsdlPort.getPortType();
        for (WsdlOperation wsdlOperation : wsdlPortType.getOperations().values()) {
            if (!string.equals(wsdlOperation.getName().getLocalPart())) continue;
            return wsdlOperation.getName().getNamespaceURI();
        }
        throw new ServiceException("Unable to find operation: " + string + " in port " + wsdlPortType);
    }

    public Call[] getCalls(QName qName) throws ServiceException {
        if (this.wsdlStatus != 1) {
            throw new ServiceException("This service is not created from a full wsdl, \"Call[] getCalls(QName port)\" is not allowed.");
        }
        if (qName == null) {
            throw new ServiceException("portName can not be null");
        }
        ArrayList<Call> arrayList = new ArrayList<Call>();
        WsdlPort wsdlPort = null;
        try {
            wsdlPort = this._getPort(qName.getLocalPart());
        }
        catch (JAXRPCException jAXRPCException) {
            ServiceImpl.throwServiceException("Failed to get port", jAXRPCException);
        }
        for (WsdlOperation wsdlOperation : wsdlPort.getPortType().getOperations().values()) {
            Call call = this.createCall(qName, wsdlOperation.getName());
            arrayList.add(call);
        }
        return arrayList.toArray(new Call[arrayList.size()]);
    }

    public QName getServiceName() {
        if (this.wsdlStatus == 3) {
            throw new JAXRPCException("This service is not created from a wsdl,\"QName getServiceName()\" is not allowed");
        }
        return this.serviceName;
    }

    public Iterator getPorts() throws ServiceException {
        if (this.wsdlStatus == 3) {
            throw new ServiceException("This service is not created from a wsdl,\"Iterator getPorts()\" is not allowed");
        }
        ArrayList<QName> arrayList = new ArrayList<QName>();
        WsdlService wsdlService = this.getWebService().getWsdlService();
        for (WsdlPort wsdlPort : wsdlService.getPorts().values()) {
            arrayList.add(wsdlPort.getName());
        }
        if (arrayList.size() == 0) {
            throw new ServiceException("Unable to find port in this web service. Make sure that you have provided the right WSDL url");
        }
        return arrayList.iterator();
    }

    public URL getWSDLDocumentLocation() {
        if (this.wsdlStatus == 3) {
            throw new JAXRPCException("This service is not created from a wsdl,\"URL getWSDLDocumentLocation()\" is not allowed");
        }
        try {
            return this.wsdlLocation == null ? null : new URL(this.wsdlLocation);
        }
        catch (IOException iOException) {
            try {
                return new URL("file://" + this.wsdlLocation);
            }
            catch (MalformedURLException malformedURLException) {
                throw new JAXRPCException("unable to create URL : " + this.wsdlLocation);
            }
        }
    }

    public TypeMappingRegistry getTypeMappingRegistry() throws JAXRPCException {
        throw new UnsupportedOperationException("This operation is not support in JSR 109 web service implementation");
    }

    protected void _setUser(String string, String string2, Object object) {
        if (string == null) {
            throw new IllegalArgumentException("No username provided");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("No password provided");
        }
        if (object == null || !(object instanceof Stub)) {
            throw new IllegalArgumentException("Got a bad stub:" + object);
        }
        Stub stub = (Stub)object;
        stub._setProperty("javax.xml.rpc.security.auth.username", (Object)string);
        stub._setProperty("javax.xml.rpc.security.auth.password", (Object)string2);
    }

    @Override
    public void loadPolicy(String string, String string2, InputStream[] inputStreamArray, InputStream[] inputStreamArray2) throws ServiceException {
        this._loadPolicy(string, string2, inputStreamArray, inputStreamArray2);
    }

    protected void _loadPolicy(String string, String string2, Set<InputStream> set, Set<InputStream> set2) throws ServiceException {
        if (set == set2) {
            InputStream[] inputStreamArray = set == null ? null : set.toArray(new InputStream[0]);
            this._loadPolicy(string, string2, inputStreamArray, inputStreamArray);
        } else {
            this._loadPolicy(string, string2, set == null ? null : set.toArray(new InputStream[0]), set2 == null ? null : set2.toArray(new InputStream[0]));
        }
    }

    protected void _loadPolicy(String string, String string2, InputStream[] inputStreamArray, InputStream[] inputStreamArray2) throws ServiceException {
        NormalizedExpression normalizedExpression;
        NormalizedExpression normalizedExpression2;
        if (inputStreamArray == inputStreamArray2) {
            normalizedExpression = normalizedExpression2 = ServiceImpl.getNormalizedPolicies(string, inputStreamArray);
        } else {
            ServiceImpl.checkDuplicatePolicyStreams(inputStreamArray, inputStreamArray2);
            normalizedExpression = ServiceImpl.getNormalizedPolicies(string, inputStreamArray);
            normalizedExpression2 = ServiceImpl.getNormalizedPolicies(string, inputStreamArray2);
        }
        this.__loadPolicies(string, string2, normalizedExpression, normalizedExpression2);
    }

    protected void _loadPolicy(String string, InputStream inputStream, boolean bl, boolean bl2) throws ServiceException {
        NormalizedExpression normalizedExpression = ServiceImpl.getNormalizedPolicy(string, inputStream);
        this.__loadPolicies(string, null, bl ? normalizedExpression : null, bl2 ? normalizedExpression : null);
    }

    private void __loadPolicies(String string, String string2, NormalizedExpression normalizedExpression, NormalizedExpression normalizedExpression2) throws ServiceException {
        Object object;
        Object object2;
        if (this.webservice == null) {
            throw new ServiceException("Webservice is not yet initialized.");
        }
        WsPort wsPort = this.webservice.getPort(string);
        if (string2 != null && !this.isSameWssPolicyVersion(normalizedExpression, normalizedExpression2, wsPort)) {
            object2 = NormalizedExpression.createEmptyExpression();
            object = wsPort.getEndpoint().getMethods();
            while (object.hasNext()) {
                ServiceImpl.setPolicyToMethod((WsMethod)object.next(), (NormalizedExpression)object2, (NormalizedExpression)object2);
            }
        }
        this.webservice.setUsingPolicy(true);
        object2 = wsPort.getEndpoint();
        if (string2 != null) {
            object = ((WsEndpoint)object2).getMethod(string2);
            if (object == null) {
                throw new ServiceException("Can not find operation for " + string2 + " while loading the policy.");
            }
            ServiceImpl.setPolicyToMethod((WsMethod)object, normalizedExpression, normalizedExpression2);
        } else {
            object = wsPort.getEndpoint().getMethods();
            while (object.hasNext()) {
                ServiceImpl.setPolicyToMethod((WsMethod)object.next(), normalizedExpression, normalizedExpression2);
            }
        }
        try {
            if (!this.policyListenerLoaded) {
                WsFactory.instance().loadPolicy(this.webservice);
                this.policyListenerLoaded = true;
            }
        }
        catch (WsException wsException) {
            wsException.printStackTrace();
            throw new ServiceException(wsException.getMessage());
        }
    }

    private boolean isSameWssPolicyVersion(NormalizedExpression normalizedExpression, NormalizedExpression normalizedExpression2, WsPort wsPort) {
        if (this.webservice.isUsingPolicy()) {
            boolean bl;
            boolean bl2 = normalizedExpression != null ? SecurityPolicyAssertionInfoFactory.hasSecurityPolicy(normalizedExpression) : (bl = normalizedExpression2 != null ? SecurityPolicyAssertionInfoFactory.hasSecurityPolicy(normalizedExpression2) : false);
            boolean bl3 = normalizedExpression != null ? SecurityPolicyAssertionFactory.hasSecurityPolicy(normalizedExpression) : (normalizedExpression2 != null ? SecurityPolicyAssertionFactory.hasSecurityPolicy(normalizedExpression2) : false);
            Iterator iterator = wsPort.getEndpoint().getMethods();
            while (iterator.hasNext()) {
                boolean bl4;
                boolean bl5;
                WsMethod wsMethod = (WsMethod)iterator.next();
                NormalizedExpression normalizedExpression3 = wsMethod.getCachedEffectiveInboundPolicy();
                NormalizedExpression normalizedExpression4 = wsMethod.getCachedEffectiveOutboundPolicy();
                boolean bl6 = normalizedExpression3 != null ? SecurityPolicyAssertionInfoFactory.hasSecurityPolicy(normalizedExpression3) : (bl5 = normalizedExpression4 != null ? SecurityPolicyAssertionInfoFactory.hasSecurityPolicy(normalizedExpression4) : false);
                boolean bl7 = normalizedExpression3 != null ? SecurityPolicyAssertionFactory.hasSecurityPolicy(normalizedExpression3) : (bl4 = normalizedExpression4 != null ? SecurityPolicyAssertionFactory.hasSecurityPolicy(normalizedExpression4) : false);
                if ((!bl || !bl4) && (!bl3 || !bl5)) continue;
                return false;
            }
        }
        return true;
    }

    private static NormalizedExpression getNormalizedPolicies(String string, InputStream[] inputStreamArray) throws ServiceException {
        NormalizedExpression normalizedExpression = null;
        if (inputStreamArray != null && inputStreamArray.length > 0) {
            normalizedExpression = ServiceImpl.getNormalizedPolicy(string, inputStreamArray[0]);
            for (int i = 1; i < inputStreamArray.length; ++i) {
                normalizedExpression = PolicyMath.merge(normalizedExpression, ServiceImpl.getNormalizedPolicy(string, inputStreamArray[i]));
            }
        }
        return normalizedExpression;
    }

    private static NormalizedExpression getNormalizedPolicy(String string, InputStream inputStream) throws ServiceException {
        PolicyStatement policyStatement = null;
        try {
            policyStatement = PolicyFinder.readPolicyFromStream(string, inputStream, true);
            if (SecurityPolicyCustomizer.isSecurityPolicyAbstract(string, policyStatement)) {
                throw new ServiceException("Abstract policy can not be attached to client dynamically.");
            }
            return policyStatement.normalize();
        }
        catch (PolicyException policyException) {
            policyException.printStackTrace();
            throw new ServiceException((Throwable)policyException);
        }
    }

    private static void setPolicyToMethod(WsMethod wsMethod, NormalizedExpression normalizedExpression, NormalizedExpression normalizedExpression2) throws ServiceException {
        boolean bl = false;
        if (normalizedExpression != null) {
            wsMethod.setCachedEffectiveInboundPolicy(normalizedExpression);
            bl = true;
        }
        if (normalizedExpression2 != null) {
            wsMethod.setCachedEffectiveOutboundPolicy(normalizedExpression2);
            bl = true;
        }
        if (!bl) {
            throw new ServiceException("Both inbound and outbound polcies are null.");
        }
    }

    private static void checkDuplicatePolicyStreams(InputStream[] inputStreamArray, InputStream[] inputStreamArray2) throws ServiceException {
        if (inputStreamArray != null && inputStreamArray2 != null) {
            int n = Math.min(inputStreamArray.length, inputStreamArray2.length);
            for (int i = 0; i < n; ++i) {
                if (inputStreamArray[i] != inputStreamArray2[i]) continue;
                throw new ServiceException("Can not use the same input stream for both inbound and outbound policy");
            }
        }
    }

    @Override
    public WebServiceContext context() {
        throw new Error("NYI");
    }

    @Override
    public WebServiceContext joinContext() throws ContextNotFoundException {
        throw new Error("NYI");
    }

    @Override
    public Dispatch createDispatch(QName qName) throws ServiceException {
        return new DispatchImpl(qName, this);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ServiceImpl[\n");
        stringBuffer.append(this.getWebService());
        stringBuffer.append("]\n");
        return stringBuffer.toString();
    }
}

