/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxrpc;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import weblogic.deployment.ServiceRefProcessor;
import weblogic.deployment.ServiceRefProcessorException;
import weblogic.descriptor.DescriptorManager;
import weblogic.j2ee.J2EEUtils;
import weblogic.j2ee.descriptor.JavaWsdlMappingBean;
import weblogic.j2ee.descriptor.PortComponentRefBean;
import weblogic.j2ee.descriptor.PortMappingBean;
import weblogic.j2ee.descriptor.ServiceInterfaceMappingBean;
import weblogic.j2ee.descriptor.ServiceRefBean;
import weblogic.j2ee.descriptor.wl.ServiceReferenceDescriptionBean;
import weblogic.wsee.deploy.ClientDeployInfo;
import weblogic.wsee.jaxrpc.JndiServiceImpl;
import weblogic.wsee.jaxrpc.ServiceImpl;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsException;
import weblogic.wsee.wsdl.WsdlPort;

public class ServiceRefProcessorImpl
implements ServiceRefProcessor {
    private static final boolean verbose = Verbose.isVerbose(ServiceRefProcessorImpl.class);
    private static final boolean DEBUG = false;
    private static String IMPL_POSTFIX = "_WEBLOGIC_WEBSERVICE_IMPL";
    private String implJndiName;
    private String proxyJndiName;
    private ServiceImpl serviceImpl;
    private Object serviceProxy;
    private ClientDeployInfo info;

    public ServiceRefProcessorImpl(ServiceRefBean serviceRefBean, ServiceReferenceDescriptionBean serviceReferenceDescriptionBean, ServletContext servletContext) throws WsException {
        this.proxyJndiName = serviceRefBean.getServiceRefName();
        this.implJndiName = this.proxyJndiName + IMPL_POSTFIX;
        this.info = new ClientDeployInfo();
        String string = null;
        if (serviceRefBean.getWsdlFile() == null) {
            this.checkNoWsdlCase(serviceRefBean);
        } else {
            string = this.getWsdlUrl(serviceRefBean, serviceReferenceDescriptionBean, servletContext);
            this.loadJaxrpcMappingFile(serviceRefBean, servletContext);
        }
        this.info.setServiceRef(serviceRefBean);
        this.info.setWlServiceRef(serviceReferenceDescriptionBean);
        try {
            this.serviceImpl = new ServiceImpl(this.info, string);
            this.serviceImpl._setAllowHandlerChain(false);
        }
        catch (ServiceException serviceException) {
            throw new WsException(serviceException.getMessage(), serviceException);
        }
        this.serviceProxy = this.createServiceProxy();
    }

    private void loadJaxrpcMappingFile(ServiceRefBean serviceRefBean, ServletContext servletContext) throws WsException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (serviceRefBean.getJaxrpcMappingFile() == null) {
            throw new WsException("<jaxrpc-mapping-file> should be specified if <wsdl-file> is declared.");
        }
        InputStream inputStream = null;
        inputStream = servletContext != null ? servletContext.getResourceAsStream(serviceRefBean.getJaxrpcMappingFile()) : classLoader.getResourceAsStream(serviceRefBean.getJaxrpcMappingFile());
        if (inputStream == null) {
            throw new WsException("Can't find jaxrpc mapping file \"" + serviceRefBean.getJaxrpcMappingFile() + "\"");
        }
        try {
            DescriptorManager descriptorManager = new DescriptorManager();
            this.info.setMappingdd((JavaWsdlMappingBean)descriptorManager.createDescriptor(inputStream).getRootBean());
        }
        catch (IOException iOException) {
            throw new WsException("Failed to parse jaxrpc mapping file \"" + serviceRefBean.getJaxrpcMappingFile() + "\"" + iOException, iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void checkNoWsdlCase(ServiceRefBean serviceRefBean) throws WsException {
        if (serviceRefBean.getJaxrpcMappingFile() != null) {
            throw new WsException("<jaxrpc-mapping-file> should not be specified if no <wsdl-file> is declared.");
        }
        if (serviceRefBean.getServiceQname() != null) {
            throw new WsException("<service-qname> should not be specified if no <wsdl-file> is declared.");
        }
    }

    private String getWsdlUrl(ServiceRefBean serviceRefBean, ServiceReferenceDescriptionBean serviceReferenceDescriptionBean, ServletContext servletContext) throws WsException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL uRL = null;
        if (verbose) {
            if (serviceReferenceDescriptionBean == null) {
                Verbose.log("Weblogic description bean is null");
            } else {
                Verbose.log("Got weblogic description bean:" + serviceReferenceDescriptionBean);
            }
        }
        if (serviceReferenceDescriptionBean != null && serviceReferenceDescriptionBean.getWsdlUrl() != null) {
            uRL = ServiceRefProcessorImpl.getResource(serviceReferenceDescriptionBean.getWsdlUrl(), servletContext);
        } else {
            uRL = servletContext != null ? this.creatURLFromServletContext(serviceRefBean, servletContext) : classLoader.getResource(serviceRefBean.getWsdlFile());
            if (uRL == null) {
                throw new WsException("Can't find wsdl file \"" + serviceRefBean.getWsdlFile() + "\"");
            }
        }
        return uRL.toString();
    }

    private URL creatURLFromServletContext(ServiceRefBean serviceRefBean, ServletContext servletContext) throws WsException {
        URL uRL;
        try {
            uRL = serviceRefBean.getWsdlFile().startsWith("/") ? servletContext.getResource(serviceRefBean.getWsdlFile()) : servletContext.getResource("/" + serviceRefBean.getWsdlFile());
        }
        catch (MalformedURLException malformedURLException) {
            throw new WsException("Can't find wsdl file \"" + serviceRefBean.getWsdlFile() + "\"" + malformedURLException, malformedURLException);
        }
        return uRL;
    }

    private static URL getResource(String string, ServletContext servletContext) throws WsException {
        try {
            URL uRL = null;
            if (string != null && string.startsWith("/") && servletContext != null) {
                uRL = servletContext.getResource(string);
            }
            if (uRL == null) {
                uRL = Thread.currentThread().getContextClassLoader().getResource(string);
            }
            if (uRL == null) {
                uRL = new URL(string);
            }
            return uRL;
        }
        catch (Exception exception) {
            throw new WsException("Failed to interpret the given WSDL URL as a web resource, class loader resource, or absolute URL: " + exception.toString(), exception);
        }
    }

    public void bindServiceRef(Context context, Context context2, String string) throws NamingException, ServiceRefProcessorException {
        ServiceRefBean serviceRefBean;
        PortComponentRefBean[] portComponentRefBeanArray;
        context2.bind(this.implJndiName, (Object)this.serviceImpl);
        context2.bind(this.proxyJndiName, this.serviceProxy);
        if (verbose) {
            Verbose.log("Bound service-ref under name " + this.proxyJndiName);
        }
        if ((portComponentRefBeanArray = (serviceRefBean = this.info.getServiceRef()).getPortComponentRefs()).length != 0) {
            try {
                this.processComponentLink(context, portComponentRefBeanArray, string);
            }
            catch (WsException wsException) {
                throw new ServiceRefProcessorException(wsException.getMessage(), wsException);
            }
        }
    }

    private void processComponentLink(Context context, PortComponentRefBean[] portComponentRefBeanArray, String string) throws WsException {
        HashMap<String, WsdlPort> hashMap = new HashMap<String, WsdlPort>();
        for (int i = 0; i < portComponentRefBeanArray.length; ++i) {
            PortComponentRefBean portComponentRefBean = portComponentRefBeanArray[i];
            String string2 = portComponentRefBean.getPortComponentLink();
            if (string2 == null) continue;
            try {
                Context context2 = null;
                try {
                    context2 = (Context)context.lookup("app/wsee");
                }
                catch (NamingException namingException) {
                    throw new WsException("Failed to resolve port component link, do you have any webservices defined in your application? " + namingException, namingException);
                }
                String string3 = J2EEUtils.getAppScopedLinkPath(string2, string, context2);
                if (string3 == null) {
                    throw new WsException("Failed to resolve port component link " + string2);
                }
                WsdlPort wsdlPort = (WsdlPort)context.lookup("app/wsee/" + string3);
                if (verbose) {
                    Verbose.log("Got wsdl port for port-component-link " + string2 + ":" + wsdlPort);
                }
                hashMap.put(portComponentRefBean.getServiceEndpointInterface(), wsdlPort);
                continue;
            }
            catch (NamingException namingException) {
                throw new WsException("Failed to resolve port component link, " + string2 + namingException, namingException);
            }
        }
        this.serviceImpl.setPortComponentLinks(hashMap);
    }

    public void unbindServiceRef(Context context) throws NamingException {
        context.unbind(this.implJndiName);
        context.unbind(this.proxyJndiName);
    }

    private Object createServiceProxy() throws WsException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ServiceRefBean serviceRefBean = this.info.getServiceRef();
        String string = serviceRefBean.getServiceInterface();
        Class<?> clazz = null;
        try {
            clazz = classLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new WsException("Failed to service interface class " + classNotFoundException, classNotFoundException);
        }
        ClassLoader classLoader2 = clazz.getClassLoader();
        Class[] classArray = new Class[]{clazz};
        JndiServiceImpl jndiServiceImpl = new JndiServiceImpl(this.implJndiName, this.buildPortNameMap());
        return Proxy.newProxyInstance(classLoader2, classArray, (InvocationHandler)jndiServiceImpl);
    }

    private Map buildPortNameMap() {
        HashMap hashMap = new HashMap();
        JavaWsdlMappingBean javaWsdlMappingBean = this.info.getMappingdd();
        QName qName = this.info.getServiceRef().getServiceQname();
        if (javaWsdlMappingBean == null) {
            return Collections.EMPTY_MAP;
        }
        ServiceInterfaceMappingBean[] serviceInterfaceMappingBeanArray = javaWsdlMappingBean.getServiceInterfaceMappings();
        if (serviceInterfaceMappingBeanArray != null) {
            for (int i = 0; i < serviceInterfaceMappingBeanArray.length; ++i) {
                ServiceInterfaceMappingBean serviceInterfaceMappingBean = serviceInterfaceMappingBeanArray[i];
                if (qName != null && !qName.equals(serviceInterfaceMappingBean.getWsdlServiceName())) continue;
                this.addPortNames(serviceInterfaceMappingBean, hashMap);
                break;
            }
        }
        return hashMap;
    }

    private void addPortNames(ServiceInterfaceMappingBean serviceInterfaceMappingBean, Map map) {
        PortMappingBean[] portMappingBeanArray = serviceInterfaceMappingBean.getPortMappings();
        for (int i = 0; i < portMappingBeanArray.length; ++i) {
            PortMappingBean portMappingBean = portMappingBeanArray[i];
            map.put(portMappingBean.getJavaPortName(), portMappingBean.getPortName());
        }
    }
}

