/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxrpc;

import com.bea.xml.XmlException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.w3c.dom.Node;
import weblogic.utils.collections.ConcurrentHashMap;
import weblogic.wsee.addressing.EndpointReference;
import weblogic.wsee.addressing.MessageIdHeader;
import weblogic.wsee.async.AsyncUtil;
import weblogic.wsee.bind.runtime.RuntimeBindings;
import weblogic.wsee.bind.runtime.internal.GenericRuntimeBindingsImpl;
import weblogic.wsee.deploy.ClientDeployInfo;
import weblogic.wsee.handler.HandlerList;
import weblogic.wsee.jaxrpc.ServiceImpl;
import weblogic.wsee.jws.JwsContext;
import weblogic.wsee.jws.container.Container;
import weblogic.wsee.message.soap.SoapMessageContext;
import weblogic.wsee.reliability.ReliabilityErrorListenerRegistry;
import weblogic.wsee.reliability.WsrmProtocolUtils;
import weblogic.wsee.util.SaajUtil;
import weblogic.wsee.util.WLMessageFactory;
import weblogic.wsee.util.WLSOAPFactory;
import weblogic.wsee.ws.WsException;
import weblogic.wsee.ws.WsFactory;
import weblogic.wsee.ws.WsMethod;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.WsService;
import weblogic.wsee.ws.WsType;
import weblogic.wsee.ws.dispatch.DispatcherImpl;
import weblogic.wsee.ws.dispatch.client.ClientDispatcher;
import weblogic.wsee.wsdl.WsdlBindingOperation;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlFactory;
import weblogic.wsee.wsdl.WsdlService;
import weblogic.wsee.wsdl.WsdlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SoapDispatch {
    public static final String SOAP_DISPATCH_INITIATED_OPERATION_PROPERTY = "weblogic.wsee.jaxrpc.SoapDispatchInitiatedOperation";
    private QName serviceName;
    private QName portName;
    private WsService webservice;
    private WsdlDefinitions definitions;
    private WsPort port;
    private Map properties = new HashMap();
    private WsrmConfigImpl _wsrmConfig;
    private WsrmUtilsImpl _wsrmUtils;
    private SOAPFactory soapFactory = WLSOAPFactory.createSOAPFactory();

    private SoapDispatch(String string) throws ServiceException {
        this(SoapDispatch.createWsdlDefinitions(ServiceImpl.getWsdlUrl(string)));
    }

    private SoapDispatch(WsdlDefinitions wsdlDefinitions) {
        this.definitions = wsdlDefinitions;
        this._wsrmUtils = new WsrmUtilsImpl();
    }

    public static SoapDispatch create(String string) throws ServiceException {
        return new SoapDispatch(string);
    }

    public static SoapDispatch create(WsdlDefinitions wsdlDefinitions) {
        return new SoapDispatch(wsdlDefinitions);
    }

    public String getWsdlTargetNamespace() {
        return this.definitions.getTargetNamespace();
    }

    public void setServiceName(QName qName) {
        this.serviceName = qName;
    }

    public void setPortName(QName qName) {
        this.portName = qName;
    }

    public SOAPElement createSoapElement(String string, String string2, String string3) throws ServiceException {
        try {
            return this.soapFactory.createElement(string, string2, string3);
        }
        catch (SOAPException sOAPException) {
            ServiceImpl.throwServiceException("Failed to create SOAP Element", sOAPException);
            throw new Error("Should never reach here");
        }
    }

    public void setProperty(String string, Object object) {
        if (string == null) {
            throw new IllegalArgumentException("name == null");
        }
        this.properties.put(string, object);
    }

    public Object getProperty(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name == null");
        }
        return this.properties.get(string);
    }

    public Map getUpdateablePropertyMap() {
        return this.properties;
    }

    public Map getUpdateableInvokePropertyMap() {
        Map map = (Map)this.properties.get("weblogic.wsee.invoke_properties");
        if (map == null) {
            map = new ConcurrentHashMap();
            this.properties.put("weblogic.wsee.invoke_properties", map);
        }
        return map;
    }

    public String getEndpointAddressFromInvokeProperties() {
        return (String)this.getUpdateableInvokePropertyMap().get("javax.xml.rpc.service.endpoint.address");
    }

    public SOAPElement invoke(QName qName, SOAPElement sOAPElement) throws ServiceException, RemoteException {
        SOAPPart sOAPPart;
        SOAPMessage sOAPMessage = null;
        try {
            sOAPMessage = WLMessageFactory.getInstance().getMessageFactory(WsdlUtils.isSoap12(this.port)).createMessage();
            sOAPPart = sOAPMessage.getSOAPPart();
            Node node = sOAPPart.importNode((Node)sOAPElement, true);
            sOAPMessage.getSOAPBody().appendChild(node);
        }
        catch (SOAPException sOAPException) {
            ServiceImpl.throwServiceException("Failed to construct request", sOAPException);
        }
        sOAPPart = this.invoke(qName, sOAPMessage);
        try {
            return SaajUtil.getFirstChild((SOAPElement)sOAPPart.getSOAPBody());
        }
        catch (SOAPException sOAPException) {
            ServiceImpl.throwServiceException("Failed to get element from response", sOAPException);
            throw new Error("Should never reach here");
        }
    }

    public static String getRequestingServiceURI(JwsContext jwsContext) {
        Container container = (Container)jwsContext;
        SoapMessageContext soapMessageContext = (SoapMessageContext)container.getUnfilteredMessageContext();
        return soapMessageContext.getDispatcher().getConnection().getTransport().getServiceURI();
    }

    public static String getRequestingServiceURI(MessageContext messageContext) {
        return ((SoapMessageContext)messageContext).getDispatcher().getConnection().getTransport().getServiceURI();
    }

    public String invokeAsync(String string, QName qName, SOAPElement sOAPElement, EndpointReference endpointReference) throws ServiceException, RemoteException {
        SOAPMessage sOAPMessage = null;
        try {
            sOAPMessage = WLMessageFactory.getInstance().getMessageFactory(WsdlUtils.isSoap12(this.port)).createMessage();
            SOAPPart sOAPPart = sOAPMessage.getSOAPPart();
            Node node = sOAPPart.importNode((Node)sOAPElement, true);
            sOAPMessage.getSOAPBody().appendChild(node);
        }
        catch (SOAPException sOAPException) {
            ServiceImpl.throwServiceException("Failed to construct request", sOAPException);
        }
        return this.invokeAsync(string, qName, sOAPMessage, endpointReference);
    }

    public String invokeAsync(String string, QName qName, SOAPMessage sOAPMessage, EndpointReference endpointReference) throws RemoteException, ServiceException {
        return (String)this.invoke(string, qName, sOAPMessage, true, endpointReference);
    }

    public SOAPMessage invoke(QName qName, SOAPMessage sOAPMessage) throws RemoteException, ServiceException {
        return (SOAPMessage)this.invoke(null, qName, sOAPMessage, false, null);
    }

    public WsrmConfig getWsrmConfig() {
        if (this._wsrmConfig == null) {
            this._wsrmConfig = new WsrmConfigImpl();
        }
        return this._wsrmConfig;
    }

    public WsrmUtils getWsrmUtils() {
        return this._wsrmUtils;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invoke(String string, QName qName, SOAPMessage sOAPMessage, boolean bl, EndpointReference endpointReference) throws RemoteException, ServiceException {
        if (qName == null) {
            throw new IllegalArgumentException("null method");
        }
        if (sOAPMessage == null) {
            throw new IllegalArgumentException("null request");
        }
        this.init();
        WsMethod wsMethod = this.port.getEndpoint().getMethod(qName.getLocalPart());
        if (wsMethod == null) {
            throw new ServiceException("Unable to find method with name: " + qName);
        }
        WsdlBindingOperation wsdlBindingOperation = this.port.getWsdlPort().getBinding().getOperations().get(qName);
        if (wsdlBindingOperation == null) {
            throw new ServiceException("Unable to find binding operation with name: " + qName);
        }
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            HashSet<String> hashSet = new HashSet<String>();
            this.properties.put(SOAP_DISPATCH_INITIATED_OPERATION_PROPERTY, "true");
            if (bl) {
                this.setTransientProperty("weblogic.wsee.async.invoke", "true", hashSet);
                this.setTransientProperty("weblogic.wsee.async.invoke", "true", hashSet);
                this.setTransientProperty("weblogic.wsee.async.invokeNonJws", "true", hashSet);
                this.setTransientProperty("weblogic.wsee.method.name", qName.getLocalPart(), hashSet);
                this.setTransientProperty("weblogic.wsee.operation.name", qName.getLocalPart(), hashSet);
                if (endpointReference == null && string == null) {
                    throw new JAXRPCException("You must specify one of (requestingServiceUri, epr) when invoking SoapDispatch.invokeAsync");
                }
                if (endpointReference == null) {
                    object4 = this.port.getWsdlPort();
                    object3 = object4.getBinding();
                    object2 = object3.getBindingType();
                    object = object4.getTransport();
                    boolean bl2 = "SOAP12".equals(object2);
                    endpointReference = AsyncUtil.getDefaultAsyncResponseServiceEPR((String)object, bl2);
                }
                this.setTransientProperty("weblogic.wsee.async.res.epr", endpointReference, hashSet);
                if (string != null) {
                    this.setTransientProperty("weblogic.wsee.enclosing.jws.serviceuri", string, hashSet);
                }
                if (this._wsrmConfig != null && this._wsrmConfig.getReliabilityErrorListenerKey() != null) {
                    this.setTransientProperty("weblogic.wsee.reliable.errorlistener", this._wsrmConfig.getReliabilityErrorListenerKey(), hashSet);
                }
            }
            object4 = new LinkedHashMap();
            object3 = new LinkedHashMap<String, Object>();
            object2 = wsMethod.getReturnType();
            if (object2 != null) {
                ((HashMap)object3).put(((WsType)object2).getName(), null);
            }
            object = new ClientDispatcher(wsMethod, this.port, wsdlBindingOperation, (Map)object4, (Map)object3, this.properties);
            SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)((DispatcherImpl)object).getContext();
            sOAPMessageContext.setMessage(sOAPMessage);
            try {
                ((ClientDispatcher)object).dispatch();
                Object var15_16 = null;
            }
            catch (Throwable throwable) {
                Object var15_17 = null;
                for (String string2 : hashSet) {
                    this.properties.remove(string2);
                }
                throw throwable;
            }
            for (String string3 : hashSet) {
                this.properties.remove(string3);
            }
            if (bl) {
                MessageIdHeader messageIdHeader = (MessageIdHeader)((DispatcherImpl)object).getContext().getHeaders().getHeader(MessageIdHeader.TYPE);
                return messageIdHeader.getMessageId();
            }
            return sOAPMessageContext.getMessage();
        }
        catch (Throwable throwable) {
            throw new RemoteException("invoke failed", throwable);
        }
    }

    private void setTransientProperty(String string, Object object, Set<String> set) {
        this.properties.put(string, object);
        set.add(string);
    }

    private void init() throws ServiceException {
        if (this.webservice != null) {
            return;
        }
        ClientDeployInfo clientDeployInfo = new ClientDeployInfo();
        clientDeployInfo.setWsdlDef(this.definitions);
        clientDeployInfo.setRuntimeBindings(this.createRuntimeBinding());
        this.setServiceName(clientDeployInfo);
        this.createWsService(clientDeployInfo);
        this.setPort();
        HandlerList handlerList = this.port.getInternalHandlerList();
        handlerList.remove("CODEC_HANDLER");
    }

    private void setPort() throws ServiceException {
        if (this.port == null) {
            this.port = this.portName == null ? this.findPort() : this.webservice.getPort(this.portName.getLocalPart());
        }
    }

    private void createWsService(ClientDeployInfo clientDeployInfo) throws ServiceException {
        WsFactory wsFactory = WsFactory.instance();
        try {
            this.webservice = wsFactory.createClientService(clientDeployInfo);
        }
        catch (WsException wsException) {
            ServiceImpl.throwServiceException("Failed to create Web Service OM", wsException);
        }
    }

    private void setServiceName(ClientDeployInfo clientDeployInfo) throws ServiceException {
        if (this.serviceName == null) {
            clientDeployInfo.setServiceName(this.findServiceName());
        } else {
            clientDeployInfo.setServiceName(this.serviceName);
        }
    }

    private WsPort findPort() throws ServiceException {
        Iterator<WsPort> iterator = this.webservice.getPorts();
        if (iterator.hasNext()) {
            WsPort wsPort = iterator.next();
            if (iterator.hasNext()) {
                throw new ServiceException("More than one port found. Use setPortName() to specify the port");
            }
            return wsPort;
        }
        throw new JAXRPCException("No port found in the WSDL");
    }

    private QName findServiceName() throws ServiceException {
        WsdlService wsdlService = this.findService();
        return wsdlService.getName();
    }

    private WsdlService findService() throws ServiceException {
        Iterator<? extends WsdlService> iterator = this.definitions.getServices().values().iterator();
        if (iterator.hasNext()) {
            WsdlService wsdlService = iterator.next();
            if (iterator.hasNext()) {
                throw new ServiceException("More than one service available in thisWSDL. Use setServiceName() to specifiy the service name");
            }
            return wsdlService;
        }
        throw new JAXRPCException("Unable to find WSDL service");
    }

    private RuntimeBindings createRuntimeBinding() {
        try {
            return new GenericRuntimeBindingsImpl();
        }
        catch (IOException iOException) {
            throw new JAXRPCException("Failed to create generic binding provider", (Throwable)iOException);
        }
        catch (XmlException xmlException) {
            throw new JAXRPCException("Failed to create generic binding provider", (Throwable)xmlException);
        }
    }

    private static WsdlDefinitions createWsdlDefinitions(String string) throws ServiceException {
        try {
            return WsdlFactory.getInstance().parse(string);
        }
        catch (WsdlException wsdlException) {
            ServiceImpl.throwServiceException("Failed to parse WSDL", wsdlException);
            throw new Error("should never reach here");
        }
    }

    private class WsrmUtilsImpl
    implements WsrmUtils {
        public void setFinalMessage() {
            WsrmProtocolUtils.setFinalMessage(SoapDispatch.this.getUpdateablePropertyMap());
        }

        public void setLastMessage() {
            WsrmProtocolUtils.setLastMessage(SoapDispatch.this.getUpdateablePropertyMap());
        }

        public void sendEmptyLastMessage() {
            WsrmProtocolUtils.sendEmptyLastMessage(SoapDispatch.this.getUpdateableInvokePropertyMap(), SoapDispatch.this.getEndpointAddressFromInvokeProperties());
        }

        public void terminateSequence() {
            WsrmProtocolUtils.terminateSequence(SoapDispatch.this.getUpdateableInvokePropertyMap());
        }
    }

    private class WsrmConfigImpl
    implements WsrmConfig {
        private String _listenerKey;

        public void setReliabilityErrorListenerKey(String string) throws IllegalArgumentException {
            if (ReliabilityErrorListenerRegistry.getInstance().getListener(string) == null) {
                throw new IllegalArgumentException("No ReliabilityErrorListener has been registered with the given key: " + string);
            }
            this._listenerKey = string;
        }

        public String getReliabilityErrorListenerKey() {
            return this._listenerKey;
        }
    }

    public static interface WsrmUtils {
        public void setFinalMessage();

        public void setLastMessage();

        public void sendEmptyLastMessage();

        public void terminateSequence();
    }

    public static interface WsrmConfig {
        public void setReliabilityErrorListenerKey(String var1);

        public String getReliabilityErrorListenerKey();
    }
}

