/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxrpc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.Stub;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.holders.Holder;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Node;
import weblogic.wsee.handler.InvocationException;
import weblogic.wsee.jaxrpc.ServiceImpl;
import weblogic.wsee.jaxrpc.WLStub;
import weblogic.wsee.util.HolderUtil;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsMethod;
import weblogic.wsee.ws.WsParameterType;
import weblogic.wsee.ws.WsStub;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlPartnerLinkType;
import weblogic.wsee.wsdl.WsdlPort;
import weblogic.wsee.wsdl.WsdlPortType;
import weblogic.wsee.wsdl.WsdlService;
import weblogic.wsee.wsdl.WsdlUtils;
import weblogic.wsee.wsdl.soap11.SoapAddress;
import weblogic.xml.dom.Util;

public class StubImpl
implements WLStub,
Stub,
InvocationHandler {
    private WsdlPort port;
    private ServiceImpl serviceImpl;
    private Map properties = new HashMap();
    private static final ArrayList propertyNames = new ArrayList();
    private static final boolean verbose = Verbose.isVerbose(StubImpl.class);

    protected StubImpl(WsdlPort wsdlPort, Class clazz, ServiceImpl serviceImpl) {
        this.port = wsdlPort;
        this.serviceImpl = serviceImpl;
        if (wsdlPort == null) {
            throw new IllegalArgumentException("port can not be null");
        }
        if (serviceImpl == null) {
            throw new IllegalArgumentException("service can not be null");
        }
        SoapAddress soapAddress = WsdlUtils.getSoapAddress(wsdlPort);
        if (soapAddress != null) {
            this._setProperty("javax.xml.rpc.service.endpoint.address", soapAddress.getLocation());
        }
        this.properties.put("weblogic.wsee.handler.registry", this.serviceImpl._internalGetHandlerRegistry());
        this.setCallbackProperty();
    }

    protected void setCallbackProperty() {
        WsdlPartnerLinkType wsdlPartnerLinkType = (WsdlPartnerLinkType)this.port.getService().getDefinitions().getExtension("PartnerLinkType");
        if (wsdlPartnerLinkType != null) {
            WsdlDefinitions wsdlDefinitions = this.port.getService().getDefinitions();
            for (WsdlService wsdlService : wsdlDefinitions.getServices().values()) {
                for (WsdlPortType wsdlPortType : wsdlService.getPortTypes()) {
                    try {
                        if (verbose) {
                            Verbose.log("Port type " + wsdlPortType.getName() + " link name " + wsdlPartnerLinkType.getRole2Name() + ", " + wsdlPartnerLinkType.getPortTypeName("Callback"));
                        }
                        if (!wsdlPortType.getName().equals(wsdlPartnerLinkType.getPortTypeName("Callback"))) continue;
                        this._setProperty("weblogic.wsee.callback.contextpath", wsdlService.getName().getLocalPart() + "Cb");
                        this._setProperty("weblogic.wsee.callback.serviceuri", wsdlService.getName().getLocalPart() + "Cb");
                        return;
                    }
                    catch (WsdlException wsdlException) {
                        throw new JAXRPCException("Failed to parse WSDL", (Throwable)wsdlException);
                    }
                }
            }
        }
    }

    protected String _getPortName() {
        return this.port.getName().getLocalPart();
    }

    protected Map _getUserProperties() {
        return (Map)((HashMap)this.properties).clone();
    }

    public void _setUserProperties(Map map) {
        if (map == null) {
            return;
        }
        for (String string : map.keySet()) {
            this._setProperty(string, map.get(string));
        }
    }

    public void _setProperty(String string, Object object) throws UnsupportedOperationException {
        if (!StubImpl.isValidProperty(string)) {
            throw new JAXRPCException("unknown property:" + string);
        }
        this.properties.put(string, object);
    }

    public Object _getProperty(String string) {
        if (!StubImpl.isValidProperty(string)) {
            throw new JAXRPCException("unknown property:" + string);
        }
        if ("weblogic.wsee.ws.WsStub".equals(string)) {
            WsStub wsStub = this.serviceImpl.getWsStub(this.port);
            return wsStub;
        }
        if ("weblogic.wsee.ws.WsService".equals(string)) {
            return this.serviceImpl.getWebService();
        }
        Object object = this.properties.get(string);
        if (object == null) {
            object = this._getInternalProperty(string);
        }
        return object;
    }

    private Object _getInternalProperty(String string) {
        SoapAddress soapAddress;
        if ("javax.xml.rpc.service.endpoint.address".equals(string) && (soapAddress = WsdlUtils.getSoapAddress(this.port)) != null) {
            return soapAddress.getLocation();
        }
        return null;
    }

    public Object _removeProperty(String string) {
        if (!StubImpl.isValidProperty(string)) {
            throw new JAXRPCException("unknown property:" + string);
        }
        return this.properties.remove(string);
    }

    static boolean isValidProperty(String string) {
        if (string == null) {
            throw new JAXRPCException("property name can not be null");
        }
        return propertyNames.contains(string) || string.startsWith("com.bea") || string.startsWith("weblogic.wsee");
    }

    public Iterator _getPropertyNames() {
        return propertyNames.iterator();
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        WsStub wsStub = this.serviceImpl.getWsStub(this.port);
        if (wsStub == null) {
            throw new IllegalStateException("Couldn't find indicated port " + (this.port != null ? this.port.getName() : null) + " in stub's service configuration for service " + (this.serviceImpl != null ? this.serviceImpl.getWebService().getWsdlService().getName() : null));
        }
        WsMethod wsMethod = this.findWsMethod(wsStub, method);
        if (wsMethod == null) {
            return this.invokeObjectMethod(method, objectArray);
        }
        try {
            return this._invoke(wsMethod.getOperationName().getLocalPart(), objectArray);
        }
        catch (SOAPFaultException sOAPFaultException) {
            return this.throwRemoteException(this._soapFault2String(sOAPFaultException), sOAPFaultException);
        }
        catch (InvocationException invocationException) {
            return this.throwRemoteException("Failed to invoke", invocationException);
        }
        catch (JAXRPCException jAXRPCException) {
            return this.throwRemoteException("Failed to invoke", jAXRPCException);
        }
    }

    private Object invokeObjectMethod(Method method, Object[] objectArray) throws Throwable {
        if (method.getDeclaringClass().isAssignableFrom(StubImpl.class)) {
            try {
                return method.invoke((Object)this, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getTargetException();
            }
        }
        throw new JAXRPCException("unable to find operation:" + method);
    }

    private WsMethod findWsMethod(WsStub wsStub, Method method) {
        Iterator iterator = wsStub.getMethods();
        while (iterator.hasNext()) {
            WsMethod wsMethod = (WsMethod)iterator.next();
            if (!method.getName().equals(wsMethod.getMethodName())) continue;
            return wsMethod;
        }
        return null;
    }

    private Object throwRemoteException(String string, Throwable throwable) throws Throwable {
        throw new RemoteException(string, throwable);
    }

    protected Object _invoke(String string, Object[] objectArray) throws Throwable {
        if (verbose) {
            Verbose.banner("Invoke : " + string);
        }
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        WsStub wsStub = this.serviceImpl.getWsStub(this.port);
        WsMethod wsMethod = wsStub.getMethod(string);
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        LinkedHashMap linkedHashMap2 = new LinkedHashMap();
        HashMap hashMap = new HashMap();
        this.fillArgs(wsMethod, objectArray, hashMap, linkedHashMap);
        Object object = wsStub.invoke(string, this.port.getName().getLocalPart(), linkedHashMap, linkedHashMap2, this.properties);
        this.setHolderValues(linkedHashMap2, hashMap);
        return object;
    }

    public Object _asyncResponse(String string, SOAPMessage sOAPMessage, MessageContext messageContext) throws Throwable {
        if (verbose) {
            Verbose.banner("AsyncResponse: " + string);
        }
        WsStub wsStub = this.serviceImpl.getWsStub(this.port);
        WsMethod wsMethod = wsStub.getMethod(string);
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        HashMap hashMap = new HashMap();
        Object object = wsStub._asyncResponse(string, this.port.getName().getLocalPart(), linkedHashMap, sOAPMessage, messageContext, this.properties);
        this.setHolderValues(linkedHashMap, hashMap);
        return object;
    }

    private void setHolderValues(Map map, HashMap hashMap) {
        for (String string : map.keySet()) {
            Object v = hashMap.get(string);
            Object v2 = map.get(string);
            if (v == null) {
                throw new JAXRPCException("Found an output param :" + string + ", but" + "a corresponding holder class not passed in");
            }
            HolderUtil.setHolderValue(v, v2);
        }
    }

    private void fillArgs(WsMethod wsMethod, Object[] objectArray, HashMap hashMap, Map map) {
        int n = 0;
        Iterator iterator = wsMethod.getParameters();
        while (iterator.hasNext()) {
            WsParameterType wsParameterType = (WsParameterType)iterator.next();
            if (n < objectArray.length) {
                Object object = objectArray[n];
                if (wsParameterType.getMode() != 0) {
                    if (!(object instanceof Holder)) {
                        throw new JAXRPCException("Parameter \"" + wsParameterType.getName() + "\" is an in-out or out param." + "but the holder class is not passed in.");
                    }
                    hashMap.put(wsParameterType.getName(), object);
                }
                if (wsParameterType.getMode() != 1) {
                    map.put(wsParameterType.getName(), HolderUtil.getHolderValue(object));
                }
            } else {
                throw new JAXRPCException("There are no enough args.");
            }
            ++n;
        }
        if (n != objectArray.length) {
            throw new JAXRPCException("There are more args than required.");
        }
    }

    public static Object implementInterface(Class clazz, WsdlPort wsdlPort, Map map, ServiceImpl serviceImpl) {
        ClassLoader classLoader = clazz.getClassLoader();
        ArrayList<Class> arrayList = new ArrayList<Class>();
        arrayList.add(clazz);
        if (!Remote.class.isAssignableFrom(clazz)) {
            arrayList.add(Remote.class);
        }
        if (!Stub.class.isAssignableFrom(clazz)) {
            arrayList.add(Stub.class);
        }
        StubImpl stubImpl = new StubImpl(wsdlPort, clazz, serviceImpl);
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                stubImpl._setProperty((String)entry.getKey(), entry.getValue());
            }
        }
        Class[] classArray = arrayList.toArray(new Class[arrayList.size()]);
        return Proxy.newProxyInstance(classLoader, classArray, (InvocationHandler)stubImpl);
    }

    public Object _wrap(int n) {
        return new Integer(n);
    }

    public Object _wrap(float f) {
        return new Float(f);
    }

    public Object _wrap(double d) {
        return new Double(d);
    }

    public Object _wrap(short s) {
        return new Short(s);
    }

    public Object _wrap(long l) {
        return new Long(l);
    }

    public Object _wrap(boolean bl) {
        return new Boolean(bl);
    }

    public Object _wrap(Object object) {
        return object;
    }

    public Object _wrap(char c) {
        return "" + c;
    }

    public Object _wrap(byte by) {
        return new Byte(by);
    }

    protected String _soapFault2String(SOAPFaultException sOAPFaultException) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SOAPFaultException - ");
        stringBuilder.append("FaultCode [" + sOAPFaultException.getFaultCode() + "]");
        stringBuilder.append(" FaultString [" + sOAPFaultException.getFaultString() + "]");
        stringBuilder.append(" FaultActor [" + sOAPFaultException.getFaultActor() + "]");
        if (sOAPFaultException.getDetail() != null) {
            stringBuilder.append(" Detail [" + Util.printNode((Node)sOAPFaultException.getDetail()) + "]");
        } else {
            stringBuilder.append("No Detail");
        }
        return stringBuilder.toString();
    }

    static {
        propertyNames.add("javax.xml.rpc.service.endpoint.address");
        propertyNames.add("javax.xml.rpc.security.auth.username");
        propertyNames.add("javax.xml.rpc.security.auth.password");
        propertyNames.add("weblogic.webservice.client.proxyusername");
        propertyNames.add("weblogic.webservice.client.proxypassword");
        propertyNames.add("javax.xml.rpc.service.endpoint.address");
        propertyNames.add("javax.xml.rpc.session.maintain");
        propertyNames.add("weblogic.wsee.client.ssladapter");
        propertyNames.add("weblogic.wsee.invoke_properties");
        propertyNames.add("weblogic.wsee.policy.default.uri");
        propertyNames.add("weblogic.wsee.security.wss.CredentialProviderList");
        propertyNames.add("weblogic.wsee.security.wss.TrustManager");
        propertyNames.add("weblogic.wsee.connection.transportinfo");
        propertyNames.add("weblogic.wsee.wst.sts_endpoint_uri");
        propertyNames.add("weblogic.wsee.security.bst.serverEncryptCert");
        propertyNames.add("weblogic.wsee.security.bst.serverVerifyCert");
        propertyNames.add("weblogic.wsee.transport.connection.timeout");
        propertyNames.add("weblogic.wsee.transport.read.timeout");
        propertyNames.add("weblogic.wsee.wssc.sct.lifetime");
        propertyNames.add("weblogic.wsee.wssc.dk.label");
        propertyNames.add("weblogic.wsee.wssc.dk.length");
        propertyNames.add("weblogic.wsee.security.message_age");
        propertyNames.add("weblogic.wsee.wsrm.sequence.expiration");
        propertyNames.add("weblogic.wsee.wsrm.offer.sequence.expiration");
        propertyNames.add("weblogic.wsee.ackstoanon");
        propertyNames.add("weblogic.wsee.lastmessage");
        propertyNames.add("weblogic.wsee.policy.selection.preference");
        propertyNames.add("weblogic.wsee.policy.compat.preference");
        propertyNames.add("weblogic.wsee.security.bst.stsEncryptCert");
        propertyNames.add("weblogic.wsee.wst.saml.sts_endpoint_uri");
        propertyNames.add("oracle.contextelement.saml2.AttributeOnly");
        propertyNames.add("weblogic.wsee.security.saml.attributies");
    }
}

