/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxrpc.soapfault;

import java.security.AccessController;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weblogic.kernel.KernelStatus;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.StackTraceUtils;
import weblogic.wsee.async.AsyncUtil;
import weblogic.wsee.jaxrpc.soapfault.WLSOAPFaultException;
import weblogic.wsee.util.ExceptionUtil;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.util.WLMessageFactory;
import weblogic.wsee.util.WLSOAPFactory;
import weblogic.xml.saaj.SOAPConstants;

public class SOAPFaultUtil {
    private static final boolean verbose = Verbose.isVerbose(SOAPFaultUtil.class);
    private static final String ENV_PREFIX = "env";
    private static final String FAULT_URI = "http://www.bea.com/servers/wls70/webservice/fault/1.0.0";
    private static final String FAULT_PREFIX = "bea_fault";
    private static final String FAULT_NAME = "stacktrace";
    public static final String SOAP12_FC_SERVER = "Receiver";
    public static final String SOAP12_FC_CLIENT = "Sender";
    public static final String SOAP11_FC_SERVER = "Server";
    public static final String SOAP11_FC_CLIENT = "Client";
    public static final QName SOAP11_FC_CLIENT_QNAME = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Client");
    public static final QName SOAP11_FC_SERVER_QNAME = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server");
    public static final QName SOAP12_FC_CLIENT_QNAME = new QName("http://www.w3.org/2003/05/soap-envelope", "Sender");
    public static final QName SOAP12_FC_SERVER_QNAME = new QName("http://www.w3.org/2003/05/soap-envelope", "Receiver");
    public static final String SOAP_FC_VERSION_MISMATCH = "VersionMismatch";
    public static final String SOAP_FC_MUST_UNDERSTAND = "MustUnderstand";
    private static final List<String> SOAP12_FAULT_CODES = Arrays.asList("VersionMismatch", "MustUnderstand", "DataEncodingUnknown", "Sender", "Receiver");

    private static WLSOAPFaultException setSOAP12SubFaultCodes(WLSOAPFaultException wLSOAPFaultException, QName ... qNameArray) {
        if (wLSOAPFaultException == null) {
            return null;
        }
        if (!wLSOAPFaultException.isSOAP12() && verbose) {
            Verbose.say("Current wlSoapFaultExceptin is not a SOAP 1.2 version");
            Verbose.say("the sub faultcode(s) can not be set onto it!");
            return wLSOAPFaultException;
        }
        SOAPFault sOAPFault = wLSOAPFaultException.getFault();
        if (qNameArray != null) {
            for (QName qName : qNameArray) {
                try {
                    sOAPFault.appendFaultSubcode(qName);
                }
                catch (SOAPException sOAPException) {
                    throw new AssertionError((Object)sOAPException);
                }
            }
        }
        return wLSOAPFaultException;
    }

    public static SOAPMessage exception2Fault(MessageFactory messageFactory, Throwable throwable) {
        try {
            SOAPMessage sOAPMessage = messageFactory.createMessage();
            SOAPBody sOAPBody = sOAPMessage.getSOAPPart().getEnvelope().getBody();
            if (sOAPBody == null) {
                sOAPBody = sOAPMessage.getSOAPPart().getEnvelope().addBody();
            }
            SOAPFault sOAPFault = sOAPBody.addFault();
            StringBuilder stringBuilder = new StringBuilder();
            throwable = ExceptionUtil.unwrapException(throwable, stringBuilder);
            SOAPFaultUtil.fillFault(sOAPFault, throwable, stringBuilder.toString());
            return sOAPMessage;
        }
        catch (SOAPException sOAPException) {
            throw new AssertionError((Object)sOAPException);
        }
    }

    private static SOAPFault fillFaultCode(SOAPFault sOAPFault, QName qName) throws SOAPException {
        if (sOAPFault == null) {
            return sOAPFault;
        }
        boolean bl = SOAPFaultUtil.getSOAPVersion(sOAPFault);
        SOAPFaultUtil.validateFaultCode(bl, qName);
        sOAPFault.setFaultCode(qName);
        return sOAPFault;
    }

    private static SOAPFault genPartialWLSOAPFault(boolean bl, String string, String string2, Throwable throwable) throws SOAPException {
        SOAPFactory sOAPFactory = SOAPFaultUtil.getSoapFactory(bl);
        SOAPFault sOAPFault = sOAPFactory.createFault();
        if (string != null) {
            sOAPFault.setFaultString(string);
        }
        if (string2 != null) {
            sOAPFault.setFaultActor(string2);
        }
        if (throwable != null) {
            Detail detail = SOAPFaultUtil.newDetail(throwable, sOAPFactory);
            Detail detail2 = sOAPFault.addDetail();
            Iterator iterator = detail.getDetailEntries();
            while (iterator.hasNext()) {
                detail2.addChildElement((SOAPElement)iterator.next());
            }
        }
        return sOAPFault;
    }

    private static QName chgFaultCode(boolean bl, String string) {
        if (string != null) {
            return SOAPFaultUtil.createQName(bl, string);
        }
        return null;
    }

    static boolean getSOAPVersion(SOAPFault sOAPFault) throws SOAPException {
        if (sOAPFault == null) {
            throw new SOAPException("inputted param fault is null!");
        }
        if ("http://www.w3.org/2003/05/soap-envelope".equals(sOAPFault.getNamespaceURI())) {
            return true;
        }
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(sOAPFault.getNamespaceURI())) {
            return false;
        }
        throw new SOAPException("Unknow the namespace of a SOAPFault!");
    }

    public static void fillSoapDetail(Detail detail, SOAPFault sOAPFault) throws SOAPException {
        if (detail != null && sOAPFault != null) {
            if (sOAPFault.getDetail() != null) {
                sOAPFault.removeChild((Node)sOAPFault.getDetail());
            }
            NodeList nodeList = detail.getChildNodes();
            Detail detail2 = sOAPFault.addDetail();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = sOAPFault.getOwnerDocument().importNode(nodeList.item(i), true);
                detail2.appendChild(node);
            }
        }
    }

    private static void copySOAPFault(SOAPFault sOAPFault, SOAPFault sOAPFault2) throws SOAPException {
        sOAPFault2.setFaultCode(sOAPFault.getFaultCodeAsQName());
        sOAPFault2.setFaultString(sOAPFault.getFaultString());
        try {
            if (sOAPFault.getFaultRole() != null) {
                sOAPFault2.setFaultRole(sOAPFault.getFaultRole());
            }
            if (sOAPFault.getFaultActor() != null) {
                sOAPFault2.setFaultActor(sOAPFault.getFaultActor());
            }
            Iterator iterator = sOAPFault.getFaultSubcodes();
            while (iterator != null && iterator.hasNext()) {
                sOAPFault2.appendFaultSubcode((QName)iterator.next());
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        SOAPFaultUtil.fillSoapDetail(sOAPFault.getDetail(), sOAPFault2);
    }

    private static String soap12FaultCodeTransform(String string) {
        if (SOAP11_FC_SERVER.equals(string)) {
            return SOAP12_FC_SERVER;
        }
        if (SOAP11_FC_CLIENT.equals(string)) {
            return SOAP12_FC_CLIENT;
        }
        return string;
    }

    private static void setSoap12FaultSubCode(SOAPFault sOAPFault, String string, String string2, String string3) throws SOAPException {
        QName qName = null;
        qName = string2 != null ? new QName(string2, string, string3) : new QName(sOAPFault.getNamespaceURI(), string, ENV_PREFIX);
        sOAPFault.appendFaultSubcode(qName);
    }

    private static void setSoap12FaultCode(SOAPFault sOAPFault, String string, String string2, String string3) throws SOAPException {
        String[] stringArray = string.trim().split("\\.", 2);
        stringArray[0] = SOAPFaultUtil.soap12FaultCodeTransform(stringArray[0]);
        if (SOAP12_FAULT_CODES.contains(stringArray[0])) {
            sOAPFault.setFaultCode("env:" + stringArray[0]);
            if (stringArray.length > 1) {
                SOAPFaultUtil.setSoap12FaultSubCode(sOAPFault, stringArray[1], string2, string3);
            }
        } else {
            sOAPFault.setFaultCode("env:Sender");
            SOAPFaultUtil.setSoap12FaultSubCode(sOAPFault, string, string2, string3);
        }
    }

    private static void autoTransformFaultCode(boolean bl, QName qName, SOAPFault sOAPFault) throws SOAPException {
        if (qName == null) {
            if (bl) {
                sOAPFault.setFaultCode("env:Receiver");
            } else {
                sOAPFault.setFaultCode("env:Server");
            }
        } else {
            String string = qName.getLocalPart();
            String string2 = qName.getNamespaceURI();
            if (string == null || "".equals(string)) {
                string = SOAP11_FC_SERVER;
            }
            if (string2 == null || string2.trim().equals("")) {
                if (bl) {
                    SOAPFaultUtil.setSoap12FaultCode(sOAPFault, string, null, null);
                } else {
                    sOAPFault.setFaultCode("env:" + string);
                }
            } else {
                String string3 = qName.getPrefix();
                if (string3 == null || "".equals(string3)) {
                    string3 = "fault";
                }
                if (!ENV_PREFIX.equals(string3)) {
                    sOAPFault.addNamespaceDeclaration(string3, string2);
                }
                if (bl) {
                    SOAPFaultUtil.setSoap12FaultCode(sOAPFault, string, string2, string3);
                } else {
                    sOAPFault.setFaultCode(string3 + ":" + string);
                }
            }
        }
    }

    public static void fillFault(SOAPFault sOAPFault, Throwable throwable) throws SOAPException {
        SOAPFaultUtil.fillFault(sOAPFault, throwable, null);
    }

    private static void fillFault(SOAPFault sOAPFault, Throwable throwable, String string) throws SOAPException {
        boolean bl = SOAPFaultUtil.getSOAPVersion(sOAPFault);
        if (throwable instanceof WLSOAPFaultException) {
            WLSOAPFaultException wLSOAPFaultException = (WLSOAPFaultException)((Object)throwable);
            SOAPFault sOAPFault2 = wLSOAPFaultException.getFault();
            SOAPFaultUtil.copySOAPFault(sOAPFault2, sOAPFault);
        } else if (throwable instanceof SOAPFaultException) {
            SOAPFaultException sOAPFaultException = (SOAPFaultException)throwable;
            SOAPFaultUtil.autoTransformFaultCode(bl, sOAPFaultException.getFaultCode(), sOAPFault);
            sOAPFault.setFaultString(sOAPFaultException.getFaultString());
            String string2 = sOAPFaultException.getFaultActor();
            if (string2 != null) {
                sOAPFault.setFaultActor(string2);
            }
            SOAPFaultUtil.fillSoapDetail(sOAPFaultException.getDetail(), sOAPFault);
        } else if (SOAPFaultUtil.isAuthError(throwable)) {
            SOAPFaultUtil.autoTransformFaultCode(bl, new QName("Client.Authentication"), sOAPFault);
            sOAPFault.setFaultString(string);
            SOAPFaultUtil.fillDetail(throwable, sOAPFault.addDetail(), bl);
        } else {
            if (bl) {
                SOAPFaultUtil.fillFaultCode(sOAPFault, SOAPFaultUtil.chgFaultCode(bl, SOAP12_FC_SERVER));
            } else {
                SOAPFaultUtil.fillFaultCode(sOAPFault, SOAPFaultUtil.chgFaultCode(bl, SOAP11_FC_SERVER));
            }
            sOAPFault.setFaultString(string);
            SOAPFaultUtil.fillDetail(throwable, sOAPFault.addDetail(), bl);
        }
    }

    private static boolean isAuthError(Throwable throwable) {
        String string = throwable.getClass().getName();
        return string.endsWith("AccessException") || string.endsWith("AccessLocalException");
    }

    static void validate(boolean bl, String string) throws SOAPException {
        if (bl && !SOAP12_FAULT_CODES.contains(string)) {
            throw new SOAPException("Faultcode [" + string + "] is not a legal SOAP1.2 faultcode!");
        }
    }

    static void validateFaultCode(boolean bl, QName qName) throws SOAPException {
        if (qName == null) {
            throw new SOAPException("Faultcode is null!");
        }
        SOAPFaultUtil.validate(bl, qName.getLocalPart());
        String string = qName.getNamespaceURI();
        if (bl && string != null && !"http://www.w3.org/2003/05/soap-envelope".equals(string)) {
            throw new SOAPException("Faultcode's namespace is not a valid SOAP 1.2 desired!");
        }
    }

    private static Name createFaultName(SOAPFactory sOAPFactory) {
        try {
            return sOAPFactory.createName(FAULT_NAME, FAULT_PREFIX, FAULT_URI);
        }
        catch (SOAPException sOAPException) {
            throw new AssertionError((Object)sOAPException);
        }
    }

    static QName createQName(boolean bl, String string) {
        String string2 = "http://schemas.xmlsoap.org/soap/envelope/";
        if (bl) {
            string2 = "http://www.w3.org/2003/05/soap-envelope";
        }
        return new QName(string2, string, ENV_PREFIX);
    }

    private static SOAPFactory getSoapFactory(boolean bl) {
        String string = "SOAP 1.1 Protocol";
        if (bl) {
            string = "SOAP 1.2 Protocol";
        }
        return WLSOAPFactory.createSOAPFactory(string);
    }

    private static Detail newDetail(Throwable throwable, SOAPFactory sOAPFactory) {
        Detail detail;
        if (throwable instanceof SOAPFaultException) {
            return ((SOAPFaultException)throwable).getDetail();
        }
        try {
            detail = sOAPFactory.createDetail();
        }
        catch (SOAPException sOAPException) {
            throw new AssertionError((Object)sOAPException);
        }
        return SOAPFaultUtil.fillDetail(throwable, detail, sOAPFactory);
    }

    public static Detail newDetail(Throwable throwable, boolean bl) {
        SOAPFactory sOAPFactory = SOAPFaultUtil.getSoapFactory(bl);
        return SOAPFaultUtil.newDetail(throwable, sOAPFactory);
    }

    private static String getDettailString(Throwable throwable) {
        StringBuffer stringBuffer = new StringBuffer();
        do {
            stringBuffer.append(throwable.toString());
            stringBuffer.append("\n");
        } while ((throwable = throwable.getCause()) != null);
        return stringBuffer.toString();
    }

    public static Detail fillDetail(Throwable throwable, Detail detail, boolean bl) {
        if (detail == null) {
            return null;
        }
        return SOAPFaultUtil.fillDetail(throwable, detail, SOAPFaultUtil.getSoapFactory(bl));
    }

    public static Detail createDetail(QName qName, String string, boolean bl) {
        SOAPFactory sOAPFactory = SOAPFaultUtil.getSoapFactory(bl);
        Detail detail = null;
        try {
            detail = sOAPFactory.createDetail();
            SOAPElement sOAPElement = detail.addDetailEntry(qName).addTextNode(string);
        }
        catch (SOAPException sOAPException) {
            throw new AssertionError((Object)sOAPException);
        }
        return detail;
    }

    private static Detail fillDetail(Throwable throwable, Detail detail, SOAPFactory sOAPFactory) {
        if (!SOAPFaultUtil.isProductionMode()) {
            SOAPFaultUtil.fillStackTrace(throwable, detail, sOAPFactory);
        } else {
            try {
                detail.addDetailEntry(new QName("java.io", "string", "java")).addTextNode(SOAPFaultUtil.getDettailString(throwable));
            }
            catch (SOAPException sOAPException) {
                throw new AssertionError((Object)sOAPException);
            }
        }
        return detail;
    }

    private static boolean isProductionMode() {
        if (!KernelStatus.isServer()) {
            return false;
        }
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        return ManagementService.getRuntimeAccess(authenticatedSubject).getDomain().isProductionModeEnabled();
    }

    private static Detail fillStackTrace(Throwable throwable, Detail detail, SOAPFactory sOAPFactory) {
        try {
            DetailEntry detailEntry = detail.addDetailEntry(SOAPFaultUtil.createFaultName(sOAPFactory));
            detailEntry.addNamespaceDeclaration(FAULT_PREFIX, FAULT_URI);
            StringBuffer stringBuffer = new StringBuffer();
            Throwable throwable2 = throwable;
            String string = "";
            do {
                stringBuffer.append(string);
                stringBuffer.append(StackTraceUtils.throwable2StackTrace((Throwable)throwable2));
                throwable2 = throwable2.getCause();
                string = "Caused by: ";
            } while (throwable2 != null);
            detailEntry.addTextNode(stringBuffer.toString());
        }
        catch (SOAPException sOAPException) {
            throw new AssertionError((Object)sOAPException);
        }
        return detail;
    }

    private static void addSupportHeader(SOAPMessage sOAPMessage) throws SOAPException {
        SOAPHeaderElement sOAPHeaderElement = sOAPMessage.getSOAPHeader().addHeaderElement(SOAPConstants.HEADER12_UPGRADE);
        SOAPElement sOAPElement = sOAPHeaderElement.addChildElement(SOAPConstants.HEADER12_SUPPORTED_ENVELOPE);
        sOAPElement.setAttributeNS(null, "qname", "Envelope");
    }

    public static SOAPMessage createVersionMismatchMsg(boolean bl, Throwable throwable) {
        try {
            if (throwable instanceof SOAPFaultException) {
                SOAPBody sOAPBody;
                SOAPFaultException sOAPFaultException = (SOAPFaultException)throwable;
                MessageFactory messageFactory = WLMessageFactory.getInstance().getMessageFactory(false);
                SOAPMessage sOAPMessage = messageFactory.createMessage();
                if (bl) {
                    SOAPFaultUtil.addSupportHeader(sOAPMessage);
                }
                if ((sOAPBody = sOAPMessage.getSOAPPart().getEnvelope().getBody()) == null) {
                    sOAPBody = sOAPMessage.getSOAPPart().getEnvelope().addBody();
                }
                SOAPFault sOAPFault = sOAPBody.addFault();
                SOAPFaultUtil.fillFault(sOAPFault, sOAPFaultException, sOAPFaultException.getMessage());
                return sOAPMessage;
            }
            throw new SOAPException("Illegal SOAPFaultException", throwable);
        }
        catch (SOAPException sOAPException) {
            throw new AssertionError((Object)sOAPException);
        }
    }

    public static boolean isVersionMismatch(Throwable throwable) {
        SOAPFaultException sOAPFaultException;
        return throwable instanceof SOAPFaultException && SOAP_FC_VERSION_MISMATCH.equals((sOAPFaultException = (SOAPFaultException)throwable).getFaultCode().getLocalPart());
    }

    public static void throwVersionMismatchException(String string) {
        throw SOAPFaultUtil.newWLSOAP11FaultException(SOAP_FC_VERSION_MISMATCH, string, null, null);
    }

    public static WLSOAPFaultException newWLSOAP11FaultException(String string, String string2, String string3, Throwable throwable) {
        QName qName = SOAPFaultUtil.createQName(false, string);
        return SOAPFaultUtil.newWLSOAP11FaultException(qName, string2, string3, throwable);
    }

    public static WLSOAPFaultException newWLSOAP11FaultException(QName qName, String string, String string2, Throwable throwable) {
        boolean bl = false;
        try {
            SOAPFaultUtil.validateFaultCode(bl, qName);
            SOAPFault sOAPFault = SOAPFaultUtil.genPartialWLSOAPFault(bl, string, string2, throwable);
            SOAPFaultUtil.fillFaultCode(sOAPFault, qName);
            return new WLSOAPFaultException(bl, sOAPFault);
        }
        catch (SOAPException sOAPException) {
            throw new AssertionError((Object)sOAPException);
        }
    }

    public static WLSOAPFaultException newWLSOAP12FaultException(String string, String string2, String string3, Throwable throwable, QName ... qNameArray) {
        boolean bl = true;
        try {
            SOAPFaultUtil.validate(bl, string);
            SOAPFault sOAPFault = SOAPFaultUtil.genPartialWLSOAPFault(bl, string2, string3, throwable);
            QName qName = SOAPFaultUtil.createQName(bl, string);
            SOAPFaultUtil.fillFaultCode(sOAPFault, qName);
            WLSOAPFaultException wLSOAPFaultException = new WLSOAPFaultException(bl, sOAPFault);
            SOAPFaultUtil.setSOAP12SubFaultCodes(wLSOAPFaultException, qNameArray);
            return wLSOAPFaultException;
        }
        catch (SOAPException sOAPException) {
            throw new AssertionError((Object)sOAPException);
        }
    }

    public static WLSOAPFaultException newWLSOAPFaultException(MessageContext messageContext, String string, String string2, String string3, String string4, Throwable throwable, QName ... qNameArray) {
        if (AsyncUtil.isSoap12(messageContext)) {
            return SOAPFaultUtil.newWLSOAP12FaultException(string2, string3, string4, throwable, qNameArray);
        }
        return SOAPFaultUtil.newWLSOAP11FaultException(string, string3, string4, throwable);
    }

    public static WLSOAPFaultException newWLSOAPFaultException(MessageContext messageContext, QName qName, String string, String string2, String string3, Throwable throwable, QName ... qNameArray) {
        if (AsyncUtil.isSoap12(messageContext)) {
            return SOAPFaultUtil.newWLSOAP12FaultException(string, string2, string3, throwable, qNameArray);
        }
        return SOAPFaultUtil.newWLSOAP11FaultException(qName, string2, string3, throwable);
    }

    public static QName createFaultCodeQName(String string) {
        return new QName(ENV_PREFIX, string);
    }
}

