/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxrpc.soapfault;

import javax.xml.namespace.QName;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.Detail;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import weblogic.wsee.jaxrpc.soapfault.SOAPFaultUtil;

public final class WLSOAPFaultException
extends SOAPFaultException {
    private boolean isSoap12 = false;
    private SOAPFault fault = null;

    public WLSOAPFaultException(SOAPFault sOAPFault) {
        super(sOAPFault.getFaultCodeAsQName(), sOAPFault.getFaultString(), sOAPFault.getFaultActor(), sOAPFault.getDetail());
        this.fault = sOAPFault;
        try {
            this.isSoap12 = SOAPFaultUtil.getSOAPVersion(sOAPFault);
        }
        catch (SOAPException sOAPException) {
            // empty catch block
        }
    }

    public WLSOAPFaultException(boolean bl, SOAPFault sOAPFault) throws SOAPException {
        super(sOAPFault.getFaultCodeAsQName(), sOAPFault.getFaultString(), sOAPFault.getFaultActor(), sOAPFault.getDetail());
        this.fault = sOAPFault;
        this.isSoap12 = bl;
        SOAPFaultUtil.validateFaultCode(bl, sOAPFault.getFaultCodeAsQName());
    }

    public SOAPFault getFault() {
        return this.fault;
    }

    public boolean isSOAP12() {
        return this.isSoap12;
    }

    public Detail getDetail() {
        return super.getDetail();
    }

    public String getFaultActor() {
        return super.getFaultActor();
    }

    public QName getFaultCode() {
        return super.getFaultCode();
    }

    public String getFaultString() {
        return super.getFaultString();
    }
}

