/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws;

import com.sun.xml.ws.developer.MemberSubmissionAddressingFeature;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.AddressingFeature;
import weblogic.wsee.addressing.policy.api.UsingAddressingVersionInfo;
import weblogic.wsee.addressing.policy.internal.WSAUsingAddressingAssertion;
import weblogic.wsee.mtom.internal.OptimizedMimeSerialization;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyAlternative;
import weblogic.wsee.wsa.wsaddressing.WSAVersion;
import weblogic.wsee.wsa.wsaddressing.WSAddressingConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointPolicyUtility {
    public static boolean checkMTOMPolicy(NormalizedExpression normalizedExpression) {
        Set set = normalizedExpression.getPolicyAlternatives();
        if (set != null) {
            for (PolicyAlternative policyAlternative : set) {
                Set set2 = policyAlternative.getAssertions(OptimizedMimeSerialization.class);
                if (set2 == null || set2.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public static WebServiceFeature checkUsingAddressingPolicy(NormalizedExpression normalizedExpression) {
        Set set = normalizedExpression.getPolicyAlternatives();
        if (set != null) {
            Object object2;
            HashSet<UsingAddressingVersionInfo> hashSet = new HashSet<UsingAddressingVersionInfo>();
            for (Object object2 : set) {
                Set set2 = ((PolicyAlternative)object2).getAssertions(WSAUsingAddressingAssertion.class);
                if (set2 == null || set2.isEmpty()) continue;
                for (WSAUsingAddressingAssertion wSAUsingAddressingAssertion : set2) {
                    WSAVersion wSAVersion = EndpointPolicyUtility.getWSAVersionByPolicyNamespace(wSAUsingAddressingAssertion.getName().getNamespaceURI());
                    hashSet.add(new UsingAddressingVersionInfo(wSAVersion, wSAUsingAddressingAssertion.isRequired()));
                }
            }
            object2 = EndpointPolicyUtility.selectUsingAddressingVersionInfo(hashSet);
            if (object2 != null) {
                switch (((UsingAddressingVersionInfo)object2).getWSAVersion()) {
                    case MemberSubmission: {
                        return new MemberSubmissionAddressingFeature(true, ((UsingAddressingVersionInfo)object2).isRequired());
                    }
                    case WSA10: {
                        return new AddressingFeature(true, ((UsingAddressingVersionInfo)object2).isRequired());
                    }
                }
            }
        }
        return null;
    }

    private static WSAVersion getWSAVersionByPolicyNamespace(String string) {
        if (WSAddressingConstants.WSAW_QNAME.getNamespaceURI().equals(string)) {
            return WSAVersion.MemberSubmission;
        }
        if (WSAddressingConstants.WSAW_QNAME_10.getNamespaceURI().equals(string)) {
            return WSAVersion.WSA10;
        }
        return null;
    }

    private static UsingAddressingVersionInfo selectUsingAddressingVersionInfo(Set<UsingAddressingVersionInfo> set) {
        if (set == null || set.size() < 1) {
            return null;
        }
        UsingAddressingVersionInfo usingAddressingVersionInfo = null;
        Iterator<UsingAddressingVersionInfo> iterator = set.iterator();
        while (iterator.hasNext()) {
            UsingAddressingVersionInfo usingAddressingVersionInfo2;
            usingAddressingVersionInfo = usingAddressingVersionInfo2 = iterator.next();
            if (!WSAVersion.WSA10.equals((Object)usingAddressingVersionInfo2.getWSAVersion())) continue;
            break;
        }
        return usingAddressingVersionInfo;
    }
}

