/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.binding.WebServiceFeatureList;
import com.sun.xml.ws.transport.http.servlet.ServletAdapter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import javax.naming.Context;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.MTOMFeature;
import weblogic.jndi.factories.java.javaURLContextFactory;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.servlet.http.AbstractAsyncServlet;
import weblogic.servlet.http.RequestResponseKey;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.work.ExecuteThread;
import weblogic.work.SelfTuningWorkManagerImpl;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;
import weblogic.wsee.jaxws.EndpointPolicyUtility;
import weblogic.wsee.jaxws.HTTPProcessor;
import weblogic.wsee.jaxws.VerboseHttpProcessor;
import weblogic.wsee.jaxws.WLSContainer;
import weblogic.wsee.jaxws.WLSServletAdapterList;
import weblogic.wsee.jaxws.framework.jaxrpc.EnvironmentFactory;
import weblogic.wsee.jaxws.framework.jaxrpc.JAXRPCEnvironmentFeature;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.runtime.PolicyServer;
import weblogic.wsee.server.ServerUtil;
import weblogic.wsee.server.servlet.SecurityHelper;
import weblogic.wsee.util.ServerSecurityHelper;
import weblogic.wsee.util.ServletDebugUtil;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlPort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HttpServletAdapter
implements HTTPProcessor {
    private final WebAppServletContext servletContext;
    private final ServletAdapter servletAdapter;
    private final WLSServletAdapterList owner;
    private final WLSContainer container;
    private final SOAPVersion soapVersion;
    private WSEndpoint<?> endpoint;
    private final WsdlPort port;
    private final PolicyServer ps;
    private final String realmName;
    private NormalizedExpression ep = null;
    private boolean isSSLRequired = false;
    private boolean isClientCertRequired;
    private URL httpsServerURL;
    private boolean forceAuth;
    private final boolean isScheduleRequest;

    HttpServletAdapter(WSEndpoint<?> wSEndpoint, WLSContainer wLSContainer, WebAppServletContext webAppServletContext, ServletAdapter servletAdapter) {
        this(wSEndpoint, wLSContainer, webAppServletContext, servletAdapter, false);
    }

    HttpServletAdapter(WSEndpoint<?> wSEndpoint, WLSContainer wLSContainer, WebAppServletContext webAppServletContext, ServletAdapter servletAdapter, boolean bl) {
        this.endpoint = wSEndpoint;
        this.container = wLSContainer;
        this.servletContext = webAppServletContext;
        this.servletAdapter = servletAdapter;
        this.isScheduleRequest = bl;
        this.owner = servletAdapter.owner instanceof WLSServletAdapterList ? (WLSServletAdapterList)servletAdapter.owner : null;
        this.realmName = webAppServletContext.getSecurityRealmName();
        EnvironmentFactory environmentFactory = JAXRPCEnvironmentFeature.getFactory(wSEndpoint);
        WsdlDefinitions wsdlDefinitions = wSEndpoint.getPort() != null ? environmentFactory.getWsdlDef() : null;
        this.port = wsdlDefinitions != null ? wsdlDefinitions.getServices().get(wSEndpoint.getServiceName()).getPorts().get(wSEndpoint.getPortName()) : null;
        EnvironmentFactory.SingletonService singletonService = this.port != null ? environmentFactory.getService() : null;
        this.ps = singletonService != null ? singletonService.getPolicyServer() : null;
        this.checkEndpointPolicy();
        this.checkTwoWaySSLEnabled();
        this.soapVersion = wSEndpoint.getBinding().getSOAPVersion();
    }

    private void checkTwoWaySSLEnabled() {
        if (this.isClientCertRequired && !SecurityHelper.isTwoWaySSLEnabled()) {
            throw new WebServiceException("The WLS server is disabling the TwoWaySSL while Client Certificate is required!");
        }
    }

    private void checkEndpointPolicy() {
        if (this.port != null && this.ps != null) {
            try {
                NormalizedExpression normalizedExpression = this.ps.getEndpointPolicy(this.port);
                if (this.ep == null || !this.ep.equals(normalizedExpression)) {
                    WebServiceFeature webServiceFeature;
                    this.isSSLRequired = SecurityHelper.isHttpsRequiredByWssp(normalizedExpression);
                    if (this.isSSLRequired) {
                        this.httpsServerURL = new URL(ServerUtil.getHTTPServerURL(true));
                        this.isClientCertRequired = SecurityHelper.isClientCertRequiredByWssp(normalizedExpression);
                    }
                    this.forceAuth = SecurityHelper.isBasicAuthReqByWssp(normalizedExpression);
                    if (EndpointPolicyUtility.checkMTOMPolicy(normalizedExpression) && this.endpoint.getBinding().getFeature(MTOMFeature.class) == null) {
                        ((WebServiceFeatureList)this.endpoint.getBinding().getFeatures()).add((WebServiceFeature)new MTOMFeature());
                    }
                    if ((webServiceFeature = EndpointPolicyUtility.checkUsingAddressingPolicy(normalizedExpression)) != null && this.endpoint.getBinding().getFeature(webServiceFeature.getClass()) == null) {
                        ((WebServiceFeatureList)this.endpoint.getBinding().getFeatures()).add(webServiceFeature);
                    }
                    this.ep = normalizedExpression;
                }
            }
            catch (PolicyException policyException) {
                throw new WebServiceException((Throwable)policyException);
            }
            catch (MalformedURLException malformedURLException) {
                throw new WebServiceException((Throwable)malformedURLException);
            }
        }
    }

    @Override
    public boolean get(RequestResponseKey requestResponseKey, boolean bl) throws ServletException {
        Object object;
        Object object2;
        if (bl) {
            object2 = new VerboseHttpProcessor.VerboseHttpServletRequest(requestResponseKey.getRequest());
            object = new VerboseHttpProcessor.VerboseHttpServletResponse(requestResponseKey.getResponse());
            ServletDebugUtil.printRequest(object2);
        } else {
            object2 = requestResponseKey.getRequest();
            object = requestResponseKey.getResponse();
        }
        try {
            Object object3;
            this.checkEndpointPolicy();
            Object object4 = object2;
            if (this.isSSLRequired) {
                object3 = new HttpServletRequestWrapper((HttpServletRequest)object2){

                    public String getScheme() {
                        return "https";
                    }

                    public int getServerPort() {
                        return HttpServletAdapter.this.httpsServerURL.getPort();
                    }
                };
                if (this.owner != null) {
                    this.owner.registerPortAddressResolver(HttpServletAdapter.getBaseAddress(object2), HttpServletAdapter.getBaseAddress((HttpServletRequest)object3));
                } else {
                    object4 = object3;
                }
            }
            object3 = new RequestResponseWrapper(requestResponseKey, (HttpServletRequest)object4, (HttpServletResponse)object, false);
            this.servletAdapter.handle((ServletContext)this.servletContext, (HttpServletRequest)((RequestResponseWrapper)object3).getRequest(), (HttpServletResponse)((RequestResponseWrapper)object3).getResponse());
            if (bl) {
                ServletDebugUtil.printResponse(object);
            }
            if (bl && !((RequestResponseWrapper)object3).isNotified) {
                ServletDebugUtil.printResponse(object);
            }
            boolean bl2 = ((RequestResponseWrapper)object3).isNotified;
            return bl2;
        }
        catch (IOException iOException) {
            throw new ServletException((Throwable)iOException);
        }
        finally {
            if (this.owner != null) {
                this.owner.clearPortAddressResolver();
            }
        }
    }

    private static String getBaseAddress(HttpServletRequest httpServletRequest) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(httpServletRequest.getScheme());
        stringBuilder.append("://");
        stringBuilder.append(httpServletRequest.getServerName());
        stringBuilder.append(':');
        stringBuilder.append(httpServletRequest.getServerPort());
        stringBuilder.append(httpServletRequest.getContextPath());
        return stringBuilder.toString();
    }

    @Override
    public boolean post(RequestResponseKey requestResponseKey, final boolean bl) throws ServletException {
        Object object;
        Object object2;
        if (bl) {
            object2 = new VerboseHttpProcessor.VerboseHttpServletRequest(requestResponseKey.getRequest());
            object = new VerboseHttpProcessor.VerboseHttpServletResponse(requestResponseKey.getResponse());
            ServletDebugUtil.printRequest(object2);
        } else {
            object2 = requestResponseKey.getRequest();
            object = requestResponseKey.getResponse();
        }
        try {
            Runnable runnable;
            try {
                this.checkEndpointPolicy();
                this.checkTwoWaySSLEnabled();
            }
            catch (WebServiceException webServiceException) {
                this.sendAccessError((HttpServletRequest)object2, (HttpServletResponse)object, webServiceException.getMessage());
                if (bl) {
                    ServletDebugUtil.printResponse(object);
                }
                return false;
            }
            if (object2.isSecure()) {
                if (this.isClientCertRequired && !SecurityHelper.isClientCertPresent(object2)) {
                    this.sendAccessError((HttpServletRequest)object2, (HttpServletResponse)object, "Client Certificate Required!");
                    if (bl) {
                        ServletDebugUtil.printResponse(object);
                    }
                    return false;
                }
            } else if (this.isSSLRequired) {
                this.sendAccessError((HttpServletRequest)object2, (HttpServletResponse)object, "SSL Required!");
                if (bl) {
                    ServletDebugUtil.printResponse(object);
                }
                return false;
            }
            final RequestResponseWrapper requestResponseWrapper = new RequestResponseWrapper(requestResponseKey, (HttpServletRequest)object2, (HttpServletResponse)object, true);
            final AuthorizedInvoke authorizedInvoke = new AuthorizedInvoke(requestResponseWrapper);
            final AuthenticatedSubject authenticatedSubject = ServerSecurityHelper.getCurrentSubject();
            if (this.forceAuth && SecurityHelper.isAnonymous(authenticatedSubject)) {
                final AuthenticatedSubject authenticatedSubject2 = SecurityHelper.getRequestSubject(object2, this.realmName);
                if (authenticatedSubject == null) {
                    this.sendAuthError((HttpServletRequest)object2, (HttpServletResponse)object, "Authentication Required!");
                    if (bl) {
                        ServletDebugUtil.printResponse(object);
                    }
                    return false;
                }
                runnable = new Runnable((HttpServletResponse)object, requestResponseKey){
                    final /* synthetic */ HttpServletResponse val$response;
                    final /* synthetic */ RequestResponseKey val$rrk;
                    {
                        this.val$response = httpServletResponse;
                        this.val$rrk = requestResponseKey;
                    }

                    public void run() {
                        Throwable throwable = null;
                        try {
                            ServerSecurityHelper.authenticatedInvoke(authenticatedSubject2, authorizedInvoke);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                        }
                        try {
                            if (HttpServletAdapter.this.isScheduleRequest && !requestResponseWrapper.isNotified) {
                                if (bl) {
                                    ServletDebugUtil.printResponse(this.val$response);
                                }
                                AbstractAsyncServlet.notify((RequestResponseKey)this.val$rrk, (Object)throwable);
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                };
            } else {
                runnable = new Runnable((HttpServletResponse)object, requestResponseKey){
                    final /* synthetic */ HttpServletResponse val$response;
                    final /* synthetic */ RequestResponseKey val$rrk;
                    {
                        this.val$response = httpServletResponse;
                        this.val$rrk = requestResponseKey;
                    }

                    public void run() {
                        Throwable throwable = null;
                        try {
                            ServerSecurityHelper.authenticatedInvoke(authenticatedSubject, authorizedInvoke);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                        }
                        try {
                            if (HttpServletAdapter.this.isScheduleRequest && !requestResponseWrapper.isNotified) {
                                if (bl) {
                                    ServletDebugUtil.printResponse(this.val$response);
                                }
                                AbstractAsyncServlet.notify((RequestResponseKey)this.val$rrk, (Object)throwable);
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                };
            }
            if (this.isScheduleRequest) {
                this.getWorkManager().schedule(runnable);
                return true;
            }
            runnable.run();
            if (bl && !requestResponseWrapper.isNotified) {
                ServletDebugUtil.printResponse(object);
            }
            return requestResponseWrapper.isNotified;
        }
        catch (LoginException loginException) {
            try {
                this.sendAuthError((HttpServletRequest)object2, (HttpServletResponse)object, loginException.getMessage());
                return false;
            }
            catch (IOException iOException) {
                throw new ServletException((Throwable)iOException);
            }
        }
        catch (Throwable throwable) {
            throw new ServletException(throwable);
        }
    }

    private WorkManager getWorkManager() {
        Thread thread2 = Thread.currentThread();
        SelfTuningWorkManagerImpl selfTuningWorkManagerImpl = null;
        if (thread2 instanceof ExecuteThread) {
            selfTuningWorkManagerImpl = ((ExecuteThread)thread2).getWorkManager();
        }
        if (selfTuningWorkManagerImpl == null) {
            selfTuningWorkManagerImpl = WorkManagerFactory.getInstance().getDefault();
        }
        return selfTuningWorkManagerImpl;
    }

    protected void sendAccessError(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws IOException, ServletException {
        try {
            httpServletResponse.setStatus(403);
            SOAPMessage sOAPMessage = this.getFaultMessage(new QName(this.soapVersion.nsUri, "Client.Access"), string);
            this.setResponseContentType(httpServletRequest, httpServletResponse);
            sOAPMessage.writeTo((OutputStream)httpServletResponse.getOutputStream());
            httpServletResponse.getOutputStream().close();
        }
        catch (SOAPException sOAPException) {
            throw new ServletException("unable to send error:", (Throwable)sOAPException);
        }
    }

    protected void sendAuthError(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws IOException, ServletException {
        try {
            httpServletResponse.setHeader("WWW-Authenticate", "Basic realm=\"" + this.realmName + "\"");
            httpServletResponse.setStatus(401);
            SOAPMessage sOAPMessage = this.getFaultMessage(new QName(this.soapVersion.nsUri, "Client.Authentication"), string);
            this.setResponseContentType(httpServletRequest, httpServletResponse);
            sOAPMessage.writeTo((OutputStream)httpServletResponse.getOutputStream());
            httpServletResponse.getOutputStream().close();
        }
        catch (SOAPException sOAPException) {
            throw new ServletException("unable to send error:", (Throwable)sOAPException);
        }
    }

    private SOAPMessage getFaultMessage(QName qName, String string) throws SOAPException {
        SOAPMessage sOAPMessage = this.soapVersion.getMessageFactory().createMessage();
        SOAPFault sOAPFault = sOAPMessage.getSOAPPart().getEnvelope().getBody().addFault();
        sOAPFault.setFaultCode(qName);
        sOAPFault.setFaultString(string);
        return sOAPMessage;
    }

    private void setResponseContentType(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string = httpServletRequest.getContentType();
        if (string == null) {
            httpServletResponse.setContentType("text/xml");
        } else {
            httpServletResponse.setContentType(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AuthorizedInvoke
    implements PrivilegedExceptionAction<Object> {
        private final RequestResponseWrapper wrap;
        private final ClassLoader cl;
        private final Context context;

        public AuthorizedInvoke(RequestResponseWrapper requestResponseWrapper) {
            this.wrap = requestResponseWrapper;
            this.cl = Thread.currentThread().getContextClassLoader();
            this.context = HttpServletAdapter.this.servletContext.getEnvironmentContext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object run() throws Exception {
            block7: {
                if (HttpServletAdapter.this.isScheduleRequest) {
                    HttpServletAdapter.this.container.setCurrent();
                    try {
                        Thread thread2 = Thread.currentThread();
                        ClassLoader classLoader = thread2.getContextClassLoader();
                        thread2.setContextClassLoader(this.cl);
                        javaURLContextFactory.pushContext(this.context);
                        try {
                            HttpServletAdapter.this.servletAdapter.handle((ServletContext)HttpServletAdapter.this.servletContext, (HttpServletRequest)this.wrap.getRequest(), (HttpServletResponse)this.wrap.getResponse());
                            break block7;
                        }
                        finally {
                            javaURLContextFactory.popContext();
                            thread2.setContextClassLoader(classLoader);
                        }
                    }
                    finally {
                        HttpServletAdapter.this.container.resetCurrent();
                    }
                }
                HttpServletAdapter.this.servletAdapter.handle((ServletContext)HttpServletAdapter.this.servletContext, (HttpServletRequest)this.wrap.getRequest(), (HttpServletResponse)this.wrap.getResponse());
            }
            return null;
        }
    }

    private class RequestResponseWrapper {
        private RequestWrapper request;
        private ResponseWrapper response;
        private RequestResponseKey rrk;
        private boolean isEndpointProcessingComplete;
        private transient boolean isNotified = false;
        private transient boolean isNotifyPending = false;
        private transient boolean isRequestClosed = false;

        public RequestResponseWrapper(RequestResponseKey requestResponseKey) {
            this(requestResponseKey, requestResponseKey.getRequest(), requestResponseKey.getResponse(), true);
        }

        public RequestResponseWrapper(RequestResponseKey requestResponseKey, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl) {
            this.request = new RequestWrapper(httpServletRequest);
            this.response = new ResponseWrapper(httpServletResponse);
            this.rrk = requestResponseKey;
            this.isEndpointProcessingComplete = !bl;
        }

        public RequestWrapper getRequest() {
            return this.request;
        }

        public ResponseWrapper getResponse() {
            return this.response;
        }

        private class InputStreamWrapper
        extends ServletInputStream {
            private ServletInputStream delegate;

            public InputStreamWrapper(ServletInputStream servletInputStream) {
                this.delegate = servletInputStream;
            }

            public int readLine(byte[] byArray, int n, int n2) throws IOException {
                return this.delegate.readLine(byArray, n, n2);
            }

            public int read() throws IOException {
                return this.delegate.read();
            }

            public int read(byte[] byArray) throws IOException {
                return this.delegate.read(byArray);
            }

            public int read(byte[] byArray, int n, int n2) throws IOException {
                return this.delegate.read(byArray, n, n2);
            }

            public long skip(long l) throws IOException {
                return this.delegate.skip(l);
            }

            public int available() throws IOException {
                return this.delegate.available();
            }

            public void close() throws IOException {
                RequestResponseWrapper.this.isRequestClosed = true;
                if (RequestResponseWrapper.this.isEndpointProcessingComplete && !HttpServletAdapter.this.isScheduleRequest) {
                    this.delegate.close();
                } else if (!RequestResponseWrapper.this.isNotified) {
                    this.delegate.close();
                    if (RequestResponseWrapper.this.isNotifyPending) {
                        try {
                            RequestResponseWrapper.this.isNotified = true;
                            AbstractAsyncServlet.notify((RequestResponseKey)RequestResponseWrapper.this.rrk, null);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }

            public void mark(int n) {
                this.delegate.mark(n);
            }

            public void reset() throws IOException {
                this.delegate.reset();
            }

            public boolean markSupported() {
                return this.delegate.markSupported();
            }
        }

        private class RequestWrapper
        extends HttpServletRequestWrapper {
            private InputStreamWrapper is;

            public RequestWrapper(HttpServletRequest httpServletRequest) {
                super(httpServletRequest);
                this.is = null;
            }

            public ServletInputStream getInputStream() throws IOException {
                if (this.is == null) {
                    this.is = new InputStreamWrapper(super.getInputStream());
                }
                return this.is;
            }
        }

        private class OutputStreamWrapper
        extends ServletOutputStream
        implements EndpointProcessingComplete {
            private ServletOutputStream delegate;

            public OutputStreamWrapper(ServletOutputStream servletOutputStream) {
                this.delegate = servletOutputStream;
            }

            public void onEndpointProcessingComplete() {
                RequestResponseWrapper.this.isEndpointProcessingComplete = true;
            }

            public void print(String string) throws IOException {
                this.delegate.print(string);
            }

            public void print(boolean bl) throws IOException {
                this.delegate.print(bl);
            }

            public void print(char c) throws IOException {
                this.delegate.print(c);
            }

            public void print(int n) throws IOException {
                this.delegate.print(n);
            }

            public void print(long l) throws IOException {
                this.delegate.print(l);
            }

            public void print(float f) throws IOException {
                this.delegate.print(f);
            }

            public void print(double d) throws IOException {
                this.delegate.print(d);
            }

            public void println() throws IOException {
                this.delegate.println();
            }

            public void println(String string) throws IOException {
                this.delegate.println(string);
            }

            public void println(boolean bl) throws IOException {
                this.delegate.println(bl);
            }

            public void println(char c) throws IOException {
                this.delegate.println(c);
            }

            public void println(int n) throws IOException {
                this.delegate.println(n);
            }

            public void println(long l) throws IOException {
                this.delegate.println(l);
            }

            public void println(float f) throws IOException {
                this.delegate.println(f);
            }

            public void println(double d) throws IOException {
                this.delegate.println(d);
            }

            public void write(int n) throws IOException {
                this.delegate.write(n);
            }

            public void write(byte[] byArray) throws IOException {
                this.delegate.write(byArray);
            }

            public void write(byte[] byArray, int n, int n2) throws IOException {
                this.delegate.write(byArray, n, n2);
            }

            public void flush() throws IOException {
                this.delegate.flush();
            }

            public void close() throws IOException {
                if (RequestResponseWrapper.this.isEndpointProcessingComplete && !HttpServletAdapter.this.isScheduleRequest) {
                    this.delegate.close();
                } else if (!RequestResponseWrapper.this.isNotified) {
                    this.delegate.close();
                    if (RequestResponseWrapper.this.isRequestClosed) {
                        try {
                            RequestResponseWrapper.this.isNotified = true;
                            AbstractAsyncServlet.notify((RequestResponseKey)RequestResponseWrapper.this.rrk, null);
                        }
                        catch (IOException iOException) {}
                    } else {
                        RequestResponseWrapper.this.isNotifyPending = true;
                    }
                }
            }
        }

        private class ResponseWrapper
        extends HttpServletResponseWrapper {
            private OutputStreamWrapper os;

            public ResponseWrapper(HttpServletResponse httpServletResponse) {
                super(httpServletResponse);
                this.os = null;
            }

            public ServletOutputStream getOutputStream() throws IOException {
                if (this.os == null) {
                    this.os = new OutputStreamWrapper(super.getOutputStream());
                }
                return this.os;
            }
        }
    }

    public static interface EndpointProcessingComplete {
        public void onEndpointProcessingComplete();
    }
}

