/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws;

import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.WSFeatureList;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.api.server.Invoker;
import com.sun.xml.ws.api.server.SDDocumentSource;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.binding.WebServiceFeatureList;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.MTOMFeature;
import weblogic.diagnostics.instrumentation.DelegatingMonitor;
import weblogic.diagnostics.instrumentation.DiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticMonitor;
import weblogic.diagnostics.instrumentation.InstrumentationSupport;
import weblogic.diagnostics.instrumentation.JoinPoint;
import weblogic.diagnostics.instrumentation.PointcutHandlingInfo;
import weblogic.diagnostics.instrumentation.ValueHandlingInfo;
import weblogic.j2ee.descriptor.wl.PortComponentBean;
import weblogic.wsee.deploy.DeployInfo;
import weblogic.wsee.jaxws.JAXWSServlet;
import weblogic.wsee.jaxws.WLSContainer;
import weblogic.wsee.jaxws.handler.ServerHandlerChainsResolver;
import weblogic.wsee.jaxws.injection.WSEEComponentContributor;
import weblogic.wsee.jaxws.spi.WLSProvider;
import weblogic.wsee.jaxws.spi.WorkManagerExecutor;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsException;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlSchema;
import weblogic.wsee.wstx.wsat.TransactionalFeature;
import weblogic.wsee.wstx.wsat.config.DDHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JAXWSDeployedServlet
extends JAXWSServlet {
    DeployInfo info;
    WSEEComponentContributor wseeComponentContributor;
    private WLSContainer container;
    private ServerHandlerChainsResolver handlerChainsResolver;
    private WSEndpoint wse = null;
    static final long serialVersionUID = 3763231725950058651L;
    public static final String _WLDF$INST_VERSION = "9.0.0";
    static /* synthetic */ Class _WLDF$INST_FLD_class;
    public static final DelegatingMonitor _WLDF$INST_FLD_Webservices_JAXWS_Diagnostic_Resource_After_Low;
    public static final JoinPoint _WLDF$INST_JPFLD_0;

    abstract DeployInfo loadDeployInfo() throws WsException;

    @Override
    public void init() throws ServletException {
        try {
            this.info = this.loadDeployInfo();
            this.info.setServletContext(this.getServletContext());
            this.handlerChainsResolver = this.info.createServerHandlerChainsResolver();
            this.wseeComponentContributor = this.info.loadComponentContributor();
            this.info.validate();
        }
        catch (Exception exception) {
            throw new ServletException("Exception in JAXWS init", (Throwable)exception);
        }
        super.init();
    }

    @Override
    public void destroy() {
        if (this.wse != null) {
            this.wse.dispose();
            this.wse = null;
        }
        super.destroy();
    }

    private Collection<SDDocumentSource> getImportedWsdlsAndSchemas(WsdlDefinitions wsdlDefinitions) throws MalformedURLException {
        HashSet<SDDocumentSource> hashSet = new HashSet<SDDocumentSource>();
        this.buildImportedWsdls(wsdlDefinitions, hashSet);
        this.buildImportedSchemas(wsdlDefinitions, hashSet);
        return hashSet;
    }

    private void buildImportedSchemas(WsdlDefinitions wsdlDefinitions, Collection<SDDocumentSource> collection) throws MalformedURLException {
        if (wsdlDefinitions.getTypes() != null && wsdlDefinitions.getTypes().getImportedWsdlSchemas() != null) {
            List<? extends WsdlSchema> list = wsdlDefinitions.getTypes().getImportedWsdlSchemas();
            for (WsdlSchema wsdlSchema : list) {
                SDDocumentSource sDDocumentSource = this.createSDDocumentSource(wsdlSchema.getLocationUrl());
                if (sDDocumentSource == null) continue;
                collection.add(sDDocumentSource);
            }
        }
    }

    private void buildImportedWsdls(WsdlDefinitions wsdlDefinitions, Collection<SDDocumentSource> collection) throws MalformedURLException {
        Set<String> set = wsdlDefinitions.getKnownImportedWsdlLocations();
        for (String string : set) {
            SDDocumentSource sDDocumentSource = this.createSDDocumentSource(string);
            if (sDDocumentSource == null) continue;
            collection.add(sDDocumentSource);
        }
    }

    private SDDocumentSource createSDDocumentSource(String string) throws MalformedURLException {
        SDDocumentSource sDDocumentSource = null;
        URL uRL = null;
        if (string != null) {
            uRL = new URL(string);
        }
        if (verbose) {
            Verbose.log("Constructing SDDocumentSource :" + uRL);
        }
        if (uRL != null) {
            sDDocumentSource = SDDocumentSource.create((URL)uRL);
        }
        return sDDocumentSource;
    }

    @Override
    WLSContainer getContainer() {
        if (this.container == null) {
            this.container = new WLSContainer(this.getServletContext(), this.info);
        }
        return this.container;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    String getServiceUri() {
        String string;
        String string2;
        try {
            string2 = this.info.getServiceURIs()[0];
            if (string2 == null || string2.equals("/")) {
                string2 = "/" + this.info.getPortComp().getWsdlService().getLocalPart();
            }
            Object var5_2 = null;
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            Object var4_5 = null;
            if (!_WLDF$INST_FLD_Webservices_JAXWS_Diagnostic_Resource_After_Low.isEnabledAndNotDyeFiltered()) throw throwable;
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Webservices_JAXWS_Diagnostic_Resource_After_Low;
            InstrumentationSupport.process((JoinPoint)InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, null, var4_5), (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
            throw throwable;
        }
        String string3 = string;
        if (!_WLDF$INST_FLD_Webservices_JAXWS_Diagnostic_Resource_After_Low.isEnabledAndNotDyeFiltered()) return string2;
        DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Webservices_JAXWS_Diagnostic_Resource_After_Low;
        InstrumentationSupport.process((JoinPoint)InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, null, (Object)string3), (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    WSEndpoint getEndpoint() throws Exception {
        WebServiceFeatureList webServiceFeatureList = new WebServiceFeatureList(this.info.getJwsClass());
        WLSProvider.parseAnnotations(webServiceFeatureList, this.info.getJwsClass(), true);
        String string = this.info.getProtocolBinding();
        WSBinding wSBinding = null;
        if (this.info.getPortComp().isEnableMtom()) {
            webServiceFeatureList.add((WebServiceFeature)new MTOMFeature());
        }
        this.addWSATFeature(webServiceFeatureList);
        wSBinding = BindingID.parse((String)string).createBinding((WSFeatureList)webServiceFeatureList);
        this.handlerChainsResolver.configureHandlers(wSBinding, this.wseeComponentContributor);
        String string2 = null;
        Collection<Object> collection = new ArrayList();
        WsdlDefinitions wsdlDefinitions = this.info.getWsdlDef();
        if (wsdlDefinitions != null) {
            string2 = wsdlDefinitions.getWsdlLocation();
            collection = this.getImportedWsdlsAndSchemas(wsdlDefinitions);
        }
        SDDocumentSource sDDocumentSource = this.createSDDocumentSource(string2);
        URL uRL = this.info.getCatalog();
        if (verbose) {
            Verbose.log("Constructing WSEndpoint:");
            Verbose.say("  JWS = " + this.info.getJwsClass());
            Verbose.say("  wsdlService = " + this.info.getPortComp().getWsdlService());
            Verbose.say("  wsdlPort = " + this.info.getPortComp().getWsdlPort());
            Verbose.say("  bindingID =" + wSBinding.getBindingId());
            Verbose.say("  MTOM Enbaled =" + wSBinding.isFeatureEnabled(MTOMFeature.class));
            Verbose.say("  SOAP Version =" + wSBinding.getSOAPVersion());
            Verbose.say("  primaryWsdl = " + sDDocumentSource);
            Verbose.say("  catalogURL = " + uRL);
            Verbose.say("");
        }
        QName qName = this.info.getPortComp().getWsdlService();
        QName qName2 = this.info.getPortComp().getWsdlPort();
        this.container.registerPendingBoundEndpoint(qName, qName2, this.getServiceUri());
        this.container.setCurrent();
        try {
            this.wse = WSEndpoint.create((Class)this.info.getJwsClass(), (boolean)false, (Invoker)this.info.createInstanceResolver().createInvoker(), (QName)qName, (QName)qName2, (Container)this.container, (WSBinding)wSBinding, (SDDocumentSource)sDDocumentSource, collection, (URL)uRL);
            this.wse.setExecutor(WorkManagerExecutor.getExecutor());
            WSEndpoint wSEndpoint = this.wse;
            return wSEndpoint;
        }
        finally {
            this.container.resetCurrent();
        }
    }

    private void addWSATFeature(WebServiceFeatureList webServiceFeatureList) {
        PortComponentBean portComponentBean = this.info.getWlPortComp();
        if (portComponentBean != null) {
            TransactionalFeature transactionalFeature = (TransactionalFeature)webServiceFeatureList.get(TransactionalFeature.class);
            if (transactionalFeature != null) {
                DDHelper.updateFeatureFromServiceDD(transactionalFeature, portComponentBean);
            } else {
                transactionalFeature = DDHelper.buildFeatureFromServiceDD(portComponentBean);
            }
            if (transactionalFeature != null) {
                webServiceFeatureList.add((WebServiceFeature)transactionalFeature);
            }
        }
    }

    static {
        _WLDF$INST_FLD_class = Class.forName("weblogic.wsee.jaxws.JAXWSDeployedServlet");
        _WLDF$INST_FLD_Webservices_JAXWS_Diagnostic_Resource_After_Low = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Webservices_JAXWS_Diagnostic_Resource_After_Low");
        _WLDF$INST_JPFLD_0 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"JAXWSDeployedServlet.java", (String)"weblogic.wsee.jaxws.JAXWSDeployedServlet", (String)"getServiceUri", (String)"()Ljava/lang/String;", (int)125, (Map)InstrumentationSupport.makeMap((String[])new String[]{"Webservices_JAXWS_Diagnostic_Resource_After_Low"}, (PointcutHandlingInfo[])new PointcutHandlingInfo[]{InstrumentationSupport.createPointcutHandlingInfo(null, (ValueHandlingInfo)InstrumentationSupport.createValueHandlingInfo((String)"uri", (String)"weblogic.diagnostics.instrumentation.gathering.WebservicesJAXWSUriStringRenderer", (boolean)false, (boolean)true), null)}), (boolean)false);
    }
}

