/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws;

import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.transport.http.servlet.ServletAdapter;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import weblogic.servlet.http.AbstractAsyncServlet;
import weblogic.servlet.http.RequestResponseKey;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.wsee.jaxws.EndpointCreationInterceptor;
import weblogic.wsee.jaxws.EndpointCreationInterceptorFeature;
import weblogic.wsee.jaxws.HTTPProcessor;
import weblogic.wsee.jaxws.HttpServletAdapter;
import weblogic.wsee.jaxws.VerboseHttpProcessor;
import weblogic.wsee.jaxws.WLSContainer;
import weblogic.wsee.util.JAXWSClassLoaderFactory;
import weblogic.wsee.util.Verbose;

abstract class JAXWSServlet
extends AbstractAsyncServlet {
    private static final String METHOD_GET = "GET";
    private static final String METHOD_POST = "POST";
    private static final String METHOD_HEAD = "HEAD";
    static boolean verbose = Verbose.isVerbose(JAXWSServlet.class);
    private HTTPProcessor httpProcessor = null;
    private WSEndpoint wsep;
    private JAXWSClassLoaderFactory jclf = JAXWSClassLoaderFactory.getInstance();

    JAXWSServlet() {
    }

    public void init() throws ServletException {
        if (verbose) {
            Verbose.log("Begin JAXWS Servlet init");
        }
        super.init();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        this.jclf.setContextLoader(classLoader);
        try {
            this.registerEndpoint();
        }
        catch (Exception exception) {
            throw new ServletException("Exception in JAXWS init", (Throwable)exception);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        this.setTimeout(-1);
    }

    public void destroy() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        this.jclf.remove(classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doRequest(RequestResponseKey requestResponseKey) throws IOException, ServletException {
        requestResponseKey.setCallDoResponse(false);
        requestResponseKey.setImmediateSendOnDoRequestFalse(false);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        this.jclf.setContextLoader(classLoader);
        WLSContainer wLSContainer = this.getContainer();
        wLSContainer.setCurrent();
        try {
            HttpServletRequest httpServletRequest = requestResponseKey.getRequest();
            HttpServletResponse httpServletResponse = requestResponseKey.getResponse();
            String string = httpServletRequest.getMethod();
            if (string.equals(METHOD_GET) || string.equals(METHOD_HEAD)) {
                boolean bl = this.httpProcessor.get(requestResponseKey, false);
                return bl;
            }
            if (string.equals(METHOD_POST)) {
                boolean bl = this.httpProcessor.post(requestResponseKey, false);
                return bl;
            }
            if (httpServletRequest.getProtocol().endsWith("1.1")) {
                httpServletResponse.sendError(405);
            } else {
                httpServletResponse.sendError(400);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            wLSContainer.resetCurrent();
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    protected void doResponse(RequestResponseKey requestResponseKey, Object object) throws IOException, ServletException {
        if (object != null) {
            throw new ServletException((Throwable)object);
        }
    }

    protected void doTimeout(RequestResponseKey requestResponseKey) throws IOException, ServletException {
        requestResponseKey.getResponse().setStatus(503);
    }

    abstract WSEndpoint getEndpoint() throws Exception;

    abstract String getServiceUri();

    abstract WLSContainer getContainer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerEndpoint() throws Exception {
        WLSContainer wLSContainer = this.getContainer();
        this.wsep = this.getEndpoint();
        ServletAdapter servletAdapter = (ServletAdapter)wLSContainer.registerBoundEndpoint(this.wsep, this.getServiceUri());
        this.httpProcessor = new HttpServletAdapter(this.wsep, wLSContainer, (WebAppServletContext)this.getServletContext(), servletAdapter);
        wLSContainer.setCurrent();
        try {
            EndpointCreationInterceptorFeature endpointCreationInterceptorFeature = (EndpointCreationInterceptorFeature)this.wsep.getBinding().getFeature(EndpointCreationInterceptorFeature.class);
            if (endpointCreationInterceptorFeature != null) {
                ArrayList<WeakReference<EndpointCreationInterceptor>> arrayList = new ArrayList<WeakReference<EndpointCreationInterceptor>>();
                for (WeakReference<EndpointCreationInterceptor> weakReference : endpointCreationInterceptorFeature.getInterceptors()) {
                    EndpointCreationInterceptor endpointCreationInterceptor = (EndpointCreationInterceptor)weakReference.get();
                    if (endpointCreationInterceptor != null) {
                        endpointCreationInterceptor.postCreateEndpoint(this.wsep);
                        continue;
                    }
                    arrayList.add(weakReference);
                }
                for (WeakReference<EndpointCreationInterceptor> weakReference : arrayList) {
                    endpointCreationInterceptorFeature.getInterceptors().remove(weakReference);
                }
            }
        }
        finally {
            wLSContainer.resetCurrent();
        }
        if (verbose) {
            this.httpProcessor = new VerboseHttpProcessor(this.httpProcessor);
        }
    }

    static {
        System.setProperty("com.sun.xml.ws.api.BindingID.SOAP_12.canGenerateWsdl", "true");
    }
}

