/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.Component;
import com.sun.xml.ws.api.PropertySet;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import weblogic.jws.jaxws.client.ClientIdentityFeature;
import weblogic.wsee.jaxws.MonitoringStatMap;
import weblogic.wsee.jaxws.framework.PropertySetUtil;
import weblogic.wsee.jaxws.persistence.StandardPersistentPropertyRegister;
import weblogic.wsee.jaxws.spi.ClientIdentityRegistry;
import weblogic.wsee.monitoring.OperationStats;
import weblogic.wsee.monitoring.WseeClientRuntimeMBeanImpl;

public class MonitoringPipe
extends AbstractFilterTubeImpl {
    @Nullable
    private WSDLPort port;
    private boolean isClient;
    private MonitoringStatMap _stats = null;
    private Map<String, WSDLBoundOperation> opMap;

    public MonitoringPipe(WSDLPort wSDLPort, Tube tube, WSBinding wSBinding, Component component, boolean bl) {
        super(tube);
        Iterator iterator;
        Object object;
        this.port = wSDLPort;
        this.isClient = bl;
        if (bl && (object = (ClientIdentityFeature)wSBinding.getFeature(ClientIdentityFeature.class)) != null && (iterator = ClientIdentityRegistry.getClientRuntimeMBean(object.getClientId())) != null) {
            this._stats = ((WseeClientRuntimeMBeanImpl)((Object)iterator)).getStatMap();
        }
        if (wSDLPort != null) {
            this.opMap = new HashMap<String, WSDLBoundOperation>();
            object = wSDLPort.getBinding();
            for (WSDLBoundOperation wSDLBoundOperation : object.getBindingOperations()) {
                this.opMap.put(wSDLBoundOperation.getName().getLocalPart(), wSDLBoundOperation);
            }
        }
        if ((object = (StandardPersistentPropertyRegister)component.getSPI(StandardPersistentPropertyRegister.class)) != null) {
            iterator = object.getStandardProperties();
            iterator.add((String)"WL_OP_NAME");
            iterator.add((String)"WL_DISPATCH_BEGIN");
            iterator.add((String)"WL_EXECUTION_BEGIN");
            iterator.add((String)"WL_EXECUTION_END");
            object.getStandardPropertyBagClassNames().add(MonitoringPropertySet.class.getName());
        }
    }

    MonitoringPipe(MonitoringPipe monitoringPipe, TubeCloner tubeCloner) {
        super((AbstractFilterTubeImpl)monitoringPipe, tubeCloner);
        this.port = monitoringPipe.port;
        this.isClient = monitoringPipe.isClient;
        this._stats = monitoringPipe._stats;
        this.opMap = monitoringPipe.opMap;
    }

    public final MonitoringPipe copy(TubeCloner tubeCloner) {
        return new MonitoringPipe(this, tubeCloner);
    }

    private void report(String string, WSDLBoundOperation wSDLBoundOperation, Packet packet, Throwable throwable, Throwable throwable2, long l, long l2, long l3, long l4) {
        Object object;
        MonitoringStatMap monitoringStatMap;
        if (this.isClient) {
            monitoringStatMap = this._stats;
        } else {
            object = packet != null ? packet.component : null;
            MonitoringStatMap monitoringStatMap2 = monitoringStatMap = object != null ? (MonitoringStatMap)object.getSPI(MonitoringStatMap.class) : null;
        }
        if (monitoringStatMap != null && string != null && (object = (OperationStats)monitoringStatMap.get(string)) != null) {
            if (wSDLBoundOperation != null && wSDLBoundOperation.getOperation().isOneWay()) {
                object.reportOnewayInvocation(l2 - l, l3 - l2);
            } else {
                if (l3 == l2 && l3 == 0L) {
                    l3 = l2 = (l4 - l) / 2L + l;
                }
                object.reportInvocation(l2 - l, l3 - l2, l4 - l3);
            }
            if (throwable != null) {
                object.reportError(throwable);
            } else if (throwable2 != null) {
                object.reportResponseError(throwable2);
            } else {
                Message message = packet.getMessage();
                if (message != null && message.isFault()) {
                    object.reportResponseError(new Throwable("Exception in Web Service invocation."));
                }
            }
        }
    }

    @NotNull
    public NextAction processRequest(Packet packet) {
        MonitoringPropertySet monitoringPropertySet = new MonitoringPropertySet();
        packet.addSatellite((PropertySet)monitoringPropertySet);
        monitoringPropertySet.setDispatchBegin(System.nanoTime());
        Message message = packet.getMessage();
        WSDLBoundOperation wSDLBoundOperation = null;
        if (message != null && this.port != null) {
            wSDLBoundOperation = null;
            try {
                wSDLBoundOperation = message.getOperation(this.port);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        if (wSDLBoundOperation != null) {
            monitoringPropertySet.setOpName(wSDLBoundOperation.getName().getLocalPart());
        } else {
            monitoringPropertySet.setOpName("Ws-Protocol");
        }
        return this.doInvoke(this.next, packet);
    }

    @NotNull
    public NextAction processResponse(Packet packet) {
        MonitoringPropertySet monitoringPropertySet = MonitoringPropertySet.propertySetRetriever.getFromPacket(packet);
        if (monitoringPropertySet != null) {
            long l = System.nanoTime();
            long l2 = monitoringPropertySet.getExecutionBegin();
            long l3 = monitoringPropertySet.getExecutionEnd();
            WSDLBoundOperation wSDLBoundOperation = this.getWsdlOp(monitoringPropertySet);
            this.report(monitoringPropertySet.getOpName(), wSDLBoundOperation, packet, null, null, monitoringPropertySet.getDispatchBegin(), l2, l3, l);
        }
        return this.doReturnWith(packet);
    }

    private WSDLBoundOperation getWsdlOp(MonitoringPropertySet monitoringPropertySet) {
        return this.opMap != null ? this.opMap.get(monitoringPropertySet.getOpName()) : null;
    }

    @NotNull
    public NextAction processException(Throwable throwable) {
        MonitoringPropertySet monitoringPropertySet = MonitoringPropertySet.propertySetRetriever.getFromPacket(Fiber.current().getPacket());
        if (monitoringPropertySet != null) {
            long l = System.nanoTime();
            long l2 = monitoringPropertySet.getExecutionBegin();
            long l3 = monitoringPropertySet.getExecutionEnd();
            WSDLBoundOperation wSDLBoundOperation = this.getWsdlOp(monitoringPropertySet);
            Throwable throwable2 = null;
            Throwable throwable3 = null;
            if (l2 == 0L) {
                throwable2 = throwable;
            } else {
                throwable3 = throwable;
            }
            this.report(monitoringPropertySet.getOpName(), wSDLBoundOperation, Fiber.current().getPacket(), throwable2, throwable3, monitoringPropertySet.getDispatchBegin(), l2, l3, l);
        }
        return this.doThrow(throwable);
    }

    public static class MonitoringPropertySet
    extends PropertySet {
        public static PropertySetUtil.PropertySetRetriever<MonitoringPropertySet> propertySetRetriever = PropertySetUtil.getRetriever(MonitoringPropertySet.class);
        static final String OP_NAME = "WL_OP_NAME";
        static final String DISPATCH_BEGIN = "WL_DISPATCH_BEGIN";
        static final String EXECUTION_BEGIN = "WL_EXECUTION_BEGIN";
        static final String EXECUTION_END = "WL_EXECUTION_END";
        private String opName;
        private long dispatchBegin = 0L;
        private long executionBegin = 0L;
        private long executionEnd = 0L;
        private static final PropertySet.PropertyMap model = MonitoringPropertySet.parse(MonitoringPropertySet.class);

        @PropertySet.Property(value={"WL_OP_NAME"})
        public String getOpName() {
            return this.opName;
        }

        public void setOpName(String string) {
            this.opName = string;
        }

        @PropertySet.Property(value={"WL_DISPATCH_BEGIN"})
        public long getDispatchBegin() {
            return this.dispatchBegin;
        }

        public void setDispatchBegin(long l) {
            this.dispatchBegin = l;
        }

        @PropertySet.Property(value={"WL_EXECUTION_END"})
        public long getExecutionEnd() {
            return this.executionEnd;
        }

        @PropertySet.Property(value={"WL_EXECUTION_BEGIN"})
        public long getExecutionBegin() {
            return this.executionBegin;
        }

        public void setExecutionEnd(long l) {
            this.executionEnd = l;
        }

        public void setExecutionBegin(long l) {
            this.executionBegin = l;
        }

        protected PropertySet.PropertyMap getPropertyMap() {
            return model;
        }
    }
}

