/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws;

import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.api.server.ContainerResolver;
import com.sun.xml.ws.api.streaming.XMLStreamReaderFactory;
import com.sun.xml.ws.api.streaming.XMLStreamWriterFactory;
import com.sun.xml.ws.api.wsdl.parser.WSDLParserExtension;
import com.sun.xml.ws.binding.WebServiceFeatureList;
import com.sun.xml.ws.model.RuntimeModeler;
import com.sun.xml.ws.model.wsdl.WSDLModelImpl;
import com.sun.xml.ws.util.ServiceFinder;
import com.sun.xml.ws.wsdl.parser.RuntimeWSDLParser;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceClient;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceRef;
import javax.xml.ws.handler.HandlerResolver;
import org.xml.sax.EntityResolver;
import weblogic.deployment.ServiceRefProcessor;
import weblogic.deployment.ServiceRefProcessorException;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.EditableDescriptorManager;
import weblogic.j2ee.descriptor.InjectionTargetBean;
import weblogic.j2ee.descriptor.ServiceRefBean;
import weblogic.j2ee.descriptor.wl.PortInfoBean;
import weblogic.j2ee.descriptor.wl.ServiceReferenceDescriptionBean;
import weblogic.j2ee.descriptor.wl.WeblogicWebAppBean;
import weblogic.j2ee.injection.PitchforkContext;
import weblogic.wsee.jaxws.WLSContainer;
import weblogic.wsee.jaxws.handler.ClientHandlerChainsResolver;
import weblogic.wsee.jaxws.injection.WSEEClientComponentContributor;
import weblogic.wsee.jaxws.spi.WLSProvider;
import weblogic.wsee.jaxws.spi.WLSServiceDelegate;
import weblogic.wsee.tools.xcatalog.XCatalogUtil;
import weblogic.wsee.util.ClassUtil;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsException;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wstx.wsat.Transactional;
import weblogic.wsee.wstx.wsat.config.DDHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceRefProcessorImpl
implements ServiceRefProcessor {
    private static final boolean verbose;
    private ServiceRefBean serviceRefBean;
    private ServiceReferenceDescriptionBean serviceReferenceDescriptionBean;
    private Object targetRef;
    private WebServiceFeatureList features = new WebServiceFeatureList();

    public ServiceRefProcessorImpl(ServiceRefBean serviceRefBean, ServiceReferenceDescriptionBean serviceReferenceDescriptionBean, ServletContext servletContext) throws WsException {
        Object object;
        Object object2;
        this.serviceRefBean = serviceRefBean;
        this.serviceReferenceDescriptionBean = serviceReferenceDescriptionBean;
        if (this.serviceReferenceDescriptionBean == null) {
            object2 = new EditableDescriptorManager();
            object = (WeblogicWebAppBean)object2.createDescriptorRoot(WeblogicWebAppBean.class).getRootBean();
            this.serviceReferenceDescriptionBean = object.createServiceReferenceDescription();
        }
        try {
            object2 = Thread.currentThread().getContextClassLoader();
            object = null;
            String string = serviceRefBean.getServiceRefType();
            if (!StringUtil.isEmpty(string)) {
                object = ((ClassLoader)object2).loadClass(string);
            }
            this.parseAnnotations();
            if (object != null && Service.class.isAssignableFrom((Class<?>)object)) {
                this.targetRef = this.createService((Class)object, servletContext);
                this.parseAnnotations(true);
            } else {
                Service service2 = this.createServiceInterface((Class)object, (ClassLoader)object2, servletContext);
                this.parseAnnotations(true);
                this.targetRef = object == null ? service2 : service2.getPort((Class)object);
            }
        }
        catch (Throwable throwable) {
            throw new WsException("Error setting up WebServiceRef: " + throwable, throwable);
        }
    }

    private void parseAnnotations() throws Exception {
        this.parseAnnotations(false);
    }

    private void parseAnnotations(boolean bl) throws Exception {
        int n = 0;
        InjectionTargetBean[] injectionTargetBeanArray = this.serviceRefBean.getInjectionTargets();
        InjectionTargetBean[] injectionTargetBeanArray2 = injectionTargetBeanArray;
        int n2 = injectionTargetBeanArray2.length;
        if (n < n2) {
            InjectionTargetBean injectionTargetBean = injectionTargetBeanArray2[n];
            String string = injectionTargetBean.getInjectionTargetClass();
            String string2 = injectionTargetBean.getInjectionTargetName();
            Class clazz = ClassUtil.loadClass(string);
            Class clazz2 = ClassUtil.loadClass(this.serviceRefBean.getServiceRefType());
            AccessibleObject accessibleObject = null;
            try {
                accessibleObject = clazz.getDeclaredField(string2);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            if (accessibleObject == null || ((AccessibleObject)accessibleObject).getAnnotation(WebServiceRef.class) == null) {
                if (verbose) {
                    Verbose.log(" no field  named " + string2 + "annotated with @WebServiceRef!");
                }
                try {
                    accessibleObject = clazz.getDeclaredMethod("set" + RuntimeModeler.capitalize((String)string2), clazz2);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new WebServiceException("can't find injection target");
                }
            }
            if (accessibleObject != null) {
                if (bl) {
                    Transactional transactional = ((AccessibleObject)accessibleObject).getAnnotation(Transactional.class);
                    if (transactional == null) {
                        return;
                    }
                    if (this.targetRef instanceof Service) {
                        Iterator iterator = ((Service)this.targetRef).getPorts();
                        while (iterator.hasNext()) {
                            QName qName = (QName)iterator.next();
                            PortInfoBean portInfoBean = this.serviceReferenceDescriptionBean.lookupPortInfo(qName.getLocalPart());
                            if (portInfoBean == null) {
                                portInfoBean = this.serviceReferenceDescriptionBean.createPortInfo();
                                portInfoBean.setPortName(qName.getLocalPart());
                            }
                            DDHelper.populateServiceRefDDFromAnnotation(transactional, portInfoBean);
                        }
                    } else {
                        PortInfoBean portInfoBean = this.serviceReferenceDescriptionBean.createPortInfo();
                        portInfoBean.setPortName(":");
                        DDHelper.populateServiceRefDDFromAnnotation(transactional, portInfoBean);
                    }
                } else {
                    WLSProvider.parseAnnotations(this.features, accessibleObject, true);
                }
            }
            return;
        }
    }

    protected boolean isSet(String string, Object object) {
        return ((DescriptorBean)object).isSet(string);
    }

    private void configureHandlers(Service service2) throws Throwable {
        PitchforkContext pitchforkContext = new PitchforkContext(null);
        WSEEClientComponentContributor wSEEClientComponentContributor = new WSEEClientComponentContributor(this.serviceRefBean.getHandlerChains(), pitchforkContext);
        wSEEClientComponentContributor.init();
        ClientHandlerChainsResolver clientHandlerChainsResolver = new ClientHandlerChainsResolver(service2.getServiceName(), service2.getPorts(), this.serviceRefBean.getHandlerChains(), wSEEClientComponentContributor);
        service2.setHandlerResolver((HandlerResolver)clientHandlerChainsResolver);
    }

    private Service createServiceInterface(Class clazz, ClassLoader classLoader, ServletContext servletContext) throws Throwable {
        String string = this.serviceRefBean.getServiceInterface();
        if (StringUtil.isEmpty(string)) {
            if (clazz == null) {
                throw new IllegalArgumentException("A ServiceInterface must be specified if no service-ref-type is specified");
            }
            throw new IllegalArgumentException("A ServiceInterface must be specified if using a SEI reference " + clazz.getName());
        }
        Class<?> clazz2 = classLoader.loadClass(string);
        if (!Service.class.isAssignableFrom(clazz2)) {
            throw new IllegalArgumentException("ServiceInterface " + clazz2.getName() + " must extend " + Service.class.getName());
        }
        return this.createService(clazz2, servletContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Service createService(Class clazz, ServletContext servletContext) throws Throwable {
        Service service2;
        URL uRL = this.getWsdlURL(clazz, servletContext);
        QName qName = this.getServiceQName(clazz, uRL);
        WLSServiceDelegate.serviceRefLocal.set(this.serviceRefBean);
        WLSServiceDelegate.serviceReferenceDescriptionLocal.set(this.serviceReferenceDescriptionBean);
        WLSServiceDelegate.featuresLocal.set(this.features);
        try {
            if (Service.class.equals((Object)clazz)) {
                service2 = Service.create((URL)uRL, (QName)qName);
            } else {
                Constructor constructor = clazz.getConstructor(URL.class, QName.class);
                service2 = (Service)constructor.newInstance(uRL, qName);
            }
        }
        finally {
            WLSServiceDelegate.serviceRefLocal.set(null);
            WLSServiceDelegate.serviceReferenceDescriptionLocal.set(null);
            WLSServiceDelegate.featuresLocal.set(null);
        }
        this.configureHandlers(service2);
        return service2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL getWsdlURL(Class clazz, ServletContext servletContext) throws Exception {
        if (this.serviceReferenceDescriptionBean != null && this.serviceReferenceDescriptionBean.getWsdlUrl() != null && servletContext != null) {
            return ServiceRefProcessorImpl.getResource(this.serviceReferenceDescriptionBean.getWsdlUrl(), servletContext);
        }
        Container container = ContainerResolver.getInstance().getContainer();
        WLSContainer wLSContainer = null;
        URL uRL = null;
        try {
            if (servletContext != null && !servletContext.equals(container.getSPI(ServletContext.class))) {
                wLSContainer = new WLSContainer(servletContext, null);
                wLSContainer.setCurrent();
            }
            if (this.serviceReferenceDescriptionBean != null && this.serviceReferenceDescriptionBean.getWsdlUrl() != null) {
                uRL = WLSProvider.locateWsdl(clazz, this.serviceReferenceDescriptionBean.getWsdlUrl());
            }
            if (uRL == null) {
                uRL = WLSProvider.locateWsdl(clazz, this.serviceRefBean.getWsdlFile());
            }
        }
        finally {
            if (wLSContainer != null) {
                wLSContainer.resetCurrent();
            }
        }
        if (uRL == null) {
            if (Service.class.equals((Object)clazz)) {
                throw new IllegalArgumentException("A wsdlLocation must be specified if using " + Service.class.getName());
            }
            WebServiceClient webServiceClient = clazz.getAnnotation(WebServiceClient.class);
            if (webServiceClient == null) {
                throw new IllegalArgumentException("Service class " + clazz.getName() + " does not have required WebServiceClient annotation.");
            }
            if (StringUtil.isEmpty(webServiceClient.wsdlLocation())) {
                throw new IllegalArgumentException("wsdlLocation not specidied on class " + clazz.getName() + " WebServiceClient annotation.");
            }
        }
        return uRL;
    }

    private static URL getResource(String string, ServletContext servletContext) throws Exception {
        URL uRL = null;
        if (string != null && string.startsWith("/")) {
            uRL = servletContext.getResource(string);
        }
        if (uRL == null) {
            uRL = Thread.currentThread().getContextClassLoader().getResource(string);
        }
        if (uRL == null) {
            uRL = new URL(string);
        }
        return uRL;
    }

    private QName getServiceQName(Class clazz, URL uRL) throws WsdlException {
        QName qName = this.serviceRefBean.getServiceQname();
        if (qName == null) {
            if (uRL == null) {
                WebServiceClient webServiceClient;
                String string;
                String string2 = string = this.serviceReferenceDescriptionBean != null ? this.serviceReferenceDescriptionBean.getWsdlUrl() : this.serviceRefBean.getWsdlFile();
                if (string == null && (webServiceClient = clazz.getAnnotation(WebServiceClient.class)) != null) {
                    string = webServiceClient.wsdlLocation();
                }
                throw new IllegalArgumentException("WSDL not found at " + string);
            }
            Set<QName> set = this.getServiceQNameByRI(uRL, clazz);
            if (set != null) {
                if (set.size() == 1) {
                    qName = set.iterator().next();
                } else if (set.size() > 1) {
                    throw new IllegalArgumentException("A serviceQName must be specified when referencing " + Service.class.getName() + ", more than one service was found in the wsdl.");
                }
            }
            if (qName == null) {
                throw new IllegalArgumentException("A serviceQName must be specified when referencing " + Service.class.getName() + ", no service was found in the wsdl.");
            }
        }
        return qName;
    }

    @Override
    public void unbindServiceRef(Context context) throws NamingException {
        context.unbind(this.serviceRefBean.getServiceRefName());
    }

    @Override
    public void bindServiceRef(Context context, Context context2, String string) throws NamingException, ServiceRefProcessorException {
        context2.bind(this.serviceRefBean.getServiceRefName(), this.targetRef);
        if (verbose) {
            Verbose.log("Bound JAXWS service-ref under name " + this.serviceRefBean.getServiceRefName());
        }
    }

    private Set<QName> getServiceQNameByRI(URL uRL, Class clazz) throws WsdlException {
        try {
            EntityResolver entityResolver = XCatalogUtil.createRuntimeCatalogResolver(2);
            Container container = ContainerResolver.getInstance().getContainer();
            WSDLModelImpl wSDLModelImpl = RuntimeWSDLParser.parse((URL)uRL, (Source)new StreamSource(uRL.toExternalForm()), (EntityResolver)entityResolver, (boolean)false, (Container)container, (Class)clazz, (WSDLParserExtension[])((WSDLParserExtension[])ServiceFinder.find(WSDLParserExtension.class).toArray()));
            return wSDLModelImpl.getServices().keySet();
        }
        catch (Exception exception) {
            throw new WsdlException("Failed to parse wsdl from " + uRL, exception);
        }
    }

    static {
        System.setProperty(XMLStreamWriterFactory.class.getName() + ".woodstox", "true");
        System.setProperty(XMLStreamReaderFactory.class.getName() + ".woodstox", "true");
        WLSContainer.setContainerResolver();
        verbose = Verbose.isVerbose(ServiceRefProcessorImpl.class);
    }
}

