/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import weblogic.servlet.http.RequestResponseKey;
import weblogic.wsee.jaxws.HTTPProcessor;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.util.VerboseInputStream;
import weblogic.wsee.util.VerboseOutputStream;

class VerboseHttpProcessor
implements HTTPProcessor {
    private HTTPProcessor delegate = null;

    public VerboseHttpProcessor(HTTPProcessor hTTPProcessor) {
        this.delegate = hTTPProcessor;
    }

    public boolean get(RequestResponseKey requestResponseKey, boolean bl) throws ServletException {
        Verbose.log("*** JAXWS get start ***");
        boolean bl2 = this.delegate.get(requestResponseKey, true);
        Verbose.log("*** JAXWS get finish ***");
        Verbose.say("");
        return bl2;
    }

    public boolean post(RequestResponseKey requestResponseKey, boolean bl) throws ServletException {
        Verbose.log("*** JAXWS post start ***");
        boolean bl2 = this.delegate.post(requestResponseKey, true);
        Verbose.log("*** JAXWS post finish ***");
        Verbose.say("");
        return bl2;
    }

    public static class VerboseServletOutputStream
    extends ServletOutputStream {
        private OutputStream delegate = null;

        public VerboseServletOutputStream(OutputStream outputStream) {
            this.delegate = new VerboseOutputStream(outputStream);
        }

        public void write(int n) throws IOException {
            this.delegate.write(n);
        }

        public void write(byte[] byArray) throws IOException {
            this.delegate.write(byArray);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.delegate.write(byArray, n, n2);
        }

        public void flush() throws IOException {
            this.delegate.flush();
        }

        public void close() throws IOException {
            this.delegate.close();
        }
    }

    static class VerboseHttpServletResponse
    extends HttpServletResponseWrapper {
        public VerboseHttpServletResponse(HttpServletResponse httpServletResponse) {
            super(httpServletResponse);
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return new VerboseServletOutputStream((OutputStream)super.getOutputStream());
        }
    }

    private static class VerboseSerlvetInputStream
    extends ServletInputStream {
        private InputStream delegate = null;

        public VerboseSerlvetInputStream(InputStream inputStream) {
            this.delegate = new VerboseInputStream(inputStream);
        }

        public int read() throws IOException {
            return this.delegate.read();
        }

        public int readLine(byte[] byArray, int n, int n2) throws IOException {
            return this.delegate.read(byArray, n, n2);
        }

        public int read(byte[] byArray) throws IOException {
            return this.delegate.read(byArray);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this.delegate.read(byArray, n, n2);
        }

        public long skip(long l) throws IOException {
            return this.delegate.skip(l);
        }

        public int available() throws IOException {
            return this.delegate.available();
        }

        public void close() throws IOException {
            this.delegate.close();
        }

        public synchronized void mark(int n) {
            this.delegate.mark(n);
        }

        public synchronized void reset() throws IOException {
            this.delegate.reset();
        }

        public boolean markSupported() {
            return this.delegate.markSupported();
        }
    }

    static class VerboseHttpServletRequest
    extends HttpServletRequestWrapper {
        public VerboseHttpServletRequest(HttpServletRequest httpServletRequest) {
            super(httpServletRequest);
        }

        public ServletInputStream getInputStream() throws IOException {
            return new VerboseSerlvetInputStream((InputStream)super.getInputStream());
        }
    }
}

