/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws;

import com.sun.xml.ws.server.EndpointFactory;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.jws.Oneway;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.ws.Provider;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceProvider;
import weblogic.wsee.jws.JWSVisitor;
import weblogic.wsee.util.ClassLoaderUtil;
import weblogic.wsee.util.StringUtil;

class VisitableJWS
extends weblogic.wsee.jws.VisitableJWS {
    MyJWSClass jws;

    VisitableJWS(Class clazz, Class clazz2, QName qName, QName qName2) {
        this.jws = new MyJWSClass(clazz, clazz2, qName, qName2);
    }

    public void accept(JWSVisitor jWSVisitor) {
        jWSVisitor.visitClass(this.jws);
        if (!this.jws.isProviderBased()) {
            this.vistitSEIWebMethods(jWSVisitor);
        }
    }

    private void vistitSEIWebMethods(JWSVisitor jWSVisitor) {
        boolean bl = this.jws.getServiceInterface() != null;
        Method[] methodArray = bl ? this.jws.getServiceInterface().getMethods() : this.jws.getServiceImpl().getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            WebMethod webMethod = method.getAnnotation(WebMethod.class);
            MyWsMethod myWsMethod = null;
            if (bl) {
                try {
                    Method method2 = this.jws.getServiceImpl().getMethod(method.getName(), method.getParameterTypes());
                    myWsMethod = new MyWsMethod(method, method2);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new WebServiceException("the service impl class doesn't implement method: " + method.getName(), (Throwable)noSuchMethodException);
                }
            } else if (!Modifier.isStatic(method.getModifiers())) {
                boolean bl2;
                boolean bl3 = webMethod != null && !webMethod.exclude();
                boolean bl4 = bl2 = webMethod == null && method.getDeclaringClass().getAnnotation(WebService.class) != null;
                if (bl3 || bl2) {
                    myWsMethod = new MyWsMethod(method, method);
                }
            }
            if (myWsMethod == null) continue;
            jWSVisitor.visitMethod(myWsMethod);
        }
    }

    private static class MyWsMethod
    implements JWSVisitor.WsMethod {
        Method seiMethod;
        Method implMethod;

        private MyWsMethod(Method method, Method method2) {
            this.seiMethod = method;
            this.implMethod = method2;
        }

        public String getOperationName() {
            WebMethod webMethod = this.seiMethod.getAnnotation(WebMethod.class);
            boolean bl = webMethod != null && !StringUtil.isEmpty(webMethod.operationName());
            return bl ? webMethod.operationName() : this.seiMethod.getName();
        }

        public Method getImplMethod() {
            return this.implMethod;
        }

        public Method getSeiMethod() {
            return this.seiMethod;
        }

        public boolean isOneway() {
            return this.seiMethod.isAnnotationPresent(Oneway.class);
        }
    }

    private static class MyJWSClass
    implements JWSVisitor.JWSClass {
        Class sei;
        Class serivceImpl;
        private QName portName;
        private QName serviceName;

        private MyJWSClass(Class clazz, Class clazz2, QName qName, QName qName2) {
            this.sei = clazz;
            this.serivceImpl = clazz2;
            this.portName = qName;
            this.serviceName = qName2;
            if (clazz != null && clazz.getAnnotation(WebService.class) == null) {
                throw new IllegalArgumentException("the service endpoint interface should be annotated with @WebService!");
            }
            if (clazz2 == null) {
                throw new IllegalArgumentException("the service implementation class can't be null!");
            }
            WebService webService = clazz2.getAnnotation(WebService.class);
            if (webService == null && clazz2.getAnnotation(WebServiceProvider.class) == null) {
                throw new IllegalArgumentException("the service implementation class should be annotated with @WebService or @WebServiceProvider!");
            }
            if (this.sei == null && webService != null && !StringUtil.isEmpty(webService.endpointInterface())) {
                try {
                    this.sei = new ClassLoaderUtil.DelegatingLoader(clazz2.getClassLoader(), Thread.currentThread().getContextClassLoader()).loadClass(webService.endpointInterface());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new WebServiceException("can't load service endpoint interface:\t" + webService.endpointInterface(), (Throwable)classNotFoundException);
                }
            }
        }

        public Class getServiceImpl() {
            return this.serivceImpl;
        }

        public Class getServiceInterface() {
            return this.sei;
        }

        public QName getServiceName() {
            if (this.serviceName == null) {
                this.serviceName = EndpointFactory.getDefaultServiceName((Class)this.serivceImpl);
            }
            return this.serviceName;
        }

        public QName getPortName() {
            if (this.portName == null) {
                this.portName = EndpointFactory.getDefaultPortName((QName)this.getServiceName(), (Class)this.serivceImpl);
            }
            return this.portName;
        }

        public boolean isProviderBased() {
            return this.serivceImpl.getAnnotation(WebServiceProvider.class) != null;
        }

        public Method getInvokeMethod() {
            if (!this.isProviderBased()) {
                return null;
            }
            Type[] typeArray = this.serivceImpl.getGenericInterfaces();
            Type[] typeArray2 = null;
            if (typeArray != null) {
                for (Type type : typeArray) {
                    ParameterizedType parameterizedType;
                    if (!(type instanceof ParameterizedType) || !Provider.class.equals((Object)(parameterizedType = (ParameterizedType)type).getRawType())) continue;
                    typeArray2 = parameterizedType.getActualTypeArguments();
                    break;
                }
            }
            if (typeArray2 != null && typeArray2.length == 1) {
                try {
                    return this.serivceImpl.getMethod("invoke", (Class)typeArray2[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

