/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws;

import com.sun.istack.NotNull;
import com.sun.xml.bind.api.JAXBRIContext;
import com.sun.xml.ws.api.server.Invoker;
import com.sun.xml.ws.api.server.WSWebServiceContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.SessionContext;
import javax.jws.WebService;
import javax.naming.Context;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import javax.xml.ws.Provider;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceProvider;
import weblogic.ejb.container.internal.BaseWSLocalObject;
import weblogic.ejb.spi.BaseWSObjectIntf;
import weblogic.ejb.spi.MethodUtils;
import weblogic.ejb.spi.WSObjectFactory;
import weblogic.wsee.deploy.DeployUtil;
import weblogic.wsee.jaxws.WLSInstanceResolver;
import weblogic.wsee.server.ejb.WsEjb;
import weblogic.wsee.util.ClassUtil;
import weblogic.wsee.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WLSEjbInstanceResolver
extends WLSInstanceResolver<BaseWSObjectIntf>
implements WLSInstanceResolver.Factory<BaseWSObjectIntf> {
    private static final Method providerInvokeMethod;
    private WSObjectFactory wsObjectFactory = null;
    private Class c;
    private SessionContext context;

    public WLSEjbInstanceResolver(WSObjectFactory wSObjectFactory, Class clazz) {
        this.wsObjectFactory = wSObjectFactory;
        this.c = clazz;
        try {
            BaseWSLocalObject baseWSLocalObject = (BaseWSLocalObject)this.create();
            Context context = baseWSLocalObject.getBeanManager().getEnvironmentContext();
            this.context = (SessionContext)context.lookup("comp/EJBContext");
        }
        catch (NamingException namingException) {
            throw new WebServiceException((Throwable)namingException);
        }
    }

    @Override
    protected WLSInstanceResolver.Factory<BaseWSObjectIntf> getFactory() {
        return this;
    }

    @Override
    public BaseWSObjectIntf create() {
        return this.wsObjectFactory.create();
    }

    public SessionContext getContext() {
        return this.context;
    }

    @Override
    public void publishContext(WSWebServiceContext wSWebServiceContext) {
        BaseWSLocalObject baseWSLocalObject = (BaseWSLocalObject)this.create();
        Context context = baseWSLocalObject.getBeanManager().getEnvironmentContext();
        try {
            context.bind("comp/WebServiceContext", (Object)wSWebServiceContext);
        }
        catch (NameAlreadyBoundException nameAlreadyBoundException) {
        }
        catch (NamingException namingException) {
            throw new WebServiceException((Throwable)namingException);
        }
    }

    @Override
    protected boolean isJsr250Needed() {
        return false;
    }

    @Override
    @NotNull
    public Invoker createInvoker() {
        try {
            return new WLSEjbInvoker(this.c);
        }
        catch (Throwable throwable) {
            throw new WebServiceException(throwable);
        }
    }

    private static Class getParameterizedType(Class clazz) {
        ParameterizedType parameterizedType;
        Type[] typeArray;
        Type type = JAXBRIContext.getBaseType((Type)clazz, Provider.class);
        if (type != null && type instanceof ParameterizedType && (typeArray = (parameterizedType = (ParameterizedType)type).getActualTypeArguments()).length > 0 && typeArray[0] instanceof Class) {
            return (Class)typeArray[0];
        }
        return null;
    }

    static {
        try {
            providerInvokeMethod = Provider.class.getMethod("invoke", Object.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)noSuchMethodException);
        }
    }

    protected class WLSEjbInvoker
    extends WLSInstanceResolver.WLSInvoker {
        private Map<Method, Method> businessMethods;
        private Map<Method, Method> preInvokeMethods;

        WLSEjbInvoker(Class clazz) throws NoSuchMethodException, NamingException, ClassNotFoundException {
            super(WLSEjbInstanceResolver.this);
            this.businessMethods = new HashMap<Method, Method>();
            this.preInvokeMethods = new HashMap<Method, Method>();
            WebServiceProvider webServiceProvider = clazz.getAnnotation(WebServiceProvider.class);
            if (webServiceProvider != null) {
                this.webServiceProviderMapping(clazz);
            } else {
                String string;
                WebService webService = clazz.getAnnotation(WebService.class);
                Class clazz2 = null;
                if (webService != null && !StringUtil.isEmpty(string = webService.endpointInterface())) {
                    clazz2 = ClassUtil.loadClass(string);
                }
                this.webServiceMapping(clazz, clazz2);
            }
        }

        private void mappingMethods(Method method, Method method2) throws NoSuchMethodException {
            Class<?> clazz = ((BaseWSObjectIntf)WLSEjbInstanceResolver.this.resolve(null)).getClass();
            String string = MethodUtils.getWSOBusinessMethodName(method2);
            Method method3 = this.findMethod(clazz, string, method2.getParameterTypes());
            this.businessMethods.put(method, method3);
            string = MethodUtils.getWSOPreInvokeMethodName(method2);
            method3 = this.findMethod(clazz, string, WsEjb.getPreinvokeParams(method2.getParameterTypes()));
            this.preInvokeMethods.put(method, method3);
        }

        private void webServiceMapping(Class clazz, Class clazz2) throws NoSuchMethodException {
            List list = DeployUtil.getWebServiceMethods(clazz, clazz2);
            for (Method method : list) {
                Method method2 = this.findMethod(clazz, method.getName(), method.getParameterTypes());
                this.mappingMethods(method2, method);
            }
        }

        private void webServiceProviderMapping(Class clazz) throws NoSuchMethodException {
            Class clazz2 = WLSEjbInstanceResolver.getParameterizedType(clazz);
            if (clazz2 == null) {
                throw new WebServiceException(clazz.getName() + " should implmenent bounded javax.ws.xml.Provider when annotated with @WebServiceProvider");
            }
            Method method = clazz.getMethod("invoke", clazz2);
            this.mappingMethods(providerInvokeMethod, method);
        }

        private Method findMethod(Class clazz, String string, Class[] classArray) throws NoSuchMethodException {
            return clazz.getMethod(string, classArray);
        }

        Object invoke(Object object, Method method, Object ... objectArray) throws InvocationTargetException, IllegalAccessException {
            WsEjb wsEjb = null;
            try {
                wsEjb = new WsEjb(WLSEjbInstanceResolver.this.wsObjectFactory);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new AssertionError((Object)"Unable to load WsEjb");
            }
            Method method2 = this.preInvokeMethods.get(method);
            if (method2 == null) {
                throw new WebServiceException("Method [" + method + "] is not a EJB business method");
            }
            wsEjb.preInvoke(method2, null, null);
            try {
                return wsEjb.invoke(this.businessMethods.get(method), objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                if (wsEjb != null) {
                    wsEjb.postInvoke();
                }
                throw invocationTargetException;
            }
            catch (Throwable throwable) {
                if (wsEjb != null) {
                    wsEjb.postInvoke();
                }
                throw new InvocationTargetException(throwable, "Error invoking JAXWS ejb.");
            }
        }
    }
}

