/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.server.Invoker;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.api.server.WSWebServiceContext;
import com.sun.xml.ws.server.AbstractInstanceResolver;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.xml.ws.WebServiceException;
import weblogic.wsee.jaxws.MonitoringPipe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WLSInstanceResolver<T>
extends AbstractInstanceResolver<T> {
    protected static final String WEB_SERVICE_CONTEXT_BINDING = "comp/WebServiceContext";
    @NotNull
    private T singleton;

    @NotNull
    public T resolve(Packet packet) {
        return this.getSingleton();
    }

    public T getSingleton() {
        if (this.singleton == null) {
            try {
                this.singleton = this.getFactory().create();
            }
            catch (Throwable throwable) {
                throw new WebServiceException(throwable);
            }
        }
        return this.singleton;
    }

    protected abstract Factory<T> getFactory();

    protected boolean isJsr250Needed() {
        return true;
    }

    public void start(WSWebServiceContext wSWebServiceContext, WSEndpoint wSEndpoint) {
        try {
            this.getFactory().publishContext(wSWebServiceContext);
        }
        catch (Throwable throwable) {
            throw new WebServiceException(throwable);
        }
        T t = this.getSingleton();
        WLSInstanceResolver.getResourceInjector((WSEndpoint)wSEndpoint).inject(wSWebServiceContext, t);
        if (this.isJsr250Needed()) {
            WLSInstanceResolver.invokeMethod((Method)this.findAnnotatedMethod(t.getClass(), PostConstruct.class), t, (Object[])new Object[0]);
        }
    }

    public void dispose() {
        T t = this.getSingleton();
        WLSInstanceResolver.invokeMethod((Method)this.findAnnotatedMethod(t.getClass(), PreDestroy.class), t, (Object[])new Object[0]);
    }

    @NotNull
    public Invoker createInvoker() {
        return new WLSInvoker();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Factory<T> {
        public T create();

        public void publishContext(WSWebServiceContext var1);
    }

    protected class WLSInvoker
    extends Invoker {
        protected WLSInvoker() {
        }

        public final Object invoke(Packet packet, Method method, Object ... objectArray) throws InvocationTargetException, IllegalAccessException {
            this.reportInvokeBegin(packet);
            Object object = this.invoke(WLSInstanceResolver.this.resolve(packet), method, objectArray);
            this.reportInvokeEnd(packet);
            return object;
        }

        public void start(WSWebServiceContext wSWebServiceContext, WSEndpoint wSEndpoint) {
            WLSInstanceResolver.this.start(wSWebServiceContext, wSEndpoint);
        }

        public void dispose() {
            WLSInstanceResolver.this.dispose();
        }

        Object invoke(Object object, Method method, Object ... objectArray) throws IllegalAccessException, InvocationTargetException {
            return method.invoke(object, objectArray);
        }

        private void reportInvokeBegin(Packet packet) {
            MonitoringPipe.MonitoringPropertySet monitoringPropertySet = (MonitoringPipe.MonitoringPropertySet)packet.getSatellite(MonitoringPipe.MonitoringPropertySet.class);
            if (monitoringPropertySet != null) {
                monitoringPropertySet.setExecutionBegin(System.nanoTime());
            }
        }

        private void reportInvokeEnd(Packet packet) {
            MonitoringPipe.MonitoringPropertySet monitoringPropertySet = (MonitoringPipe.MonitoringPropertySet)packet.getSatellite(MonitoringPipe.MonitoringPropertySet.class);
            if (monitoringPropertySet != null) {
                monitoringPropertySet.setExecutionEnd(System.nanoTime());
            }
        }
    }
}

