/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws;

import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.server.DocumentAddressResolver;
import com.sun.xml.ws.api.server.PortAddressResolver;
import com.sun.xml.ws.api.server.SDDocument;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.transport.http.HttpAdapter;
import com.sun.xml.ws.transport.http.HttpMetadataPublisher;
import com.sun.xml.ws.transport.http.WSHTTPConnection;
import com.sun.xml.ws.transport.http.servlet.ServletAdapter;
import com.sun.xml.ws.transport.http.servlet.ServletAdapterList;
import com.sun.xml.ws.transport.http.servlet.ServletConnectionImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.Principal;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.ws.WebServiceException;
import weblogic.j2ee.ComponentRuntimeMBeanImpl;
import weblogic.j2ee.J2EEApplicationRuntimeMBeanImpl;
import weblogic.management.ManagementException;
import weblogic.management.runtime.WseeBaseRuntimeMBean;
import weblogic.management.runtime.WseePortRuntimeMBean;
import weblogic.management.runtime.WseeRuntimeMBean;
import weblogic.management.runtime.WseeV2RuntimeMBean;
import weblogic.security.SubjectUtils;
import weblogic.security.WLSPrincipals;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.ContextHandler;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.RoleManager;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.service.WebServiceResource;
import weblogic.security.spi.Resource;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.wsee.deploy.DeployInfo;
import weblogic.wsee.deploy.DeployInfoUtil;
import weblogic.wsee.jaxws.HttpServletAdapter;
import weblogic.wsee.jaxws.MonitoringStatMap;
import weblogic.wsee.jaxws.WLSContainer;
import weblogic.wsee.jaxws.WLSServletAdapterList;
import weblogic.wsee.jaxws.framework.policy.advertisementimpl.AdvertisementHelper;
import weblogic.wsee.jaxws.framework.policy.advertisementimpl.AdvertisementHelperFactory;
import weblogic.wsee.jaxws.tubeline.standard.ClientContainerUtil;
import weblogic.wsee.monitoring.WseeRuntimeMBeanManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WLSServletAdapter
extends ServletAdapter {
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private WseeBaseRuntimeMBean runtimeMBean;
    private WseePortRuntimeMBean portRuntimeMBean;
    private MonitoringStatMap statMap;

    public WLSServletAdapter(String string, String string2, WSEndpoint<?> wSEndpoint, ServletAdapterList servletAdapterList) {
        super(string, string2, wSEndpoint, servletAdapterList);
        Object object;
        DeployInfo deployInfo = (DeployInfo)wSEndpoint.getContainer().getSPI(DeployInfo.class);
        WebAppServletContext webAppServletContext = (WebAppServletContext)wSEndpoint.getContainer().getSPI(ServletContext.class);
        try {
            object = webAppServletContext.getApplicationContext();
            J2EEApplicationRuntimeMBeanImpl j2EEApplicationRuntimeMBeanImpl = object.getRuntime();
            String string3 = deployInfo == null ? null : ((DeployInfo)wSEndpoint.getContainer().getSPI(DeployInfo.class)).getModuleName();
            ComponentRuntimeMBeanImpl componentRuntimeMBeanImpl = ClientContainerUtil.getContainingComponentRuntimeByModuleName(string3);
            if (j2EEApplicationRuntimeMBeanImpl != null) {
                this.runtimeMBean = WseeRuntimeMBeanManager.createJaxWsMBean(wSEndpoint, j2EEApplicationRuntimeMBeanImpl, componentRuntimeMBeanImpl, deployInfo != null ? deployInfo.getApplication() : object.getApplicationId(), deployInfo != null ? deployInfo.getWebserviceDescriptionName() : wSEndpoint.getServiceName().getLocalPart(), webAppServletContext.getContextPath(), string2, deployInfo != null ? deployInfo.getWssPolicyContext() : null);
                if (wSEndpoint instanceof WLSContainer.WLSEndpointFactory.WLSEndpointImpl) {
                    ((WLSContainer.WLSEndpointFactory.WLSEndpointImpl)wSEndpoint).setWseeRuntimeMBean(this.runtimeMBean);
                }
                for (WseePortRuntimeMBean wseePortRuntimeMBean : this.runtimeMBean.getPorts()) {
                    if (!wseePortRuntimeMBean.getPortName().equals(wSEndpoint.getPortName().getLocalPart())) continue;
                    this.portRuntimeMBean = wseePortRuntimeMBean;
                }
                this.statMap = new MonitoringStatMap(this.runtimeMBean, wSEndpoint);
            }
        }
        catch (ManagementException managementException) {
            throw new WebServiceException((Throwable)managementException);
        }
        object = AdvertisementHelperFactory.getAdvertisementHelper();
        if (object != null && this.endpoint.getServiceDefinition() != null && object.hasPolicyAdvertisementFilter()) {
            this.wsdls.put("orawsdl", this.wsdls.get("wsdl"));
            this.wsdls.put("ORAWSDL", this.wsdls.get("WSDL"));
        }
    }

    public DocumentAddressResolver getDocumentAddressResolver(PortAddressResolver portAddressResolver) {
        if (portAddressResolver instanceof WLSServletAdapterList.WLSPortAddressResolver) {
            portAddressResolver = ((WLSServletAdapterList.WLSPortAddressResolver)portAddressResolver).getDocumentPortAddressResolver();
        }
        return super.getDocumentAddressResolver(portAddressResolver);
    }

    protected WSHTTPConnection createConnection(ServletContext servletContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return new WLSServletConnection(this, servletContext, httpServletRequest, httpServletResponse);
    }

    public String getServiceUri() {
        return this.urlPattern;
    }

    public <T> T getSPI(Class<T> clazz) {
        if (clazz == MonitoringStatMap.class) {
            return clazz.cast(this.statMap);
        }
        if (clazz == WseePortRuntimeMBean.class) {
            return clazz.cast(this.portRuntimeMBean);
        }
        if (clazz == WseeRuntimeMBean.class) {
            return clazz.cast(this.runtimeMBean);
        }
        if (clazz == WseeV2RuntimeMBean.class) {
            return clazz.cast(this.runtimeMBean);
        }
        return null;
    }

    public void handle(ServletContext servletContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        if (httpServletRequest.getMethod().equals("GET") || httpServletRequest.getMethod().equals("HEAD")) {
            HttpMetadataPublisher httpMetadataPublisher = (HttpMetadataPublisher)this.endpoint.getSPI(HttpMetadataPublisher.class);
            if (httpMetadataPublisher != null && httpMetadataPublisher.handleMetadataRequest((HttpAdapter)this, this.createConnection(servletContext, httpServletRequest, httpServletResponse))) {
                return;
            }
            if (this.isOraWsdlMetadataQuery(httpServletRequest.getQueryString())) {
                this.publishWSDL(this.createConnection(servletContext, httpServletRequest, httpServletResponse));
                return;
            }
        }
        super.handle(servletContext, httpServletRequest, httpServletResponse);
    }

    public void publishWSDL(WSHTTPConnection wSHTTPConnection) throws IOException {
        DocumentAddressResolver documentAddressResolver;
        PortAddressResolver portAddressResolver;
        boolean bl;
        SDDocument sDDocument;
        DeployInfo deployInfo = (DeployInfo)this.endpoint.getContainer().getSPI(DeployInfo.class);
        if (deployInfo != null && !DeployInfoUtil.exposeWsdl(deployInfo) || this.getEndpoint().getServiceDefinition() == null) {
            wSHTTPConnection.setStatus(404);
            wSHTTPConnection.getOutput();
            return;
        }
        AdvertisementHelper advertisementHelper = AdvertisementHelperFactory.getAdvertisementHelper();
        if (advertisementHelper != null && (sDDocument = (SDDocument)this.wsdls.get(WLSServletAdapter.getRequestCmd(wSHTTPConnection.getQueryString()))) == this.getEndpoint().getServiceDefinition().getPrimary() && (bl = advertisementHelper.handleAdvertisementRequest(sDDocument, this.endpoint, wSHTTPConnection, portAddressResolver = this.getPortAddressResolver(wSHTTPConnection.getBaseAddress()), documentAddressResolver = this.getDocumentAddressResolver(portAddressResolver)))) {
            return;
        }
        super.publishWSDL(wSHTTPConnection);
    }

    public static String getRequestCmd(String string) {
        String[] stringArray = string.split("&");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            int n = string2.indexOf(61);
            if (n > -1) {
                string2 = string2.substring(0, n);
            }
            if (!"WSDL".equalsIgnoreCase(string2) && !"ORAWSDL".equalsIgnoreCase(string2)) continue;
            return stringArray[i];
        }
        return null;
    }

    private boolean isOraWsdlMetadataQuery(String string) {
        if (string != null) {
            String[] stringArray = string.split("&");
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                int n = string2.indexOf(61);
                if (n > -1) {
                    string2 = string2.substring(0, n);
                }
                if (!"WSDL".equalsIgnoreCase(string2) && !"ORAWSDL".equalsIgnoreCase(string2)) continue;
                return true;
            }
        }
        return false;
    }

    public class WLSServletConnection
    extends ServletConnectionImpl {
        public WLSServletConnection(WLSServletAdapter wLSServletAdapter2, ServletContext servletContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
            super((ServletAdapter)wLSServletAdapter2, servletContext, httpServletRequest, httpServletResponse);
        }

        public boolean isUserInRole(Packet packet, String string) {
            if (super.isUserInRole(packet, string)) {
                return true;
            }
            RoleManager roleManager = SecurityServiceManager.getRoleManager((AuthenticatedSubject)KERNEL_ID, (String)SecurityServiceManager.getDefaultRealmName());
            WebServiceResource webServiceResource = (WebServiceResource)packet.invocationProperties.get("weblogic.wsee.jaxws.security.resource");
            if (webServiceResource != null) {
                Map map = roleManager.getRoles((AuthenticatedSubject)packet.invocationProperties.get("weblogic.wsee.jaxws.security.subject"), (Resource)webServiceResource, (ContextHandler)packet.invocationProperties.get("weblogic.wsee.jaxws.security.contexthandler"));
                return map.containsKey(string);
            }
            return false;
        }

        public Principal getUserPrincipal(Packet packet) {
            Principal principal = null;
            AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)KERNEL_ID);
            if (authenticatedSubject != null) {
                principal = SubjectUtils.getUserPrincipal((AuthenticatedSubject)authenticatedSubject);
            }
            return principal == null ? WLSPrincipals.getAnonymousUserPrincipal() : principal;
        }

        public OutputStream getOutput() throws IOException {
            OutputStream outputStream = super.getOutput();
            if (this.isEndpointProcessingComplete()) {
                ((HttpServletAdapter.EndpointProcessingComplete)((Object)outputStream)).onEndpointProcessingComplete();
            }
            return outputStream;
        }
    }
}

