/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws;

import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.WSService;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.client.ServiceCreationInterceptor;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.PartialForwardTube;
import com.sun.xml.ws.api.pipe.ResponseOnlyTube;
import com.sun.xml.ws.api.pipe.ServerTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.Stubs;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.TubelineAssembler;
import com.sun.xml.ws.api.pipe.TubelineAssemblerFactory;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.binding.WebServiceFeatureList;
import com.sun.xml.ws.client.Stub;
import com.sun.xml.ws.server.EndpointFactory;
import com.sun.xml.ws.util.ServiceFinder;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Holder;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import weblogic.jws.jaxws.client.async.AsyncClientTransportFeature;
import weblogic.wsee.jaxws.EndpointCreationInterceptor;
import weblogic.wsee.jaxws.EndpointCreationInterceptorFeature;
import weblogic.wsee.jaxws.InvokerOnlyFeature;
import weblogic.wsee.jaxws.ServiceCreationInterceptorFeature;
import weblogic.wsee.jaxws.TransportOnlyFeature;
import weblogic.wsee.jaxws.client.async.AsyncClientTransportReconnectTube;
import weblogic.wsee.jaxws.framework.jaxrpc.EnvironmentFactory;
import weblogic.wsee.jaxws.framework.jaxrpc.JAXRPCEnvironmentFeature;
import weblogic.wsee.jaxws.tubeline.FlowControlAware;
import weblogic.wsee.jaxws.tubeline.FlowControlTube;
import weblogic.wsee.jaxws.tubeline.Ordering;
import weblogic.wsee.jaxws.tubeline.TubeFactory;
import weblogic.wsee.jaxws.tubeline.TubelineAssemblerItem;
import weblogic.wsee.jaxws.tubeline.TubelineDeploymentListener;
import weblogic.wsee.jaxws.tubeline.TubelineDeploymentListenerRepository;
import weblogic.wsee.jaxws.tubeline.TubelineSpliceFactory;
import weblogic.wsee.jaxws.tubeline.TubelineSpliceMarkerTube;
import weblogic.wsee.policy.checker.PolicyLevelChecker;
import weblogic.wsee.util.Pair;

public class WLSTubelineAssemblerFactory
extends TubelineAssemblerFactory {
    private static final Logger LOGGER = Logger.getLogger(WLSTubelineAssemblerFactory.class.getName());

    public TubelineAssembler doCreate(BindingID bindingID) {
        return new TubelineAssemblerImpl();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TubelineAssemblerImpl
    implements TubelineAssembler {
        private TubelineAssemblerImpl() {
        }

        public Tube createClient(ClientTubeAssemblerContext clientTubeAssemblerContext) {
            Object object3;
            LOGGER.fine("Creating client tubeline for " + clientTubeAssemblerContext.getService().getServiceName());
            Object object2 = clientTubeAssemblerContext.createTransportTube();
            if (object2 instanceof ServiceCreationInterceptor) {
                ServiceCreationInterceptorFeature serviceCreationInterceptorFeature = (ServiceCreationInterceptorFeature)clientTubeAssemblerContext.getBinding().getFeature(ServiceCreationInterceptorFeature.class);
                if (serviceCreationInterceptorFeature == null) {
                    serviceCreationInterceptorFeature = new ServiceCreationInterceptorFeature();
                    ((WebServiceFeatureList)clientTubeAssemblerContext.getBinding().getFeatures()).add((WebServiceFeature)serviceCreationInterceptorFeature);
                }
                serviceCreationInterceptorFeature.getInterceptors().add(new WeakReference<ServiceCreationInterceptor>((ServiceCreationInterceptor)object2));
            }
            boolean bl = false;
            if (object2 instanceof FlowControlAware) {
                bl = ((FlowControlAware)object2).isFlowControlRequired();
            }
            if (clientTubeAssemblerContext.getBinding().getFeature(TransportOnlyFeature.class) != null) {
                return bl ? new FlowControlTube((Tube)object2) : object2;
            }
            LinkedHashSet<TubelineAssemblerItem> linkedHashSet = new LinkedHashSet<TubelineAssemblerItem>();
            ServiceFinder serviceFinder = null;
            TubelineDeploymentListenerRepository tubelineDeploymentListenerRepository = (TubelineDeploymentListenerRepository)clientTubeAssemblerContext.getService().getSPI(TubelineDeploymentListenerRepository.class);
            if (tubelineDeploymentListenerRepository != null) {
                serviceFinder = tubelineDeploymentListenerRepository.getListeners();
            }
            if (serviceFinder == null) {
                serviceFinder = ServiceFinder.find(TubelineDeploymentListener.class, (ClassLoader)clientTubeAssemblerContext.getService().getClass().getClassLoader());
            }
            for (Object object3 : serviceFinder) {
                object3.createClient(clientTubeAssemblerContext, linkedHashSet);
            }
            AsyncClientTransportFeature asyncClientTransportFeature = (AsyncClientTransportFeature)clientTubeAssemblerContext.getBinding().getFeature(AsyncClientTransportFeature.class);
            if (asyncClientTransportFeature != null) {
                object2 = new AsyncClientTransportReconnectTube(asyncClientTransportFeature, clientTubeAssemblerContext, (Tube)object2);
            }
            object3 = this.prepareTubelineAssemblerItems(linkedHashSet);
            Holder holder = null;
            Iterator<TubelineAssemblerItem> iterator = ((Ordering)object3).iterator();
            while (iterator.hasNext()) {
                Tube tube;
                TubelineAssemblerItem tubelineAssemblerItem = iterator.next();
                LOGGER.finer("Calling tubeline assembler item: " + tubelineAssemblerItem.getName());
                TubeFactory tubeFactory = tubelineAssemblerItem.getFactory();
                if (tubeFactory instanceof TubelineSpliceFactory) {
                    if (holder != null) {
                        holder.value = TubeCloner.clone((Tube)((Tube)holder.value));
                    }
                    holder = new Holder(object2);
                    ((TubelineSpliceFactory)tubeFactory).createSplice(new MyClientDispatchFactory(clientTubeAssemblerContext, (Holder<Tube>)holder, TubeCloner.clone((Tube)object2)), clientTubeAssemblerContext);
                    object2 = new TubelineSpliceMarkerTube((Tube)object2);
                }
                if ((tube = tubeFactory.createClient((Tube)object2, clientTubeAssemblerContext)) == null) continue;
                object2 = tube;
                if (!bl && object2 instanceof FlowControlAware) {
                    bl = ((FlowControlAware)object2).isFlowControlRequired();
                }
                if (object2 instanceof ServiceCreationInterceptor) {
                    ServiceCreationInterceptorFeature serviceCreationInterceptorFeature = (ServiceCreationInterceptorFeature)clientTubeAssemblerContext.getBinding().getFeature(ServiceCreationInterceptorFeature.class);
                    if (serviceCreationInterceptorFeature == null) {
                        serviceCreationInterceptorFeature = new ServiceCreationInterceptorFeature();
                        ((WebServiceFeatureList)clientTubeAssemblerContext.getBinding().getFeatures()).add((WebServiceFeature)serviceCreationInterceptorFeature);
                    }
                    serviceCreationInterceptorFeature.getInterceptors().add(new WeakReference<ServiceCreationInterceptor>((ServiceCreationInterceptor)object2));
                }
                if (holder == null) continue;
                holder.value = bl ? new FlowControlTube((Tube)object2) : object2;
            }
            return bl ? new FlowControlTube((Tube)object2) : object2;
        }

        public Tube createServer(ServerTubeAssemblerContext serverTubeAssemblerContext) {
            EndpointFactory endpointFactory;
            Object object3;
            LOGGER.fine("Creating server tubeline for " + serverTubeAssemblerContext.getEndpoint().getServiceName());
            this.doPolicyCheck(serverTubeAssemblerContext);
            Object object2 = serverTubeAssemblerContext.getTerminalTube();
            if (object2 instanceof EndpointCreationInterceptor) {
                EndpointCreationInterceptorFeature endpointCreationInterceptorFeature = (EndpointCreationInterceptorFeature)serverTubeAssemblerContext.getEndpoint().getBinding().getFeature(EndpointCreationInterceptorFeature.class);
                if (endpointCreationInterceptorFeature == null) {
                    endpointCreationInterceptorFeature = new EndpointCreationInterceptorFeature();
                    ((WebServiceFeatureList)serverTubeAssemblerContext.getEndpoint().getBinding().getFeatures()).add((WebServiceFeature)endpointCreationInterceptorFeature);
                }
                endpointCreationInterceptorFeature.getInterceptors().add(new WeakReference<EndpointCreationInterceptor>((EndpointCreationInterceptor)object2));
            }
            boolean bl = false;
            if (object2 instanceof FlowControlAware) {
                bl = ((FlowControlAware)object2).isFlowControlRequired();
            }
            if (serverTubeAssemblerContext.getEndpoint().getBinding().getFeature(InvokerOnlyFeature.class) != null) {
                return bl ? new FlowControlTube((Tube)object2) : object2;
            }
            LinkedHashSet<TubelineAssemblerItem> linkedHashSet = new LinkedHashSet<TubelineAssemblerItem>();
            ServiceFinder serviceFinder = null;
            TubelineDeploymentListenerRepository tubelineDeploymentListenerRepository = (TubelineDeploymentListenerRepository)serverTubeAssemblerContext.getEndpoint().getSPI(TubelineDeploymentListenerRepository.class);
            if (tubelineDeploymentListenerRepository != null) {
                serviceFinder = tubelineDeploymentListenerRepository.getListeners();
            }
            if (serviceFinder == null) {
                serviceFinder = ServiceFinder.find(TubelineDeploymentListener.class, (ClassLoader)serverTubeAssemblerContext.getEndpoint().getImplementationClass().getClassLoader());
            }
            for (Object object3 : serviceFinder) {
                object3.createServer(serverTubeAssemblerContext, linkedHashSet);
            }
            Ordering ordering = this.prepareTubelineAssemblerItems(linkedHashSet);
            object3 = null;
            Container container = serverTubeAssemblerContext.getEndpoint().getContainer();
            EndpointFactory endpointFactory2 = endpointFactory = container != null ? (EndpointFactory)container.getSPI(EndpointFactory.class) : null;
            if (endpointFactory == null) {
                endpointFactory = EndpointFactory.getInstance();
            }
            Iterator<TubelineAssemblerItem> iterator = ordering.iterator();
            while (iterator.hasNext()) {
                Tube tube;
                TubelineAssemblerItem tubelineAssemblerItem = iterator.next();
                LOGGER.finer("Calling tubeline assembler item: " + tubelineAssemblerItem.getName());
                TubeFactory tubeFactory = tubelineAssemblerItem.getFactory();
                if (tubeFactory instanceof TubelineSpliceFactory) {
                    if (object3 != null) {
                        ((Holder)((Pair)object3).getRight()).value = endpointFactory.createSpliceEndpoint(serverTubeAssemblerContext.getEndpoint(), serverTubeAssemblerContext.getSEIModel(), TubeCloner.clone((Tube)(bl ? new FlowControlTube((Tube)object2) : object2)), TubeCloner.clone((Tube)((Tube)((Pair)object3).getLeft())));
                    }
                    object3 = new Pair<Tube, Holder>((Tube)object2, new Holder());
                    tube = (Holder)((Pair)object3).getRight();
                    ((TubelineSpliceFactory)tubeFactory).createSplice(new TubelineSpliceFactory.DispatchFactory((Holder)tube){
                        final /* synthetic */ Holder val$s;
                        {
                            this.val$s = holder;
                        }

                        @Override
                        public <T> Dispatch<T> createDispatch(Class<T> clazz, Service.Mode mode) {
                            return ((WSEndpoint)this.val$s.value).createDispatch(clazz, mode);
                        }

                        @Override
                        public <T> Dispatch<T> createResponseDispatch(WSEndpointReference wSEndpointReference, Class<T> clazz, Service.Mode mode) {
                            return ((WSEndpoint)this.val$s.value).createResponseDispatch(clazz, mode, wSEndpointReference);
                        }
                    }, serverTubeAssemblerContext);
                    object2 = new TubelineSpliceMarkerTube((Tube)object2);
                }
                if ((tube = tubeFactory.createServer((Tube)object2, serverTubeAssemblerContext)) == null) continue;
                object2 = tube;
                if (!bl && object2 instanceof FlowControlAware) {
                    bl = ((FlowControlAware)object2).isFlowControlRequired();
                }
                if (!(object2 instanceof EndpointCreationInterceptor)) continue;
                EndpointCreationInterceptorFeature endpointCreationInterceptorFeature = (EndpointCreationInterceptorFeature)serverTubeAssemblerContext.getEndpoint().getBinding().getFeature(EndpointCreationInterceptorFeature.class);
                if (endpointCreationInterceptorFeature == null) {
                    endpointCreationInterceptorFeature = new EndpointCreationInterceptorFeature();
                    ((WebServiceFeatureList)serverTubeAssemblerContext.getEndpoint().getBinding().getFeatures()).add((WebServiceFeature)endpointCreationInterceptorFeature);
                }
                endpointCreationInterceptorFeature.getInterceptors().add(new WeakReference<EndpointCreationInterceptor>((EndpointCreationInterceptor)object2));
            }
            if (object3 != null) {
                ((Holder)((Pair)object3).getRight()).value = endpointFactory.createSpliceEndpoint(serverTubeAssemblerContext.getEndpoint(), serverTubeAssemblerContext.getSEIModel(), TubeCloner.clone((Tube)(bl ? new FlowControlTube((Tube)object2) : object2)), TubeCloner.clone((Tube)((Tube)((Pair)object3).getLeft())));
            }
            return bl ? new FlowControlTube((Tube)object2) : object2;
        }

        private Ordering prepareTubelineAssemblerItems(Set<TubelineAssemblerItem> set) {
            for (TubelineAssemblerItem tubelineAssemblerItem : set) {
                if (tubelineAssemblerItem.getRequired() == null) continue;
                for (String string : tubelineAssemblerItem.getRequired()) {
                    boolean bl = false;
                    for (TubelineAssemblerItem tubelineAssemblerItem2 : set) {
                        if (!string.equals(tubelineAssemblerItem2.getName())) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    throw new WebServiceException("TubelineAssemberItem " + tubelineAssemblerItem.getName() + " requires support for " + string + ", which is not configured");
                }
            }
            return new Ordering(set);
        }

        public void doPolicyCheck(ServerTubeAssemblerContext serverTubeAssemblerContext) throws WebServiceException {
            EnvironmentFactory environmentFactory = JAXRPCEnvironmentFeature.getFactory(serverTubeAssemblerContext.getEndpoint());
            if (environmentFactory == null) {
                return;
            }
            WSDLPort wSDLPort = environmentFactory.getPort();
            if (wSDLPort == null) {
                return;
            }
            EnvironmentFactory.SingletonService singletonService = environmentFactory.getService();
            if (singletonService == null) {
                return;
            }
            QName qName = wSDLPort.getName();
            PolicyLevelChecker policyLevelChecker = new PolicyLevelChecker(singletonService, qName);
            policyLevelChecker.doJAXWSDefaultCheck();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class MyClientDispatchFactory
        implements TubelineSpliceFactory.ClientDispatchFactory {
            private final ClientTubeAssemblerContext context;
            private final Holder<Tube> preSpliceHeadHolder;
            private final Tube tube;

            public MyClientDispatchFactory(ClientTubeAssemblerContext clientTubeAssemblerContext, Holder<Tube> holder, Tube tube) {
                this.context = clientTubeAssemblerContext;
                this.preSpliceHeadHolder = holder;
                this.tube = tube;
            }

            @Override
            public <T> Dispatch<T> createDispatch(Class<T> clazz, Service.Mode mode) {
                return this.createDispatch(null, clazz, mode);
            }

            public <T> Dispatch<T> createPostSpliceDispatch(Class<T> clazz, Service.Mode mode) {
                return this.createPostSpliceDispatch(null, clazz, mode);
            }

            @Override
            public <T> Dispatch<T> createResponseDispatch(WSEndpointReference wSEndpointReference, Class<T> clazz, Service.Mode mode) {
                WSDLPort wSDLPort = this.context.getWsdlModel();
                ResponseOnlyTube responseOnlyTube = new ResponseOnlyTube((Tube)this.preSpliceHeadHolder.value, this.tube, false, true);
                Dispatch dispatch = Stubs.createDispatch((QName)(wSDLPort != null ? wSDLPort.getName() : null), (WSService)this.context.getService(), (WSBinding)this.context.getBinding(), clazz, (Service.Mode)mode, (Tube)responseOnlyTube, (WSEndpointReference)wSEndpointReference);
                ((Stub)dispatch).setServerResponse(true);
                return dispatch;
            }

            @Override
            public <T> Dispatch<T> createDispatch(WSEndpointReference wSEndpointReference, Class<T> clazz, Service.Mode mode) {
                WSDLPort wSDLPort = this.context.getWsdlModel();
                return Stubs.createDispatch((QName)(wSDLPort != null ? wSDLPort.getName() : null), (WSService)this.context.getService(), (WSBinding)this.context.getBinding(), clazz, (Service.Mode)mode, (Tube)new PartialForwardTube((Tube)this.preSpliceHeadHolder.value, this.tube), (WSEndpointReference)wSEndpointReference);
            }

            @Override
            public <T> Dispatch<T> createPostSpliceDispatch(WSEndpointReference wSEndpointReference, Class<T> clazz, Service.Mode mode) {
                WSDLPort wSDLPort = this.context.getWsdlModel();
                Dispatch dispatch = Stubs.createDispatch((QName)(wSDLPort != null ? wSDLPort.getName() : null), (WSService)this.context.getService(), (WSBinding)this.context.getBinding(), clazz, (Service.Mode)mode, (Tube)TubeCloner.clone((Tube)this.tube), (WSEndpointReference)wSEndpointReference);
                ((Stub)dispatch).setServerResponse(true);
                return dispatch;
            }
        }
    }
}

