/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.buffer;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.ServerTubeAssemblerContext;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import weblogic.j2ee.descriptor.wl.BufferingConfigBean;
import weblogic.j2ee.descriptor.wl.BufferingQueueBean;
import weblogic.j2ee.descriptor.wl.PortComponentBean;
import weblogic.management.configuration.WebServiceBufferingMBean;
import weblogic.management.configuration.WebServiceBufferingQueueMBean;
import weblogic.management.configuration.WebServiceLogicalStoreMBean;
import weblogic.management.configuration.WebServiceMBean;
import weblogic.wsee.config.WebServiceMBeanFactory;
import weblogic.wsee.jaxws.config.PerServicePropertyAccessor;
import weblogic.wsee.jaxws.config.Property;
import weblogic.wsee.jaxws.config.PropertyContainer;
import weblogic.wsee.jaxws.config.VmWidePropertyAccessor;
import weblogic.wsee.jaxws.framework.ConfigUtil;
import weblogic.wsee.jaxws.persistence.PersistenceConfig;

public class BufferingConfig {
    public static Service getServiceConfig(@Nullable ServerTubeAssemblerContext serverTubeAssemblerContext) {
        return BufferingConfig.getServiceConfig(serverTubeAssemblerContext, null);
    }

    public static Service getServiceConfig(@Nullable ServerTubeAssemblerContext serverTubeAssemblerContext, @Nullable Packet packet) {
        Service service2 = new Service(serverTubeAssemblerContext, packet);
        return service2;
    }

    public static Service getServiceConfig(@Nullable ClientTubeAssemblerContext clientTubeAssemblerContext) {
        return BufferingConfig.getServiceConfig(clientTubeAssemblerContext, null);
    }

    public static Service getServiceConfig(@Nullable ClientTubeAssemblerContext clientTubeAssemblerContext, @Nullable Packet packet) {
        Service service2 = new Service(clientTubeAssemblerContext, packet);
        return service2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Queue
    extends PropertyContainer
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private transient Property<Boolean> _enabled;
        private transient Property<String> _jndiName;
        private transient Property<String> _connectionFactoryJndiName;
        private transient Property<Boolean> _transactionEnabled;

        @Override
        protected List<Property> getPropertyFields() {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(this._enabled);
            arrayList.add(this._jndiName);
            arrayList.add(this._connectionFactoryJndiName);
            arrayList.add(this._transactionEnabled);
            return arrayList;
        }

        public Queue(@NotNull WebServiceLogicalStoreMBean webServiceLogicalStoreMBean, @NotNull String string, @Nullable BufferingQueueBean bufferingQueueBean, @NotNull WebServiceBufferingQueueMBean webServiceBufferingQueueMBean) {
            this._enabled = new Property<Boolean>("Enabled", Boolean.class, false, new PerServicePropertyAccessor(bufferingQueueBean), new VmWidePropertyAccessor(null, (Object)webServiceBufferingQueueMBean));
            this._jndiName = new Property<Object>(string, String.class, null, new VmWidePropertyAccessor(webServiceLogicalStoreMBean));
            this._connectionFactoryJndiName = new Property<Object>("ConnectionFactoryJndiName", String.class, null, new PerServicePropertyAccessor(bufferingQueueBean), new VmWidePropertyAccessor(webServiceBufferingQueueMBean));
            this._transactionEnabled = new Property<Boolean>("TransactionEnabled", Boolean.class, false, new PerServicePropertyAccessor(bufferingQueueBean), new VmWidePropertyAccessor(webServiceBufferingQueueMBean));
        }

        public boolean isEnabled() {
            return this._enabled.getValue();
        }

        public String getJndiName() {
            return this._jndiName.getValue();
        }

        public String getConnectionFactoryJndiName() {
            return this._connectionFactoryJndiName.getValue();
        }

        public boolean isTransactionEnabled() {
            return this._transactionEnabled.getValue();
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        }
    }

    public static abstract class Common
    extends PropertyContainer {
        protected WebServiceMBean _wsMBean = WebServiceMBeanFactory.getInstance();
        protected PersistenceConfig.Common _persistConfig;

        public Common(@Nullable ServerTubeAssemblerContext serverTubeAssemblerContext) {
            this._persistConfig = PersistenceConfig.getServiceConfig(serverTubeAssemblerContext);
        }

        public Common(@Nullable ClientTubeAssemblerContext clientTubeAssemblerContext) {
            this._persistConfig = PersistenceConfig.getClientConfig(clientTubeAssemblerContext);
        }

        public PersistenceConfig.Common getPersistenceConfig() {
            return this._persistConfig;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Service
    extends Common {
        private Queue _requestQueue;
        private Queue _responseQueue;
        private Property<Integer> _retryCount;
        private Property<String> _retryDelay;

        @Override
        protected List<Property> getPropertyFields() {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(this._retryCount);
            arrayList.add(this._retryDelay);
            return arrayList;
        }

        public Service(@Nullable ServerTubeAssemblerContext serverTubeAssemblerContext, @Nullable Packet packet) {
            super(serverTubeAssemblerContext);
            PortComponentBean portComponentBean = null;
            if (serverTubeAssemblerContext != null) {
                portComponentBean = ConfigUtil.getPortComponentBeanForService(serverTubeAssemblerContext);
            }
            BufferingConfigBean bufferingConfigBean = portComponentBean != null ? portComponentBean.getBufferingConfig() : null;
            this.commonConstructorCode(bufferingConfigBean, packet);
        }

        public Service(@Nullable ClientTubeAssemblerContext clientTubeAssemblerContext, @Nullable Packet packet) {
            super(clientTubeAssemblerContext);
            this.commonConstructorCode(null, packet);
        }

        private void commonConstructorCode(@Nullable BufferingConfigBean bufferingConfigBean, @Nullable Packet packet) {
            if (bufferingConfigBean != null && !bufferingConfigBean.isCustomized()) {
                bufferingConfigBean = null;
            }
            WebServiceMBean webServiceMBean = WebServiceMBeanFactory.getInstance();
            WebServiceBufferingMBean webServiceBufferingMBean = webServiceMBean.getWebServiceBuffering();
            WebServiceLogicalStoreMBean webServiceLogicalStoreMBean = ConfigUtil.getLogicalStoreMBean(this._persistConfig.getLogicalStoreName());
            this._requestQueue = new Queue(webServiceLogicalStoreMBean, "RequestBufferingQueueJndiName", bufferingConfigBean != null ? bufferingConfigBean.getRequestQueue() : null, webServiceBufferingMBean.getWebServiceRequestBufferingQueue());
            this._responseQueue = new Queue(webServiceLogicalStoreMBean, "ResponseBufferingQueueJndiName", bufferingConfigBean != null ? bufferingConfigBean.getResponseQueue() : null, webServiceBufferingMBean.getWebServiceResponseBufferingQueue());
            this._retryCount = new Property<Integer>("RetryCount", Integer.class, 3, new PerServicePropertyAccessor(bufferingConfigBean), new VmWidePropertyAccessor(null, (Object)webServiceBufferingMBean));
            this._retryDelay = new Property<String>("RetryDelay", String.class, "P0DT30S", new PerServicePropertyAccessor(bufferingConfigBean), new VmWidePropertyAccessor(null, (Object)webServiceBufferingMBean));
        }

        public Queue getRequestQueue() {
            return this._requestQueue;
        }

        public Queue getResponseQueue() {
            return this._responseQueue;
        }

        public int getRetryCount() {
            return this._retryCount.getValue();
        }

        public String getRetryDelay() {
            return this._retryDelay.getValue();
        }
    }
}

