/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.client.async;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.api.pipe.helper.AbstractTubeImpl;
import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.jws.jaxws.client.async.AsyncClientHandlerFeature;
import weblogic.jws.jaxws.client.async.AsyncClientTransportFeature;
import weblogic.jws.jaxws.client.async.FiberBox;
import weblogic.wsee.jaxws.client.async.AsyncClientHandlerMarkerFeature;
import weblogic.wsee.jaxws.client.async.AsyncClientPropertyBag;
import weblogic.wsee.jaxws.persistence.PersistenceConfig;
import weblogic.wsee.jaxws.persistence.PersistentContext;
import weblogic.wsee.jaxws.persistence.PersistentMessageFactory;

public class AsyncClientTransportReconnectTube
extends AbstractFilterTubeImpl {
    private static final Logger LOGGER = Logger.getLogger(AsyncClientTransportReconnectTube.class.getName());
    private AsyncClientTransportFeature actf;
    private boolean usingAsyncClientHandlerFeature;
    private ClientTubeAssemblerContext context;
    private WSBinding binding;
    private FiberBox fiberBox;

    public AsyncClientTransportReconnectTube(AsyncClientTransportFeature asyncClientTransportFeature, ClientTubeAssemblerContext clientTubeAssemblerContext, Tube tube) {
        super(tube);
        this.actf = asyncClientTransportFeature;
        this.context = clientTubeAssemblerContext;
        this.binding = clientTubeAssemblerContext.getBinding();
        this.usingAsyncClientHandlerFeature = this.binding.getFeature(AsyncClientHandlerFeature.class) != null || this.binding.getFeature(AsyncClientHandlerMarkerFeature.class) != null;
    }

    protected AsyncClientTransportReconnectTube(AsyncClientTransportReconnectTube asyncClientTransportReconnectTube, TubeCloner tubeCloner) {
        super((AbstractFilterTubeImpl)asyncClientTransportReconnectTube, tubeCloner);
        this.actf = asyncClientTransportReconnectTube.actf;
        this.binding = asyncClientTransportReconnectTube.binding;
        this.usingAsyncClientHandlerFeature = asyncClientTransportReconnectTube.usingAsyncClientHandlerFeature;
    }

    public AbstractTubeImpl copy(TubeCloner tubeCloner) {
        return new AsyncClientTransportReconnectTube(this, tubeCloner);
    }

    @NotNull
    public NextAction processRequest(Packet packet) {
        boolean bl;
        String string;
        if (packet == null) {
            return super.processRequest(packet);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            string = null;
            if (this.binding.getAddressingVersion() != null) {
                string = packet.getMessage().getHeaders().getMessageID(this.binding.getAddressingVersion(), this.binding.getSOAPVersion());
            }
            LOGGER.fine("AsyncClientTransportReconnectTube.processRequest clearing fiberBox " + this.fiberBox + " before processing request with msgId " + string);
        }
        this.fiberBox = null;
        if (Boolean.TRUE.equals(packet.isSynchronousMEP) && !this.actf.isUseAsyncWithSyncInvoke()) {
            return this.doInvoke(this.next, packet);
        }
        string = packet.getMessage().getID(this.binding.getAddressingVersion(), this.binding.getSOAPVersion());
        if (!Boolean.TRUE.equals(packet.expectReply)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Request msg: " + string + " was flagged expectReply=false. We won't suspend any fiber or save any request context for this request");
            }
            return this.doInvoke(this.next, packet);
        }
        boolean bl2 = Boolean.TRUE.equals(packet.invocationProperties.get("weblogic.wsee.jaxws.client.async.SendErrorOnlyAsyncHandler"));
        boolean bl3 = bl = !this.usingAsyncClientHandlerFeature || Boolean.TRUE.equals(packet.nonNullAsyncHandlerGiven) && !bl2;
        if (bl) {
            this.fiberBox = new FiberBox(Fiber.current());
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("For message ID '" + string + "' storing fiber '" + Fiber.current().toString() + "' and tube " + (Object)((Object)this) + " in FiberBox " + this.fiberBox + " for later resumption (assumes this fiber will be suspended after the request is sent)");
            }
            this.actf.register(string, this.fiberBox);
            return this.doInvoke(this.next, packet);
        }
        PersistentContext persistentContext = PersistentMessageFactory.getInstance().createContextFromPacket(string, packet);
        PersistenceConfig.Client client = PersistenceConfig.getClientConfig(this.context);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Storing persistent context for async request msg: " + string + " into logical store: " + client.getLogicalStoreName());
        }
        PersistentContext.getStoreMap(client.getLogicalStoreName()).put(string, persistentContext);
        AsyncClientPropertyBag asyncClientPropertyBag = AsyncClientPropertyBag.propertySetRetriever.getFromPacket(packet);
        asyncClientPropertyBag.setRequestMessageID(string);
        return this.doInvoke(this.next, packet);
    }

    @NotNull
    public NextAction processResponse(Packet packet) {
        if (packet.getMessage() != null) {
            Object object;
            if (LOGGER.isLoggable(Level.FINE)) {
                object = null;
                if (this.binding.getAddressingVersion() != null) {
                    object = packet.getMessage().getHeaders().getMessageID(this.binding.getAddressingVersion(), this.binding.getSOAPVersion());
                }
                LOGGER.fine("AsyncClientTransportReconnectTube.processResponse for fiber " + Fiber.current() + " and tube " + (Object)((Object)this) + " found non-empty message. Returning with response packet msgId: " + (String)object);
            }
            if (this.fiberBox != null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    object = null;
                    if (this.binding.getAddressingVersion() != null) {
                        object = packet.getMessage().getHeaders().getMessageID(this.binding.getAddressingVersion(), this.binding.getSOAPVersion());
                    }
                    LOGGER.fine("AsyncClientTransportReconnectTube.processResponse for fiber " + Fiber.current() + " and tube " + (Object)((Object)this) + " clearing/opening fiberBox " + this.fiberBox + ". Returning with response packet msgId: " + (String)object);
                }
                object = this.fiberBox;
                this.fiberBox = null;
                object.open();
            } else {
                object = AsyncClientPropertyBag.propertySetRetriever.getFromPacket(packet);
                if (object.getRequestMessageID() != null) {
                    String string = object.getRequestMessageID();
                    PersistenceConfig.Client client = PersistenceConfig.getClientConfig(this.context);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Removing persistent context for async request msg: " + string + " from logical store: " + client.getLogicalStoreName() + " because the response for it was returned on the back-channel instead of the async response endpoint");
                    }
                    PersistentContext.getStoreMap(client.getLogicalStoreName()).remove(string);
                }
            }
            return this.doReturnWith(packet);
        }
        if (this.fiberBox == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("AsyncClientTransportReconnectTube.processResponse for fiber " + Fiber.current() + " and tube " + (Object)((Object)this) + " found empty response message but null fiberBox. Returning with empty response packet");
            }
            return this.doReturnWith(packet);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("AsyncClientTransportReconnectTube.processResponse for fiber " + Fiber.current() + " and tube " + (Object)((Object)this) + " clearing FiberBox and returning doSuspend() to eventually suspend fiber");
        }
        final FiberBox fiberBox = this.fiberBox;
        this.fiberBox = null;
        Fiber.current().addListener(new Fiber.Listener(){

            public void fiberSuspended(Fiber fiber) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Detected fiber suspension, opening FiberBox to allow response thread to resume it. Fiber=" + fiberBox);
                }
                fiberBox.open();
                fiber.removeListener((Fiber.Listener)this);
            }

            public void fiberResumed(Fiber fiber) {
                fiber.removeListener((Fiber.Listener)this);
            }
        });
        return this.doSuspend();
    }

    public NextAction processException(Throwable throwable) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("AsyncClientTransportReconnectTube.processException clearing fiberBox " + this.fiberBox + " because of exception: " + throwable);
        }
        this.fiberBox = null;
        return this.doThrow(throwable);
    }

    public void preDestroy() {
        this.actf.dispose();
        if (this.next != null) {
            this.next.preDestroy();
        }
    }
}

