/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.client.async;

import com.sun.istack.Nullable;
import com.sun.xml.ws.api.DistributedPropertySet;
import com.sun.xml.ws.api.PropertySet;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.WSFeatureList;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.ResponseOnlyTube;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.api.pipe.helper.AbstractTubeImpl;
import com.sun.xml.ws.api.server.AsyncProviderCallback;
import com.sun.xml.ws.api.server.ContainerResolver;
import com.sun.xml.ws.api.server.WSWebServiceContext;
import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.binding.ImpliesWebServiceFeature;
import com.sun.xml.ws.client.Stub;
import com.sun.xml.ws.client.SyncStartForAsyncInvokeFeature;
import com.sun.xml.ws.client.WSServiceDelegate;
import com.sun.xml.ws.client.dispatch.PacketDispatch;
import com.sun.xml.ws.server.sei.CorrelationPropertySet;
import com.sun.xml.ws.util.Pool;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Dispatch;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.Response;
import javax.xml.ws.Service;
import javax.xml.ws.ServiceMode;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.WebServiceProvider;
import org.w3c.dom.Element;
import weblogic.jws.jaxws.client.async.AsyncClientHandlerFeature;
import weblogic.jws.jaxws.client.async.AsyncClientTransportFeature;
import weblogic.jws.jaxws.client.async.FiberBox;
import weblogic.jws.jaxws.client.async.OnServerInfo;
import weblogic.kernel.KernelStatus;
import weblogic.wsee.jaxws.InvokerOnlyFeature;
import weblogic.wsee.jaxws.client.async.AsyncResponseEndpoint;
import weblogic.wsee.jaxws.client.async.AsyncTransportProviderPropertyBag;
import weblogic.wsee.jaxws.cluster.ClusterRoutingPropertyBag;
import weblogic.wsee.jaxws.cluster.ClusterTubelineDeploymentListener;
import weblogic.wsee.jaxws.cluster.spi.PhysicalStoreNameHeader;
import weblogic.wsee.jaxws.persistence.ClientInstancePoolFeature;
import weblogic.wsee.jaxws.persistence.ConversationalClientInstanceFeature;
import weblogic.wsee.jaxws.persistence.PersistenceConfig;
import weblogic.wsee.jaxws.persistence.PersistentContext;
import weblogic.wsee.jaxws.persistence.PersistentContextStore;
import weblogic.wsee.jaxws.persistence.PersistentMessageFactory;
import weblogic.wsee.jaxws.spi.WLSEndpoint;
import weblogic.wsee.mc.api.McFeature;
import weblogic.wsee.runtime.WebServicesRuntime;
import weblogic.wsee.util.Guid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebServiceProvider
@ServiceMode(value=Service.Mode.MESSAGE)
public class AsyncTransportProvider
implements weblogic.jws.jaxws.client.async.AsyncTransportProvider,
ImpliesWebServiceFeature,
AsyncResponseEndpoint {
    private static final Logger LOGGER = Logger.getLogger(AsyncTransportProvider.class.getName());
    private AsyncClientTransportFeature actf;
    private AddressingVersion av;
    private SOAPVersion sv;
    private WSFeatureList featuresWithHandler;
    private Dispatch<Packet> responseDispatch;
    private PersistenceConfig.Client persistConfig;
    @Nullable
    private OnServerInfo onServerInfo;
    private ReentrantReadWriteLock _responseCompleteListenersLock = new ReentrantReadWriteLock(false);
    private List<AsyncResponseEndpoint.ResponseProcessingCompletionListener> _responseCompleteListeners = new ArrayList<AsyncResponseEndpoint.ResponseProcessingCompletionListener>();

    public AsyncTransportProvider(AsyncClientTransportFeature asyncClientTransportFeature) {
        this.actf = asyncClientTransportFeature;
    }

    public void performValidations(WSBinding wSBinding) {
        if (wSBinding.getFeature(McFeature.class) != null) {
            throw new WebServiceException("Cannot concurrently use AsyncClientTransportFeature and McFeature. They are mutually exclusive.");
        }
        AddressingVersion addressingVersion = wSBinding.getAddressingVersion();
        SOAPVersion sOAPVersion = wSBinding.getSOAPVersion();
        if (this.av != null && !this.av.equals((Object)addressingVersion)) {
            throw new WebServiceException("Client callback endpoints sharing the same instance of AsyncClientTransportFeature must use the same addressing version.  Mismatched versions: " + this.av + " and " + addressingVersion);
        }
        if (this.sv != null && !this.sv.equals((Object)sOAPVersion)) {
            throw new WebServiceException("Client callback endpoints sharing the same instance of AsyncClientTransportFeature must use the same SOAP version.  Mismatched versions: " + this.sv + " and " + sOAPVersion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Stub stub) {
        Object object;
        Object object2;
        Object object3;
        Pool pool;
        WSBinding wSBinding = stub.getBinding();
        AddressingVersion addressingVersion = wSBinding.getAddressingVersion();
        SOAPVersion sOAPVersion = wSBinding.getSOAPVersion();
        this.performValidations(wSBinding);
        this.av = addressingVersion;
        this.sv = sOAPVersion;
        WSFeatureList wSFeatureList = wSBinding.getFeatures();
        boolean bl = false;
        AsyncClientHandlerFeature asyncClientHandlerFeature = (AsyncClientHandlerFeature)wSFeatureList.get(AsyncClientHandlerFeature.class);
        if (asyncClientHandlerFeature != null) {
            if (this.featuresWithHandler == null) {
                bl = true;
            } else if (!this.compareFeatureLists(wSFeatureList, this.featuresWithHandler)) {
                // empty if block
            }
            this.featuresWithHandler = wSFeatureList;
        }
        if (bl || this.responseDispatch == null) {
            pool = stub.getTubes();
            object3 = (Tube)pool.take();
            try {
                object2 = new ResponseOnlyTube(this.createTubeEnd(TubeCloner.clone((Tube)object3), asyncClientHandlerFeature), true, false);
                object = stub.getWSDLPort();
                this.responseDispatch = new PacketDispatch(object != null ? object.getName() : null, (WSServiceDelegate)stub.getService(), (Tube)object2, (BindingImpl)stub.getBinding(), null, true);
                if (wSBinding.isFeatureEnabled(SyncStartForAsyncInvokeFeature.class)) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("AsyncTransportProvider " + this + " defeating SyncStartForAsyncInvokeFeature found on client binding by setting PREVENT_SYNC_START_FOR_ASYNC_INVOKE on the dispatch used for responses");
                    }
                    this.responseDispatch.getRequestContext().put("com.sun.xml.ws.client.StubRequestSyncStartForAsyncInvoke", "true");
                }
            }
            finally {
                pool.recycle(object3);
            }
        }
        this.persistConfig = PersistenceConfig.getClientConfig(stub);
        if (KernelStatus.isServer()) {
            this.onServerInfo = new OnServerInfo();
            pool = (ServletContext)ContainerResolver.getInstance().getContainer().getSPI(ServletContext.class);
            this.onServerInfo.setContext((Object)pool);
            object3 = WLSEndpoint.getServerAddress();
            this.onServerInfo.setListenAddress((String)object3);
            object2 = WLSEndpoint.getServerAddressForSSL();
            this.onServerInfo.setSslListenAddress((String)object2);
            object = Guid.generateGuid();
            this.onServerInfo.setGuid((String)object);
            this.onServerInfo.setReplyToRefParams(this.getReplyToRefParams());
        }
    }

    private boolean compareFeatureLists(WSFeatureList wSFeatureList, WSFeatureList wSFeatureList2) {
        return wSFeatureList.get(ClientInstancePoolFeature.class) != null || wSFeatureList.get(ConversationalClientInstanceFeature.class) != null || wSFeatureList.equals(wSFeatureList2);
    }

    private Tube createTubeEnd(Tube tube, AsyncClientHandlerFeature asyncClientHandlerFeature) {
        if (asyncClientHandlerFeature == null) {
            return new ErrorTube(tube);
        }
        return tube;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addResponseProcessingCompletionListener(AsyncResponseEndpoint.ResponseProcessingCompletionListener responseProcessingCompletionListener) {
        try {
            this._responseCompleteListenersLock.writeLock().lock();
            if (!this._responseCompleteListeners.contains(responseProcessingCompletionListener)) {
                this._responseCompleteListeners.add(responseProcessingCompletionListener);
            }
        }
        finally {
            this._responseCompleteListenersLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeResponseProcessingCompletionListener(AsyncResponseEndpoint.ResponseProcessingCompletionListener responseProcessingCompletionListener) {
        try {
            this._responseCompleteListenersLock.writeLock().lock();
            this._responseCompleteListeners.remove(responseProcessingCompletionListener);
        }
        finally {
            this._responseCompleteListenersLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AsyncResponseEndpoint.ResponseProcessingCompletionListener[] getResponseProcessingCompletionListeners() {
        try {
            this._responseCompleteListenersLock.readLock().lock();
            AsyncResponseEndpoint.ResponseProcessingCompletionListener[] responseProcessingCompletionListenerArray = this._responseCompleteListeners.toArray(new AsyncResponseEndpoint.ResponseProcessingCompletionListener[this._responseCompleteListeners.size()]);
            return responseProcessingCompletionListenerArray;
        }
        finally {
            this._responseCompleteListenersLock.readLock().unlock();
        }
    }

    public void invoke(Message message, AsyncProviderCallback<Message> asyncProviderCallback, WebServiceContext webServiceContext) {
        try {
            FiberBox fiberBox;
            Packet packet = ((WSWebServiceContext)webServiceContext).getRequestPacket();
            HeaderList headerList = message.getHeaders();
            String string = headerList.getMessageID(this.av, this.sv);
            String string2 = headerList.getRelatesTo(this.av, this.sv);
            AsyncTransportProviderPropertyBag asyncTransportProviderPropertyBag = AsyncTransportProviderPropertyBag.propertySetRetriever.getFromPacket(packet);
            asyncTransportProviderPropertyBag.setResponseEndpoint(this);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Added AsyncTransportProviderPropertyBag for msgId " + string + " packet: " + packet.toShortString());
            }
            FiberBox fiberBox2 = fiberBox = string2 != null ? this.actf.retrieve(string2) : null;
            if (fiberBox == null) {
                if (string2 != null) {
                    PersistentContextStore persistentContextStore;
                    PersistentContext persistentContext;
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Found async response with no suspended thread. Attempting to find saved persistent contex for async request msg: " + string2 + " into response msg: " + string);
                    }
                    if ((persistentContext = (PersistentContext)(persistentContextStore = PersistentContext.getStoreMap(this.persistConfig.getLogicalStoreName())).get(string2)) != null) {
                        this.dispatchResponseWithAsyncRequestContext(packet, string, string2, asyncTransportProviderPropertyBag, persistentContextStore, asyncProviderCallback, persistentContext);
                    } else if (ClusterTubelineDeploymentListener.isClusterServer()) {
                        ClusterRoutingPropertyBag clusterRoutingPropertyBag = ClusterRoutingPropertyBag.propertySetRetriever.getFromPacket(packet);
                        clusterRoutingPropertyBag.setUncorrelatedAsyncResponse(true);
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("DIDN'T FIND saved persistent contex for async request msg: " + string2 + " while processing response msg: " + string + ". ALLOWING it to be processed in order to allow cluster routing to kick in.");
                        }
                        this.dispatchResponseDownTubeline(asyncProviderCallback, packet);
                    } else {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("DIDN'T FIND saved persistent contex for async request msg: " + string2 + " while processing response msg: " + string + ". This message cannot be processed.");
                        }
                        Exception exception = new Exception("Message cannot be processed: " + string);
                        exception.fillInStackTrace();
                        asyncProviderCallback.sendError((Throwable)exception);
                    }
                } else {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Found incoming async message with no related outgoing request. Assuming " + string + " is a protocol message");
                    }
                    this.dispatchResponseDownTubeline(asyncProviderCallback, packet);
                }
            } else {
                this.dispatchResponseWithSuspendedFiber(packet, string, string2, fiberBox, asyncProviderCallback);
            }
        }
        catch (Throwable throwable) {
            asyncProviderCallback.sendError(throwable);
        }
    }

    private void dispatchResponseWithSuspendedFiber(final Packet packet, String string, String string2, FiberBox fiberBox, final AsyncProviderCallback<Message> asyncProviderCallback) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Found suspended fiber in fiberBox " + fiberBox + " from async request msg: " + string2 + ". Will get a ref to it (may block till original fiber is suspended), resume it and process response msg: " + string);
        }
        try {
            Fiber fiber = fiberBox.get();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Obtained ref to suspended fiber from fiberBox " + fiberBox + " incoming RelatesTo msgId: " + string2 + ". Will resume it and process response msg: " + string);
            }
            Packet packet2 = fiber.getPacket().createClientResponse(packet.getMessage());
            packet2.wasTransportSecure = packet.wasTransportSecure;
            packet.copySatelliteInto((DistributedPropertySet)packet2);
            final Fiber.CompletionCallback completionCallback = fiber.getCompletionCallback();
            fiber.setCompletionCallback(new Fiber.CompletionCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onCompletion(Packet packet3) {
                    Message message;
                    Packet packet2 = null;
                    try {
                        if (completionCallback != null) {
                            completionCallback.onCompletion(packet3);
                        }
                        message = (packet2 = AsyncTransportProvider.this.getFinalResponsePacket(packet, packet3)) != null ? packet2.getMessage() : null;
                    }
                    catch (Throwable throwable) {
                        asyncProviderCallback.send((Object)(packet2 != null ? packet2.getMessage() : null));
                        throw throwable;
                    }
                    asyncProviderCallback.send((Object)message);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onCompletion(Throwable throwable) {
                    try {
                        Packet packet2;
                        if (completionCallback != null) {
                            completionCallback.onCompletion(throwable);
                        }
                        if ((packet2 = AsyncTransportProvider.this.getFinalResponsePacket(packet, throwable)) != null) {
                            throwable = null;
                            asyncProviderCallback.send((Object)packet2.getMessage());
                        }
                    }
                    finally {
                        if (throwable != null) {
                            asyncProviderCallback.sendError(throwable);
                        }
                    }
                }
            });
            fiber.resume(packet2);
        }
        catch (InterruptedException interruptedException) {
            asyncProviderCallback.send(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchResponseWithAsyncRequestContext(Packet packet, String string, final String string2, AsyncTransportProviderPropertyBag asyncTransportProviderPropertyBag, final PersistentContextStore persistentContextStore, AsyncProviderCallback<Message> asyncProviderCallback, PersistentContext persistentContext) {
        PersistentContext persistentContext2 = persistentContext;
        synchronized (persistentContext2) {
            persistentContext = (PersistentContext)persistentContextStore.get(string2);
            if (persistentContext != null) {
                Object object;
                String string3;
                if (LOGGER.isLoggable(Level.FINE)) {
                    string3 = this.dumpPersistentContext(persistentContext);
                    LOGGER.fine("Restoring saved persistent contex for async request msg: " + string2 + " into response msg: " + string + " contents: " + string3);
                }
                string3 = (String)packet.get((Object)"javax.xml.ws.soap.http.soapaction.uri");
                PersistentMessageFactory.getInstance().setContextIntoPacket(persistentContext, packet);
                packet.addSatellite((PropertySet)new CorrelationPropertySet((String)packet.get((Object)"javax.xml.ws.soap.http.soapaction.uri")));
                packet.put("javax.xml.ws.soap.http.soapaction.uri", (Object)string3);
                if (LOGGER.isLoggable(Level.FINE)) {
                    object = null;
                    if (packet.persistentContext != null) {
                        object = AsyncTransportProvider.dumpPersistentContextContextProps(packet.persistentContext);
                    }
                    LOGGER.fine("Beginning dispatch of async response for request " + string2 + " as response msg " + string + " with Packet.persistentContext: " + (String)object);
                }
                persistentContext.setState(PersistentContext.State.IN_USE);
                object = new RequestContextRemovalCallback(){

                    public void stopUsingAsyncRequestContext() {
                        PersistentContext persistentContext = (PersistentContext)persistentContextStore.get(string2);
                        if (persistentContext != null) {
                            if (LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.fine("RequestContextRemovalCallback is setting PersistentContext.State.UNUSED for async request msgId: " + string2);
                            }
                            persistentContext.setState(PersistentContext.State.UNUSED);
                        }
                    }

                    public void removeAsyncRequestContext() {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("RequestContextRemovalCallback is removing PersistentContext for async request msgId: " + string2);
                        }
                        persistentContextStore.remove(string2);
                    }
                };
                asyncTransportProviderPropertyBag.setRequestContextRemovalCallback((RequestContextRemovalCallback)object);
                this.dispatchResponseDownTubeline(asyncProviderCallback, packet);
            } else {
                asyncProviderCallback.sendError((Throwable)new RuntimeException("persistCtx is null"));
            }
        }
    }

    private String dumpPersistentContext(PersistentContext persistentContext) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ContextPropCount=");
        if (persistentContext.getContextPropertyMap() != null) {
            stringBuffer.append(AsyncTransportProvider.dumpPersistentContextContextProps(persistentContext.getContextPropertyMap()));
        } else {
            stringBuffer.append("0");
        }
        stringBuffer.append(" PropCount=").append(persistentContext.getPropertyMap().size());
        stringBuffer.append(" InvokePropCount=").append(persistentContext.getInvocationPropertyMap().size());
        return stringBuffer.toString();
    }

    public static String dumpPersistentContextContextProps(Map<String, ?> map) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(map.size());
        stringBuffer.append(" (");
        for (String string : map.keySet()) {
            stringBuffer.append(string).append("=");
            stringBuffer.append(map.get(string));
            stringBuffer.append(",");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private void dispatchResponseDownTubeline(final AsyncProviderCallback<Message> asyncProviderCallback, final Packet packet) {
        if (LOGGER.isLoggable(Level.FINE)) {
            String string = packet.getMessage().getHeaders().getMessageID(this.av, this.sv);
            String string2 = AsyncTransportProvider.dumpPersistentContextContextProps(packet.persistentContext);
            LOGGER.fine("Putting persistentContext props onto RequestContext for msg " + string + " contents: " + string2);
        }
        this.responseDispatch.getRequestContext().put("weblogic.wsee.jaxws.async.PersistentContext", packet.persistentContext);
        this.responseDispatch.invokeAsync((Object)packet, (AsyncHandler)new AsyncHandler<Packet>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleResponse(Response<Packet> response) {
                Object object;
                try {
                    object = (Packet)response.get();
                    Packet packet2 = AsyncTransportProvider.this.getFinalResponsePacket(packet, (Packet)object);
                    asyncProviderCallback.send((Object)packet2.getMessage());
                }
                catch (Throwable throwable) {
                    Packet packet3 = AsyncTransportProvider.this.getFinalResponsePacket(packet, throwable);
                    if (packet3 != null) {
                        asyncProviderCallback.send((Object)packet3.getMessage());
                    } else {
                        asyncProviderCallback.sendError(throwable);
                    }
                }
                finally {
                    object = AsyncTransportProviderPropertyBag.propertySetRetriever.getFromPacket(packet);
                    if (((AsyncTransportProviderPropertyBag)((Object)object)).getRequestContextRemovalCallback() != null) {
                        ((AsyncTransportProviderPropertyBag)((Object)object)).getRequestContextRemovalCallback().removeAsyncRequestContext();
                    }
                }
            }
        });
    }

    private Packet getFinalResponsePacket(Packet packet, Packet packet2) {
        Packet packet3 = null;
        AsyncResponseEndpoint.ResponseProcessingCompletionListener[] responseProcessingCompletionListenerArray = this.getResponseProcessingCompletionListeners();
        for (AsyncResponseEndpoint.ResponseProcessingCompletionListener responseProcessingCompletionListener : responseProcessingCompletionListenerArray) {
            Packet packet4 = responseProcessingCompletionListener.responseProcessingComplete(packet2);
            if (packet4 == packet2) continue;
            packet3 = packet4;
        }
        AsyncTransportProviderPropertyBag asyncTransportProviderPropertyBag = AsyncTransportProviderPropertyBag.propertySetRetriever.getFromPacket(packet);
        asyncTransportProviderPropertyBag.setPacket(packet3 != null ? packet3 : packet2);
        Packet packet5 = asyncTransportProviderPropertyBag.getResponsePacket();
        if (packet5 != null) {
            packet3 = packet5;
        }
        if (packet3 == null) {
            packet3 = packet2.copy(false);
        }
        if ((packet2 = packet3) != null) {
            if (packet.outboundHttpHeaders != null && packet2.outboundHttpHeaders != null) {
                packet.outboundHttpHeaders.putAll(packet2.outboundHttpHeaders);
            } else if (packet.outboundHttpHeaders == null) {
                packet.outboundHttpHeaders = packet2.outboundHttpHeaders;
            }
            if (packet.transportBackChannel == null) {
                packet.transportBackChannel = packet2.transportBackChannel;
            }
        }
        return packet2;
    }

    private Packet getFinalResponsePacket(Packet packet, Throwable throwable) {
        AsyncResponseEndpoint.ResponseProcessingCompletionListener[] responseProcessingCompletionListenerArray = this.getResponseProcessingCompletionListeners();
        Packet packet2 = null;
        for (AsyncResponseEndpoint.ResponseProcessingCompletionListener responseProcessingCompletionListener : responseProcessingCompletionListenerArray) {
            packet2 = responseProcessingCompletionListener.responseProcessingFailed(packet, throwable);
            if (packet2 == null) continue;
            packet2 = this.getFinalResponsePacket(packet, packet2);
            break;
        }
        return packet2;
    }

    public void implyFeatures(Map<Class<? extends WebServiceFeature>, WebServiceFeature> map) {
        map.put(InvokerOnlyFeature.class, new InvokerOnlyFeature());
    }

    public OnServerInfo getOnServerInfo() {
        return this.onServerInfo;
    }

    @Override
    public EndpointReference getEndpointReference() {
        return this.actf.getEndpoint().getEndpointReference(new Element[0]);
    }

    private HeaderList getReplyToRefParams() {
        HeaderList headerList = null;
        String string = this.persistConfig.getLogicalStoreName();
        if (string != null) {
            String string2;
            List<String> list = WebServicesRuntime.getInstance().getLocalPhysicalStoresForLogicalStore(string);
            String string3 = string2 = list != null && list.size() > 0 ? list.get(0) : null;
            if (string2 != null) {
                PhysicalStoreNameHeader physicalStoreNameHeader = new PhysicalStoreNameHeader(string2);
                headerList = new HeaderList();
                headerList.add((Header)physicalStoreNameHeader);
            }
        }
        return headerList;
    }

    private static class ErrorTube
    extends AbstractFilterTubeImpl {
        public ErrorTube(Tube tube) {
            super(tube);
        }

        public ErrorTube(ErrorTube errorTube, TubeCloner tubeCloner) {
            super((AbstractFilterTubeImpl)errorTube, tubeCloner);
        }

        public AbstractTubeImpl copy(TubeCloner tubeCloner) {
            return new ErrorTube(this, tubeCloner);
        }

        public NextAction processRequest(Packet packet) {
            throw new IllegalStateException("ErrorTube's processRequest shouldn't be called.");
        }

        public NextAction processResponse(Packet packet) {
            if (packet.getMessage() == null) {
                return this.doReturnWith(packet);
            }
            throw new WebServiceException("No handler present and protocol message reached tubeline end");
        }
    }

    public static interface RequestContextRemovalCallback {
        public void stopUsingAsyncRequestContext();

        public void removeAsyncRequestContext();
    }
}

