/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.client.async;

import com.sun.istack.Nullable;
import com.sun.xml.bind.api.JAXBRIContext;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.SEIModel;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.client.AsyncInvoker;
import com.sun.xml.ws.client.AsyncResponseImpl;
import com.sun.xml.ws.client.ResponseContext;
import com.sun.xml.ws.client.Stub;
import com.sun.xml.ws.client.sei.ResponseBuilder;
import com.sun.xml.ws.client.sei.ValueSetter;
import com.sun.xml.ws.client.sei.ValueSetterFactory;
import com.sun.xml.ws.fault.SOAPFaultBuilder;
import com.sun.xml.ws.model.CheckedExceptionImpl;
import com.sun.xml.ws.model.JavaMethodImpl;
import com.sun.xml.ws.model.ParameterImpl;
import com.sun.xml.ws.model.SOAPSEIModel;
import com.sun.xml.ws.model.WrapperParameter;
import com.sun.xml.ws.server.sei.DispatchException;
import com.sun.xml.ws.server.sei.EndpointMethodDispatcher;
import com.sun.xml.ws.server.sei.EndpointMethodDispatcherGetter;
import com.sun.xml.ws.server.sei.EndpointMethodHandler;
import com.sun.xml.ws.server.sei.EndpointMethodHandlerFactory;
import com.sun.xml.ws.server.sei.Invoker;
import com.sun.xml.ws.server.sei.InvokerSource;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jws.soap.SOAPBinding;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Response;
import javax.xml.ws.Service;
import javax.xml.ws.ServiceMode;
import javax.xml.ws.WebServiceException;
import weblogic.jws.jaxws.client.async.AsyncClientHandlerFeature;
import weblogic.wsee.jaxws.client.async.AsyncTransportProvider;
import weblogic.wsee.jaxws.client.async.HandlerInvoker;
import weblogic.wsee.jaxws.framework.WsUtil;

public class HandlerInvokerFactory {
    private static final Logger LOGGER = Logger.getLogger(HandlerInvokerFactory.class.getName());

    private HandlerInvokerFactory() {
    }

    public static HandlerInvoker getInvoker(AsyncClientHandlerFeature asyncClientHandlerFeature, WSBinding wSBinding, Stub stub) {
        if (asyncClientHandlerFeature.getHandler() instanceof AsyncHandler) {
            return new DispatchHandlerInvokerImpl(asyncClientHandlerFeature, wSBinding, stub);
        }
        HandlerInvokerImpl handlerInvokerImpl = new HandlerInvokerImpl(asyncClientHandlerFeature, wSBinding, stub);
        if (handlerInvokerImpl.dispatcherList == null) {
            return null;
        }
        return handlerInvokerImpl;
    }

    private static class MessageReaderImpl
    implements MessageReader {
        private MessageReaderImpl() {
        }

        public Object readAsObject(Message message) {
            return message;
        }
    }

    private static class SOAPMessageReaderImpl
    implements MessageReader {
        private SOAPMessageReaderImpl() {
        }

        public Object readAsObject(Message message) {
            try {
                return message.readAsSOAPMessage(Fiber.current().getPacket(), true);
            }
            catch (SOAPException sOAPException) {
                throw new WebServiceException((Throwable)sOAPException);
            }
        }
    }

    private static class EnvelopeAsSourceReaderImpl
    implements MessageReader {
        private EnvelopeAsSourceReaderImpl() {
        }

        public Object readAsObject(Message message) {
            return message.readEnvelopeAsSource();
        }
    }

    private static class PayloadReaderImpl
    implements MessageReader {
        private PayloadReaderImpl() {
        }

        public Object readAsObject(Message message) {
            return message.readPayloadAsSource();
        }
    }

    private static interface MessageReader {
        public Object readAsObject(Message var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AsyncDispatchMethodHandler
    extends BaseEndpointMethodHandler
    implements EndpointMethodHandler {
        private AsyncHandler handler;
        private Class dataType;
        private static Method invokeMethod;
        private Service.Mode mode;
        private MessageReader reader;

        protected AsyncDispatchMethodHandler(AsyncHandler asyncHandler, Map<QName, CheckedExceptionImpl> map, WSBinding wSBinding) {
            super(map, wSBinding);
            this.handler = asyncHandler;
            Type type = JAXBRIContext.getBaseType(asyncHandler.getClass(), AsyncHandler.class);
            if (type == null || !(type instanceof ParameterizedType)) {
                throw new WebServiceException("provider is not parameterized");
            }
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] typeArray = parameterizedType.getActualTypeArguments();
            if (!(typeArray[0] instanceof Class)) {
                throw new WebServiceException(asyncHandler.getClass().getName() + "'s paramterized type '" + typeArray[0] + "' is not supported");
            }
            this.dataType = (Class)typeArray[0];
            ServiceMode serviceMode = asyncHandler.getClass().getAnnotation(ServiceMode.class);
            Service.Mode mode = this.mode = serviceMode == null ? Service.Mode.PAYLOAD : serviceMode.value();
            if (this.mode == Service.Mode.PAYLOAD) {
                if (this.dataType == Source.class) {
                    this.reader = new PayloadReaderImpl();
                }
            } else if (this.dataType == Source.class) {
                this.reader = new EnvelopeAsSourceReaderImpl();
            } else if (this.dataType == SOAPMessage.class) {
                this.reader = new SOAPMessageReaderImpl();
            } else if (this.dataType == Message.class) {
                this.reader = new MessageReaderImpl();
            } else {
                throw new WebServiceException("Illeagal combination of service mode '" + this.mode + "' and parameterized type '" + this.dataType + "' on " + asyncHandler.getClass().getName());
            }
        }

        @Override
        protected Object getResponse(Message message) throws Exception {
            return this.reader.readAsObject(message);
        }

        @Override
        public void handleResponse(Packet packet, Response response) {
            try {
                invokeMethod.invoke((Object)this.handler, response);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new WebServiceException((Throwable)invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new WebServiceException((Throwable)illegalAccessException);
            }
        }

        static {
            try {
                invokeMethod = AsyncHandler.class.getDeclaredMethod("handleResponse", Response.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new WebServiceException((Throwable)noSuchMethodException);
            }
        }
    }

    static class AsyncEndpointMethodHandler
    extends BaseEndpointMethodHandler
    implements EndpointMethodHandler {
        private final ResponseBuilder responseBuilder;
        @Nullable
        private final Class asyncBeanClass;
        private InvokerSource owner;
        private WSBinding binding;
        private Method method;

        public AsyncEndpointMethodHandler(InvokerSource invokerSource, JavaMethodImpl javaMethodImpl, JavaMethodImpl javaMethodImpl2, WSBinding wSBinding, EndpointMethodDispatcherGetter endpointMethodDispatcherGetter) {
            super(new HashMap<QName, CheckedExceptionImpl>(), wSBinding);
            WrapperParameter wrapperParameter;
            Object object;
            this.owner = invokerSource;
            this.binding = wSBinding;
            this.method = endpointMethodDispatcherGetter.getHandlerMethod(javaMethodImpl);
            for (CheckedExceptionImpl checkedExceptionImpl : javaMethodImpl.getCheckedExceptions()) {
                this.checkedExceptions.put(checkedExceptionImpl.getBridge().getTypeReference().tagName, checkedExceptionImpl);
            }
            Object object2 = javaMethodImpl2.getResponseParameters();
            int n = 0;
            Object object3 = object2.iterator();
            while (object3.hasNext()) {
                object = (ParameterImpl)object3.next();
                if (object.isWrapperStyle()) {
                    wrapperParameter = (WrapperParameter)object;
                    n += wrapperParameter.getWrapperChildren().size();
                    if (javaMethodImpl2.getBinding().getStyle() != SOAPBinding.Style.DOCUMENT) continue;
                    n += 2;
                    continue;
                }
                ++n;
            }
            object3 = null;
            if (n > 1) {
                object2 = javaMethodImpl.getResponseParameters();
                object = object2.iterator();
                while (object.hasNext()) {
                    wrapperParameter = (ParameterImpl)object.next();
                    if (wrapperParameter.isWrapperStyle()) {
                        WrapperParameter wrapperParameter2 = wrapperParameter;
                        if (javaMethodImpl2.getBinding().getStyle() == SOAPBinding.Style.DOCUMENT) {
                            object3 = (Class)wrapperParameter2.getTypeReference().type;
                            break;
                        }
                        for (ParameterImpl parameterImpl : wrapperParameter2.getWrapperChildren()) {
                            if (parameterImpl.getIndex() != -1) continue;
                            object3 = (Class)parameterImpl.getTypeReference().type;
                            break;
                        }
                        if (object3 == null) continue;
                        break;
                    }
                    if (wrapperParameter.getIndex() != -1) continue;
                    object3 = (Class)wrapperParameter.getTypeReference().type;
                    break;
                }
            }
            this.asyncBeanClass = object3;
            switch (n) {
                case 0: {
                    this.responseBuilder = this.buildResponseBuilder(javaMethodImpl2, ValueSetterFactory.NONE);
                    break;
                }
                case 1: {
                    this.responseBuilder = this.buildResponseBuilder(javaMethodImpl2, ValueSetterFactory.SINGLE);
                    break;
                }
                default: {
                    this.responseBuilder = this.buildResponseBuilder(javaMethodImpl2, (ValueSetterFactory)new ValueSetterFactory.AsyncBeanValueSetterFactory(this.asyncBeanClass));
                }
            }
        }

        ResponseBuilder buildResponseBuilder(JavaMethodImpl javaMethodImpl, ValueSetterFactory valueSetterFactory) {
            ResponseBuilder responseBuilder;
            List list = javaMethodImpl.getResponseParameters();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            block10: for (ParameterImpl parameterImpl : list) {
                switch (parameterImpl.getOutBinding().kind) {
                    case BODY: {
                        if (parameterImpl.isWrapperStyle()) {
                            if (parameterImpl.getParent().getBinding().isRpcLit()) {
                                arrayList.add(new ResponseBuilder.RpcLit((WrapperParameter)parameterImpl, valueSetterFactory));
                                continue block10;
                            }
                            arrayList.add(new ResponseBuilder.DocLit((WrapperParameter)parameterImpl, valueSetterFactory));
                            continue block10;
                        }
                        ValueSetter valueSetter = valueSetterFactory.get(parameterImpl);
                        arrayList.add(new ResponseBuilder.Body(parameterImpl.getBridge(), valueSetter));
                        continue block10;
                    }
                    case HEADER: {
                        ValueSetter valueSetter = valueSetterFactory.get(parameterImpl);
                        arrayList.add(new ResponseBuilder.Header(this.binding.getSOAPVersion(), parameterImpl, valueSetter));
                        continue block10;
                    }
                    case ATTACHMENT: {
                        ValueSetter valueSetter = valueSetterFactory.get(parameterImpl);
                        arrayList.add(ResponseBuilder.AttachmentBuilder.createAttachmentBuilder((ParameterImpl)parameterImpl, (ValueSetter)valueSetter));
                        continue block10;
                    }
                    case UNBOUND: {
                        ValueSetter valueSetter = valueSetterFactory.get(parameterImpl);
                        arrayList.add(new ResponseBuilder.NullSetter(valueSetter, ResponseBuilder.getVMUninitializedValue((Type)parameterImpl.getTypeReference().type)));
                        continue block10;
                    }
                }
                throw new AssertionError();
            }
            switch (arrayList.size()) {
                case 0: {
                    responseBuilder = ResponseBuilder.NONE;
                    break;
                }
                case 1: {
                    responseBuilder = (ResponseBuilder)arrayList.get(0);
                    break;
                }
                default: {
                    responseBuilder = new ResponseBuilder.Composite(arrayList);
                }
            }
            return responseBuilder;
        }

        protected Object getResponse(Message message) throws Exception {
            Object[] objectArray = new Object[1];
            if (this.asyncBeanClass != null) {
                objectArray[0] = this.asyncBeanClass.newInstance();
            }
            this.responseBuilder.readResponse(message, objectArray);
            return objectArray[0];
        }

        public void handleResponse(Packet packet, Response response) {
            try {
                Object object = this.owner.getInvoker(packet).invoke(packet, this.method, new Object[]{response});
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new WebServiceException((Throwable)invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new WebServiceException((Throwable)illegalAccessException);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class BaseEndpointMethodHandler
    implements EndpointMethodHandler {
        protected final Map<QName, CheckedExceptionImpl> checkedExceptions;
        private WSBinding binding;

        protected BaseEndpointMethodHandler(Map<QName, CheckedExceptionImpl> map, WSBinding wSBinding) {
            this.checkedExceptions = map;
            this.binding = wSBinding;
        }

        protected abstract Object getResponse(Message var1) throws Exception;

        public abstract void handleResponse(Packet var1, Response var2);

        public Packet invoke(Throwable throwable) {
            Packet packet = Fiber.current().getPacket();
            return this.invoke(packet, throwable);
        }

        public Packet invoke(Packet packet) {
            return this.invoke(packet, null);
        }

        public Packet invoke(final Packet packet, final Throwable throwable) {
            AsyncInvoker asyncInvoker = new AsyncInvoker(){

                public void do_run() {
                    Object object;
                    Object object2;
                    this.responseImpl.setResponseContext(new ResponseContext(packet));
                    Message message = packet.getMessage();
                    if (message == null) {
                        return;
                    }
                    if (LOGGER.isLoggable(Level.FINE)) {
                        object2 = packet.getMessage().getHeaders().getMessageID(BaseEndpointMethodHandler.this.binding.getAddressingVersion(), BaseEndpointMethodHandler.this.binding.getSOAPVersion());
                        object = AsyncTransportProvider.dumpPersistentContextContextProps(packet.persistentContext);
                        String string = AsyncTransportProvider.dumpPersistentContextContextProps(this.responseImpl.getContext());
                        LOGGER.fine("In AsyncEndpointMethodHandler for msg " + (String)object2 + " and Packet.persistentContext contents '" + (String)object + "'. Set new ResponseContext contents: " + string);
                    }
                    if ((object2 = throwable) == null) {
                        try {
                            if (message.isFault()) {
                                object = SOAPFaultBuilder.create((Message)message);
                                throw object.createException(BaseEndpointMethodHandler.this.checkedExceptions);
                            }
                            this.responseImpl.set(BaseEndpointMethodHandler.this.getResponse(message), null);
                        }
                        catch (Throwable throwable2) {
                            object2 = throwable2;
                        }
                    }
                    if (object2 != null) {
                        if (object2 instanceof RuntimeException) {
                            if (throwable instanceof WebServiceException) {
                                this.responseImpl.set(null, (Throwable)object2);
                                return;
                            }
                        } else if (object2 instanceof Exception) {
                            this.responseImpl.set(null, (Throwable)object2);
                            return;
                        }
                        this.responseImpl.set(null, (Throwable)new WebServiceException((Throwable)object2));
                    }
                }
            };
            AsyncResponseImpl asyncResponseImpl = new AsyncResponseImpl((Runnable)asyncInvoker, new AsyncHandler(){

                public void handleResponse(Response response) {
                    BaseEndpointMethodHandler.this.handleResponse(packet, response);
                }
            });
            asyncInvoker.setReceiver(asyncResponseImpl);
            asyncInvoker.run();
            packet.setMessage(null);
            return packet;
        }
    }

    static class AsyncEndpointMethodHandlerFactory
    extends EndpointMethodHandlerFactory {
        private Map<WSDLBoundOperation, JavaMethodImpl> syncs = new HashMap<WSDLBoundOperation, JavaMethodImpl>();

        public AsyncEndpointMethodHandlerFactory(SEIModel sEIModel) {
            for (JavaMethodImpl javaMethodImpl : ((SOAPSEIModel)sEIModel).getJavaMethods()) {
                if (javaMethodImpl.getMEP().isAsync) continue;
                this.syncs.put(javaMethodImpl.getOperation(), javaMethodImpl);
            }
        }

        public EndpointMethodHandler create(InvokerSource invokerSource, JavaMethodImpl javaMethodImpl, WSBinding wSBinding, EndpointMethodDispatcherGetter endpointMethodDispatcherGetter) {
            JavaMethodImpl javaMethodImpl2 = this.syncs.get(javaMethodImpl.getOperation());
            return new AsyncEndpointMethodHandler(invokerSource, javaMethodImpl, javaMethodImpl2, wSBinding, endpointMethodDispatcherGetter);
        }
    }

    private static class HandlerInvokerImpl
    implements HandlerInvoker {
        private final List<EndpointMethodDispatcher> dispatcherList;
        private WSBinding binding;
        private Stub stub;

        private HandlerInvokerImpl(final AsyncClientHandlerFeature asyncClientHandlerFeature, WSBinding wSBinding, final Stub stub) {
            this.binding = wSBinding;
            this.stub = stub;
            SEIModel sEIModel = stub.getRuntimeModel();
            if (sEIModel == null) {
                this.dispatcherList = null;
                return;
            }
            InvokerSource invokerSource = new InvokerSource(){

                public Invoker getInvoker(Packet packet) {
                    return new Invoker(){

                        public Object invoke(Packet packet, Method method, Object ... objectArray) throws InvocationTargetException, IllegalAccessException {
                            try {
                                Object object = asyncClientHandlerFeature.getHandler();
                                if (object == null) {
                                    throw new NullPointerException("AsyncClientHandlerFeature contained a null handler impl");
                                }
                                return method.invoke(object, objectArray);
                            }
                            catch (Throwable throwable) {
                                throwable.printStackTrace();
                                throw new WebServiceException(throwable);
                            }
                        }
                    };
                }
            };
            EndpointMethodDispatcherGetter endpointMethodDispatcherGetter = new EndpointMethodDispatcherGetter(sEIModel, wSBinding, invokerSource, true, new AsyncEndpointMethodHandlerFactory(sEIModel)){

                public Method getHandlerMethod(JavaMethodImpl javaMethodImpl) {
                    try {
                        Method method = javaMethodImpl.getMethod();
                        String string = method.getName();
                        String string2 = "on" + string.substring(0, 1).toUpperCase(Locale.ENGLISH) + string.substring(1, string.length() - 5) + "Response";
                        Class clazz = stub.getPortInterface();
                        Class<?> clazz2 = Class.forName(clazz.getName() + "AsyncHandler", true, clazz.getClassLoader());
                        return clazz2.getMethod(string2, Response.class);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        throw new WebServiceException((Throwable)noSuchMethodException);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new WebServiceException((Throwable)classNotFoundException);
                    }
                }
            };
            this.dispatcherList = endpointMethodDispatcherGetter.getDispatcherList();
        }

        private EndpointMethodHandler findHandler(Packet packet) throws DispatchException {
            for (EndpointMethodDispatcher endpointMethodDispatcher : this.dispatcherList) {
                EndpointMethodHandler endpointMethodHandler = endpointMethodDispatcher.getEndpointMethodHandler(packet);
                if (endpointMethodHandler == null) continue;
                return endpointMethodHandler;
            }
            return null;
        }

        public Packet createNoHandlerError(Packet packet) {
            String string = MessageFormat.format("Request=[SOAPAction={0},Payload='{'{1}'}'{2}]", packet.soapAction, packet.getMessage().getPayloadNamespaceURI(), packet.getMessage().getPayloadLocalPart());
            String string2 = "Dispatch cannot find method: " + string;
            Message message = SOAPFaultBuilder.createSOAPFaultMessage((SOAPVersion)this.binding.getSOAPVersion(), (String)string2, (QName)this.binding.getSOAPVersion().faultCodeClient);
            SEIModel sEIModel = this.stub.getRuntimeModel();
            return packet.createServerResponse(message, sEIModel != null ? sEIModel.getPort() : null, null, this.binding);
        }

        public Packet handleResponse(Packet packet) {
            EndpointMethodHandler endpointMethodHandler;
            try {
                endpointMethodHandler = this.findHandler(packet);
            }
            catch (DispatchException dispatchException) {
                if (packet.getMessage() != null && packet.getMessage().isFault()) {
                    return packet;
                }
                return packet.createServerResponse(dispatchException.fault, this.stub.getRuntimeModel().getPort(), null, this.binding);
            }
            if (endpointMethodHandler != null) {
                Packet packet2 = endpointMethodHandler.invoke(packet);
                return packet2;
            }
            return this.createNoHandlerError(packet);
        }

        public Packet handleException(Throwable throwable) {
            EndpointMethodHandler endpointMethodHandler;
            Packet packet = Fiber.current().getPacket();
            try {
                endpointMethodHandler = this.findHandler(packet);
            }
            catch (DispatchException dispatchException) {
                if (WsUtil.isPermanentSendFailure(throwable) || WsUtil.hasRootCause(throwable, IOException.class)) {
                    return null;
                }
                return packet.createServerResponse(dispatchException.fault, this.stub.getRuntimeModel().getPort(), null, this.binding);
            }
            if (endpointMethodHandler != null) {
                Packet packet2 = endpointMethodHandler.invoke(throwable);
                return packet2;
            }
            return this.createNoHandlerError(packet);
        }
    }

    private static class DispatchHandlerInvokerImpl
    implements HandlerInvoker {
        AsyncDispatchMethodHandler handler;

        private DispatchHandlerInvokerImpl(AsyncClientHandlerFeature asyncClientHandlerFeature, WSBinding wSBinding, Stub stub) {
            this.handler = new AsyncDispatchMethodHandler((AsyncHandler)asyncClientHandlerFeature.getHandler(), null, wSBinding);
        }

        public Packet handleResponse(Packet packet) {
            return this.handler.invoke(packet);
        }

        public Packet handleException(Throwable throwable) {
            Packet packet = Fiber.current().getPacket();
            return this.handler.invoke(packet, throwable);
        }
    }
}

