/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.client.async;

import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.client.ServiceCreationInterceptor;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.api.pipe.helper.AbstractTubeImpl;
import com.sun.xml.ws.client.Stub;
import com.sun.xml.ws.developer.WSBindingProvider;
import java.lang.reflect.Proxy;
import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.jws.jaxws.client.async.AsyncClientHandlerFeature;
import weblogic.wsee.jaxws.client.async.AsyncTransportProvider;
import weblogic.wsee.jaxws.client.async.HandlerInvoker;
import weblogic.wsee.jaxws.client.async.HandlerInvokerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerInvokerTube
extends AbstractFilterTubeImpl
implements ServiceCreationInterceptor {
    private HandlerInvoker invoker;
    private AsyncClientHandlerFeature achf;
    private WSBinding binding;
    private static final Logger LOGGER = Logger.getLogger(HandlerInvokerTube.class.getName());

    public HandlerInvokerTube(Tube tube, AsyncClientHandlerFeature asyncClientHandlerFeature, WSBinding wSBinding) {
        super(tube);
        this.achf = asyncClientHandlerFeature;
        this.binding = wSBinding;
    }

    protected HandlerInvokerTube(HandlerInvokerTube handlerInvokerTube, TubeCloner tubeCloner) {
        super((AbstractFilterTubeImpl)handlerInvokerTube, tubeCloner);
        this.achf = handlerInvokerTube.achf;
        this.binding = handlerInvokerTube.binding;
        this.invoker = handlerInvokerTube.invoker;
    }

    public AbstractTubeImpl copy(TubeCloner tubeCloner) {
        return new HandlerInvokerTube(this, tubeCloner);
    }

    public void postCreateDispatch(WSBindingProvider wSBindingProvider) {
        this.init(wSBindingProvider);
    }

    public void postCreateProxy(WSBindingProvider wSBindingProvider, Class<?> clazz) {
        this.init(wSBindingProvider);
    }

    private void init(WSBindingProvider wSBindingProvider) {
        Stub stub = Proxy.isProxyClass(wSBindingProvider.getClass()) ? (Stub)Proxy.getInvocationHandler(wSBindingProvider) : (Stub)wSBindingProvider;
        this.invoker = HandlerInvokerFactory.getInvoker(this.achf, this.binding, stub);
    }

    public NextAction processException(Throwable throwable) {
        if (this.invoker == null) {
            return this.doThrow(throwable);
        }
        Packet packet = this.invoker.handleException(throwable);
        if (packet == null) {
            return this.doThrow(throwable);
        }
        return this.doReturnWith(packet);
    }

    public NextAction processRequest(Packet packet) {
        if (this.invoker == null) {
            return super.processRequest(packet);
        }
        if (LOGGER.isLoggable(Level.FINE) && packet.supports((Object)"com.sun.xml.ws.api.addressing.messageId")) {
            String string = (String)packet.get((Object)"com.sun.xml.ws.api.addressing.messageId");
            String string2 = AsyncTransportProvider.dumpPersistentContextContextProps(packet.persistentContext);
            LOGGER.fine("In HandlerInvokerTube, dispatching request path for msg id " + string + " persistentContext: " + string2);
        }
        return super.processRequest(packet);
    }

    public NextAction processResponse(Packet packet) {
        if (this.invoker == null) {
            return super.processResponse(packet);
        }
        if (packet.supports((Object)"com.sun.xml.ws.api.addressing.messageId")) {
            String string = (String)packet.get((Object)"com.sun.xml.ws.api.addressing.messageId");
            String string2 = AsyncTransportProvider.dumpPersistentContextContextProps(packet.persistentContext);
            LOGGER.fine("In HandlerInvokerTube, dispatching response path for msg id " + string + " persistentContext: " + string2);
        }
        return this.doReturnWith(packet.getMessage() != null ? this.invoker.handleResponse(packet) : packet);
    }
}

