/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.cluster;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.wsee.WseeCoreLogger;
import weblogic.wsee.jaxws.cluster.DeliveryException;
import weblogic.wsee.jaxws.cluster.spi.AffinityBasedRoutingInfoFinder;
import weblogic.wsee.jaxws.cluster.spi.RoutingInfo;
import weblogic.wsee.jaxws.cluster.spi.RoutingInfoFinder;
import weblogic.wsee.jaxws.cluster.spi.RoutingInfoFinderRegistry;
import weblogic.wsee.monitoring.WseeClusterRoutingRuntimeMBeanImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseSOAPRouter<S, R extends BaseRoutables> {
    private static final Logger LOGGER = Logger.getLogger(BaseSOAPRouter.class.getName());
    private WseeClusterRoutingRuntimeMBeanImpl _clusterRouting;

    public void init(WseeClusterRoutingRuntimeMBeanImpl wseeClusterRoutingRuntimeMBeanImpl) {
        this._clusterRouting = wseeClusterRoutingRuntimeMBeanImpl;
    }

    protected abstract S getTargetServerForRouting(RoutingInfo var1) throws DeliveryException;

    protected abstract RoutingInfo getRoutingForTargetServer(S var1);

    protected abstract R deliverMessageToTargetServer(R var1, S var2) throws Exception;

    protected abstract R setAbstainedFinders(R var1, Map<AffinityBasedRoutingInfoFinder, RoutingInfo> var2);

    protected String getMessageId(Message message) {
        for (AddressingVersion addressingVersion : AddressingVersion.values()) {
            for (SOAPVersion sOAPVersion : SOAPVersion.values()) {
                String string = message.getHeaders().getMessageID(addressingVersion, sOAPVersion);
                if (string == null) continue;
                return string;
            }
        }
        return null;
    }

    protected String getRelatesTo(Message message) {
        for (AddressingVersion addressingVersion : AddressingVersion.values()) {
            for (SOAPVersion sOAPVersion : SOAPVersion.values()) {
                String string = message.getHeaders().getRelatesTo(addressingVersion, sOAPVersion);
                if (string == null) continue;
                return string;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public R route(R r) throws Exception {
        void var8_17;
        void var8_15;
        RoutingInfo routingInfo;
        Serializable serializable;
        boolean bl;
        Object object2;
        Message message = ((BaseRoutables)r).packet.getMessage();
        if (LOGGER.isLoggable(Level.FINE)) {
            String string = this.getMessageId(message);
            object2 = "";
            if (string != null) {
                object2 = "ID: " + string;
            }
            LOGGER.fine(this.getClass().getSimpleName() + " handling inbound message " + (String)object2);
        }
        boolean bl2 = bl = this.getRelatesTo(message) != null;
        if (this._clusterRouting != null) {
            if (bl) {
                this._clusterRouting.incrementResponseCount();
            } else {
                this._clusterRouting.incrementRequestCount();
            }
        }
        object2 = RoutingInfoFinderRegistry.getInstance().getFinders();
        if (LOGGER.isLoggable(Level.FINE)) {
            serializable = new StringBuffer("RoutingInfoFinders: ");
            for (int i = 0; i < ((RoutingInfoFinder[])object2).length; ++i) {
                ((StringBuffer)serializable).append(object2[i].getClass().getSimpleName());
                if (i >= ((RoutingInfoFinder[])object2).length - 1) continue;
                ((StringBuffer)serializable).append(", ");
            }
            LOGGER.fine(((StringBuffer)serializable).toString());
        }
        serializable = new HashMap();
        RoutingInfo routingInfo2 = null;
        HeaderList headerList = message.getHeaders();
        for (RoutingInfoFinder routingInfoFinder : object2) {
            try {
                if (routingInfo2 != null && !(routingInfoFinder instanceof AffinityBasedRoutingInfoFinder) || (routingInfo = routingInfoFinder.findRoutingInfo(headerList)) == null) continue;
                if (routingInfo.getType() == RoutingInfo.Type.NEED_BODY) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Finder " + routingInfoFinder + " determined it could find routing info in the SOAP body, allowing it to parse the body now.");
                    }
                    if ((routingInfo = routingInfoFinder.findRoutingInfoFromSoapBody(routingInfo, ((BaseRoutables)r).packet)) == null) {
                        if (!LOGGER.isLoggable(Level.FINE)) continue;
                        LOGGER.fine("Finder " + routingInfoFinder + " did not find routing info in the SOAP body, moving on to next finder");
                        continue;
                    }
                }
                if (routingInfo.getType() == RoutingInfo.Type.ABSTAIN) {
                    if (!(routingInfoFinder instanceof AffinityBasedRoutingInfoFinder)) continue;
                    serializable.put((AffinityBasedRoutingInfoFinder)routingInfoFinder, routingInfo);
                    continue;
                }
                if (routingInfo2 != null) continue;
                routingInfo2 = routingInfo;
            }
            catch (Exception exception) {
                this.logRoutingFailure(exception);
                throw exception;
            }
        }
        if (routingInfo2 != null) {
            S s;
            try {
                s = this.getTargetServerForRouting(routingInfo2);
            }
            catch (DeliveryException deliveryException) {
                String string = "Couldn't get target server for msg ID '" + this.getMessageId(message) + "': " + deliveryException.toString();
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(string);
                }
                this.logRoutingFailure(deliveryException);
                throw new DeliveryException(string, deliveryException);
            }
            if (s != null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Final SOAP routing decision is " + routingInfo2.toString() + " for server: " + s);
                }
                if (this._clusterRouting != null) {
                    if (bl) {
                        this._clusterRouting.incrementRoutedResponseCount();
                    } else {
                        this._clusterRouting.incrementRoutedRequestCount();
                    }
                }
                for (AffinityBasedRoutingInfoFinder affinityBasedRoutingInfoFinder : serializable.keySet()) {
                    routingInfo = (RoutingInfo)serializable.get(affinityBasedRoutingInfoFinder);
                    try {
                        affinityBasedRoutingInfoFinder.recordRoutingIDAffinity(routingInfo, routingInfo2);
                    }
                    catch (Exception exception) {
                        this.logRoutingFailure(exception);
                    }
                }
                try {
                    R r2 = this.deliverMessageToTargetServer(r, s);
                }
                catch (Exception exception) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, "Delivery Failure: " + exception.toString(), exception);
                    }
                    this.logRoutingFailure(exception);
                    throw new DeliveryException(exception.toString(), exception);
                }
            } else {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Couldn't get target server for final SOAP routing decision " + routingInfo2.toString());
                }
                Object var8_12 = null;
            }
        } else {
            Object var8_14 = null;
        }
        if (var8_15 == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("No SOAP routing decision for this message");
            }
            if (serializable.size() > 0) {
                R r3 = this.setAbstainedFinders(r, (Map<AffinityBasedRoutingInfoFinder, RoutingInfo>)((Object)serializable));
            }
        }
        return var8_17;
    }

    public void notifyRoutingDecision(S s, Map<AffinityBasedRoutingInfoFinder, RoutingInfo> map) {
        RoutingInfo routingInfo = this.getRoutingForTargetServer(s);
        for (AffinityBasedRoutingInfoFinder affinityBasedRoutingInfoFinder : map.keySet()) {
            RoutingInfo routingInfo2 = map.get(affinityBasedRoutingInfoFinder);
            try {
                affinityBasedRoutingInfoFinder.recordRoutingIDAffinity(routingInfo2, routingInfo);
            }
            catch (Exception exception) {
                this.logRoutingFailure(exception);
            }
        }
    }

    protected void logRoutingFailure(Exception exception) {
        if (this._clusterRouting != null) {
            this._clusterRouting.incrementRoutingFailureCount();
            this._clusterRouting.setLastRoutingFailure(exception.toString());
            this._clusterRouting.setLastRoutingFailureTime(System.currentTimeMillis());
        }
        if (!(exception instanceof DeliveryException)) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, exception.toString(), exception);
            }
            WseeCoreLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
        }
    }

    public static class BaseRoutables {
        public Packet packet;

        public BaseRoutables(Packet packet) {
            this.packet = packet;
        }
    }
}

