/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.cluster;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.message.Packet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.wsee.jaxws.framework.WsUtil;
import weblogic.wsee.jaxws.persistence.PersistenceConfig;
import weblogic.wsee.runtime.WebServicesRuntime;

public class ClusterInjectionTubeUtils {
    private static final Logger LOGGER = Logger.getLogger(ClusterInjectionTubeUtils.class.getName());
    private WSBinding _binding;
    private PersistenceConfig.Common _persistConfig;

    protected ClusterInjectionTubeUtils(WSBinding wSBinding, PersistenceConfig.Common common) {
        this._binding = wSBinding;
        this._persistConfig = common;
    }

    public Packet processOutboundMessage(Packet packet) {
        block9: {
            Object object;
            if (packet.getMessage() == null || this._binding.getAddressingVersion() == null) {
                return null;
            }
            String string = null;
            if (LOGGER.isLoggable(Level.FINE)) {
                string = packet.getMessage().getHeaders().getMessageID(this._binding.getAddressingVersion(), this._binding.getSOAPVersion());
                LOGGER.fine("ClusterInjectionTubeUtils outbound message ID: " + string);
            }
            AddressingVersion addressingVersion = this._binding.getAddressingVersion();
            SOAPVersion sOAPVersion = this._binding.getSOAPVersion();
            boolean bl = false;
            String string2 = packet.getMessage().getHeaders().getRelatesTo(addressingVersion, sOAPVersion);
            if (string2 == null) {
                object = packet.getMessage().getHeaders().getReplyTo(addressingVersion, sOAPVersion);
                if (object != null && !object.isAnonymous()) {
                    bl = true;
                }
            } else {
                bl = true;
            }
            if (bl) {
                try {
                    boolean bl2;
                    object = this._persistConfig.getLogicalStoreMBean();
                    boolean bl3 = bl2 = !object.getPersistenceStrategy().equals("NETWORK_ACCESSIBLE");
                    if (bl2) {
                        this.injectRoutableMessageId(packet);
                    }
                }
                catch (Exception exception) {
                    if (!LOGGER.isLoggable(Level.INFO)) break block9;
                    LOGGER.info("Unable to inject routable message ID into outgoing message with ID '" + string + ": " + exception.toString());
                }
            }
        }
        return null;
    }

    private void injectRoutableMessageId(Packet packet) {
        List<String> list;
        if (packet.getMessage() == null || this._binding.getAddressingVersion() == null) {
            return;
        }
        String string = packet.getMessage().getHeaders().getMessageID(this._binding.getAddressingVersion(), this._binding.getSOAPVersion());
        if (WsUtil.getStoreNameFromRoutableUUID(string) != null) {
            return;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("ClusterInjectionTubeUtils **INJECTING** message ID into message with old ID: " + packet.getMessage().getHeaders().getMessageID(this._binding.getAddressingVersion(), this._binding.getSOAPVersion()));
        }
        String string2 = (list = WebServicesRuntime.getInstance().getLocalPhysicalStoresForLogicalStore(this._persistConfig.getLogicalStoreName())).size() > 0 ? list.get(0) : null;
        WsUtil.getOrSetMessageID(packet.getMessage(), this._binding.getAddressingVersion(), this._binding.getSOAPVersion(), string2);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("ClusterInjectionTubeUtils **INJECTED** message ID into message: " + packet.getMessage().getHeaders().getMessageID(this._binding.getAddressingVersion(), this._binding.getSOAPVersion()));
        }
    }
}

