/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.cluster;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.api.pipe.helper.AbstractTubeImpl;
import com.sun.xml.ws.api.server.WSEndpoint;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.jws.jaxws.client.async.AsyncClientTransportFeature;
import weblogic.wsee.jaxws.client.async.AsyncResponseEndpoint;
import weblogic.wsee.jaxws.client.async.AsyncTransportProviderPropertyBag;
import weblogic.wsee.jaxws.cluster.ClusterRoutingPropertyBag;
import weblogic.wsee.jaxws.cluster.ClusterRoutingTubeUtils;
import weblogic.wsee.jaxws.cluster.DeliveryException;
import weblogic.wsee.jaxws.framework.WsUtil;
import weblogic.wsee.jaxws.spi.WLSEndpoint;

public class ClusterRoutingClientTube
extends AbstractFilterTubeImpl {
    private static final Logger LOGGER = Logger.getLogger(ClusterRoutingClientTube.class.getName());
    private static Map<String, AsyncResponseCompleteListener> _asyncResponseCompleteListenerMap = new HashMap<String, AsyncResponseCompleteListener>();
    private ClusterRoutingTubeUtils _util;
    private ClientTubeAssemblerContext _context;
    private WSEndpoint _endpoint;

    public ClusterRoutingClientTube(Tube tube, ClientTubeAssemblerContext clientTubeAssemblerContext, WSEndpoint wSEndpoint) {
        super(tube);
        this._context = clientTubeAssemblerContext;
        this._endpoint = wSEndpoint;
        this.commonConstructorCode(clientTubeAssemblerContext, wSEndpoint);
    }

    private void commonConstructorCode(ClientTubeAssemblerContext clientTubeAssemblerContext, WSEndpoint wSEndpoint) {
        this._util = new ClusterRoutingTubeUtils(clientTubeAssemblerContext.getBinding(), wSEndpoint);
    }

    public ClusterRoutingClientTube(ClusterRoutingClientTube clusterRoutingClientTube, TubeCloner tubeCloner) {
        super((AbstractFilterTubeImpl)clusterRoutingClientTube, tubeCloner);
        this._context = clusterRoutingClientTube._context;
        this._endpoint = clusterRoutingClientTube._endpoint;
        this.commonConstructorCode(this._context, this._endpoint);
    }

    void setEndpoint(WSEndpoint wSEndpoint) {
        this._endpoint = wSEndpoint;
        this._util.setEndpoint(wSEndpoint);
    }

    public AbstractTubeImpl copy(TubeCloner tubeCloner) {
        return new ClusterRoutingClientTube(this, tubeCloner);
    }

    public void preDestroy() {
        AsyncResponseCompleteListener asyncResponseCompleteListener;
        if (this._endpoint != null && (asyncResponseCompleteListener = _asyncResponseCompleteListenerMap.remove(this._endpoint.getEndpointId())) != null && asyncResponseCompleteListener.getEndpoint() != null) {
            asyncResponseCompleteListener.getEndpoint().removeResponseProcessingCompletionListener(asyncResponseCompleteListener);
        }
        if (this.next != null) {
            super.preDestroy();
        }
    }

    @NotNull
    public NextAction processRequest(@NotNull Packet packet) {
        return this.doInvoke(this.next, packet);
    }

    @NotNull
    public NextAction processResponse(@NotNull Packet packet) {
        boolean bl;
        boolean bl2 = bl = packet.getSatellite(AsyncTransportProviderPropertyBag.class) != null;
        if (bl) {
            return this.processAsyncResponse(packet);
        }
        return this.doReturnWith(packet);
    }

    private void ensureEndpoint() {
        if (this._endpoint == null) {
            WSEndpoint wSEndpoint;
            AsyncClientTransportFeature asyncClientTransportFeature;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Warning!, ClusterRoutingClientTube " + (Object)((Object)this) + " having to search for endpoint");
            }
            if ((asyncClientTransportFeature = (AsyncClientTransportFeature)this._context.getBinding().getFeature(AsyncClientTransportFeature.class)) != null && (wSEndpoint = ((WLSEndpoint)asyncClientTransportFeature.getEndpoint()).getWSEndpoint()) != null) {
                this.setEndpoint(wSEndpoint);
            }
        }
    }

    @NotNull
    public NextAction processAsyncResponse(@NotNull Packet packet) {
        AsyncTransportProviderPropertyBag asyncTransportProviderPropertyBag = AsyncTransportProviderPropertyBag.propertySetRetriever.getFromPacket(packet);
        try {
            ClusterRoutingPropertyBag clusterRoutingPropertyBag;
            Packet packet2;
            this.ensureEndpoint();
            AsyncResponseCompleteListener asyncResponseCompleteListener = _asyncResponseCompleteListenerMap.get(this._endpoint.getEndpointId());
            if (asyncResponseCompleteListener == null) {
                asyncResponseCompleteListener = new AsyncResponseCompleteListener(asyncTransportProviderPropertyBag.getResponseEndpoint());
                _asyncResponseCompleteListenerMap.put(this._endpoint.getEndpointId(), asyncResponseCompleteListener);
                asyncTransportProviderPropertyBag.getResponseEndpoint().addResponseProcessingCompletionListener(asyncResponseCompleteListener);
            }
            if ((packet2 = this._util.handleInboundMessage(packet)) == null && (clusterRoutingPropertyBag = ClusterRoutingPropertyBag.propertySetRetriever.getFromPacket(packet)).getUncorrelatedAsyncResponse()) {
                String string = null;
                AddressingVersion addressingVersion = this._context.getBinding().getAddressingVersion();
                SOAPVersion sOAPVersion = this._context.getBinding().getSOAPVersion();
                if (addressingVersion != null) {
                    string = packet.getMessage().getHeaders().getMessageID(addressingVersion, sOAPVersion);
                }
                Exception exception = new Exception("Message cannot be processed: " + string);
                exception.fillInStackTrace();
                packet2 = packet.copy(false);
                Message message = WsUtil.createMessageFromThrowable(exception, addressingVersion, sOAPVersion);
                packet2.setMessage(message);
            }
            if (packet2 != null) {
                if (packet2.getMessage() != null) {
                    clusterRoutingPropertyBag = packet2.copy(true);
                    asyncTransportProviderPropertyBag.setResponsePacket((Packet)clusterRoutingPropertyBag);
                }
                clusterRoutingPropertyBag = new NextAction();
                clusterRoutingPropertyBag.abortResponse(packet2);
                return clusterRoutingPropertyBag;
            }
            return this.doReturnWith(packet);
        }
        catch (DeliveryException deliveryException) {
            NextAction nextAction = new NextAction();
            nextAction.throwExceptionAbortResponse((Throwable)deliveryException);
            return nextAction;
        }
        catch (Exception exception) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, exception.toString(), exception);
            }
            return this.doThrow(exception);
        }
    }

    @NotNull
    public NextAction processException(@NotNull Throwable throwable) {
        return this.doThrow(throwable);
    }

    private class AsyncResponseCompleteListener
    implements AsyncResponseEndpoint.ResponseProcessingCompletionListener {
        private WeakReference<AsyncResponseEndpoint> _endpointRef;

        private AsyncResponseCompleteListener(AsyncResponseEndpoint asyncResponseEndpoint) {
            this._endpointRef = new WeakReference<AsyncResponseEndpoint>(asyncResponseEndpoint);
        }

        public AsyncResponseEndpoint getEndpoint() {
            return this._endpointRef != null ? (AsyncResponseEndpoint)this._endpointRef.get() : null;
        }

        public Packet responseProcessingComplete(Packet packet) {
            ClusterRoutingClientTube.this._util.processOutboundMessage(packet);
            return packet;
        }

        public Packet responseProcessingFailed(Packet packet, Throwable throwable) {
            if (packet.outboundHttpHeaders != null && packet.outboundHttpHeaders.containsKey("X-weblogic-wsee-storetoserver-list")) {
                AddressingVersion addressingVersion = ClusterRoutingClientTube.this._context.getBinding().getAddressingVersion();
                SOAPVersion sOAPVersion = ClusterRoutingClientTube.this._context.getBinding().getSOAPVersion();
                Message message = WsUtil.createMessageFromThrowable(throwable, addressingVersion, sOAPVersion);
                String string = message.getHeaders().getAction(addressingVersion, sOAPVersion);
                return packet.createServerResponse(message, addressingVersion, sOAPVersion, string);
            }
            return null;
        }
    }
}

