/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.cluster;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.ServerTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.api.pipe.helper.AbstractTubeImpl;
import com.sun.xml.ws.api.server.TransportBackChannel;
import com.sun.xml.ws.api.server.WSEndpoint;
import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.wsee.jaxws.cluster.ClusterRoutingTubeUtils;

public class ClusterRoutingServerTube
extends AbstractFilterTubeImpl {
    private static final Logger LOGGER = Logger.getLogger(ClusterRoutingServerTube.class.getName());
    private ClusterRoutingTubeUtils _util;
    private ServerTubeAssemblerContext _context;
    private WSEndpoint _endpoint;
    private TransportBackChannel _backChannel;

    public ClusterRoutingServerTube(Tube tube, ServerTubeAssemblerContext serverTubeAssemblerContext, WSEndpoint wSEndpoint) {
        super(tube);
        this._context = serverTubeAssemblerContext;
        this._endpoint = wSEndpoint;
        this.commonConstructorCode(serverTubeAssemblerContext, wSEndpoint);
    }

    private void commonConstructorCode(ServerTubeAssemblerContext serverTubeAssemblerContext, WSEndpoint wSEndpoint) {
        this._util = new ClusterRoutingTubeUtils(serverTubeAssemblerContext.getEndpoint().getBinding(), wSEndpoint);
    }

    public ClusterRoutingServerTube(ClusterRoutingServerTube clusterRoutingServerTube, TubeCloner tubeCloner) {
        super((AbstractFilterTubeImpl)clusterRoutingServerTube, tubeCloner);
        this._context = clusterRoutingServerTube._context;
        this._endpoint = clusterRoutingServerTube._endpoint;
        this.commonConstructorCode(this._context, this._endpoint);
    }

    public AbstractTubeImpl copy(TubeCloner tubeCloner) {
        return new ClusterRoutingServerTube(this, tubeCloner);
    }

    @NotNull
    public NextAction processRequest(@NotNull Packet packet) {
        this._backChannel = packet.keepTransportBackChannelOpen();
        try {
            Packet packet2 = this._util.handleInboundMessage(packet);
            if (packet2 != null) {
                return this.doReturnWith(packet2);
            }
            return this.doInvoke(this.next, packet);
        }
        catch (Exception exception) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, exception.toString(), exception);
            }
            return this.doThrow(exception);
        }
    }

    @NotNull
    public NextAction processResponse(@NotNull Packet packet) {
        packet.transportBackChannel = this._backChannel;
        this._util.processOutboundMessage(packet);
        return this.doReturnWith(packet);
    }

    @NotNull
    public NextAction processException(@NotNull Throwable throwable) {
        return this.doThrow(throwable);
    }
}

