/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.cluster;

import com.sun.istack.Nullable;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.server.WSEndpoint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPMessage;
import weblogic.jws.jaxws.client.async.AsyncClientTransportFeature;
import weblogic.management.runtime.WseePortRuntimeMBean;
import weblogic.management.runtime.WseeV2RuntimeMBean;
import weblogic.wsee.WseeCoreLogger;
import weblogic.wsee.jaxws.cluster.BaseSOAPRouter;
import weblogic.wsee.jaxws.cluster.InPlaceSOAPRouter;
import weblogic.wsee.jaxws.spi.WLSEndpoint;
import weblogic.wsee.jaxws.tubeline.standard.WseeWsaPropertyBag;
import weblogic.wsee.monitoring.WseeClusterRoutingRuntimeMBeanImpl;
import weblogic.wsee.monitoring.WseePortRuntimeMBeanImpl;
import weblogic.wsee.reliability2.compat.SOAPActionHeader;

public class ClusterRoutingTubeUtils {
    private static final Logger LOGGER = Logger.getLogger(ClusterRoutingTubeUtils.class.getName());
    private WSBinding _binding;
    private WSEndpoint _endpoint;
    @Nullable
    private InPlaceSOAPRouter _router;

    protected ClusterRoutingTubeUtils(WSBinding wSBinding, WSEndpoint wSEndpoint) {
        this._binding = wSBinding;
        this._router = null;
        this.setEndpoint(wSEndpoint);
    }

    void setEndpoint(WSEndpoint wSEndpoint) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Set endpoint " + wSEndpoint + " in ClusterRoutingTubeUtils " + this);
        }
        this._endpoint = wSEndpoint;
    }

    private void ensureSOAPRouter() {
        if (this._router == null) {
            WseeClusterRoutingRuntimeMBeanImpl wseeClusterRoutingRuntimeMBeanImpl;
            if (this._endpoint == null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Warning!, ClusterRoutingTubeUtils " + this + " having to search for endpoint");
                }
                if ((wseeClusterRoutingRuntimeMBeanImpl = (AsyncClientTransportFeature)this._binding.getFeature(AsyncClientTransportFeature.class)) != null) {
                    this._endpoint = ((WLSEndpoint)wseeClusterRoutingRuntimeMBeanImpl.getEndpoint()).getWSEndpoint();
                }
            }
            if ((wseeClusterRoutingRuntimeMBeanImpl = ClusterRoutingTubeUtils.getClusterRoutingRuntimeFromEndpoint(this._endpoint)) != null) {
                this._router = new InPlaceSOAPRouter(this._binding, this._endpoint);
                this._router.init(wseeClusterRoutingRuntimeMBeanImpl);
            } else {
                throw new IllegalStateException("ClusterRoutingTubeUtils " + this + " not ready, no WseeClusterRoutingRuntimeMBean/WseeRuntimeMBean");
            }
        }
    }

    public Packet handleInboundMessage(Packet packet) throws Exception {
        if (this._endpoint.getSPI(WseeV2RuntimeMBean.class) != null) {
            this.ensureSOAPRouter();
        }
        if (packet.getMessage() == null || this._router == null) {
            return null;
        }
        BaseSOAPRouter.BaseRoutables baseRoutables = new BaseSOAPRouter.BaseRoutables(packet);
        BaseSOAPRouter.BaseRoutables baseRoutables2 = this._router.route(baseRoutables);
        return baseRoutables2 != null ? baseRoutables2.packet : null;
    }

    public void processOutboundMessage(Packet packet) {
        if (packet.outboundHttpHeaders != null && packet.outboundHttpHeaders.containsKey("X-weblogic-wsee-storetoserver-list")) {
            SOAPMessage sOAPMessage;
            Object object;
            boolean bl;
            WseeWsaPropertyBag wseeWsaPropertyBag = WseeWsaPropertyBag.propertySetRetriever.getFromPacket(packet);
            boolean bl2 = bl = wseeWsaPropertyBag.getResponsePacket() == null && packet.getMessage() == null;
            if (!bl && this._binding.getAddressingVersion() != null) {
                object = packet.getMessage().getHeaders().getTo(this._binding.getAddressingVersion(), this._binding.getSOAPVersion());
                WSEndpointReference wSEndpointReference = sOAPMessage = object != null ? new WSEndpointReference((String)object, this._binding.getAddressingVersion()) : null;
                if (sOAPMessage == null && packet.supports((Object)"com.sun.xml.ws.addressing.WsaPropertyBag.ReplyToFromRequest")) {
                    sOAPMessage = (WSEndpointReference)packet.get((Object)"com.sun.xml.ws.addressing.WsaPropertyBag.ReplyToFromRequest");
                }
                if (sOAPMessage == null && packet.supports((Object)"com.sun.xml.ws.addressing.WsaPropertyBag.FaultToFromRequest")) {
                    sOAPMessage = (WSEndpointReference)packet.get((Object)"com.sun.xml.ws.addressing.WsaPropertyBag.FaultToFromRequest");
                }
                boolean bl3 = bl = sOAPMessage != null && !sOAPMessage.isAnonymous();
            }
            if (bl) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Forcing a secondary response onto the response packet because we have to deliver a Store-to-Server Map back to the front-end router");
                }
                try {
                    Object object2;
                    object = new Packet();
                    sOAPMessage = MessageFactory.newInstance((String)"SOAP 1.1 Protocol").createMessage();
                    Message message = Messages.create((SOAPMessage)sOAPMessage);
                    object.setMessage(message);
                    String string = "http://www.oracle.com/wsee/jaxws/cluster/SecondaryResponse";
                    if (this._binding != null && this._binding.getAddressingVersion() != null) {
                        object2 = new SOAPActionHeader(this._binding.getAddressingVersion().actionTag, string, this._binding.getSOAPVersion());
                        ((SOAPActionHeader)((Object)object2)).setMustUnderstand(true);
                        message.getHeaders().addOrReplace((Header)object2);
                    }
                    object.soapAction = string;
                    object.outboundHttpHeaders = new HashMap(packet.outboundHttpHeaders);
                    object2 = new ArrayList<String>();
                    object2.add("true");
                    object.outboundHttpHeaders.put("X-weblogic-wsee-ignore-this-response", object2);
                    wseeWsaPropertyBag.setResponsePacket((Packet)object);
                    object.transportBackChannel = packet.keepTransportBackChannelOpen();
                }
                catch (Exception exception) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.warning("While forcing a secondary response onto the response packet: " + exception.toString());
                    }
                    WseeCoreLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                }
            }
        }
    }

    @Nullable
    private static WseeClusterRoutingRuntimeMBeanImpl getClusterRoutingRuntimeFromEndpoint(@Nullable WSEndpoint wSEndpoint) {
        WseePortRuntimeMBean wseePortRuntimeMBean = WseePortRuntimeMBeanImpl.getFromEndpoint(wSEndpoint);
        WseeClusterRoutingRuntimeMBeanImpl wseeClusterRoutingRuntimeMBeanImpl = null;
        try {
            if (wseePortRuntimeMBean != null) {
                wseeClusterRoutingRuntimeMBeanImpl = (WseeClusterRoutingRuntimeMBeanImpl)wseePortRuntimeMBean.getClusterRouting();
            }
        }
        catch (Exception exception) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, exception.toString(), exception);
            }
            WseeCoreLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
        }
        return wseeClusterRoutingRuntimeMBeanImpl;
    }
}

