/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.cluster;

import com.sun.xml.ws.api.addressing.OneWayFeature;
import com.sun.xml.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.ServerTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.server.WSEndpointImpl;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.Endpoint;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.w3c.dom.Element;
import weblogic.jws.jaxws.client.async.AsyncClientTransportFeature;
import weblogic.kernel.KernelStatus;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.wsee.jaxws.cluster.ClusterInjectionClientTube;
import weblogic.wsee.jaxws.cluster.ClusterInjectionServerTube;
import weblogic.wsee.jaxws.cluster.ClusterRoutingClientTube;
import weblogic.wsee.jaxws.cluster.ClusterRoutingServerTube;
import weblogic.wsee.jaxws.spi.WLSEndpoint;
import weblogic.wsee.jaxws.tubeline.AbstractTubeFactory;
import weblogic.wsee.jaxws.tubeline.TubelineAssemblerItem;
import weblogic.wsee.jaxws.tubeline.TubelineDeploymentListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterTubelineDeploymentListener
implements TubelineDeploymentListener {
    private static final Logger LOGGER;
    private static final boolean _isClusterServer;

    public static boolean isClusterServer() {
        return _isClusterServer;
    }

    @Override
    public void createClient(ClientTubeAssemblerContext clientTubeAssemblerContext, Set<TubelineAssemblerItem> set) {
        if (!_isClusterServer || clientTubeAssemblerContext.getBinding().getAddressingVersion() == null) {
            return;
        }
        MyInjectionTubeFactory myInjectionTubeFactory = new MyInjectionTubeFactory();
        TubelineAssemblerItem tubelineAssemblerItem = new TubelineAssemblerItem("ClusterInjectionClient", myInjectionTubeFactory);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("WS_SECURITY_1.1");
        tubelineAssemblerItem.setGoAfter(hashSet);
        set.add(tubelineAssemblerItem);
        MyRoutingTubeFactory myRoutingTubeFactory = new MyRoutingTubeFactory();
        TubelineAssemblerItem tubelineAssemblerItem2 = new TubelineAssemblerItem("ClusterRoutingClient", myRoutingTubeFactory);
        HashSet<String> hashSet2 = new HashSet<String>();
        hashSet2.add("WS_SECURITY_1.1");
        tubelineAssemblerItem2.setGoBefore(hashSet2);
        set.add(tubelineAssemblerItem2);
    }

    @Override
    public void createServer(ServerTubeAssemblerContext serverTubeAssemblerContext, Set<TubelineAssemblerItem> set) {
        HashSet<String> hashSet;
        TubelineAssemblerItem tubelineAssemblerItem;
        AbstractTubeFactory abstractTubeFactory;
        if (!_isClusterServer) {
            return;
        }
        if (serverTubeAssemblerContext.getEndpoint().getBinding().getAddressingVersion() != null) {
            abstractTubeFactory = new MyInjectionTubeFactory();
            tubelineAssemblerItem = new TubelineAssemblerItem("ClusterInjectionServer", abstractTubeFactory);
            hashSet = new HashSet<String>();
            hashSet.add("WS_SECURITY_1.1");
            tubelineAssemblerItem.setGoBefore(hashSet);
            set.add(tubelineAssemblerItem);
        }
        abstractTubeFactory = new MyRoutingTubeFactory();
        tubelineAssemblerItem = new TubelineAssemblerItem("ClusterRoutingServer", abstractTubeFactory);
        hashSet = new HashSet();
        hashSet.add("WS_SECURITY_1.1");
        tubelineAssemblerItem.setGoAfter(hashSet);
        set.add(tubelineAssemblerItem);
    }

    static {
        AuthenticatedSubject authenticatedSubject;
        RuntimeAccess runtimeAccess;
        LOGGER = Logger.getLogger(ClusterTubelineDeploymentListener.class.getName());
        _isClusterServer = KernelStatus.isServer() ? (runtimeAccess = ManagementService.getRuntimeAccess(authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction()))).getServer().getCluster() != null : false;
    }

    private static class MyAsyncEndpointListener
    implements AsyncClientTransportFeature.AsyncEndpointListener {
        MyRoutingTubeFactory _listener;
        ClientTubeAssemblerContext _context;
        AsyncClientTransportFeature _feature;
        ClusterRoutingClientTube _routingTube;

        public MyAsyncEndpointListener(MyRoutingTubeFactory myRoutingTubeFactory, ClientTubeAssemblerContext clientTubeAssemblerContext, AsyncClientTransportFeature asyncClientTransportFeature, ClusterRoutingClientTube clusterRoutingClientTube) {
            this._listener = myRoutingTubeFactory;
            this._context = clientTubeAssemblerContext;
            this._feature = asyncClientTransportFeature;
            this._routingTube = clusterRoutingClientTube;
        }

        public void endpointSet(AsyncClientTransportFeature asyncClientTransportFeature) {
            Endpoint endpoint = asyncClientTransportFeature.getEndpoint();
            if (endpoint instanceof WLSEndpoint) {
                WLSEndpoint wLSEndpoint = (WLSEndpoint)endpoint;
                this._routingTube.setEndpoint(wLSEndpoint.getWSEndpoint());
            }
        }

        public void endpointPublished(AsyncClientTransportFeature asyncClientTransportFeature) {
            if (LOGGER.isLoggable(Level.FINE) && asyncClientTransportFeature.getEndpoint() != null) {
                Endpoint endpoint = asyncClientTransportFeature.getEndpoint();
                W3CEndpointReference w3CEndpointReference = (W3CEndpointReference)endpoint.getEndpointReference(W3CEndpointReference.class, new Element[0]);
                LOGGER.fine("Cluster routing client tube deployment listener " + this._listener + " detected that feature " + asyncClientTransportFeature + " with endpoint " + w3CEndpointReference + " is now published");
            }
            asyncClientTransportFeature.removeAsyncEndpointListener((AsyncClientTransportFeature.AsyncEndpointListener)this);
            this.endpointSet(asyncClientTransportFeature);
        }

        public void endpointDisposed(AsyncClientTransportFeature asyncClientTransportFeature) {
            asyncClientTransportFeature.removeAsyncEndpointListener((AsyncClientTransportFeature.AsyncEndpointListener)this);
        }
    }

    private static class MyRoutingTubeFactory
    extends AbstractTubeFactory {
        public Tube createClient(Tube tube, ClientTubeAssemblerContext clientTubeAssemblerContext) {
            AsyncClientTransportFeature asyncClientTransportFeature;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Cluster RoutingTubeFactory.createClient(" + clientTubeAssemblerContext.getAddress() + ") with isClusterServer=" + _isClusterServer);
            }
            ClusterRoutingClientTube clusterRoutingClientTube = null;
            if (_isClusterServer && (asyncClientTransportFeature = (AsyncClientTransportFeature)clientTubeAssemblerContext.getBinding().getFeature(AsyncClientTransportFeature.class)) != null) {
                ClusterRoutingClientTube clusterRoutingClientTube2;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Cluster deployment listener " + this + " setting up client tubes for client with AsyncClientTransportFeature " + asyncClientTransportFeature);
                }
                clusterRoutingClientTube = clusterRoutingClientTube2 = new ClusterRoutingClientTube(tube, clientTubeAssemblerContext, null);
                MyAsyncEndpointListener myAsyncEndpointListener = new MyAsyncEndpointListener(this, clientTubeAssemblerContext, asyncClientTransportFeature, clusterRoutingClientTube2);
                if (asyncClientTransportFeature.isEndpointPublished()) {
                    myAsyncEndpointListener.endpointPublished(asyncClientTransportFeature);
                } else {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Cluster deployment listener " + this + " listening for future endpoint publish on  AsyncClientTransportFeature " + asyncClientTransportFeature);
                    }
                    asyncClientTransportFeature.addAsyncEndpointListener((AsyncClientTransportFeature.AsyncEndpointListener)myAsyncEndpointListener);
                }
            }
            return clusterRoutingClientTube;
        }

        public Tube createServer(Tube tube, ServerTubeAssemblerContext serverTubeAssemblerContext) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Cluster RoutingTubeFactory.createServer(" + serverTubeAssemblerContext.getEndpoint() + ") with isClusterServer=" + _isClusterServer);
            }
            ClusterRoutingServerTube clusterRoutingServerTube = null;
            if (_isClusterServer) {
                WSEndpoint wSEndpoint = serverTubeAssemblerContext.getEndpoint();
                clusterRoutingServerTube = new ClusterRoutingServerTube(tube, serverTubeAssemblerContext, wSEndpoint);
            }
            return clusterRoutingServerTube;
        }
    }

    private static class MyInjectionTubeFactory
    extends AbstractTubeFactory {
        public Tube createClient(Tube tube, ClientTubeAssemblerContext clientTubeAssemblerContext) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Cluster InjectionTubeFactory.createClient(" + clientTubeAssemblerContext.getAddress() + ") with isClusterServer=" + _isClusterServer);
            }
            ClusterInjectionClientTube clusterInjectionClientTube = null;
            if (_isClusterServer) {
                WebServiceFeature webServiceFeature = clientTubeAssemblerContext.getBinding().getFeature(AsyncClientTransportFeature.class);
                if (webServiceFeature == null) {
                    webServiceFeature = clientTubeAssemblerContext.getBinding().getFeature(OneWayFeature.class);
                }
                if (webServiceFeature != null) {
                    clusterInjectionClientTube = new ClusterInjectionClientTube(tube, clientTubeAssemblerContext);
                }
            }
            return clusterInjectionClientTube;
        }

        public Tube createServer(Tube tube, ServerTubeAssemblerContext serverTubeAssemblerContext) {
            WSEndpoint wSEndpoint;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Cluster InjectionTubeFactory.createServer(" + serverTubeAssemblerContext.getEndpoint() + ") with isClusterServer=" + _isClusterServer);
            }
            ClusterInjectionServerTube clusterInjectionServerTube = null;
            if (_isClusterServer && (wSEndpoint = serverTubeAssemblerContext.getEndpoint()) instanceof WSEndpointImpl) {
                clusterInjectionServerTube = new ClusterInjectionServerTube(tube, serverTubeAssemblerContext);
            }
            return clusterInjectionServerTube;
        }
    }
}

