/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.cluster;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.EndpointAddress;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.fastinfoset.FastInfosetFeature;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.Codec;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.helper.PipeAdapter;
import com.sun.xml.ws.api.server.BoundEndpoint;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.transport.http.WSHTTPConnection;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.xml.ws.WebServiceFeature;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.protocol.Protocol;
import weblogic.protocol.ProtocolManager;
import weblogic.protocol.URLManager;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.encoders.BASE64Encoder;
import weblogic.wsee.WseeCoreLogger;
import weblogic.wsee.jaxws.cluster.BaseSOAPRouter;
import weblogic.wsee.jaxws.cluster.DeliveryException;
import weblogic.wsee.jaxws.cluster.spi.AffinityBasedRoutingInfoFinder;
import weblogic.wsee.jaxws.cluster.spi.RoutableIDMapServiceRegistry;
import weblogic.wsee.jaxws.cluster.spi.RoutingInfo;
import weblogic.wsee.jaxws.cluster.spi.ServerNameMapService;
import weblogic.wsee.runtime.WebServicesRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InPlaceSOAPRouter
extends BaseSOAPRouter<String, BaseSOAPRouter.BaseRoutables> {
    private static final Logger LOGGER = Logger.getLogger(InPlaceSOAPRouter.class.getName());
    private static final AuthenticatedSubject _kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final RuntimeAccess _runtimeAccess = ManagementService.getRuntimeAccess(_kernelId);
    private WSBinding _binding;
    private WSEndpoint _endpoint;
    private MessageDigest _sha;
    private final BASE64Encoder _base64 = new BASE64Encoder();
    private Pipe _transportPipe;
    private static long _lastStoreToServerListDeliveryTime = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InPlaceSOAPRouter(WSBinding wSBinding, WSEndpoint wSEndpoint) {
        Codec codec2;
        this._binding = wSBinding;
        this._endpoint = wSEndpoint;
        FastInfosetFeature fastInfosetFeature = new FastInfosetFeature(false);
        try {
            ((BindingImpl)wSBinding).addFeature((WebServiceFeature)fastInfosetFeature);
            codec2 = ((BindingImpl)wSBinding).createCodec();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            fastInfosetFeature = new FastInfosetFeature(true);
            ((BindingImpl)wSBinding).addFeature((WebServiceFeature)fastInfosetFeature);
            throw throwable;
        }
        fastInfosetFeature = new FastInfosetFeature(true);
        ((BindingImpl)wSBinding).addFeature((WebServiceFeature)fastInfosetFeature);
        this._transportPipe = PipeAdapter.adapt((Tube)new ClientTubeAssemblerContext(null, null, null, this._binding, null, codec2).createTransportTube());
        this._binding = wSBinding;
        this._endpoint = wSEndpoint;
        try {
            this._sha = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            LOGGER.warning("MessageDigest error on getting SHA-256, changing to SHA-1 instead...");
            try {
                this._sha = MessageDigest.getInstance("SHA-1");
            }
            catch (Exception exception) {
                WseeCoreLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
            }
        }
    }

    @Override
    protected String getMessageId(Message message) {
        if (this._binding.getAddressingVersion() != null) {
            return message.getHeaders().getMessageID(this._binding.getAddressingVersion(), this._binding.getSOAPVersion());
        }
        return super.getMessageId(message);
    }

    @Override
    protected String getRelatesTo(Message message) {
        if (this._binding.getAddressingVersion() != null) {
            return message.getHeaders().getRelatesTo(this._binding.getAddressingVersion(), this._binding.getSOAPVersion());
        }
        return super.getRelatesTo(message);
    }

    @Override
    public BaseSOAPRouter.BaseRoutables route(BaseSOAPRouter.BaseRoutables baseRoutables) throws Exception {
        Packet packet;
        Map<String, List<String>> map = this.getOutboundHttpHeaders(baseRoutables.packet);
        BaseSOAPRouter.BaseRoutables baseRoutables2 = super.route(baseRoutables);
        Packet packet2 = packet = baseRoutables2 != null ? baseRoutables2.packet : null;
        if (packet == null) {
            packet = baseRoutables.packet;
        }
        if (packet != null) {
            if (packet.outboundHttpHeaders == null) {
                packet.outboundHttpHeaders = map;
            } else {
                packet.outboundHttpHeaders.putAll(map);
            }
        }
        return baseRoutables2;
    }

    @Override
    protected String getTargetServerForRouting(@NotNull RoutingInfo routingInfo) throws DeliveryException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(this.getClass().getSimpleName() + " getting target server name for routing info: " + routingInfo);
        }
        String string = null;
        switch (routingInfo.getType()) {
            case ABSTAIN: {
                return null;
            }
            case PHYSICAL_STORE_NAME: {
                string = WebServicesRuntime.getInstance().getServerNameForPhysicalStore(routingInfo.getName());
                if (string != null) break;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Couldn't find server hosting persistent store '" + routingInfo.getName() + "'");
                }
                throw new DeliveryException("Couldn't find server hosting persistent store: " + routingInfo.getName());
            }
            case SERVER_NAME: {
                string = routingInfo.getName();
            }
        }
        if (_runtimeAccess.getServerName().equals(string)) {
            string = null;
        }
        return string;
    }

    @Override
    protected RoutingInfo getRoutingForTargetServer(String string) {
        return new RoutingInfo(string, RoutingInfo.Type.SERVER_NAME);
    }

    @Override
    protected BaseSOAPRouter.BaseRoutables deliverMessageToTargetServer(BaseSOAPRouter.BaseRoutables baseRoutables, String string) throws Exception {
        Serializable serializable;
        Object object;
        Set set;
        String string2;
        String string3;
        block8: {
            string3 = "";
            if (this._binding.getAddressingVersion() != null) {
                string3 = "ID: " + baseRoutables.packet.getMessage().getHeaders().getMessageID(this._binding.getAddressingVersion(), this._binding.getSOAPVersion());
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("ClusterRoutingTubeUtils **ROUTING** inbound message " + string3 + " to server " + string);
            }
            string2 = null;
            try {
                string2 = baseRoutables.packet.webServiceContextDelegate.getEPRAddress(baseRoutables.packet, this._endpoint);
            }
            catch (Exception exception) {
                set = this._endpoint.getBoundEndpoints();
                if (!set.isEmpty()) {
                    object = (BoundEndpoint)set.iterator().next();
                    serializable = object.getAddress();
                    serializable = new URI("http", ((URI)serializable).getUserInfo(), ((URI)serializable).getHost(), ((URI)serializable).getPort(), ((URI)serializable).getPath(), ((URI)serializable).getQuery(), ((URI)serializable).getFragment());
                    string2 = ((URI)serializable).toString();
                }
                if (string2 != null) break block8;
                throw new IllegalStateException("Couldn't determine the endpoint address for this endpoint");
            }
        }
        URL uRL = new URL(string2);
        set = ProtocolManager.findProtocol((String)uRL.getProtocol());
        if (set.isSecure() && this.isSslTerminationInUse(baseRoutables.packet)) {
            object = set.getProtocolName();
            object = ((String)object).substring(0, ((String)object).length() - 1);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("InPlaceSOAPRouter *downgrading* protocol from " + set + " to " + (String)object);
            }
            set = ProtocolManager.findProtocol((String)object);
        }
        object = URLManager.findURL(string, (Protocol)set);
        serializable = new URL((String)object);
        URL uRL2 = new URL(((URL)serializable).getProtocol(), ((URL)serializable).getHost(), ((URL)serializable).getPort(), uRL.getFile());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(this.getClass().getSimpleName() + " **ROUTING** inbound message " + string3 + " to server " + string + " Target URL: " + uRL2.toExternalForm());
        }
        baseRoutables.packet.endpointAddress = new EndpointAddress(uRL2.toExternalForm());
        this.copySSLHeadersForForwarding(baseRoutables.packet);
        Packet packet = this._transportPipe.process(baseRoutables.packet);
        return new BaseSOAPRouter.BaseRoutables(packet);
    }

    private boolean isSslTerminationInUse(Packet packet) {
        if (packet.supports((Object)"javax.xml.ws.servlet.request")) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)packet.get((Object)"javax.xml.ws.servlet.request");
            String string = httpServletRequest.getHeader("WL-Proxy-SSL");
            return Boolean.valueOf(string);
        }
        return false;
    }

    private void copySSLHeadersForForwarding(Packet packet) {
        if (packet.supports((Object)"javax.xml.ws.servlet.request")) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)packet.get((Object)"javax.xml.ws.servlet.request");
            this.copyHeaderForForwarding("WL-Proxy-SSL", httpServletRequest, packet);
            this.copyHeaderForForwarding("WL-Proxy-Client-Cert", httpServletRequest, packet);
            this.copyHeaderForForwarding("WL-Proxy-Client-IP", httpServletRequest, packet);
        }
    }

    private void copyHeaderForForwarding(String string, HttpServletRequest httpServletRequest, Packet packet) {
        String string2;
        HashMap<String, List<String>> hashMap = (HashMap<String, List<String>>)packet.invocationProperties.get("javax.xml.ws.http.request.headers");
        if (hashMap == null) {
            hashMap = new HashMap<String, List<String>>();
            packet.invocationProperties.put("javax.xml.ws.http.request.headers", hashMap);
        }
        if ((string2 = httpServletRequest.getHeader(string)) != null) {
            hashMap.put(string, Arrays.asList(string2));
        }
    }

    @Override
    protected BaseSOAPRouter.BaseRoutables setAbstainedFinders(BaseSOAPRouter.BaseRoutables baseRoutables, Map<AffinityBasedRoutingInfoFinder, RoutingInfo> map) {
        return null;
    }

    private Map<String, List<String>> getOutboundHttpHeaders(Packet packet) {
        boolean bl;
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        WSHTTPConnection wSHTTPConnection = (WSHTTPConnection)packet.getSatellite(WSHTTPConnection.class);
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (wSHTTPConnection != null) {
            bl2 = RoutableIDMapServiceRegistry.getInstance().hasNewInfoSince(_lastStoreToServerListDeliveryTime);
            bl3 = wSHTTPConnection.getRequestHeader("X-weblogic-wsee-request-storetoserver-list") != null;
            bl4 = wSHTTPConnection.getRequestHeader("X-weblogic-wsee-storetoserver-accepted") != null;
        }
        boolean bl5 = bl = wSHTTPConnection != null && (bl3 || bl4 && bl2);
        if (bl) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("InPlaceSOAPRouter placing output HTTP headers with Store->Server Map info. ListRequested=" + bl3 + " ListAccepted=" + bl4 + " NewListInfo=" + bl2);
            }
            _lastStoreToServerListDeliveryTime = System.currentTimeMillis();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Map<String, String> map = RoutableIDMapServiceRegistry.getInstance().getCurrentRoutableIDToServerMap();
            if (map.size() > 0) {
                Object object;
                String string2;
                StringBuffer stringBuffer = new StringBuffer();
                for (String string2 : map.keySet()) {
                    stringBuffer.append(string2);
                    stringBuffer.append("/");
                    object = map.get(string2);
                    ServerNameMapService.ServerAddress serverAddress = RoutableIDMapServiceRegistry.getInstance().getServerAddress((String)object);
                    Object object2 = serverAddress != null ? (String)object + ":" + serverAddress.host + ":" + serverAddress.port + ":" + serverAddress.sslPort : object;
                    stringBuffer.append((String)object2);
                    stringBuffer.append("|");
                }
                if (stringBuffer.charAt(stringBuffer.length() - 1) == '|') {
                    stringBuffer.setLength(stringBuffer.length() - 1);
                }
                String string3 = stringBuffer.toString();
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Adding StoreToServerList string to outbound HTTP headers: " + (String)string3);
                }
                arrayList.add(string3);
                string2 = this.calculateHash(string3);
                object = new ArrayList();
                object.add(string2);
                hashMap.put("X-weblogic-wsee-storetoserver-list", arrayList);
                hashMap.put("X-weblogic-wsee-storetoserver-hash", (List<String>)object);
                if (packet.outboundHttpHeaders == null) {
                    packet.outboundHttpHeaders = hashMap;
                } else {
                    packet.outboundHttpHeaders.putAll(hashMap);
                }
            }
        }
        return hashMap;
    }

    private String calculateHash(String string) {
        this._sha.reset();
        byte[] byArray = this._sha.digest(string.getBytes());
        String string2 = this._base64.encodeBuffer(byArray);
        return string2.substring(0, string2.length() - 1);
    }
}

