/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.cluster.proxy;

import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.streaming.XMLStreamReaderFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLStreamReader;
import weblogic.management.ManagementException;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.servlet.proxy.HttpClusterServlet;
import weblogic.servlet.proxy.RoutingHandler;
import weblogic.utils.io.Chunk;
import weblogic.utils.io.ChunkedInputStream;
import weblogic.wsee.WseeCoreLogger;
import weblogic.wsee.jaxws.cluster.proxy.FrontEndRoutables;
import weblogic.wsee.jaxws.cluster.proxy.FrontEndSOAPRouter;
import weblogic.wsee.jaxws.cluster.spi.RoutingInfo;
import weblogic.wsee.jaxws.security.SCTIDRoutingInfoFinder;
import weblogic.wsee.mc.cluster.McAnonIDRoutingInfoFinder;
import weblogic.wsee.monitoring.WseeClusterFrontEndRuntimeMBeanImpl;
import weblogic.wsee.monitoring.WseeClusterRoutingRuntimeMBeanImpl;
import weblogic.wsee.monitoring.WseeRuntimeMBeanDelegate;
import weblogic.wsee.reliability2.tube.SequenceIDRoutingInfoFinder;

public class SOAPRoutingHandler
implements RoutingHandler,
HttpClusterServlet.ServerListListener {
    private static RuntimeAccess _runtimeAccess;
    private static final Logger LOGGER;
    public static final String EOL = "\r\n";
    public static final String X_WEBLOGIC_WSEE_STORETOSERVER_LIST_ACCEPTED = "X-weblogic-wsee-storetoserver-accepted";
    public static final String X_WEBLOGIC_WSEE_REQUEST_STORETOSERVER_LIST = "X-weblogic-wsee-request-storetoserver-list";
    public static final String X_WEBLOGIC_WSEE_IGNORE_THIS_RESPONSE = "X-weblogic-wsee-ignore-this-response";
    public static final String X_WEBLOGIC_WSEE_STORETOSERVER_HASH = "X-weblogic-wsee-storetoserver-hash";
    public static final String X_WEBLOGIC_WSEE_STORETOSERVER_LIST = "X-weblogic-wsee-storetoserver-list";
    private HttpClusterServlet _servlet;
    private WseeClusterFrontEndRuntimeMBeanImpl _clusterFrontEndMBean;
    private WseeClusterRoutingRuntimeMBeanImpl _clusterRoutingMBean;
    private FrontEndSOAPRouter _router;
    private ReentrantReadWriteLock _mapLock = new ReentrantReadWriteLock();
    private Map<String, HttpClusterServlet.Server> _storeNameToServerMap;
    private Map<String, HttpClusterServlet.Server> _serverNameToServerMap;
    private Map<HttpClusterServlet.Server, String> _serverToServerNameMap;
    private ReentrantReadWriteLock _hashLock = new ReentrantReadWriteLock();
    private String _currentStoreToServerMapHash;
    private String _pendingStoreToServerMapHash;
    private String _pendingStoreToServerMapString;
    private boolean _dummyServerCreated;

    public SOAPRoutingHandler() throws ManagementException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("SOAP routing handler created");
        }
        this._currentStoreToServerMapHash = null;
        this._storeNameToServerMap = new HashMap<String, HttpClusterServlet.Server>();
        this._serverNameToServerMap = new HashMap<String, HttpClusterServlet.Server>();
        this._serverToServerNameMap = new HashMap<HttpClusterServlet.Server, String>();
        this._router = new FrontEndSOAPRouter(this);
    }

    public void init(HttpClusterServlet httpClusterServlet) {
        this._servlet = httpClusterServlet;
        this._servlet.addServerListChangeListener(this);
        String string = this._servlet.getServletContext().getContextPath() + "/" + this._servlet.getServletName();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("SOAP routing handler init called for: " + string);
        }
        try {
            this._clusterFrontEndMBean = new WseeClusterFrontEndRuntimeMBeanImpl(string, _runtimeAccess.getServerRuntime());
            this._clusterRoutingMBean = (WseeClusterRoutingRuntimeMBeanImpl)this._clusterFrontEndMBean.getClusterRouting();
            _runtimeAccess.getServerRuntime().setWseeClusterFrontEndRuntime(this._clusterFrontEndMBean);
            this._router.init(this._clusterRoutingMBean);
        }
        catch (Exception exception) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, exception.toString(), exception);
            }
            WseeCoreLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
        }
    }

    public void destroy() {
        try {
            this._clusterRoutingMBean.unregister();
        }
        catch (Exception exception) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, exception.toString(), exception);
            }
            WseeCoreLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
        }
        try {
            this._clusterFrontEndMBean.unregister();
        }
        catch (Exception exception) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, exception.toString(), exception);
            }
            WseeCoreLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
        }
        this._servlet.removeServerListChangeListener(this);
    }

    /*
     * Loose catch block
     */
    public HttpClusterServlet.RequestInfo route(HttpClusterServlet.RequestInfo requestInfo, HttpServletRequest httpServletRequest) throws Exception {
        HttpClusterServlet.RequestInfo requestInfo2;
        long l;
        String string;
        XMLStreamReader xMLStreamReader;
        InputStream inputStream;
        block32: {
            FrontEndRoutables frontEndRoutables;
            block29: {
                HttpClusterServlet.RequestInfo requestInfo3;
                block30: {
                    block26: {
                        HttpClusterServlet.RequestInfo requestInfo4;
                        block27: {
                            String string2 = httpServletRequest.getContentType();
                            if (string2 == null) {
                                return null;
                            }
                            if (!string2.startsWith("text/xml") && !string2.startsWith("application/xml")) {
                                return null;
                            }
                            String string3 = httpServletRequest.getHeader("SOAPAction");
                            if (string3 == null) {
                                return null;
                            }
                            if (LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.fine("SOAPRoutingHandler handling incoming SOAP message with action: " + string3);
                            }
                            if ((inputStream = requestInfo.getInputStream()) == null) {
                                String string4 = "SOAPRoutingHandler supports only HTTP POST with chunked data streaming.";
                                if (LOGGER.isLoggable(Level.FINE)) {
                                    LOGGER.fine(string4);
                                }
                                this._clusterRoutingMBean.setLastRoutingFailure(string4);
                                this._clusterRoutingMBean.setLastRoutingFailureTime(System.currentTimeMillis());
                                this._clusterRoutingMBean.incrementRoutingFailureCount();
                                return null;
                            }
                            int n = 1000000;
                            xMLStreamReader = null;
                            string = null;
                            l = 0L;
                            inputStream.mark(n);
                            xMLStreamReader = XMLStreamReaderFactory.create(null, (InputStream)inputStream, (boolean)false);
                            Message message = Messages.create((XMLStreamReader)xMLStreamReader);
                            Packet packet = new Packet();
                            packet.setMessage(message);
                            FrontEndRoutables frontEndRoutables2 = new FrontEndRoutables(requestInfo, packet);
                            frontEndRoutables = this._router.route(frontEndRoutables2);
                            if (frontEndRoutables != null) break block26;
                            requestInfo4 = null;
                            Object var18_19 = null;
                            if (string != null) {
                                this._clusterRoutingMBean.setLastRoutingFailure(string);
                                this._clusterRoutingMBean.incrementRoutingFailureCount();
                                this._clusterRoutingMBean.setLastRoutingFailureTime(l);
                            }
                            if (xMLStreamReader == null) break block27;
                            XMLStreamReaderFactory.recycle((XMLStreamReader)xMLStreamReader);
                        }
                        try {
                            inputStream.reset();
                        }
                        catch (Exception exception) {
                            if (LOGGER.isLoggable(Level.SEVERE)) {
                                LOGGER.log(Level.SEVERE, exception.toString(), exception);
                            }
                            WseeCoreLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                        }
                        return requestInfo4;
                    }
                    if (frontEndRoutables.abstainers == null) break block29;
                    Map<RoutingHandler, Object> map = requestInfo.getNotificationData();
                    map.put(this, frontEndRoutables.abstainers);
                    requestInfo3 = null;
                    Object var18_20 = null;
                    if (string != null) {
                        this._clusterRoutingMBean.setLastRoutingFailure(string);
                        this._clusterRoutingMBean.incrementRoutingFailureCount();
                        this._clusterRoutingMBean.setLastRoutingFailureTime(l);
                    }
                    if (xMLStreamReader == null) break block30;
                    XMLStreamReaderFactory.recycle((XMLStreamReader)xMLStreamReader);
                }
                try {
                    inputStream.reset();
                }
                catch (Exception exception) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, exception.toString(), exception);
                    }
                    WseeCoreLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                }
                return requestInfo3;
            }
            requestInfo2 = frontEndRoutables.ri;
            Object var18_21 = null;
            if (string != null) {
                this._clusterRoutingMBean.setLastRoutingFailure(string);
                this._clusterRoutingMBean.incrementRoutingFailureCount();
                this._clusterRoutingMBean.setLastRoutingFailureTime(l);
            }
            if (xMLStreamReader == null) break block32;
            XMLStreamReaderFactory.recycle((XMLStreamReader)xMLStreamReader);
        }
        try {
            inputStream.reset();
        }
        catch (Exception exception) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, exception.toString(), exception);
            }
            WseeCoreLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
        }
        return requestInfo2;
        catch (Exception exception) {
            try {
                string = exception.toString();
                l = System.currentTimeMillis();
                throw exception;
            }
            catch (Throwable throwable) {
                Object var18_22 = null;
                if (string != null) {
                    this._clusterRoutingMBean.setLastRoutingFailure(string);
                    this._clusterRoutingMBean.incrementRoutingFailureCount();
                    this._clusterRoutingMBean.setLastRoutingFailureTime(l);
                }
                if (xMLStreamReader != null) {
                    XMLStreamReaderFactory.recycle((XMLStreamReader)xMLStreamReader);
                }
                try {
                    inputStream.reset();
                }
                catch (Exception exception2) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, exception2.toString(), exception2);
                    }
                    WseeCoreLogger.logUnexpectedException((String)exception2.toString(), (Throwable)exception2);
                }
                throw throwable;
            }
        }
    }

    public void addRequestHeaders(HttpServletRequest httpServletRequest, PrintStream printStream, HttpClusterServlet.RequestInfo requestInfo, HttpClusterServlet.Server server) {
        if (this.needNewStoreToServerList()) {
            printStream.print("X-weblogic-wsee-request-storetoserver-list: " + this.getHash());
            printStream.print(EOL);
        }
        printStream.print("X-weblogic-wsee-storetoserver-accepted: true");
        printStream.print(EOL);
    }

    public boolean handleResponseHeader(HttpServletResponse httpServletResponse, String string, String string2, HttpClusterServlet.RequestInfo requestInfo) {
        if (string.equals(X_WEBLOGIC_WSEE_STORETOSERVER_LIST)) {
            this.setPendingStoreToServerMap(string2);
            return true;
        }
        if (string.equals(X_WEBLOGIC_WSEE_STORETOSERVER_HASH)) {
            this.setPendingStoreToServerMapHash(string2);
            return true;
        }
        if (string.equals(X_WEBLOGIC_WSEE_IGNORE_THIS_RESPONSE)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Ignoring router-induced response from primary server: " + requestInfo.getPrimaryServer());
            }
            httpServletResponse.setStatus(202);
            try {
                httpServletResponse.getOutputStream().close();
            }
            catch (Exception exception) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.warning("While trying to ignore router-induced response: " + exception.toString());
                }
                WseeCoreLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean needNewStoreToServerList() {
        try {
            this._hashLock.readLock().lock();
            boolean bl = this._currentStoreToServerMapHash == null || this._dummyServerCreated;
            Object var3_2 = null;
            this._hashLock.readLock().unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._hashLock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getHash() {
        try {
            this._hashLock.readLock().lock();
            String string = this._currentStoreToServerMapHash;
            Object var3_2 = null;
            this._hashLock.readLock().unlock();
            return string;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._hashLock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPendingStoreToServerMap(String string) {
        try {
            this._hashLock.writeLock().lock();
            this._pendingStoreToServerMapString = string;
            if (this._pendingStoreToServerMapHash != null) {
                this.parseMapIfNeeded();
            }
            Object var3_2 = null;
            this._hashLock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._hashLock.writeLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPendingStoreToServerMapHash(String string) {
        try {
            this._hashLock.writeLock().lock();
            this._pendingStoreToServerMapHash = string;
            if (this._pendingStoreToServerMapString != null) {
                this.parseMapIfNeeded();
            }
            Object var3_2 = null;
            this._hashLock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._hashLock.writeLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requestUpdatedStoreToServerMap() {
        try {
            this._hashLock.writeLock().lock();
            this._pendingStoreToServerMapHash = null;
            Object var2_1 = null;
            this._hashLock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this._hashLock.writeLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseMapIfNeeded() {
        ParsedMaps parsedMaps = null;
        if (this._currentStoreToServerMapHash == null || this._pendingStoreToServerMapHash != null && !this._currentStoreToServerMapHash.equals(this._pendingStoreToServerMapHash)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Replacing store/server map with new contents: " + this._pendingStoreToServerMapString);
            }
            parsedMaps = this.parseMap(this._pendingStoreToServerMapString);
            this._currentStoreToServerMapHash = this._pendingStoreToServerMapHash;
            this._pendingStoreToServerMapHash = null;
            this._pendingStoreToServerMapString = null;
        }
        if (parsedMaps != null) {
            try {
                this._mapLock.writeLock().lock();
                this._dummyServerCreated = parsedMaps.dummyServerCreated;
                this._storeNameToServerMap = parsedMaps.storeNameToServerMap;
                this._serverNameToServerMap = parsedMaps.serverNameToServerMap;
                this._serverToServerNameMap = parsedMaps.serverToServerNameMap;
                Object var3_2 = null;
                this._mapLock.writeLock().unlock();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this._mapLock.writeLock().unlock();
                throw throwable;
            }
        }
    }

    private ParsedMaps parseMap(String string) {
        ParsedMaps parsedMaps = new ParsedMaps();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            this.parseStoreServerTupple(string2, parsedMaps);
        }
        return parsedMaps;
    }

    private void parseStoreServerTupple(String string, ParsedMaps parsedMaps) {
        int n = string.indexOf("/");
        if (n > 0) {
            Object object;
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ":");
            int n2 = 0;
            String string4 = "";
            String string5 = "";
            int n3 = -1;
            int n4 = -1;
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken().trim();
                switch (n2) {
                    case 0: {
                        string4 = object;
                        break;
                    }
                    case 1: {
                        string5 = object;
                        break;
                    }
                    case 2: {
                        n3 = Integer.parseInt((String)object);
                        break;
                    }
                    case 3: {
                        n4 = Integer.parseInt((String)object);
                        break;
                    }
                }
                ++n2;
            }
            object = this._servlet.getServerList().getByHostAndPort(string5, n3);
            if (object == null) {
                LOGGER.warning("WARNING: Didn't find servlet Server definition matching " + string4 + ":" + string5 + ":" + n3 + ". We'll create a dummy Server item and then wait to see the servlet's Server list get refreshed.");
                object = this._servlet.createServer(null, string5, n3, n4);
                parsedMaps.dummyServerCreated = true;
            }
            parsedMaps.storeNameToServerMap.put(string2, (HttpClusterServlet.Server)object);
            parsedMaps.serverNameToServerMap.put(string4, (HttpClusterServlet.Server)object);
            parsedMaps.serverToServerNameMap.put((HttpClusterServlet.Server)object, string4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serverListChanged() {
        try {
            HttpClusterServlet.Server server;
            HttpClusterServlet.Server server2;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Refreshing server info from HttpClusterServlet server list...");
            }
            this._mapLock.writeLock().lock();
            this._dummyServerCreated = false;
            for (String string : this._storeNameToServerMap.keySet()) {
                server2 = this._storeNameToServerMap.get(string);
                server = this._servlet.getServerList().getByHostAndPort(server2.getHost(), server2.getPort());
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("For storeName '" + string + "' oldServer: " + server2 + " newServer: " + server);
                }
                if (server == null) continue;
                this._storeNameToServerMap.put(string, server);
            }
            for (String string : this._serverNameToServerMap.keySet()) {
                server2 = this._serverNameToServerMap.get(string);
                server = this._servlet.getServerList().getByHostAndPort(server2.getHost(), server2.getPort());
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("For serverName '" + string + "' oldServer: " + server2 + " newServer: " + server);
                }
                if (server == null) continue;
                this._serverNameToServerMap.put(string, server);
                this._serverToServerNameMap.put(server, string);
            }
            Object var6_5 = null;
            this._mapLock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this._mapLock.writeLock().unlock();
            throw throwable;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("DONE refreshing server info from HttpClusterServlet server list...");
        }
    }

    public void notifyRoutingDecision(HttpClusterServlet.Server server, Object object) {
        this._router.notifyRoutingDecision(server, (Map)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    HttpClusterServlet.Server getTargetServerForRouting(RoutingInfo routingInfo) {
        HttpClusterServlet.Server server;
        block11: {
            HttpClusterServlet.Server server2;
            block10: {
                HttpClusterServlet.Server server3;
                block9: {
                    HttpClusterServlet.Server server4;
                    block8: {
                        try {
                            this._mapLock.readLock().lock();
                            switch (routingInfo.getType()) {
                                case SERVER_NAME: {
                                    HttpClusterServlet.Server server5 = this._serverNameToServerMap.get(routingInfo.getName());
                                    Object var8_5 = null;
                                    this._mapLock.readLock().unlock();
                                    return server5;
                                }
                                case PHYSICAL_STORE_NAME: {
                                    server4 = this._storeNameToServerMap.get(routingInfo.getName());
                                    break block8;
                                }
                                case HOST_AND_PORT: {
                                    String string = routingInfo.getName();
                                    int n = string.indexOf(":");
                                    if (n > 0) {
                                        String string2 = string.substring(0, n);
                                        int n2 = Integer.parseInt(string.substring(n + 1));
                                        server3 = this._servlet.getServerList().getByHostAndPort(string2, n2);
                                        break block9;
                                    }
                                    server2 = null;
                                    break block10;
                                }
                                default: {
                                    server = null;
                                    break;
                                }
                            }
                            break block11;
                        }
                        catch (Throwable throwable) {
                            Object var8_10 = null;
                            this._mapLock.readLock().unlock();
                            throw throwable;
                        }
                    }
                    Object var8_6 = null;
                    this._mapLock.readLock().unlock();
                    return server4;
                }
                Object var8_7 = null;
                this._mapLock.readLock().unlock();
                return server3;
            }
            Object var8_8 = null;
            this._mapLock.readLock().unlock();
            return server2;
        }
        Object var8_9 = null;
        this._mapLock.readLock().unlock();
        return server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RoutingInfo getRoutingForTargetServer(HttpClusterServlet.Server server) {
        block3: {
            try {
                this._mapLock.readLock().lock();
                String string = this._serverToServerNameMap.get(server);
                if (string == null) break block3;
                RoutingInfo routingInfo = new RoutingInfo(string, RoutingInfo.Type.SERVER_NAME);
                Object var6_5 = null;
                this._mapLock.readLock().unlock();
                return routingInfo;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this._mapLock.readLock().unlock();
                throw throwable;
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(server.getHostIp());
        stringBuilder.append(':');
        stringBuilder.append(Integer.toString(server.getPort()));
        RoutingInfo routingInfo = new RoutingInfo(stringBuilder.toString(), RoutingInfo.Type.HOST_AND_PORT);
        Object var6_6 = null;
        this._mapLock.readLock().unlock();
        return routingInfo;
    }

    static {
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        _runtimeAccess = ManagementService.getRuntimeAccess(authenticatedSubject);
        LOGGER = Logger.getLogger(SOAPRoutingHandler.class.getName());
        if (WseeRuntimeMBeanDelegate.isReliableSecureProfileEnabled()) {
            SequenceIDRoutingInfoFinder.registerIfNeeded();
            McAnonIDRoutingInfoFinder.registerIfNeeded();
            SCTIDRoutingInfoFinder.registerIfNeeded();
        }
    }

    private static class ParsedMaps {
        boolean dummyServerCreated;
        Map<String, HttpClusterServlet.Server> storeNameToServerMap = new HashMap<String, HttpClusterServlet.Server>();
        Map<String, HttpClusterServlet.Server> serverNameToServerMap = new HashMap<String, HttpClusterServlet.Server>();
        Map<HttpClusterServlet.Server, String> serverToServerNameMap = new HashMap<HttpClusterServlet.Server, String>();
    }

    private static class SOAPHeaderChunkedInputStream
    extends ChunkedInputStream {
        int _maxHeaderBlockSize;

        public SOAPHeaderChunkedInputStream(Chunk chunk, int n) {
            super(chunk, 0);
            this._maxHeaderBlockSize = n;
        }

        public int read() throws IOException {
            int n = super.read();
            if (this.pos() > this._maxHeaderBlockSize) {
                throw new IOException("Max header block size exceeded: " + this._maxHeaderBlockSize);
            }
            return n;
        }
    }
}

