/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.cluster.spi;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import weblogic.wsee.jaxws.cluster.spi.PhysicalStoreNameMsgHeader;
import weblogic.wsee.message.MsgHeader;
import weblogic.wsee.message.MsgHeaderException;
import weblogic.wsee.message.MsgHeaderFactoryIntf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterMsgHeaderFactory
implements MsgHeaderFactoryIntf {
    private Map<QName, Class<? extends MsgHeader>> headerClasses = new HashMap<QName, Class<? extends MsgHeader>>();

    public ClusterMsgHeaderFactory() {
        this.addMsgHeaderClass(PhysicalStoreNameMsgHeader.NAME, PhysicalStoreNameMsgHeader.class);
    }

    @Override
    public MsgHeader createMsgHeader(QName qName) throws MsgHeaderException {
        try {
            Class<? extends MsgHeader> clazz = this.headerClasses.get(qName);
            if (clazz != null) {
                return clazz.newInstance();
            }
            return null;
        }
        catch (MsgHeaderException msgHeaderException) {
            throw msgHeaderException;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new MsgHeaderException("Could not build header for " + qName, illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new MsgHeaderException("Could not build header for " + qName, instantiationException);
        }
    }

    private void addMsgHeaderClass(QName qName, Class<? extends MsgHeader> clazz) {
        this.headerClasses.put(qName, clazz);
    }

    public Class<? extends MsgHeader> getHeaderClass(QName qName) {
        return this.headerClasses.get(qName);
    }
}

