/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.cluster.spi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import weblogic.wsee.WseeCoreLogger;
import weblogic.wsee.jaxws.cluster.spi.RoutableIDMapService;
import weblogic.wsee.jaxws.cluster.spi.ServerNameMapService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoutableIDMapServiceRegistry
implements ServerNameMapService.ServerAddressChangeListener {
    private static final RoutableIDMapServiceRegistry _instance = new RoutableIDMapServiceRegistry();
    private ArrayList<RoutableIDMapService> _mappers;
    private ServerNameMapService _serverNameMapService = null;
    private ReentrantReadWriteLock _mappersLock = new ReentrantReadWriteLock(false);
    private ReentrantReadWriteLock _serverNameToAddressMapLock = new ReentrantReadWriteLock();
    private Map<String, ServerNameMapService.ServerAddress> _serverNameToAddressMap;
    private long _lastUpdateTime = 0L;

    public static RoutableIDMapServiceRegistry getInstance() {
        return _instance;
    }

    private RoutableIDMapServiceRegistry() {
        this._mappers = new ArrayList();
        this._serverNameToAddressMap = new HashMap<String, ServerNameMapService.ServerAddress>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMapper(RoutableIDMapService routableIDMapService) {
        try {
            this._mappersLock.writeLock().lock();
            if (this._mappers.contains(routableIDMapService)) {
                boolean bl = false;
                return bl;
            }
            this._mappers.add(routableIDMapService);
            if (routableIDMapService instanceof ServerNameMapService) {
                this._serverNameMapService = (ServerNameMapService)((Object)routableIDMapService);
                this._serverNameMapService.addServerAddressChangeListener(this);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this._mappersLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMapper(RoutableIDMapService routableIDMapService) {
        try {
            this._mappersLock.writeLock().lock();
            if (this._serverNameMapService == routableIDMapService) {
                this._serverNameMapService.removeServerAddressChangeListener(this);
                this._serverNameMapService = null;
            }
            boolean bl = this._mappers.remove(routableIDMapService);
            return bl;
        }
        finally {
            this._mappersLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RoutableIDMapService[] getMappers() {
        try {
            this._mappersLock.readLock().lock();
            RoutableIDMapService[] routableIDMapServiceArray = this._mappers.toArray(new RoutableIDMapService[this._mappers.size()]);
            return routableIDMapServiceArray;
        }
        finally {
            this._mappersLock.readLock().unlock();
        }
    }

    public boolean hasNewInfoSince(long l) {
        return this._lastUpdateTime > l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getCurrentRoutableIDToServerMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            this._mappersLock.readLock().lock();
            for (RoutableIDMapService routableIDMapService : this._mappers) {
                try {
                    hashMap.putAll(routableIDMapService.getCurrentRoutableIDToServerMap());
                }
                catch (Exception exception) {
                    WseeCoreLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                }
            }
        }
        finally {
            this._mappersLock.readLock().unlock();
        }
        this.refreshServerNameToAddressMap(hashMap);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerNameMapService.ServerAddress getServerAddress(String string) {
        ServerNameMapService.ServerAddress serverAddress = null;
        try {
            this._serverNameToAddressMapLock.readLock().lock();
            serverAddress = this._serverNameToAddressMap.get(string);
        }
        finally {
            this._serverNameToAddressMapLock.readLock().unlock();
        }
        if (serverAddress == null && this._serverNameMapService != null) {
            try {
                this._serverNameToAddressMapLock.writeLock().lock();
                serverAddress = this._serverNameMapService.getServerAddress(string);
                if (serverAddress != null) {
                    this._serverNameToAddressMap.put(string, serverAddress);
                }
            }
            finally {
                this._serverNameToAddressMapLock.writeLock().unlock();
            }
        }
        return serverAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshServerNameToAddressMap(Map<String, String> map) {
        if (this._serverNameMapService != null) {
            HashSet<String> hashSet = new HashSet<String>();
            for (String iterator : map.values()) {
                hashSet.add(iterator);
            }
            HashSet hashSet2 = new HashSet();
            try {
                this._serverNameToAddressMapLock.readLock().lock();
                for (String string : hashSet) {
                    if (!this._serverNameToAddressMap.containsKey(string)) continue;
                    hashSet2.add(string);
                }
            }
            finally {
                this._serverNameToAddressMapLock.readLock().unlock();
            }
            if (!hashSet2.isEmpty()) {
                try {
                    this._serverNameToAddressMapLock.writeLock().lock();
                    this._lastUpdateTime = System.currentTimeMillis();
                    Iterator iterator = hashSet2.iterator();
                    while (iterator.hasNext()) {
                        String string;
                        string = (String)iterator.next();
                        ServerNameMapService.ServerAddress serverAddress = this._serverNameMapService.getServerAddress(string);
                        if (serverAddress == null) continue;
                        this._serverNameToAddressMap.put(string, serverAddress);
                    }
                }
                finally {
                    this._serverNameToAddressMapLock.writeLock().unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serverAddressChanged(String string, ServerNameMapService serverNameMapService) {
        try {
            this._serverNameToAddressMapLock.writeLock().lock();
            this._lastUpdateTime = System.currentTimeMillis();
            if (string == null) {
                this._serverNameToAddressMap.clear();
            } else {
                ServerNameMapService.ServerAddress serverAddress = serverNameMapService.getServerAddress(string);
                this._serverNameToAddressMap.put(string, serverAddress);
            }
        }
        finally {
            this._serverNameToAddressMapLock.writeLock().unlock();
        }
    }
}

