/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.cluster.spi;

import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import weblogic.wsee.jaxws.cluster.spi.MessageIDRoutingInfoFinder;
import weblogic.wsee.jaxws.cluster.spi.PhysicalStoreNameRoutingInfoFinder;
import weblogic.wsee.jaxws.cluster.spi.RoutingInfoFinder;
import weblogic.wsee.wstx.wsat.cluster.WSATRoutingInfoFinder;

public class RoutingInfoFinderRegistry {
    private static final RoutingInfoFinderRegistry _instance = new RoutingInfoFinderRegistry();
    private ArrayList<RoutingInfoFinder> _finders;
    private ReentrantReadWriteLock _findersLock = new ReentrantReadWriteLock(false);

    public static RoutingInfoFinderRegistry getInstance() {
        return _instance;
    }

    private RoutingInfoFinderRegistry() {
        this._finders = new ArrayList();
        this.addFinder(new MessageIDRoutingInfoFinder());
        this.addFinder(new PhysicalStoreNameRoutingInfoFinder());
        this.addFinder(new WSATRoutingInfoFinder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addFinder(RoutingInfoFinder routingInfoFinder) {
        block5: {
            this._findersLock.writeLock().lock();
            if (!this._finders.contains(routingInfoFinder)) break block5;
            boolean bl = false;
            Object var5_4 = null;
            this._findersLock.writeLock().unlock();
            return bl;
        }
        try {
            int n;
            int n2 = -1;
            for (n = 0; n < this._finders.size(); n += 1) {
                if (this._finders.get(n).getFinderPriority() >= routingInfoFinder.getFinderPriority()) continue;
                n2 = n;
                break;
            }
            if (n2 < 0) {
                n2 = this._finders.size();
            }
            this._finders.add(n2, routingInfoFinder);
            n = 1;
            Object var5_5 = null;
            this._findersLock.writeLock().unlock();
            return n != 0;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this._findersLock.writeLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeFinder(RoutingInfoFinder routingInfoFinder) {
        try {
            this._findersLock.writeLock().lock();
            boolean bl = this._finders.remove(routingInfoFinder);
            Object var4_3 = null;
            this._findersLock.writeLock().unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this._findersLock.writeLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RoutingInfoFinder[] getFinders() {
        try {
            this._findersLock.readLock().lock();
            RoutingInfoFinder[] routingInfoFinderArray = this._finders.toArray(new RoutingInfoFinder[this._finders.size()]);
            Object var3_2 = null;
            this._findersLock.readLock().unlock();
            return routingInfoFinderArray;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._findersLock.readLock().unlock();
            throw throwable;
        }
    }
}

