/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.config;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import java.io.Serializable;
import java.lang.reflect.Method;
import weblogic.wsee.jaxws.config.Property;
import weblogic.wsee.jaxws.config.PropertyAccessor;
import weblogic.wsee.jaxws.config.PropertySource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasePropertyAccessor
implements PropertyAccessor {
    protected Property _property;
    protected Class<? extends Serializable> _clazz;
    protected PropertySource _source;
    protected Object _sourceObject;

    protected BasePropertyAccessor(@NotNull PropertySource propertySource, @Nullable Object object) {
        this(propertySource, null, object);
    }

    protected BasePropertyAccessor(@NotNull PropertySource propertySource, @Nullable Class<? extends Serializable> clazz, @Nullable Object object) {
        this._source = propertySource;
        this._clazz = clazz;
        this._sourceObject = object;
    }

    @Override
    public Property getProperty() {
        return this._property;
    }

    @Override
    public void setProperty(Property property) {
        this._property = property;
        if (this._clazz == null) {
            this._clazz = this._property.getValueClass();
        }
    }

    @Override
    public Class<? extends Serializable> getValueClass() {
        return this._clazz;
    }

    @Override
    public PropertySource getSource() {
        return this._source;
    }

    protected String getMethodPrefix(boolean bl) {
        if (bl) {
            return "get";
        }
        return this._clazz == Boolean.class || this._clazz == Boolean.TYPE ? "is" : "get";
    }

    @Override
    public Object getValue() {
        if (this._sourceObject == null) {
            return null;
        }
        String string = this.getMethodPrefix(false) + this._property.getName();
        try {
            Method method = this._sourceObject.getClass().getMethod(string, new Class[0]);
            return method.invoke(this._sourceObject, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            string = this.getMethodPrefix(true) + this._property.getName();
            try {
                Method method = this._sourceObject.getClass().getMethod(string, new Class[0]);
                return method.invoke(this._sourceObject, new Object[0]);
            }
            catch (Exception exception) {
                throw new RuntimeException(noSuchMethodException.toString(), noSuchMethodException);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString(), exception);
        }
    }
}

