/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.config;

import java.io.Serializable;
import weblogic.wsee.jaxws.config.PropertyAccessor;
import weblogic.wsee.jaxws.config.PropertySource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Property<T extends Serializable> {
    private String _name;
    private Class _clazz;
    private T _defaultValue;
    private PropertyAccessor[] _sources;

    public Property(String string, Class<T> clazz, T t, PropertyAccessor ... propertyAccessorArray) {
        this._name = string;
        this._clazz = clazz;
        this._defaultValue = t;
        this._sources = propertyAccessorArray;
        for (PropertyAccessor propertyAccessor : propertyAccessorArray) {
            propertyAccessor.setProperty(this);
        }
    }

    public String getName() {
        return this._name;
    }

    public Class<T> getValueClass() {
        return this._clazz;
    }

    public T getValue() {
        return this.getValueInfo().value;
    }

    public ValueInfo getValueInfo() {
        ValueInfo valueInfo = new ValueInfo();
        Object object = null;
        for (PropertyAccessor propertyAccessor : this._sources) {
            object = propertyAccessor.getValue();
            if (object == null) continue;
            valueInfo.source = propertyAccessor.getSource();
            break;
        }
        if (object != null) {
            valueInfo.value = (Serializable)this.sanitizeValue(object);
        } else {
            valueInfo.value = this._defaultValue;
            valueInfo.source = PropertySource.DEFAULT_VALUE;
        }
        return valueInfo;
    }

    private Object sanitizeValue(Object object) {
        Serializable serializable;
        if ((this._clazz == Boolean.class || this._clazz == Boolean.TYPE) && object.getClass() != this._clazz) {
            object = Boolean.valueOf(object.toString());
        }
        try {
            serializable = (Serializable)object;
        }
        catch (ClassCastException classCastException) {
            serializable = this._defaultValue;
        }
        return serializable;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this._name);
        stringBuffer.append(": ");
        ValueInfo valueInfo = this.getValueInfo();
        boolean bl = valueInfo.value instanceof String;
        if (bl) {
            stringBuffer.append("'");
        }
        stringBuffer.append(valueInfo.value);
        if (bl) {
            stringBuffer.append("'");
        }
        stringBuffer.append(" (");
        stringBuffer.append((Object)valueInfo.source);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    class ValueInfo {
        T value;
        PropertySource source;

        ValueInfo() {
        }
    }
}

