/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.framework;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.ServerTubeAssemblerContext;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import weblogic.j2ee.descriptor.wl.PortComponentBean;
import weblogic.j2ee.descriptor.wl.PortInfoBean;
import weblogic.j2ee.descriptor.wl.PropertyNamevalueBean;
import weblogic.j2ee.descriptor.wl.ServiceReferenceDescriptionBean;
import weblogic.management.configuration.WebServiceLogicalStoreMBean;
import weblogic.management.configuration.WebServiceMBean;
import weblogic.wsee.WseePersistLogger;
import weblogic.wsee.config.WebServiceMBeanFactory;
import weblogic.wsee.jaxws.framework.jaxrpc.EnvironmentFactory;
import weblogic.wsee.jaxws.framework.jaxrpc.JAXRPCEnvironmentFeature;
import weblogic.wsee.jaxws.spi.WLSServiceDelegate;
import weblogic.wsee.ws.WsPort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigUtil {
    @Nullable
    public static Map<String, Object> getServiceRefPropsForClient(@Nullable ClientTubeAssemblerContext clientTubeAssemblerContext) {
        QName qName;
        if (clientTubeAssemblerContext == null) {
            return null;
        }
        WLSServiceDelegate wLSServiceDelegate = null;
        if (clientTubeAssemblerContext.getService() instanceof WLSServiceDelegate) {
            wLSServiceDelegate = (WLSServiceDelegate)clientTubeAssemblerContext.getService();
        }
        String string = (qName = clientTubeAssemblerContext.getPortName()) == null ? null : qName.getLocalPart();
        return ConfigUtil.getServiceRefPropsForClient(wLSServiceDelegate, string);
    }

    @Nullable
    public static Map<String, Object> getServiceRefPropsForClient(@Nullable WLSServiceDelegate wLSServiceDelegate, String string) {
        PortInfoBean[] portInfoBeanArray;
        if (wLSServiceDelegate == null) {
            return null;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ServiceReferenceDescriptionBean serviceReferenceDescriptionBean = wLSServiceDelegate.getServiceReferenceDescription();
        if (serviceReferenceDescriptionBean != null && (portInfoBeanArray = serviceReferenceDescriptionBean.getPortInfos()) != null) {
            for (PortInfoBean portInfoBean : portInfoBeanArray) {
                PropertyNamevalueBean[] propertyNamevalueBeanArray;
                if (!portInfoBean.getPortName().equals(string) || (propertyNamevalueBeanArray = portInfoBean.getStubProperties()) == null) continue;
                for (PropertyNamevalueBean propertyNamevalueBean : propertyNamevalueBeanArray) {
                    hashMap.put(propertyNamevalueBean.getName(), propertyNamevalueBean.getValue());
                }
            }
        }
        return hashMap;
    }

    public static Map<String, Object> getServiceRefProps(@NotNull PortInfoBean portInfoBean) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        PropertyNamevalueBean[] propertyNamevalueBeanArray = portInfoBean.getStubProperties();
        if (propertyNamevalueBeanArray != null) {
            for (PropertyNamevalueBean propertyNamevalueBean : propertyNamevalueBeanArray) {
                hashMap.put(propertyNamevalueBean.getName(), propertyNamevalueBean.getValue());
            }
        }
        return hashMap;
    }

    public static PortInfoBean getPortInfoBeanForClient(@Nullable ClientTubeAssemblerContext clientTubeAssemblerContext) {
        if (clientTubeAssemblerContext == null) {
            return null;
        }
        WLSServiceDelegate wLSServiceDelegate = null;
        if (clientTubeAssemblerContext.getService() instanceof WLSServiceDelegate) {
            wLSServiceDelegate = (WLSServiceDelegate)clientTubeAssemblerContext.getService();
        }
        WSDLPort wSDLPort = clientTubeAssemblerContext.getWsdlModel();
        if (wLSServiceDelegate == null || wSDLPort == null) {
            return null;
        }
        String string = wSDLPort.getName().getLocalPart();
        return ConfigUtil.getPortInfoBeanForPort(wLSServiceDelegate, string);
    }

    public static PortInfoBean getPortInfoBeanForPort(WLSServiceDelegate wLSServiceDelegate, String string) {
        PortInfoBean[] portInfoBeanArray;
        ServiceReferenceDescriptionBean serviceReferenceDescriptionBean = wLSServiceDelegate.getServiceReferenceDescription();
        if (serviceReferenceDescriptionBean != null && (portInfoBeanArray = serviceReferenceDescriptionBean.getPortInfos()) != null) {
            for (PortInfoBean portInfoBean : portInfoBeanArray) {
                if (!portInfoBean.getPortName().equals(string)) continue;
                return portInfoBean;
            }
        }
        return null;
    }

    @Nullable
    public static PortComponentBean getPortComponentBeanForService(@NotNull ServerTubeAssemblerContext serverTubeAssemblerContext) {
        EnvironmentFactory environmentFactory = JAXRPCEnvironmentFeature.getFactory(serverTubeAssemblerContext.getEndpoint());
        WSDLPort wSDLPort = environmentFactory.getPort();
        if (wSDLPort != null) {
            QName qName = wSDLPort.getName();
            EnvironmentFactory.SingletonService singletonService = environmentFactory.getService();
            WsPort wsPort = singletonService.getPort(qName.getLocalPart());
            PortComponentBean portComponentBean = wsPort.getPortComponent();
            return portComponentBean;
        }
        return null;
    }

    public static WebServiceLogicalStoreMBean getLogicalStoreMBean(String string) {
        WebServiceLogicalStoreMBean[] webServiceLogicalStoreMBeanArray;
        WebServiceMBean webServiceMBean = WebServiceMBeanFactory.getInstance();
        for (WebServiceLogicalStoreMBean webServiceLogicalStoreMBean : webServiceLogicalStoreMBeanArray = webServiceMBean.getWebServicePersistence().getWebServiceLogicalStores()) {
            if (!webServiceLogicalStoreMBean.getName().equals(string)) continue;
            return webServiceLogicalStoreMBean;
        }
        throw new IllegalArgumentException(WseePersistLogger.logLogicalStoreNotFoundLoggable((String)string).getMessage());
    }

    public static File getStandaloneClientStoreDir() {
        String string = System.getProperty("weblogic.wsee.persistence.webservice-client.dir", System.getProperty("user.dir", System.getProperty("user.home", System.getProperty("java.io.tmpdir"))));
        return new File(string);
    }
}

