/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.framework;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.streaming.XMLStreamReaderFactory;
import com.sun.xml.ws.api.streaming.XMLStreamWriterFactory;
import com.sun.xml.ws.client.ClientTransportAccessException;
import com.sun.xml.ws.message.StringHeader;
import com.sun.xml.ws.util.DOMUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.net.ssl.SSLHandshakeException;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.soap.SOAPFaultException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import weblogic.protocol.LocalServerIdentity;
import weblogic.store.PersistentStoreManager;
import weblogic.wsee.util.Guid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsUtil {
    public static final String ROUTABLE_UUID_FORMAT_ID = "WLS1";

    public static boolean isPermanentSendFailure(Throwable throwable) {
        List<Class<? extends Throwable>> list = WsUtil.findNestedThrowableClasses(throwable);
        if (list.contains(ClientTransportAccessException.class) || list.contains(SSLHandshakeException.class)) {
            return true;
        }
        if (list.contains(SOAPFaultException.class)) {
            SOAPFaultException sOAPFaultException = WsUtil.getNestedThrowable(throwable, SOAPFaultException.class);
            try {
                int n;
                String string;
                String string2 = sOAPFaultException.getFault().getFaultCode();
                if (string2 != null && (string = string2.substring((n = string2.indexOf(":")) + 1)).equals("Client.Access")) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean hasRootCause(Throwable throwable, Class<? extends Throwable> clazz) {
        List<Class<? extends Throwable>> list = WsUtil.findNestedThrowableClasses(throwable);
        for (Class<? extends Throwable> clazz2 : list) {
            if (!clazz.isAssignableFrom(clazz2)) continue;
            return true;
        }
        return false;
    }

    public static List<Class<? extends Throwable>> findNestedThrowableClasses(Throwable throwable) {
        ArrayList<Class<? extends Throwable>> arrayList = new ArrayList<Class<? extends Throwable>>();
        while (throwable != null) {
            arrayList.add(throwable.getClass());
            throwable = throwable.getCause();
        }
        return arrayList;
    }

    public static <T extends Throwable> T getNestedThrowable(Throwable throwable, Class<T> clazz) {
        while (throwable != null) {
            if (clazz.isAssignableFrom(throwable.getClass())) {
                return (T)throwable;
            }
            throwable = throwable.getCause();
        }
        return null;
    }

    public static weblogic.wsee.addressing.EndpointReference createWseeEPRFromWsEPR(WSEndpointReference wSEndpointReference) {
        weblogic.wsee.addressing.EndpointReference endpointReference = new weblogic.wsee.addressing.EndpointReference();
        DOMResult dOMResult = new DOMResult();
        wSEndpointReference.toSpec().writeTo((Result)dOMResult);
        endpointReference.read(((Document)dOMResult.getNode()).getDocumentElement());
        return endpointReference;
    }

    public static WSEndpointReference createWsEPRFromWseeEPR(weblogic.wsee.addressing.EndpointReference endpointReference) {
        try {
            Element element = DOMUtil.createDom().createElementNS(endpointReference.getNamespaceURI(), "EndpointReference");
            endpointReference.write(element);
            DOMSource dOMSource = new DOMSource(element);
            EndpointReference endpointReference2 = EndpointReference.readFrom((Source)dOMSource);
            return new WSEndpointReference(endpointReference2);
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception.toString(), exception);
        }
    }

    public static Message createMessageFromThrowable(Throwable throwable, AddressingVersion addressingVersion, SOAPVersion sOAPVersion) throws RuntimeException {
        try {
            String string = sOAPVersion == SOAPVersion.SOAP_12 ? "SOAP 1.2 Protocol" : "SOAP 1.1 Protocol";
            MessageFactory messageFactory = MessageFactory.newInstance((String)string);
            SOAPMessage sOAPMessage = messageFactory.createMessage();
            QName qName = sOAPVersion.faultCodeServer;
            String string2 = throwable.toString();
            SOAPFault sOAPFault = sOAPMessage.getSOAPBody().addFault(qName, string2);
            Detail detail = sOAPFault.addDetail();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(byteArrayOutputStream, true);
            throwable.printStackTrace(printWriter);
            String string3 = byteArrayOutputStream.toString();
            detail.addTextNode(string3);
            Message message = Messages.create((SOAPMessage)sOAPMessage);
            WsUtil.addSOAPFaultActionHeader(addressingVersion, message);
            return message;
        }
        catch (SOAPException sOAPException) {
            throw new RuntimeException(sOAPException.toString(), sOAPException);
        }
    }

    public static void addSOAPFaultActionHeader(AddressingVersion addressingVersion, Message message) {
        String string = WsUtil.getSOAPFaultAction(addressingVersion);
        StringHeader stringHeader = new StringHeader(addressingVersion.actionTag, string);
        message.getHeaders().add((Header)stringHeader);
    }

    public static String getSOAPFaultAction(AddressingVersion addressingVersion) {
        return addressingVersion.nsUri + "/fault";
    }

    public static Message createEmptyMessage(String string, AddressingVersion addressingVersion, SOAPVersion sOAPVersion) throws SOAPException {
        String string2 = sOAPVersion == SOAPVersion.SOAP_12 ? "SOAP 1.2 Protocol" : "SOAP 1.1 Protocol";
        MessageFactory messageFactory = MessageFactory.newInstance((String)string2);
        SOAPMessage sOAPMessage = messageFactory.createMessage();
        Message message = Messages.create((SOAPMessage)sOAPMessage);
        StringHeader stringHeader = new StringHeader(addressingVersion.actionTag, string);
        message.getHeaders().add((Header)stringHeader);
        return message;
    }

    public static String generateUUID() {
        String string = Guid.generateGuid();
        String string2 = LocalServerIdentity.getIdentity().getServerName();
        if (string2 == null) {
            string2 = "client";
        }
        return "uuid:" + string2 + ":" + string.substring(5, string.length());
    }

    public static String generateRoutableUUID(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null storeName parameter given when generating routable UUID");
        }
        if (string.isEmpty()) {
            string = PersistentStoreManager.getManager().getDefaultStore().getName();
        }
        String string2 = Guid.generateGuid();
        return "uuid:WLS1:" + string + ":" + string2.substring(5, string2.length());
    }

    public static String getStoreNameFromRoutableUUID(String string) {
        ArrayList<String> arrayList = WsUtil.parseRoutableUUID(string);
        if (arrayList.size() >= 4 && "uuid".equals(arrayList.get(0)) && arrayList.get(1).equals(ROUTABLE_UUID_FORMAT_ID)) {
            return arrayList.get(2);
        }
        return null;
    }

    public static ArrayList<String> parseRoutableUUID(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":", true);
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals(":")) {
                if (bl) {
                    arrayList.add("");
                }
                bl = true;
                continue;
            }
            arrayList.add(string2);
            bl = false;
        }
        return arrayList;
    }

    public static void serializeWSEndpointReference(@Nullable WSEndpointReference wSEndpointReference, @NotNull ObjectOutputStream objectOutputStream) throws IOException {
        if (wSEndpointReference == null) {
            objectOutputStream.writeInt(0);
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XMLStreamWriter xMLStreamWriter = XMLStreamWriterFactory.create((OutputStream)byteArrayOutputStream, (String)"UTF-8");
        try {
            wSEndpointReference.writeTo("dummy", xMLStreamWriter);
            xMLStreamWriter.flush();
            xMLStreamWriter.close();
            XMLStreamWriterFactory.recycle((XMLStreamWriter)xMLStreamWriter);
        }
        catch (Exception exception) {
            throw new IOException(exception.toString(), exception);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        objectOutputStream.writeInt(byArray.length);
        if (byArray.length > 0) {
            objectOutputStream.write(byArray);
        }
    }

    @Nullable
    public static WSEndpointReference deserializeWSEndpointReference(@NotNull ObjectInputStream objectInputStream, @NotNull AddressingVersion addressingVersion) throws IOException {
        int n = objectInputStream.readInt();
        if (n > 0) {
            byte[] byArray = new byte[n];
            objectInputStream.readFully(byArray);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            XMLStreamReader xMLStreamReader = XMLStreamReaderFactory.create(null, (InputStream)byteArrayInputStream, (String)"UTF-8", (boolean)false);
            try {
                return new WSEndpointReference(xMLStreamReader, addressingVersion);
            }
            catch (Exception exception) {
                throw new IOException(exception.toString(), exception);
            }
        }
        return null;
    }

    public static String getOrSetMessageID(Message message, AddressingVersion addressingVersion, SOAPVersion sOAPVersion) {
        return WsUtil.getOrSetMessageID(message, addressingVersion, sOAPVersion, null);
    }

    public static String getOrSetMessageID(Message message, AddressingVersion addressingVersion, SOAPVersion sOAPVersion, String string) {
        String string2 = message.getHeaders().getMessageID(addressingVersion, sOAPVersion);
        if (string2 == null || string != null && !string.equals(WsUtil.getStoreNameFromRoutableUUID(string2))) {
            string2 = string == null ? WsUtil.generateUUID() : WsUtil.generateRoutableUUID(string);
            StringHeader stringHeader = new StringHeader(addressingVersion.messageIDTag, string2);
            message.getHeaders().addOrReplace((Header)stringHeader);
            message.getHeaders().clearCachedMessageID();
            message.clearCachedID();
        }
        return string2;
    }
}

