/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.framework.jaxrpc;

import com.sun.istack.Nullable;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundPortType;
import com.sun.xml.ws.api.model.wsdl.WSDLExtensible;
import com.sun.xml.ws.api.model.wsdl.WSDLFault;
import com.sun.xml.ws.api.model.wsdl.WSDLInput;
import com.sun.xml.ws.api.model.wsdl.WSDLMessage;
import com.sun.xml.ws.api.model.wsdl.WSDLModel;
import com.sun.xml.ws.api.model.wsdl.WSDLOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLOutput;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.model.wsdl.WSDLPortType;
import com.sun.xml.ws.api.model.wsdl.WSDLService;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.client.HandlerConfiguration;
import com.sun.xml.ws.developer.MemberSubmissionAddressingFeature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.soap.AddressingFeature;
import weblogic.j2ee.descriptor.wl.PortComponentBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.wsee.WebServiceType;
import weblogic.wsee.deploy.DeployInfo;
import weblogic.wsee.deploy.EJBDeployInfo;
import weblogic.wsee.deploy.ServletDeployInfo;
import weblogic.wsee.deploy.WsdlAddressInfo;
import weblogic.wsee.jaxws.framework.jaxrpc.AbstractPropertyConverter;
import weblogic.wsee.jaxws.framework.jaxrpc.BasicPropertyConverter;
import weblogic.wsee.jaxws.framework.jaxrpc.HandlerList;
import weblogic.wsee.jaxws.framework.jaxrpc.PropertyConverter;
import weblogic.wsee.jaxws.framework.jaxrpc.SOAPMessageContext;
import weblogic.wsee.jaxws.framework.jaxrpc.WsdlExtensibleHolder;
import weblogic.wsee.jaxws.framework.policy.PolicyReferencedByAttributeWsdlExtension;
import weblogic.wsee.jaxws.framework.policy.WSDLParserExtension;
import weblogic.wsee.jaxws.owsm.PropertyConverters;
import weblogic.wsee.jaxws.tubeline.TubelineAssemblerItem;
import weblogic.wsee.monitoring.OperationStats;
import weblogic.wsee.monitoring.WsspStats;
import weblogic.wsee.policy.deployment.PolicyRef;
import weblogic.wsee.policy.deployment.PolicyURIs;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.runtime.PolicyServer;
import weblogic.wsee.security.configuration.WssConfiguration;
import weblogic.wsee.security.configuration.WssConfigurationException;
import weblogic.wsee.security.policy.WssPolicyContext;
import weblogic.wsee.server.servlet.SecurityHelper;
import weblogic.wsee.ws.WsEndpoint;
import weblogic.wsee.ws.WsMethod;
import weblogic.wsee.ws.WsParameterType;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.WsReturnType;
import weblogic.wsee.ws.WsService;
import weblogic.wsee.ws.init.WsDeploymentContext;
import weblogic.wsee.wsa.wsaddressing.WSAVersion;
import weblogic.wsee.wsdl.WsdlBinding;
import weblogic.wsee.wsdl.WsdlBindingMessage;
import weblogic.wsee.wsdl.WsdlBindingOperation;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlDocumentation;
import weblogic.wsee.wsdl.WsdlElement;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlExtensible;
import weblogic.wsee.wsdl.WsdlExtension;
import weblogic.wsee.wsdl.WsdlFilter;
import weblogic.wsee.wsdl.WsdlImport;
import weblogic.wsee.wsdl.WsdlMessage;
import weblogic.wsee.wsdl.WsdlMethod;
import weblogic.wsee.wsdl.WsdlOperation;
import weblogic.wsee.wsdl.WsdlPart;
import weblogic.wsee.wsdl.WsdlPort;
import weblogic.wsee.wsdl.WsdlPortType;
import weblogic.wsee.wsdl.WsdlSchema;
import weblogic.wsee.wsdl.WsdlService;
import weblogic.wsee.wsdl.WsdlTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EnvironmentFactory {
    public static final String KEY = "weblogic.wsee.jaxws.framework.jaxrpc.context";
    private static final Logger LOGGER = Logger.getLogger(EnvironmentFactory.class.getName());
    private WSBinding binding;
    private Set<String> roles;
    private WSDLPort port;
    private Container container;
    private SingletonService simulatedService;
    private WsDeploymentContext simulatedDepoymentContext;
    private WsdlDefinitions wsdlDef;
    private Map<String, PropertyConverter> jaxrpcConverters;

    protected EnvironmentFactory(WSBinding wSBinding, WSDLPort wSDLPort, Container container) {
        Set set;
        this.binding = wSBinding;
        HandlerConfiguration handlerConfiguration = ((BindingImpl)wSBinding).getHandlerConfig();
        this.roles = new HashSet<String>();
        if (handlerConfiguration != null && (set = handlerConfiguration.getRoles()) != null) {
            this.roles.addAll(set);
        }
        this.port = wSDLPort;
        this.container = container;
        if (wSDLPort != null) {
            this.wsdlDef = new SimulatedWsdlDefinitions(wSDLPort.getOwner().getParent());
        }
    }

    private void initializeConverters() {
        this.jaxrpcConverters = new HashMap<String, PropertyConverter>();
        this.jaxrpcConverters.put("javax.xml.rpc.service.endpoint.address", new BasicPropertyConverter("javax.xml.rpc.service.endpoint.address", "javax.xml.ws.service.endpoint.address"));
        this.jaxrpcConverters.put("javax.xml.rpc.security.auth.username", new BasicPropertyConverter("javax.xml.rpc.security.auth.username", "javax.xml.ws.security.auth.username"));
        this.jaxrpcConverters.put("javax.xml.rpc.security.auth.password", new BasicPropertyConverter("javax.xml.rpc.security.auth.password", "javax.xml.ws.security.auth.password"));
        this.jaxrpcConverters.put("javax.xml.rpc.session.maintain", new BasicPropertyConverter("javax.xml.rpc.session.maintain", "javax.xml.ws.session.maintain"));
        this.jaxrpcConverters.put("javax.xml.rpc.soap.http.soapaction.use", new BasicPropertyConverter("javax.xml.rpc.soap.http.soapaction.use", "javax.xml.ws.soap.http.soapaction.use"));
        this.jaxrpcConverters.put("javax.xml.rpc.soap.http.soapaction.uri", new BasicPropertyConverter("javax.xml.rpc.soap.http.soapaction.uri", "javax.xml.ws.soap.http.soapaction.uri"));
        this.jaxrpcConverters.put("weblogic.wsee.invoke_properties", new AbstractPropertyConverter(){

            public Object convertToJAXRPC(Packet packet, MessageContext messageContext) {
                return packet.proxy != null ? packet.proxy.getRequestContext() : null;
            }

            public Object convertToJAXWS(Packet packet, MessageContext messageContext, Object object) {
                if (object != null && packet.proxy != null) {
                    packet.proxy.getRequestContext().putAll((Map)object);
                }
                return null;
            }
        });
        this.jaxrpcConverters.put("weblogic.wsee.connection.end_point_address", new BasicPropertyConverter("weblogic.wsee.connection.end_point_address", "com.sun.xml.ws.transport.http.servlet.requestURL"));
        this.jaxrpcConverters.put("weblogic.wsee.transport.servlet.request.secure", new AbstractPropertyConverter(){

            public Object convertToJAXRPC(Packet packet, MessageContext messageContext) {
                HttpServletRequest httpServletRequest = (HttpServletRequest)messageContext.get((Object)"javax.xml.ws.servlet.request");
                return httpServletRequest != null ? Boolean.valueOf(httpServletRequest.isSecure()) : null;
            }
        });
        this.jaxrpcConverters.put("weblogic.wsee.transport.client.cert.required", new AbstractPropertyConverter(){

            public Object convertToJAXRPC(Packet packet, MessageContext messageContext) {
                HttpServletRequest httpServletRequest = (HttpServletRequest)messageContext.get((Object)"javax.xml.ws.servlet.request");
                return httpServletRequest != null ? Boolean.valueOf(SecurityHelper.isClientCertPresent(httpServletRequest)) : null;
            }
        });
        this.jaxrpcConverters.put("weblogic.wsee.transport.headers", new AbstractPropertyConverter(){

            public Object convertToJAXRPC(Packet packet, MessageContext messageContext) {
                return ((javax.xml.ws.handler.soap.SOAPMessageContext)messageContext).getMessage().getMimeHeaders();
            }

            public Object convertToJAXWS(Packet packet, MessageContext messageContext, Object object) {
                return null;
            }
        });
        this.jaxrpcConverters.put("weblogic.wsee.service_name", new AbstractPropertyConverter(){

            public Object convertToJAXRPC(Packet packet, MessageContext messageContext) {
                return EnvironmentFactory.this.getServiceName();
            }
        });
        this.jaxrpcConverters.put("weblogic.wsee.context_path", new AbstractPropertyConverter(){

            public Object convertToJAXRPC(Packet packet, MessageContext messageContext) {
                return EnvironmentFactory.this.getContextPath();
            }
        });
        this.jaxrpcConverters.put("weblogic.wsee.service_uri", new AbstractPropertyConverter(){

            public Object convertToJAXRPC(Packet packet, MessageContext messageContext) {
                return EnvironmentFactory.this.getServiceUris();
            }
        });
        this.jaxrpcConverters.put("weblogic.wsee.security_realm", new AbstractPropertyConverter(){

            public Object convertToJAXRPC(Packet packet, MessageContext messageContext) {
                return EnvironmentFactory.this.getSecurityRealmName();
            }
        });
        this.jaxrpcConverters.put("weblogic.wsee.application_id", new AbstractPropertyConverter(){

            public Object convertToJAXRPC(Packet packet, MessageContext messageContext) {
                return EnvironmentFactory.this.getApplication();
            }
        });
        this.jaxrpcConverters.put("weblogic.wsee.addressing.version", new AbstractPropertyConverter(){

            public Object convertToJAXRPC(Packet packet, MessageContext messageContext) {
                return EnvironmentFactory.this.getWSAVersion();
            }
        });
        this.jaxrpcConverters.putAll(new PropertyConverters(this).getConverters());
    }

    public Map<String, PropertyConverter> getJAXRPCConverters() {
        if (this.jaxrpcConverters == null) {
            this.initializeConverters();
        }
        return this.jaxrpcConverters;
    }

    public WsdlDefinitions getWsdlDef() {
        return this.wsdlDef;
    }

    public Container getContainer() {
        return this.container;
    }

    public WSBinding getBinding() {
        return this.binding;
    }

    public WSDLPort getPort() {
        return this.port;
    }

    protected SimulatedWsMethod createSimulatedWsMethod(WsdlOperation wsdlOperation) {
        return new SimulatedWsMethod(wsdlOperation);
    }

    protected SimulatedWsEndpoint createSimulatedWsEndpoint(Map<String, WsMethod> map, @Nullable QName qName) {
        return new SimulatedWsEndpoint(map, qName);
    }

    protected SimulatedWsPort createSimulatedWsPort(WsEndpoint wsEndpoint, @Nullable QName qName) {
        return new SimulatedWsPort(wsEndpoint, qName);
    }

    protected abstract void initPolicyContext(SingletonService var1);

    public SingletonService getService() {
        if (this.simulatedService == null) {
            DeployInfo deployInfo;
            final QName qName = this.port != null ? this.port.getName() : null;
            final QName qName2 = this.port != null ? this.port.getOwner().getName() : null;
            HashMap<String, WsMethod> hashMap = new HashMap<String, WsMethod>();
            WsdlDefinitions wsdlDefinitions = this.getWsdlDef();
            if (wsdlDefinitions != null) {
                for (WsdlOperation object2 : wsdlDefinitions.getPorts().get(qName).getPortType().getOperations().values()) {
                    hashMap.put(object2.getName().getLocalPart(), this.createSimulatedWsMethod(object2));
                }
            }
            final SimulatedWsEndpoint simulatedWsEndpoint = this.createSimulatedWsEndpoint(hashMap, qName);
            final SimulatedWsPort simulatedWsPort = this.createSimulatedWsPort(simulatedWsEndpoint, qName);
            if (this.getContainer() != null && (deployInfo = (DeployInfo)this.getContainer().getSPI(DeployInfo.class)) != null) {
                ((WsPort)simulatedWsPort).setPortComponent(deployInfo.getWlPortComp());
            }
            this.simulatedService = new SingletonService(){
                private boolean isUsingPolicy = false;
                private WssPolicyContext wssPolicyContext = null;

                @Override
                public WsPort getSingletonPort() {
                    return simulatedWsPort;
                }

                @Override
                public WsEndpoint getSingletonEndpoint() {
                    return simulatedWsEndpoint;
                }

                @Override
                public void addEndpoint(QName qName3, WsEndpoint wsEndpoint) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public WsPort addPort(String string, WsdlPort wsdlPort, WsEndpoint wsEndpoint) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public WsEndpoint getEndpoint(QName qName3) {
                    if (EnvironmentFactory.this.getWsdlDef() != null && qName != null && EnvironmentFactory.this.getWsdlDef().getPorts().get(qName).getPortType().getName().equals(qName3)) {
                        return simulatedWsEndpoint;
                    }
                    return null;
                }

                @Override
                public Iterator<WsEndpoint> getEndpoints() {
                    return new Iterator<WsEndpoint>(){
                        private boolean nextCalled = false;

                        @Override
                        public boolean hasNext() {
                            return !this.nextCalled;
                        }

                        @Override
                        public WsEndpoint next() {
                            if (this.nextCalled) {
                                throw new NoSuchElementException();
                            }
                            this.nextCalled = true;
                            return simulatedWsEndpoint;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public PolicyServer getPolicyServer() {
                    return this.wssPolicyContext != null ? this.wssPolicyContext.getPolicyServer() : null;
                }

                @Override
                public WsPort getPort(String string) {
                    if (string.equals(qName.getLocalPart())) {
                        return simulatedWsPort;
                    }
                    return null;
                }

                @Override
                public Iterator<WsPort> getPorts() {
                    return new Iterator<WsPort>(){
                        private boolean nextCalled = false;

                        @Override
                        public boolean hasNext() {
                            return !this.nextCalled;
                        }

                        @Override
                        public WsPort next() {
                            if (this.nextCalled) {
                                throw new NoSuchElementException();
                            }
                            this.nextCalled = true;
                            return simulatedWsPort;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public WsdlService getWsdlService() {
                    if (EnvironmentFactory.this.getWsdlDef() == null) {
                        return null;
                    }
                    return EnvironmentFactory.this.getWsdlDef().getServices().get(qName2);
                }

                @Override
                public WssConfiguration getWssConfiguration() {
                    return this.wssPolicyContext.getWssConfiguration();
                }

                @Override
                public WssPolicyContext getWssPolicyContext() {
                    return this.wssPolicyContext;
                }

                @Override
                public void initWssConfiguration() throws WssConfigurationException {
                    this.wssPolicyContext.getWssConfiguration().init();
                }

                @Override
                public boolean isUsingPolicy() {
                    return this.isUsingPolicy;
                }

                @Override
                public void setUsingPolicy(boolean bl) {
                    this.isUsingPolicy = bl;
                }

                @Override
                public void setWssPolicyContext(WssPolicyContext wssPolicyContext) {
                    this.wssPolicyContext = wssPolicyContext;
                }
            };
            this.initPolicyContext(this.simulatedService);
        }
        return this.simulatedService;
    }

    public String[] getServiceUris() {
        DeployInfo deployInfo;
        DeployInfo deployInfo2 = deployInfo = this.container != null ? (DeployInfo)this.container.getSPI(DeployInfo.class) : null;
        if (deployInfo instanceof ServletDeployInfo) {
            ServletDeployInfo servletDeployInfo = (ServletDeployInfo)deployInfo;
            return servletDeployInfo.getServiceURIs();
        }
        if (deployInfo instanceof EJBDeployInfo) {
            EJBDeployInfo eJBDeployInfo = (EJBDeployInfo)deployInfo;
            return eJBDeployInfo.getServiceURIs();
        }
        return null;
    }

    public String getContextPath() {
        DeployInfo deployInfo;
        DeployInfo deployInfo2 = deployInfo = this.container != null ? (DeployInfo)this.container.getSPI(DeployInfo.class) : null;
        if (deployInfo instanceof ServletDeployInfo) {
            ServletDeployInfo servletDeployInfo = (ServletDeployInfo)deployInfo;
            return servletDeployInfo.getContextPath();
        }
        if (deployInfo instanceof EJBDeployInfo) {
            EJBDeployInfo eJBDeployInfo = (EJBDeployInfo)deployInfo;
            return eJBDeployInfo.getContextPath();
        }
        return null;
    }

    public String getSecurityRealmName() {
        DeployInfo deployInfo = this.container != null ? (DeployInfo)this.container.getSPI(DeployInfo.class) : null;
        return deployInfo != null ? deployInfo.getSecurityRealmName() : null;
    }

    public String getApplication() {
        DeployInfo deployInfo = this.container != null ? (DeployInfo)this.container.getSPI(DeployInfo.class) : null;
        return deployInfo != null ? deployInfo.getApplication() : null;
    }

    public WSAVersion getWSAVersion() {
        WebServiceFeature webServiceFeature = this.binding.getFeature(MemberSubmissionAddressingFeature.class);
        if (webServiceFeature != null && webServiceFeature.isEnabled()) {
            return WSAVersion.MemberSubmission;
        }
        webServiceFeature = this.binding.getFeature(AddressingFeature.class);
        if (webServiceFeature != null && webServiceFeature.isEnabled()) {
            return WSAVersion.WSA10;
        }
        return null;
    }

    public String getServiceName() {
        DeployInfo deployInfo;
        DeployInfo deployInfo2 = deployInfo = this.container != null ? (DeployInfo)this.container.getSPI(DeployInfo.class) : null;
        if (deployInfo instanceof ServletDeployInfo) {
            ServletDeployInfo servletDeployInfo = (ServletDeployInfo)deployInfo;
            return servletDeployInfo.getServiceName();
        }
        if (deployInfo instanceof EJBDeployInfo) {
            EJBDeployInfo eJBDeployInfo = (EJBDeployInfo)deployInfo;
            return eJBDeployInfo.getServiceName();
        }
        return this.port != null ? this.port.getOwner().getName().getLocalPart() : null;
    }

    public WsDeploymentContext getDeploymentContext() {
        if (this.simulatedDepoymentContext == null) {
            this.simulatedDepoymentContext = this.buildDeploymentContext(this.getServiceUris(), this.getContextPath(), this.getServiceName());
        }
        return this.simulatedDepoymentContext;
    }

    protected String getCurrentVersionId() {
        return null;
    }

    protected WsDeploymentContext newDeploymentContext() {
        return new WsDeploymentContext();
    }

    protected WsDeploymentContext buildDeploymentContext(String[] stringArray, String string, String string2) {
        WsDeploymentContext wsDeploymentContext = this.newDeploymentContext();
        wsDeploymentContext.setWsService(this.getService());
        wsDeploymentContext.setServiceURIs(stringArray);
        String string3 = this.getCurrentVersionId();
        wsDeploymentContext.setVersion(string3);
        wsDeploymentContext.setContextPath(string);
        wsDeploymentContext.setServiceName(string2);
        wsDeploymentContext.setType(WebServiceType.JAXWS);
        return wsDeploymentContext;
    }

    public HandlerList buildServerHandlerList(Set<TubelineAssemblerItem> set) {
        return new HandlerList(set){

            protected void initialize() {
                this.add("MESSAGE_CONTEXT_INIT_HANDLER", (TubelineAssemblerItem)null);
                this.add("CONNECTION_HANDLER", (TubelineAssemblerItem)null);
                this.add("WS_VERSION_REDIRECT_HANDLER", (TubelineAssemblerItem)null);
                this.add("DIRECT_INVOKE_HANDLER", (TubelineAssemblerItem)null);
                this.add("ADDRESSING_HANDLER", (TubelineAssemblerItem)null);
                this.add("OPERATION_LOOKUP_HANDLER", (TubelineAssemblerItem)null);
                this.add("ONE_WAY_HANDLER", (TubelineAssemblerItem)null);
                this.add("PRE_INVOKE_HANDLER", (TubelineAssemblerItem)null);
                this.add("CODEC_HANDLER", (TubelineAssemblerItem)null);
                this.add("AUTHORIZATION_HANDLER", (TubelineAssemblerItem)null);
                super.initialize();
                this.add("COMPONENT_HANDLER", (TubelineAssemblerItem)null);
            }
        };
    }

    public HandlerList buildClientHandlerList(Set<TubelineAssemblerItem> set) {
        return new HandlerList(set){

            protected void initialize() {
                this.add("CODEC_HANDLER", (TubelineAssemblerItem)null);
                this.add("ADDRESSING_HANDLER", (TubelineAssemblerItem)null);
                this.add("MMEHEADER_HANDLER", (TubelineAssemblerItem)null);
                super.initialize();
                this.add("ASYNC_HANDLER", (TubelineAssemblerItem)null);
                this.add("CONNECTION_HANDLER", (TubelineAssemblerItem)null);
            }
        };
    }

    public SOAPMessageContext getContext(Packet packet) {
        Context context = (Context)packet.invocationProperties.get(KEY);
        if (context == null || !context.isValid(packet)) {
            context = new Context(packet);
            packet.invocationProperties.put(KEY, context);
        }
        return context.getContext();
    }

    public static SOAPMessageContext getContext(MessageContext messageContext) {
        Context context = (Context)messageContext.get((Object)KEY);
        return context == null ? null : context.getContext();
    }

    public Context create(Packet packet) {
        return new Context(packet);
    }

    private class Context {
        private SOAPMessageContext context;

        public Context(Packet packet) {
            this.context = new SOAPMessageContext(EnvironmentFactory.this, EnvironmentFactory.this.binding, packet, EnvironmentFactory.this.roles);
        }

        public SOAPMessageContext getContext() {
            return this.context;
        }

        public boolean isValid(Packet packet) {
            return this.context.isValid(packet);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SimulatedWsPort
    extends WsPort {
        private WsEndpoint wse;
        @Nullable
        protected QName wsdlPort;
        private weblogic.wsee.handler.HandlerList hl;
        private Set<PolicyRef> inboundRefs = new HashSet<PolicyRef>();
        private Set<PolicyRef> outboundRefs = new HashSet<PolicyRef>();
        private Map<Name, QName> soapDispatchMap = new HashMap<Name, QName>();
        private PortComponentBean portComp;
        private WsspStats wsspStats = null;

        protected SimulatedWsPort(@Nullable WsEndpoint wsEndpoint, QName qName) {
            this.wse = wsEndpoint;
            this.wsdlPort = qName;
        }

        @Override
        public void addPolicyRef(PolicyRef policyRef, boolean bl, boolean bl2) {
            if (bl) {
                this.inboundRefs.add(policyRef);
            }
            if (bl2) {
                this.outboundRefs.add(policyRef);
            }
        }

        @Override
        public WsEndpoint getEndpoint() {
            return this.wse;
        }

        @Override
        public Set<PolicyRef> getInboundPolicyRefs() {
            return this.inboundRefs;
        }

        @Override
        public weblogic.wsee.handler.HandlerList getInternalHandlerList() {
            return this.hl;
        }

        @Override
        public Set<PolicyRef> getOutboundPolicyRefs() {
            return this.outboundRefs;
        }

        @Override
        public RuntimeMBean getRuntimeMBean() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<Name, QName> getSoapDispatchMap() {
            return this.soapDispatchMap;
        }

        @Override
        public Map<Name, QName> getActionDispatchMap(String string) {
            return null;
        }

        @Override
        @Nullable
        public WsdlPort getWsdlPort() {
            return EnvironmentFactory.this.getWsdlDef() != null && this.wsdlPort != null ? EnvironmentFactory.this.getWsdlDef().getPorts().get(this.wsdlPort) : null;
        }

        @Override
        public void removePolicyRef(PolicyRef policyRef) {
            this.inboundRefs.remove(policyRef);
            this.outboundRefs.remove(policyRef);
        }

        @Override
        public void resetPolicyRefs() {
            this.inboundRefs.clear();
            this.outboundRefs.clear();
        }

        @Override
        public void setInternalHandlerList(weblogic.wsee.handler.HandlerList handlerList) {
            this.hl = handlerList;
        }

        @Override
        public PortComponentBean getPortComponent() {
            return this.portComp;
        }

        @Override
        public void setPortComponent(PortComponentBean portComponentBean) {
            this.portComp = portComponentBean;
        }

        @Override
        public WsspStats getWsspStats() {
            return this.wsspStats;
        }

        @Override
        public void setWsspStats(WsspStats wsspStats) {
            this.wsspStats = wsspStats;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SimulatedWsEndpoint
    extends WsEndpoint {
        private Map<String, WsMethod> methods;
        @Nullable
        private QName wsdlPort;

        protected SimulatedWsEndpoint(@Nullable Map<String, WsMethod> map, QName qName) {
            this.methods = map;
            this.wsdlPort = qName;
        }

        @Override
        public Class getEndpointInterface() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Class getJwsClass() {
            throw new UnsupportedOperationException();
        }

        @Override
        public WsMethod getMethod(String string) {
            return this.methods.get(string);
        }

        @Override
        public Iterator<WsMethod> getMethods() {
            return this.methods.values().iterator();
        }

        @Override
        public WsdlPortType getPortType() {
            return EnvironmentFactory.this.getWsdlDef() != null && this.wsdlPort != null ? EnvironmentFactory.this.getWsdlDef().getPorts().get(this.wsdlPort).getPortType() : null;
        }

        @Override
        public WsService getService() {
            return EnvironmentFactory.this.simulatedService;
        }
    }

    protected class SimulatedWsMethod
    extends WsMethod {
        private WsdlOperation op;
        private NormalizedExpression cip;
        private NormalizedExpression cop;
        private OperationStats os;

        public SimulatedWsMethod(WsdlOperation wsdlOperation) {
            this.op = wsdlOperation;
        }

        public NormalizedExpression getCachedEffectiveInboundPolicy() {
            return this.cip;
        }

        public NormalizedExpression getCachedEffectiveOutboundPolicy() {
            return this.cop;
        }

        public WsEndpoint getEndpoint() {
            return EnvironmentFactory.this.simulatedService.getSingletonEndpoint();
        }

        public Iterator getExceptions() {
            throw new UnsupportedOperationException();
        }

        public String getMethodName() {
            throw new UnsupportedOperationException();
        }

        public QName getOperationName() {
            return this.op.getName();
        }

        public WsParameterType getParameter(int n) {
            throw new UnsupportedOperationException();
        }

        public int getParameterSize() {
            throw new UnsupportedOperationException();
        }

        public Iterator getParameters() {
            throw new UnsupportedOperationException();
        }

        public WsReturnType getReturnType() {
            throw new UnsupportedOperationException();
        }

        public QName getReturnWrapperElement() {
            throw new UnsupportedOperationException();
        }

        public OperationStats getStats() {
            return this.os;
        }

        public QName getWrapperElement() {
            throw new UnsupportedOperationException();
        }

        public boolean isWrapped() {
            throw new UnsupportedOperationException();
        }

        public void setCachedEffectiveInboundPolicy(NormalizedExpression normalizedExpression) {
            this.cip = normalizedExpression;
        }

        public void setCachedEffectiveOutboundPolicy(NormalizedExpression normalizedExpression) {
            this.cop = normalizedExpression;
        }

        public void setStats(OperationStats operationStats) {
            this.os = operationStats;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SimulatedWsdlExtensible
    extends SimulatedWsdlElement
    implements WsdlExtensible {
        private WSDLExtensible inner;

        public SimulatedWsdlExtensible(WSDLExtensible wSDLExtensible) {
            this.inner = wSDLExtensible;
        }

        private WsdlExtensible get() {
            return WsdlExtensibleHolder.get(this.inner);
        }

        @Override
        public WsdlExtension getExtension(String string) {
            return this.get().getExtension(string);
        }

        @Override
        public List<WsdlExtension> getExtensionList(String string) {
            return this.get().getExtensionList(string);
        }

        @Override
        public Map<String, List<WsdlExtension>> getExtensions() {
            return this.get().getExtensions();
        }

        @Override
        public void putExtension(WsdlExtension wsdlExtension) {
            this.get().putExtension(wsdlExtension);
        }
    }

    protected class SimulatedWsdlElement
    implements WsdlElement {
        protected SimulatedWsdlElement() {
        }

        public WsdlDocumentation getDocumentation() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SimulatedWsdlMessage
    extends SimulatedWsdlExtensible
    implements WsdlMessage {
        private WSDLMessage message;
        private PolicyURIs policyURIs;

        public SimulatedWsdlMessage(WSDLMessage wSDLMessage) {
            super((WSDLExtensible)wSDLMessage);
            this.message = wSDLMessage;
        }

        @Override
        public QName getName() {
            return this.message.getName();
        }

        @Override
        public Map<String, ? extends WsdlPart> getParts() {
            throw new UnsupportedOperationException();
        }

        @Override
        public PolicyURIs getPolicyUris() {
            return this.policyURIs;
        }

        @Override
        public void setPolicyUris(PolicyURIs policyURIs) {
            this.policyURIs = policyURIs;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SimulatedWsdlOperation
    extends SimulatedWsdlExtensible
    implements WsdlOperation {
        private WSDLOperation operation;
        private PolicyURIs policyURIs;
        private PolicyURIs inputPolicy;
        private PolicyURIs outputPolicy;
        private Map<String, SimulatedWsdlMessage> faults;
        private SimulatedWsdlMessage input;
        private SimulatedWsdlMessage output;

        public SimulatedWsdlOperation(SimulatedWsdlDefinitions simulatedWsdlDefinitions, WSDLOperation wSDLOperation) {
            super((WSDLExtensible)wSDLOperation);
            this.faults = new HashMap<String, SimulatedWsdlMessage>();
            this.operation = wSDLOperation;
            Map<QName, SimulatedWsdlMessage> map = simulatedWsdlDefinitions.getMessages();
            for (WSDLFault wSDLFault : wSDLOperation.getFaults()) {
                SimulatedWsdlMessage simulatedWsdlMessage = new SimulatedWsdlMessage(wSDLFault.getMessage());
                this.faults.put(wSDLFault.getName(), simulatedWsdlMessage);
                map.put(simulatedWsdlMessage.getName(), simulatedWsdlMessage);
            }
            this.input = new SimulatedWsdlMessage(wSDLOperation.getInput().getMessage());
            if (wSDLOperation.getOutput() != null) {
                this.output = new SimulatedWsdlMessage(wSDLOperation.getOutput().getMessage());
            }
        }

        @Override
        public PolicyURIs getFaultPolicyUris(String string) {
            return this.faults.get(string).getPolicyUris();
        }

        public Map<String, SimulatedWsdlMessage> getFaults() {
            return this.faults;
        }

        @Override
        public SimulatedWsdlMessage getInput() {
            return this.input;
        }

        @Override
        public String getInputAction() {
            return this.operation.getInput().getAction();
        }

        @Override
        public String getInputName() {
            WSDLInput wSDLInput = this.operation.getInput();
            return wSDLInput == null ? null : wSDLInput.getName();
        }

        @Override
        public String getOutputName() {
            WSDLOutput wSDLOutput = this.operation.getOutput();
            return wSDLOutput == null ? null : wSDLOutput.getName();
        }

        @Override
        public PolicyURIs getInputPolicyUris() {
            return this.inputPolicy;
        }

        @Override
        public QName getName() {
            return this.operation.getName();
        }

        @Override
        public SimulatedWsdlMessage getOutput() {
            return this.output;
        }

        @Override
        public String getOutputAction() {
            return this.operation.getOutput().getAction();
        }

        @Override
        public PolicyURIs getOutputPolicyUris() {
            return this.outputPolicy;
        }

        @Override
        public PolicyURIs getPolicyUris() {
            return this.policyURIs;
        }

        @Override
        public int getType() {
            return this.operation.isOneWay() ? 1 : 0;
        }

        @Override
        public WsdlMethod getWsdlMethod() {
            throw new UnsupportedOperationException();
        }

        @Override
        public WsdlMethod getWsdlMethod(boolean bl) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isWrapped() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setFaultPolicyUris(String string, PolicyURIs policyURIs) {
            this.faults.get(string).setPolicyUris(policyURIs);
        }

        @Override
        public void setInputPolicyUris(PolicyURIs policyURIs) {
            this.inputPolicy = policyURIs;
        }

        @Override
        public void setOutputPolicyUris(PolicyURIs policyURIs) {
            this.outputPolicy = policyURIs;
        }

        @Override
        public void setPolicyUris(PolicyURIs policyURIs) {
            this.policyURIs = policyURIs;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SimulatedWsdlPortType
    extends SimulatedWsdlElement
    implements WsdlPortType {
        private WSDLPortType portType;
        private SimulatedWsdlDefinitions owner;
        private PolicyURIs policyURIs;
        private Map<QName, SimulatedWsdlOperation> operations = new HashMap<QName, SimulatedWsdlOperation>();

        public SimulatedWsdlPortType(SimulatedWsdlDefinitions simulatedWsdlDefinitions, WSDLPortType wSDLPortType) {
            WSDLOperation wSDLOperation2;
            this.owner = simulatedWsdlDefinitions;
            this.portType = wSDLPortType;
            for (WSDLOperation wSDLOperation2 : wSDLPortType.getOperations()) {
                this.operations.put(wSDLOperation2.getName(), new SimulatedWsdlOperation(simulatedWsdlDefinitions, wSDLOperation2));
            }
            WsdlExtensibleHolder wsdlExtensibleHolder = (WsdlExtensibleHolder)wSDLPortType.getExtension(WsdlExtensibleHolder.class);
            PolicyReferencedByAttributeWsdlExtension policyReferencedByAttributeWsdlExtension = wSDLOperation2 = wsdlExtensibleHolder == null ? null : (PolicyReferencedByAttributeWsdlExtension)wsdlExtensibleHolder.getExtension("PolicyURIs");
            if (wSDLOperation2 != null) {
                this.policyURIs = wSDLOperation2.getPolicyUri();
            }
        }

        @Override
        public QName getName() {
            return this.portType.getName();
        }

        public Map<QName, SimulatedWsdlOperation> getOperations() {
            return this.operations;
        }

        @Override
        public PolicyURIs getPolicyUris() {
            return this.policyURIs;
        }

        @Override
        public void setPolicyUris(PolicyURIs policyURIs) {
            this.policyURIs = policyURIs;
        }
    }

    protected class SimulatedWsdlPort
    extends SimulatedWsdlExtensible
    implements WsdlPort {
        private WSDLPort port;
        private SimulatedWsdlService service;
        private SimulatedWsdlBinding binding;
        private PolicyURIs policyURIs;

        public SimulatedWsdlPort(SimulatedWsdlService simulatedWsdlService, SimulatedWsdlBinding simulatedWsdlBinding, WSDLPort wSDLPort) {
            super((WSDLExtensible)wSDLPort);
            this.service = simulatedWsdlService;
            this.binding = simulatedWsdlBinding;
            this.port = wSDLPort;
        }

        public SimulatedWsdlBinding getBinding() {
            return this.binding;
        }

        public SimulatedWsdlDefinitions getDefinitions() {
            return this.service.getDefinitions();
        }

        public QName getName() {
            return this.port.getName();
        }

        public PolicyURIs getPolicyUris() {
            return this.policyURIs;
        }

        public WsdlAddressInfo.PortAddress getPortAddress() {
            return null;
        }

        public SimulatedWsdlPortType getPortType() {
            return this.binding.getPortType();
        }

        public SimulatedWsdlService getService() {
            return this.service;
        }

        public String getTransport() {
            return null;
        }

        public void setPolicyUris(PolicyURIs policyURIs) {
            this.policyURIs = policyURIs;
        }

        public void setPortAddress(WsdlAddressInfo.PortAddress portAddress) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SimulatedWsdlService
    extends SimulatedWsdlExtensible
    implements WsdlService {
        private WSDLService service;
        private SimulatedWsdlDefinitions owner;
        private PolicyURIs policyURIs;
        private Map<QName, SimulatedWsdlPort> ports;
        private List<SimulatedWsdlPortType> portTypes;

        public SimulatedWsdlService(SimulatedWsdlDefinitions simulatedWsdlDefinitions, WSDLService wSDLService) {
            super((WSDLExtensible)wSDLService);
            this.ports = new HashMap<QName, SimulatedWsdlPort>();
            this.portTypes = new ArrayList<SimulatedWsdlPortType>();
            this.owner = simulatedWsdlDefinitions;
            this.service = wSDLService;
            for (WSDLPort wSDLPort : wSDLService.getPorts()) {
                SimulatedWsdlPort simulatedWsdlPort = new SimulatedWsdlPort(this, simulatedWsdlDefinitions.getBindings().get(wSDLPort.getBinding().getName()), wSDLPort);
                this.ports.put(wSDLPort.getName(), simulatedWsdlPort);
                this.portTypes.add(simulatedWsdlPort.getPortType());
            }
        }

        @Override
        public SimulatedWsdlDefinitions getDefinitions() {
            return this.owner;
        }

        @Override
        public QName getName() {
            return this.service.getName();
        }

        @Override
        public PolicyURIs getPolicyUris() {
            return this.policyURIs;
        }

        @Override
        public void setPolicyUris(PolicyURIs policyURIs) {
            this.policyURIs = policyURIs;
        }

        public List<SimulatedWsdlPortType> getPortTypes() {
            return this.portTypes;
        }

        public Map<QName, SimulatedWsdlPort> getPorts() {
            return this.ports;
        }

        @Override
        public WsdlFilter getWsdlFilter() {
            throw new UnsupportedOperationException();
        }
    }

    protected class SimulatedWsdlBindingMessage
    extends SimulatedWsdlExtensible
    implements WsdlBindingMessage {
        private SimulatedWsdlBindingOperation op;
        private SimulatedWsdlMessage msg;
        private String name;
        private PolicyURIs policyURIs;

        public SimulatedWsdlBindingMessage(WSDLExtensible wSDLExtensible, String string, SimulatedWsdlBindingOperation simulatedWsdlBindingOperation, SimulatedWsdlMessage simulatedWsdlMessage) {
            super(wSDLExtensible);
            this.op = simulatedWsdlBindingOperation;
            this.msg = simulatedWsdlMessage;
            this.name = string;
        }

        public SimulatedWsdlBindingOperation getBindingOperation() {
            return this.op;
        }

        public SimulatedWsdlMessage getMessage() throws WsdlException {
            return this.msg;
        }

        public String getName() {
            return this.name;
        }

        public PolicyURIs getPolicyUris() {
            return this.policyURIs;
        }

        public int getType() {
            return 0;
        }

        public void setPolicyUris(PolicyURIs policyURIs) {
            this.policyURIs = policyURIs;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SimulatedWsdlBindingOperation
    extends SimulatedWsdlExtensible
    implements WsdlBindingOperation {
        private WSDLBoundOperation boundOp;
        private SimulatedWsdlBinding binding;
        private Map<String, SimulatedWsdlBindingMessage> faults;
        private PolicyURIs policyURIs;
        private SimulatedWsdlBindingMessage input;
        private SimulatedWsdlBindingMessage output;

        public SimulatedWsdlBindingOperation(SimulatedWsdlDefinitions simulatedWsdlDefinitions, SimulatedWsdlBinding simulatedWsdlBinding, WSDLBoundOperation wSDLBoundOperation) {
            Object object2;
            super((WSDLExtensible)wSDLBoundOperation);
            this.faults = new HashMap<String, SimulatedWsdlBindingMessage>();
            this.binding = simulatedWsdlBinding;
            this.boundOp = wSDLBoundOperation;
            for (Object object2 : wSDLBoundOperation.getFaults()) {
                this.faults.put(object2.getName(), new SimulatedWsdlBindingMessage((WSDLExtensible)object2, object2.getName(), this, simulatedWsdlDefinitions.getMessages().get(object2.getFault().getMessage().getName())));
            }
            WSDLOperation wSDLOperation = wSDLBoundOperation.getOperation();
            object2 = (WSDLParserExtension.PseudoBoundInputExtensible)wSDLBoundOperation.getExtension(WSDLParserExtension.PseudoBoundInputExtensible.class);
            this.input = new SimulatedWsdlBindingMessage((WSDLExtensible)object2, wSDLOperation.getInput().getName(), this, simulatedWsdlDefinitions.getMessages().get(wSDLOperation.getInput().getMessage().getName()));
            if (wSDLOperation.getOutput() != null) {
                WSDLParserExtension.PseudoBoundOutputExtensible pseudoBoundOutputExtensible = (WSDLParserExtension.PseudoBoundOutputExtensible)wSDLBoundOperation.getExtension(WSDLParserExtension.PseudoBoundOutputExtensible.class);
                this.output = new SimulatedWsdlBindingMessage(pseudoBoundOutputExtensible, wSDLOperation.getOutput().getName(), this, simulatedWsdlDefinitions.getMessages().get(wSDLOperation.getOutput().getMessage().getName()));
            }
        }

        @Override
        public SimulatedWsdlBinding getBinding() {
            return this.binding;
        }

        public Map<String, SimulatedWsdlBindingMessage> getFaults() {
            return this.faults;
        }

        @Override
        public SimulatedWsdlBindingMessage getInput() {
            return this.input;
        }

        @Override
        public QName getName() {
            return this.boundOp.getName();
        }

        @Override
        public SimulatedWsdlBindingMessage getOutput() {
            return this.output;
        }

        @Override
        public PolicyURIs getPolicyUris() {
            return this.policyURIs;
        }

        @Override
        public void setPolicyUris(PolicyURIs policyURIs) {
            this.policyURIs = policyURIs;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SimulatedWsdlBinding
    extends SimulatedWsdlExtensible
    implements WsdlBinding {
        private SimulatedWsdlPortType portType;
        private SimulatedWsdlDefinitions owner;
        private WSDLBoundPortType binding;
        private PolicyURIs policyURIs;
        private Map<QName, SimulatedWsdlBindingOperation> operations;

        public SimulatedWsdlBinding(SimulatedWsdlDefinitions simulatedWsdlDefinitions, SimulatedWsdlPortType simulatedWsdlPortType, WSDLBoundPortType wSDLBoundPortType) {
            super((WSDLExtensible)wSDLBoundPortType);
            this.operations = new HashMap<QName, SimulatedWsdlBindingOperation>();
            this.portType = simulatedWsdlPortType;
            this.binding = wSDLBoundPortType;
            this.owner = simulatedWsdlDefinitions;
            for (WSDLBoundOperation wSDLBoundOperation : wSDLBoundPortType.getBindingOperations()) {
                this.operations.put(wSDLBoundOperation.getName(), new SimulatedWsdlBindingOperation(simulatedWsdlDefinitions, this, wSDLBoundOperation));
            }
        }

        @Override
        public String getBindingType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public QName getName() {
            return this.binding.getName();
        }

        public Map<QName, SimulatedWsdlBindingOperation> getOperations() {
            return this.operations;
        }

        @Override
        public PolicyURIs getPolicyUris() {
            return this.policyURIs;
        }

        @Override
        public SimulatedWsdlPortType getPortType() {
            return this.portType;
        }

        @Override
        public String getTransportProtocol() {
            return null;
        }

        @Override
        public String getTransportURI() {
            return null;
        }

        @Override
        public void setPolicyUris(PolicyURIs policyURIs) {
            this.policyURIs = policyURIs;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SimulatedWsdlDefinitions
    extends SimulatedWsdlExtensible
    implements WsdlDefinitions {
        private WSDLModel model;
        private Map<QName, SimulatedWsdlService> services;
        private Map<QName, SimulatedWsdlPortType> portTypes;
        private Map<QName, SimulatedWsdlBinding> bindings;
        private Map<QName, SimulatedWsdlPort> ports;
        private Map<QName, SimulatedWsdlMessage> messages;

        public SimulatedWsdlDefinitions(WSDLModel wSDLModel) {
            super((WSDLExtensible)wSDLModel);
            this.services = new HashMap<QName, SimulatedWsdlService>();
            this.portTypes = new HashMap<QName, SimulatedWsdlPortType>();
            this.bindings = new HashMap<QName, SimulatedWsdlBinding>();
            this.ports = new HashMap<QName, SimulatedWsdlPort>();
            this.messages = new HashMap<QName, SimulatedWsdlMessage>();
            this.model = wSDLModel;
            for (WSDLPortType wSDLPortType : wSDLModel.getPortTypes().values()) {
                this.portTypes.put(wSDLPortType.getName(), new SimulatedWsdlPortType(this, wSDLPortType));
            }
            for (WSDLPortType wSDLPortType : wSDLModel.getBindings().values()) {
                this.bindings.put(wSDLPortType.getName(), new SimulatedWsdlBinding(this, this.portTypes.get(wSDLPortType.getPortTypeName()), (WSDLBoundPortType)wSDLPortType));
            }
            for (WSDLPortType wSDLPortType : wSDLModel.getServices().values()) {
                SimulatedWsdlService simulatedWsdlService = new SimulatedWsdlService(this, (WSDLService)wSDLPortType);
                this.services.put(wSDLPortType.getName(), simulatedWsdlService);
                this.ports.putAll(simulatedWsdlService.getPorts());
            }
        }

        public Map<QName, SimulatedWsdlBinding> getBindings() {
            return this.bindings;
        }

        @Override
        public String getEncoding() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<? extends WsdlDefinitions> getImportedWsdlDefinitions() {
            return Collections.emptyList();
        }

        @Override
        public List<? extends WsdlImport> getImports() {
            return Collections.emptyList();
        }

        @Override
        public Set<String> getKnownImportedWsdlLocations() {
            return Collections.emptySet();
        }

        public Map<QName, SimulatedWsdlMessage> getMessages() {
            return this.messages;
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        public Map<QName, SimulatedWsdlPortType> getPortTypes() {
            return this.portTypes;
        }

        public Map<QName, SimulatedWsdlPort> getPorts() {
            return this.ports;
        }

        public Map<QName, SimulatedWsdlService> getServices() {
            return this.services;
        }

        @Override
        public String getTargetNamespace() {
            throw new UnsupportedOperationException();
        }

        @Override
        public WsdlSchema getTheOnlySchema() {
            throw new UnsupportedOperationException();
        }

        @Override
        public WsdlTypes getTypes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getWsdlLocation() {
            throw new UnsupportedOperationException();
        }
    }

    public static interface SingletonService
    extends WsService {
        public WsPort getSingletonPort();

        public WsEndpoint getSingletonEndpoint();
    }
}

