/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.framework.jaxrpc;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.rpc.handler.HandlerInfo;
import weblogic.wsee.handler.HandlerException;
import weblogic.wsee.jaxws.framework.jaxrpc.TubeFactory;
import weblogic.wsee.jaxws.tubeline.Ordering;
import weblogic.wsee.jaxws.tubeline.TubelineAssemblerItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerList
implements weblogic.wsee.handler.HandlerList {
    private List<NamedHandlerInfo> internal = new ArrayList<NamedHandlerInfo>();
    protected Set<TubelineAssemblerItem> items;

    public HandlerList(Set<TubelineAssemblerItem> set) {
        this.items = set;
        this.initialize();
    }

    protected void initialize() {
        Ordering ordering = new Ordering(this.items);
        int n = ordering.size();
        TubelineAssemblerItem[] tubelineAssemblerItemArray = new TubelineAssemblerItem[n];
        for (TubelineAssemblerItem tubelineAssemblerItem : ordering) {
            tubelineAssemblerItemArray[--n] = tubelineAssemblerItem;
        }
        for (TubelineAssemblerItem tubelineAssemblerItem : tubelineAssemblerItemArray) {
            this.add(tubelineAssemblerItem.getName(), tubelineAssemblerItem);
        }
    }

    protected void add(String string, TubelineAssemblerItem tubelineAssemblerItem) {
        for (NamedHandlerInfo namedHandlerInfo : this.internal) {
            if (!namedHandlerInfo.getName().equals(string)) continue;
            namedHandlerInfo.item = tubelineAssemblerItem;
            return;
        }
        this.internal.add(new NamedHandlerInfo(string, tubelineAssemblerItem));
    }

    @Override
    public void add(String string, HandlerInfo handlerInfo) throws HandlerException {
        this.insert(string, this.size(), handlerInfo);
    }

    @Override
    public boolean contains(String string) {
        for (NamedHandlerInfo namedHandlerInfo : this.internal) {
            if (!namedHandlerInfo.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getHandlerNames() {
        String[] stringArray = new String[this.internal.size()];
        for (int i = 0; i < this.internal.size(); ++i) {
            stringArray[i] = this.internal.get(i).getName();
        }
        return stringArray;
    }

    @Override
    public HandlerInfo getInfo(int n) {
        return this.internal.get(n).getInfo();
    }

    @Override
    public String getName(int n) {
        return this.internal.get(n).getName();
    }

    @Override
    public void insert(String string, int n, HandlerInfo handlerInfo) throws HandlerException {
        TubelineAssemblerItem tubelineAssemblerItem = new TubelineAssemblerItem(string, new TubeFactory(handlerInfo));
        this.internal.add(n, new NamedHandlerInfo(string, tubelineAssemblerItem));
        this.items.clear();
        for (NamedHandlerInfo namedHandlerInfo : this.internal) {
            if (namedHandlerInfo.getItem() == null) continue;
            this.items.add(namedHandlerInfo.getItem());
        }
    }

    @Override
    public int insert(String string, HandlerInfo handlerInfo, List<String> list, List<String> list2) throws HandlerException {
        return this.orderedInsert(string, handlerInfo, list, list2, false);
    }

    @Override
    public int lenientInsert(String string, HandlerInfo handlerInfo, List<String> list, List<String> list2) throws HandlerException {
        return this.orderedInsert(string, handlerInfo, list, list2, true);
    }

    private int orderedInsert(String string, HandlerInfo handlerInfo, List<String> list, List<String> list2, boolean bl) throws HandlerException {
        HashSet<String> hashSet = list != null ? new HashSet<String>(list) : null;
        HashSet<String> hashSet2 = list2 != null ? new HashSet<String>(list2) : null;
        int n = -1;
        for (int i = 0; i < this.internal.size(); ++i) {
            if (!this.checkAfterConstraint(i, hashSet, bl) || !this.checkBeforeConstraint(i, hashSet2, bl)) continue;
            n = i;
            break;
        }
        if (n == -1) {
            throw new HandlerException(this.getMessage(hashSet, hashSet2));
        }
        this.insert(string, n, handlerInfo);
        return n;
    }

    private String getMessage(Set<String> set, Set<String> set2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Failed to insert handler after [");
        stringBuffer.append(set);
        stringBuffer.append("] and before [");
        stringBuffer.append(set2);
        stringBuffer.append("] into handler chain [");
        for (NamedHandlerInfo namedHandlerInfo : this.internal) {
            stringBuffer.append(namedHandlerInfo.name);
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    private boolean checkBeforeConstraint(int n, Set<String> set, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(set);
        for (int i = n; i < this.internal.size(); ++i) {
            NamedHandlerInfo namedHandlerInfo = this.internal.get(i);
            arrayList.remove(namedHandlerInfo.name);
        }
        if (arrayList.isEmpty()) {
            return true;
        }
        return bl && this.handlerNotPresent(arrayList);
    }

    private boolean handlerNotPresent(ArrayList<String> arrayList) {
        for (int i = 0; i < this.internal.size(); ++i) {
            NamedHandlerInfo namedHandlerInfo = this.internal.get(i);
            if (!arrayList.contains(namedHandlerInfo.name)) continue;
            return false;
        }
        return true;
    }

    private boolean checkAfterConstraint(int n, Set<String> set, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(set);
        for (int i = 0; i < n; ++i) {
            NamedHandlerInfo namedHandlerInfo = this.internal.get(i);
            arrayList.remove(namedHandlerInfo.name);
        }
        if (arrayList.isEmpty()) {
            return true;
        }
        return bl && this.handlerNotPresent(arrayList);
    }

    @Override
    public void remove(int n) {
        NamedHandlerInfo namedHandlerInfo = this.internal.remove(n);
    }

    @Override
    public boolean remove(String string) {
        Iterator<NamedHandlerInfo> iterator = this.internal.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getName().equals(string)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.internal.size();
    }

    protected HandlerInfo getHandlerInfo(TubelineAssemblerItem tubelineAssemblerItem) {
        if (tubelineAssemblerItem != null && tubelineAssemblerItem.getFactory() instanceof TubeFactory) {
            return ((TubeFactory)tubelineAssemblerItem.getFactory()).getHandlerInfo();
        }
        return null;
    }

    private class NamedHandlerInfo {
        private String name;
        private TubelineAssemblerItem item;

        public NamedHandlerInfo(String string, TubelineAssemblerItem tubelineAssemblerItem) {
            this.name = string;
            this.item = tubelineAssemblerItem;
        }

        public TubelineAssemblerItem getItem() {
            return this.item;
        }

        public HandlerInfo getInfo() {
            return HandlerList.this.getHandlerInfo(this.item);
        }

        public String getName() {
            return this.name;
        }
    }
}

