/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.framework.jaxrpc;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.WSService;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.handler.SOAPMessageContextImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.soap.MTOMFeature;
import weblogic.jws.jaxws.client.async.AsyncClientTransportFeature;
import weblogic.utils.collections.CombinedIterator;
import weblogic.wsee.connection.Connection;
import weblogic.wsee.connection.transport.Transport;
import weblogic.wsee.jaxws.framework.jaxrpc.EnvironmentFactory;
import weblogic.wsee.jaxws.framework.jaxrpc.PropertyConverter;
import weblogic.wsee.jaxws.framework.jaxrpc.client.ClientEnvironmentFactory;
import weblogic.wsee.jaxws.owsm.WsdlDefinitionFeature;
import weblogic.wsee.mc.api.McFeature;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.message.soap.SoapMessageContext;
import weblogic.wsee.message.soap.SoapMsgHeaders;
import weblogic.wsee.ws.WsMethod;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.dispatch.Dispatcher;
import weblogic.wsee.wsdl.WsdlBindingOperation;
import weblogic.wsee.wsdl.WsdlOperation;
import weblogic.wsee.wsdl.WsdlPort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPMessageContext
extends SoapMessageContext {
    public static final String JAX_WS_RUNTIME = "weblogic.wsee.jaxws.framework.jaxrpc.SOAPMessageContext.JAX_WS_RUNTIME";
    private static final String OPERATION_NAME_KEY = "weblogic.wsee.jaxws.framework.jaxrpc.OPERATION_NAME";
    public static final String ASYNC_CLIENT_FEATURE = "weblogic.wsee.jaxws.framework.jaxrpc.SOAPMessageContext.ASYNC_CLIENT_FEATURE";
    public static final String SERVICE = "weblogic.wsee.jaxws.framework.jaxrpc.SOAPMessageContext.SERVICE";
    private SOAPMessageContextImpl smc;
    private EnvironmentFactory factory;
    private Packet p;

    public SOAPMessageContext(final EnvironmentFactory environmentFactory, WSBinding wSBinding, final Packet packet, Set<String> set) {
        super(SOAPVersion.SOAP_12.equals((Object)wSBinding.getSOAPVersion()));
        this.smc = new SOAPMessageContextImpl(wSBinding, packet, set);
        this.factory = environmentFactory;
        this.p = packet;
        this.setProperty(JAX_WS_RUNTIME, "true");
        if (wSBinding.isFeatureEnabled(MTOMFeature.class)) {
            this.setProperty("weblogic.wsee.mtom.enable", "true");
            this.setProperty("weblogic.wsee.mtom.threshold", ((MTOMFeature)wSBinding.getFeature(MTOMFeature.class)).getThreshold());
        }
        if (wSBinding.isFeatureEnabled(AsyncClientTransportFeature.class)) {
            this.setProperty(ASYNC_CLIENT_FEATURE, wSBinding.getFeature(AsyncClientTransportFeature.class));
        } else if (wSBinding.isFeatureEnabled(McFeature.class)) {
            this.setProperty(ASYNC_CLIENT_FEATURE, wSBinding.getFeature(McFeature.class));
        }
        if (environmentFactory instanceof ClientEnvironmentFactory) {
            WSService wSService = ((ClientEnvironmentFactory)environmentFactory).getWSService();
            this.setProperty(SERVICE, wSService);
        }
        if (wSBinding.isFeatureEnabled(WsdlDefinitionFeature.class)) {
            this.setProperty("oracle.webservices.wsdldefinition", ((WsdlDefinitionFeature)wSBinding.getFeature(WsdlDefinitionFeature.class)).getDefinition());
        }
        this.setDispatcher(new Dispatcher(){
            private Map inParams;
            private Map outParams;

            public WsdlBindingOperation getBindingOperation() {
                return this.getWsdlPort().getBinding().getOperations().get(this.getOperationName());
            }

            public Connection getConnection() {
                return new Connection(){

                    public Transport getTransport() {
                        return new Transport(){

                            public void confirmOneway() throws IOException {
                                if (packet.transportBackChannel != null) {
                                    packet.transportBackChannel.close();
                                }
                            }

                            public String getEndpointAddress() {
                                throw new UnsupportedOperationException();
                            }

                            public String getName() {
                                throw new UnsupportedOperationException();
                            }

                            public String getServiceURI() {
                                throw new UnsupportedOperationException();
                            }

                            public InputStream receive(MimeHeaders mimeHeaders) throws IOException {
                                throw new UnsupportedOperationException();
                            }

                            public OutputStream send(MimeHeaders mimeHeaders) throws IOException {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }

                    public void receive(javax.xml.rpc.handler.MessageContext messageContext) throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    public void send(javax.xml.rpc.handler.MessageContext messageContext) throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    public void setTransport(Transport transport) {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            public WlMessageContext getContext() {
                return SOAPMessageContext.this;
            }

            public Map getInParams() {
                return this.inParams;
            }

            public WsdlOperation getOperation() {
                if (this.getWsMethod() == null) {
                    return null;
                }
                return this.getWsdlPort().getPortType().getOperations().get(this.getWsMethod().getOperationName());
            }

            public QName getOperationName() {
                QName qName = (QName)SOAPMessageContext.this.smc.get((Object)SOAPMessageContext.OPERATION_NAME_KEY);
                if (qName == null) {
                    WSDLBoundOperation wSDLBoundOperation;
                    Message message = packet.getMessage();
                    WSDLPort wSDLPort = environmentFactory.getPort();
                    if (message != null && wSDLPort != null && (wSDLBoundOperation = message.getOperation(wSDLPort)) != null) {
                        qName = wSDLBoundOperation.getName();
                        SOAPMessageContext.this.smc.put(SOAPMessageContext.OPERATION_NAME_KEY, (Object)qName);
                    }
                }
                return qName;
            }

            public Map getOutParams() {
                return this.outParams;
            }

            public WsMethod getWsMethod() {
                if (this.getOperationName() == null) {
                    return null;
                }
                return this.getWsPort().getEndpoint().getMethod(this.getOperationName().getLocalPart());
            }

            public WsPort getWsPort() {
                return environmentFactory.getService().getSingletonPort();
            }

            public void setWsPort(WsPort wsPort) {
                throw new UnsupportedOperationException();
            }

            public WsdlPort getWsdlPort() {
                return this.getWsPort().getWsdlPort();
            }

            public QName getPortName() {
                return this.getWsdlPort().getName();
            }

            public QName getServiceName() {
                return this.getWsdlPort().getService().getName();
            }

            public boolean isSOAP12() {
                return SOAPMessageContext.this.isSoap12();
            }

            public void setInParams(Map map) {
                this.inParams = map;
            }

            public void setOutParams(Map map) {
                this.outParams = map;
            }
        });
    }

    boolean isValid(Packet packet) {
        return this.p == packet;
    }

    @Override
    protected Map createPropertyMap() {
        return new InvocationPropertyMap();
    }

    public final void updatePacket() {
        this.smc.updatePacket();
        this.msg = null;
    }

    @Override
    public SOAPMessage getMessage() {
        if (this.msg == null && this.p.getMessage() != null) {
            super.setMessage(this.smc.getMessage());
        }
        return this.msg;
    }

    @Override
    public void setMessage(SOAPMessage sOAPMessage) {
        super.setMessage(sOAPMessage);
        this.smc.setMessage(sOAPMessage);
    }

    public void setFault(Throwable throwable, boolean bl) {
        if (bl) {
            super.setFault(throwable);
        } else {
            this.fault = throwable;
        }
    }

    public boolean isClient() {
        return this.factory instanceof ClientEnvironmentFactory;
    }

    public WSService getWSService() {
        if (this.factory instanceof ClientEnvironmentFactory) {
            return ((ClientEnvironmentFactory)this.factory).getWSService();
        }
        return null;
    }

    @Override
    public SoapMsgHeaders getHeaders() {
        this.getMessage();
        return (SoapMsgHeaders)super.getHeaders();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InvocationPropertyMap
    implements Map<String, Object> {
        private InvocationPropertyMap() {
        }

        @Override
        public Object get(Object object) {
            PropertyConverter propertyConverter = SOAPMessageContext.this.factory.getJAXRPCConverters().get(object);
            if (propertyConverter != null) {
                return propertyConverter.convertToJAXRPC(SOAPMessageContext.this.p, (MessageContext)SOAPMessageContext.this.smc);
            }
            return SOAPMessageContext.this.smc.get(object);
        }

        @Override
        public Object put(String string, Object object) {
            PropertyConverter propertyConverter = SOAPMessageContext.this.factory.getJAXRPCConverters().get(string);
            if (propertyConverter != null) {
                return propertyConverter.convertToJAXWS(SOAPMessageContext.this.p, (MessageContext)SOAPMessageContext.this.smc, object);
            }
            return SOAPMessageContext.this.smc.put(string, object);
        }

        @Override
        public boolean containsValue(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return new Set<Map.Entry<String, Object>>(){

                @Override
                public boolean add(Map.Entry<String, Object> entry) {
                    return InvocationPropertyMap.this.put(entry.getKey(), entry.getValue()) == null;
                }

                @Override
                public boolean addAll(Collection<? extends Map.Entry<String, Object>> collection) {
                    boolean bl = false;
                    for (Map.Entry<String, Object> entry : collection) {
                        bl = this.add(entry) || bl;
                    }
                    return bl;
                }

                @Override
                public void clear() {
                    InvocationPropertyMap.this.clear();
                }

                @Override
                public boolean contains(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    Object object2 = InvocationPropertyMap.this.get(entry.getKey());
                    return object2 == object || object2 != null && object2.equals(object);
                }

                @Override
                public boolean containsAll(Collection<?> collection) {
                    for (Object obj : collection) {
                        if (this.contains(obj)) continue;
                        return false;
                    }
                    return true;
                }

                @Override
                public boolean isEmpty() {
                    return InvocationPropertyMap.this.isEmpty();
                }

                @Override
                public Iterator<Map.Entry<String, Object>> iterator() {
                    return new Iterator<Map.Entry<String, Object>>(){
                        private Iterator<String> it;
                        {
                            this.it = InvocationPropertyMap.this.keySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.it.hasNext();
                        }

                        @Override
                        public Map.Entry<String, Object> next() {
                            return new Map.Entry<String, Object>(){
                                String key;
                                {
                                    this.key = (String)it.next();
                                }

                                @Override
                                public String getKey() {
                                    return this.key;
                                }

                                @Override
                                public Object getValue() {
                                    return InvocationPropertyMap.this.get(this.key);
                                }

                                @Override
                                public Object setValue(Object object) {
                                    return InvocationPropertyMap.this.put(this.key, object);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            this.it.remove();
                        }
                    };
                }

                @Override
                public boolean remove(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    Object object2 = InvocationPropertyMap.this.get(entry.getKey());
                    if (object2 == object || object2 != null && object2.equals(object)) {
                        InvocationPropertyMap.this.remove(entry.getKey());
                        return true;
                    }
                    return false;
                }

                @Override
                public boolean removeAll(Collection<?> collection) {
                    boolean bl = false;
                    for (Object obj : collection) {
                        bl = this.remove(obj) || bl;
                    }
                    return bl;
                }

                @Override
                public boolean retainAll(Collection<?> collection) {
                    boolean bl = false;
                    Iterator<Map.Entry<String, Object>> iterator = this.iterator();
                    while (iterator.hasNext()) {
                        if (collection.contains(iterator.next())) continue;
                        iterator.remove();
                        bl = true;
                    }
                    return bl;
                }

                @Override
                public int size() {
                    return InvocationPropertyMap.this.size();
                }

                @Override
                public Object[] toArray() {
                    Object[] objectArray = new Object[this.size()];
                    Iterator<Map.Entry<String, Object>> iterator = this.iterator();
                    int n = 0;
                    while (iterator.hasNext()) {
                        objectArray[n] = iterator.next();
                        ++n;
                    }
                    return objectArray;
                }

                @Override
                public <T> T[] toArray(T[] objectArray) {
                    int n = this.size();
                    if (objectArray.length < n) {
                        objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
                    }
                    Iterator<Map.Entry<String, Object>> iterator = this.iterator();
                    T[] TArray = objectArray;
                    for (int i = 0; i < n; ++i) {
                        TArray[i] = iterator.next();
                    }
                    if (objectArray.length > n) {
                        objectArray[n] = null;
                    }
                    return objectArray;
                }
            };
        }

        @Override
        public Set<String> keySet() {
            Map<String, PropertyConverter> map = SOAPMessageContext.this.factory.getJAXRPCConverters();
            if (map == null || map.isEmpty()) {
                return SOAPMessageContext.this.smc.keySet();
            }
            final Set set = SOAPMessageContext.this.smc.keySet();
            if (set == null || set.isEmpty()) {
                return map.keySet();
            }
            final Set<String> set2 = map.keySet();
            return new AbstractSet<String>(){

                @Override
                public Iterator<String> iterator() {
                    return new CombinedIterator(set.iterator(), set2.iterator());
                }

                @Override
                public int size() {
                    return set.size() + set2.size();
                }
            };
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> map) {
            for (Map.Entry<? extends String, ? extends Object> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public Object remove(Object object) {
            PropertyConverter propertyConverter = SOAPMessageContext.this.factory.getJAXRPCConverters().get(object);
            if (propertyConverter != null) {
                propertyConverter.remove(SOAPMessageContext.this.p, (MessageContext)SOAPMessageContext.this.smc);
            }
            return SOAPMessageContext.this.smc.remove(object);
        }

        @Override
        public Collection<Object> values() {
            return new AbstractCollection<Object>(){

                @Override
                public Iterator<Object> iterator() {
                    final Iterator<Map.Entry<String, Object>> iterator = InvocationPropertyMap.this.entrySet().iterator();
                    return new Iterator<Object>(){

                        @Override
                        public boolean hasNext() {
                            return iterator.hasNext();
                        }

                        @Override
                        public Object next() {
                            return ((Map.Entry)iterator.next()).getValue();
                        }

                        @Override
                        public void remove() {
                            iterator.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return InvocationPropertyMap.this.size();
                }
            };
        }

        @Override
        public boolean containsKey(Object object) {
            PropertyConverter propertyConverter = SOAPMessageContext.this.factory.getJAXRPCConverters().get(object);
            if (propertyConverter != null) {
                return propertyConverter.containsKey(SOAPMessageContext.this.p, (MessageContext)SOAPMessageContext.this.smc);
            }
            return SOAPMessageContext.this.smc.containsKey(object);
        }

        @Override
        public void clear() {
            SOAPMessageContext.this.smc.clear();
        }

        @Override
        public boolean isEmpty() {
            return SOAPMessageContext.this.smc.isEmpty();
        }

        @Override
        public int size() {
            return SOAPMessageContext.this.smc.size();
        }
    }
}

