/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.framework.jaxrpc;

import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.WebServiceException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class SOAPMessageRefactor {
    private Entry envEntry;
    private Entry headerEntry;
    private Entry bodyEntry;

    public void init(Message message) {
        if (message == null) {
            return;
        }
        try {
            SOAPMessage sOAPMessage = message.readAsSOAPMessage();
            SOAPEnvelope sOAPEnvelope = sOAPMessage.getSOAPPart().getEnvelope();
            SOAPHeader sOAPHeader = sOAPEnvelope.getHeader();
            SOAPBody sOAPBody = sOAPEnvelope.getBody();
            this.envEntry = SOAPMessageRefactor.lookupAtts((Element)sOAPEnvelope);
            this.headerEntry = SOAPMessageRefactor.lookupAtts((Element)sOAPHeader);
            this.bodyEntry = SOAPMessageRefactor.lookupAtts((Element)sOAPBody);
        }
        catch (SOAPException sOAPException) {
            throw new WebServiceException((Throwable)sOAPException);
        }
    }

    public Message refator(Message message) {
        if (message == null) {
            return null;
        }
        try {
            SOAPMessage sOAPMessage = message.readAsSOAPMessage();
            SOAPEnvelope sOAPEnvelope = sOAPMessage.getSOAPPart().getEnvelope();
            SOAPHeader sOAPHeader = sOAPEnvelope.getHeader();
            SOAPBody sOAPBody = sOAPEnvelope.getBody();
            SOAPMessageRefactor.setupAtts((Element)sOAPEnvelope, this.envEntry);
            SOAPMessageRefactor.setupAtts((Element)sOAPHeader, this.headerEntry);
            SOAPMessageRefactor.setupAtts((Element)sOAPBody, this.bodyEntry);
            return Messages.create((SOAPMessage)sOAPMessage);
        }
        catch (SOAPException sOAPException) {
            throw new WebServiceException((Throwable)sOAPException);
        }
    }

    private static Entry lookupAtts(Element element) {
        NamedNodeMap namedNodeMap = null;
        Attr attr = null;
        namedNodeMap = element.getAttributes();
        if (namedNodeMap != null) {
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Attr attr2 = (Attr)namedNodeMap.item(i);
                String string = attr2.getLocalName();
                if (!"http://www.w3.org/2000/xmlns/".equals(attr2.getNamespaceURI()) || string == null || !string.equals(element.getPrefix())) continue;
                attr = attr2;
                break;
            }
        }
        return new Entry(namedNodeMap, attr);
    }

    private static void setupAtts(Element element, Entry entry) {
        NamedNodeMap namedNodeMap = entry.atts;
        Attr attr = entry.excludeAtt;
        if (namedNodeMap != null) {
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Attr attr2 = (Attr)namedNodeMap.item(i);
                if (attr2 == attr) continue;
                element.setAttributeNode((Attr)element.getOwnerDocument().importNode(attr2, true));
            }
        }
    }

    private static class Entry {
        private NamedNodeMap atts = null;
        private Attr excludeAtt = null;

        public Entry(NamedNodeMap namedNodeMap, Attr attr) {
            this.atts = namedNodeMap;
            this.excludeAtt = attr;
        }
    }
}

